/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.restspec;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.restli.restspec.CustomAnnotationContentSchemaMap;
import com.linkedin.restli.restspec.ParameterSchemaArray;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestMethodSchema
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"RestMethodSchema\",\"namespace\":\"com.linkedin.restli.restspec\",\"include\":[{\"type\":\"record\",\"name\":\"CustomAnnotationSchema\",\"doc\":\"Custom annotation for idl\",\"fields\":[{\"name\":\"annotations\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"CustomAnnotationContentSchema\",\"doc\":\"Unstructured record that represents arbitrary custom annotations for idl. Actual content is always a map with annotation's overridable member name as key and member value as value\",\"fields\":[]}},\"doc\":\"custom annotation data\",\"optional\":true}]}],\"fields\":[{\"name\":\"method\",\"type\":\"string\",\"doc\":\"Method type for this rest method\"},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this rest method\",\"optional\":true},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"ParameterSchema\",\"include\":[\"CustomAnnotationSchema\"],\"fields\":[{\"name\":\"name\",\"type\":\"string\",\"doc\":\"name of this parameter\"},{\"name\":\"type\",\"type\":\"string\",\"doc\":\"avro type of this parameter\"},{\"name\":\"items\",\"type\":\"string\",\"doc\":\"type of individual items, if this is an array parameter (used for finder parameters)\",\"optional\":true},{\"name\":\"optional\",\"type\":\"boolean\",\"doc\":\"indicates whether this parameter is optional.  omitted for required parameters\",\"optional\":true},{\"name\":\"default\",\"type\":\"string\",\"doc\":\"indicates the default value for this parameter\",\"optional\":true},{\"name\":\"doc\",\"type\":\"string\",\"doc\":\"Documentation for this parameter\",\"optional\":true}]}},\"doc\":\"list of query parameters for this method\",\"optional\":true},{\"name\":\"pagingSupported\",\"type\":\"boolean\",\"doc\":\"Indicates if this rest method has paging support using the start and count parameters\",\"optional\":true}]}");
    private static final RecordDataSchema.Field FIELD_Annotations = SCHEMA.getField("annotations");
    private static final RecordDataSchema.Field FIELD_Method = SCHEMA.getField("method");
    private static final RecordDataSchema.Field FIELD_Doc = SCHEMA.getField("doc");
    private static final RecordDataSchema.Field FIELD_Parameters = SCHEMA.getField("parameters");
    private static final RecordDataSchema.Field FIELD_PagingSupported = SCHEMA.getField("pagingSupported");

    public RestMethodSchema() {
        super(new DataMap(), SCHEMA);
    }

    public RestMethodSchema(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasAnnotations() {
        return this.contains(FIELD_Annotations);
    }

    public void removeAnnotations() {
        this.remove(FIELD_Annotations);
    }

    public CustomAnnotationContentSchemaMap getAnnotations(GetMode mode) {
        return (CustomAnnotationContentSchemaMap)this.obtainWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, mode);
    }

    @Nullable
    public CustomAnnotationContentSchemaMap getAnnotations() {
        return (CustomAnnotationContentSchemaMap)this.obtainWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, GetMode.STRICT);
    }

    public RestMethodSchema setAnnotations(CustomAnnotationContentSchemaMap value, SetMode mode) {
        this.putWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, (DataTemplate)value, mode);
        return this;
    }

    public RestMethodSchema setAnnotations(@Nonnull CustomAnnotationContentSchemaMap value) {
        this.putWrapped(FIELD_Annotations, CustomAnnotationContentSchemaMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasMethod() {
        return this.contains(FIELD_Method);
    }

    public void removeMethod() {
        this.remove(FIELD_Method);
    }

    public String getMethod(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Method, String.class, mode);
    }

    @Nonnull
    public String getMethod() {
        return (String)this.obtainDirect(FIELD_Method, String.class, GetMode.STRICT);
    }

    public RestMethodSchema setMethod(String value, SetMode mode) {
        this.putDirect(FIELD_Method, String.class, String.class, value, mode);
        return this;
    }

    public RestMethodSchema setMethod(@Nonnull String value) {
        this.putDirect(FIELD_Method, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDoc() {
        return this.contains(FIELD_Doc);
    }

    public void removeDoc() {
        this.remove(FIELD_Doc);
    }

    public String getDoc(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Doc, String.class, mode);
    }

    @Nullable
    public String getDoc() {
        return (String)this.obtainDirect(FIELD_Doc, String.class, GetMode.STRICT);
    }

    public RestMethodSchema setDoc(String value, SetMode mode) {
        this.putDirect(FIELD_Doc, String.class, String.class, value, mode);
        return this;
    }

    public RestMethodSchema setDoc(@Nonnull String value) {
        this.putDirect(FIELD_Doc, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasParameters() {
        return this.contains(FIELD_Parameters);
    }

    public void removeParameters() {
        this.remove(FIELD_Parameters);
    }

    public ParameterSchemaArray getParameters(GetMode mode) {
        return (ParameterSchemaArray)this.obtainWrapped(FIELD_Parameters, ParameterSchemaArray.class, mode);
    }

    @Nullable
    public ParameterSchemaArray getParameters() {
        return (ParameterSchemaArray)this.obtainWrapped(FIELD_Parameters, ParameterSchemaArray.class, GetMode.STRICT);
    }

    public RestMethodSchema setParameters(ParameterSchemaArray value, SetMode mode) {
        this.putWrapped(FIELD_Parameters, ParameterSchemaArray.class, (DataTemplate)value, mode);
        return this;
    }

    public RestMethodSchema setParameters(@Nonnull ParameterSchemaArray value) {
        this.putWrapped(FIELD_Parameters, ParameterSchemaArray.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasPagingSupported() {
        return this.contains(FIELD_PagingSupported);
    }

    public void removePagingSupported() {
        this.remove(FIELD_PagingSupported);
    }

    public Boolean isPagingSupported(GetMode mode) {
        return (Boolean)this.obtainDirect(FIELD_PagingSupported, Boolean.class, mode);
    }

    @Nullable
    public Boolean isPagingSupported() {
        return (Boolean)this.obtainDirect(FIELD_PagingSupported, Boolean.class, GetMode.STRICT);
    }

    public RestMethodSchema setPagingSupported(Boolean value, SetMode mode) {
        this.putDirect(FIELD_PagingSupported, Boolean.class, Boolean.class, value, mode);
        return this;
    }

    public RestMethodSchema setPagingSupported(@Nonnull Boolean value) {
        this.putDirect(FIELD_PagingSupported, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public RestMethodSchema setPagingSupported(boolean value) {
        this.putDirect(FIELD_PagingSupported, Boolean.class, Boolean.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public RestMethodSchema clone() throws CloneNotSupportedException {
        return (RestMethodSchema)super.clone();
    }

    public RestMethodSchema copy() throws CloneNotSupportedException {
        return (RestMethodSchema)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public CustomAnnotationContentSchemaMap.Fields annotations() {
            return new CustomAnnotationContentSchemaMap.Fields(this.getPathComponents(), "annotations");
        }

        public PathSpec method() {
            return new PathSpec(this.getPathComponents(), "method");
        }

        public PathSpec doc() {
            return new PathSpec(this.getPathComponents(), "doc");
        }

        public ParameterSchemaArray.Fields parameters() {
            return new ParameterSchemaArray.Fields(this.getPathComponents(), "parameters");
        }

        public PathSpec pagingSupported() {
            return new PathSpec(this.getPathComponents(), "pagingSupported");
        }
    }
}

