/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ModifiableView;
import org.apache.calcite.schema.Path;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;

public class ViewTable
extends AbstractQueryableTable
implements TranslatableTable {
    private final String viewSql;
    private final List<String> schemaPath;
    private final RelProtoDataType protoRowType;

    public ViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath) {
        super(elementType);
        this.viewSql = viewSql;
        this.schemaPath = ImmutableList.copyOf(schemaPath);
        this.protoRowType = rowType;
    }

    @Deprecated
    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath) {
        return ViewTable.viewMacro(schema, viewSql, schemaPath, Boolean.TRUE);
    }

    public static ViewTableMacro viewMacro(SchemaPlus schema, String viewSql, List<String> schemaPath, Boolean modifiable) {
        return new ViewTableMacro(CalciteSchema.from(schema), viewSql, schemaPath, modifiable);
    }

    public String getViewSql() {
        return this.viewSql;
    }

    public List<String> getSchemaPath() {
        return this.schemaPath;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.VIEW;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return queryProvider.createQuery(this.getExpression(schema, tableName, Queryable.class), this.elementType);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return this.expandView(context, relOptTable.getRowType(), this.viewSql);
    }

    private RelNode expandView(RelOptTable.ToRelContext preparingStmt, RelDataType rowType, String queryString) {
        try {
            RelNode rel = preparingStmt.expandView(rowType, queryString, this.schemaPath);
            rel = RelOptUtil.createCastRel(rel, rowType, true);
            return rel;
        }
        catch (Throwable e) {
            throw Util.newInternal(e, "Error while parsing view definition:  " + queryString);
        }
    }

    static class ModifiableViewTable
    extends ViewTable
    implements ModifiableView {
        private final Table table;
        private final Path tablePath;
        private final RexNode constraint;
        private final ImmutableIntList columnMapping;

        public ModifiableViewTable(Type elementType, RelProtoDataType rowType, String viewSql, List<String> schemaPath, Table table, Path tablePath, RexNode constraint, ImmutableIntList columnMapping) {
            super(elementType, rowType, viewSql, schemaPath);
            this.table = table;
            this.tablePath = tablePath;
            this.constraint = constraint;
            this.columnMapping = columnMapping;
        }

        @Override
        public RexNode getConstraint(RexBuilder rexBuilder, RelDataType tableRowType) {
            return rexBuilder.copy(this.constraint);
        }

        @Override
        public ImmutableIntList getColumnMapping() {
            return this.columnMapping;
        }

        @Override
        public Table getTable() {
            return this.table;
        }

        @Override
        public Path getTablePath() {
            return this.tablePath;
        }
    }

    static class ViewTableMacro
    implements TableMacro {
        protected final String viewSql;
        protected final CalciteSchema schema;
        private final Boolean modifiable;
        protected final List<String> schemaPath;

        ViewTableMacro(CalciteSchema schema, String viewSql, List<String> schemaPath, Boolean modifiable) {
            this.viewSql = viewSql;
            this.schema = schema;
            this.modifiable = modifiable;
            this.schemaPath = schemaPath == null ? null : ImmutableList.copyOf(schemaPath);
        }

        @Override
        public List<FunctionParameter> getParameters() {
            return Collections.emptyList();
        }

        @Override
        public TranslatableTable apply(List<Object> arguments) {
            CalcitePrepare.AnalyzeViewResult parsed = Schemas.analyzeView(MaterializedViewTable.MATERIALIZATION_CONNECTION, this.schema, this.schemaPath, this.viewSql, this.modifiable != null && this.modifiable != false);
            List<String> schemaPath1 = this.schemaPath != null ? this.schemaPath : this.schema.path(null);
            JavaTypeFactory typeFactory = (JavaTypeFactory)parsed.typeFactory;
            Type elementType = typeFactory.getJavaClass(parsed.rowType);
            if ((this.modifiable == null || this.modifiable.booleanValue()) && parsed.table != null) {
                return new ModifiableViewTable(elementType, RelDataTypeImpl.proto(parsed.rowType), this.viewSql, schemaPath1, parsed.table, Schemas.path(this.schema.root(), parsed.tablePath), parsed.constraint, parsed.columnMapping);
            }
            return new ViewTable(elementType, RelDataTypeImpl.proto(parsed.rowType), this.viewSql, schemaPath1);
        }
    }
}

