/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.tool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

public class KafkaCheckpoint {
    private final HashMap<Integer, Long> _partitionOffsetMap;
    private static final ObjectMapper _mapper = new ObjectMapper();

    public static KafkaCheckpoint emptyCheckpoint() {
        return new KafkaCheckpoint(new HashMap<Integer, Long>());
    }

    public KafkaCheckpoint(HashMap<Integer, Long> partitionOffsetMap) {
        this._partitionOffsetMap = partitionOffsetMap;
    }

    public void update(int partition, long offset) {
        this._partitionOffsetMap.put(partition, offset);
    }

    public static KafkaCheckpoint deserialize(InputStream inputStream) throws IOException {
        TypeFactory typeFactory = _mapper.getTypeFactory();
        MapType mapType = typeFactory.constructMapType(HashMap.class, Integer.class, Long.class);
        HashMap checkpoint = (HashMap)_mapper.readValue(inputStream, (JavaType)mapType);
        return new KafkaCheckpoint(checkpoint);
    }

    public static void serialize(KafkaCheckpoint checkpoint, OutputStream outputStream) throws IOException {
        _mapper.writeValue(outputStream, checkpoint._partitionOffsetMap);
    }

    public static void serialize(KafkaCheckpoint checkpoint, File outputFile) throws IOException {
        _mapper.writeValue(outputFile, checkpoint._partitionOffsetMap);
    }

    public boolean isEmpty() {
        return this._partitionOffsetMap.isEmpty();
    }
}

