/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.caprep;

import com.linkedin.r2.caprep.CapRepAdmin;
import com.linkedin.r2.caprep.CaptureFilter;
import com.linkedin.r2.caprep.PassThroughFilter;
import com.linkedin.r2.caprep.ReplaceableFilter;
import com.linkedin.r2.caprep.ReplayFilter;
import com.linkedin.r2.caprep.db.DefaultMessageSerializer;
import com.linkedin.r2.caprep.db.DirectoryDbSink;
import com.linkedin.r2.caprep.db.DirectoryDbSource;
import com.linkedin.r2.caprep.db.MessageSerializer;
import com.linkedin.r2.filter.NextFilter;
import com.linkedin.r2.filter.message.rest.RestFilter;
import com.linkedin.r2.filter.message.stream.StreamFilter;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamResponse;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapRepFilter
implements RestFilter,
StreamFilter,
CapRepAdmin {
    private static final Logger _log = LoggerFactory.getLogger(CapRepFilter.class);
    private static final PassThroughFilter PASS_THROUGH_FILTER = new PassThroughFilter();
    private final ReplaceableFilter _filter = new ReplaceableFilter(PASS_THROUGH_FILTER);

    @Override
    public void capture(String directory) throws IOException {
        _log.debug("Switching to capture mode. Directory: " + directory);
        this._filter.setFilter(PASS_THROUGH_FILTER);
        try {
            this._filter.setFilter(new CaptureFilter(new DirectoryDbSink(directory, (MessageSerializer)new DefaultMessageSerializer())));
        }
        catch (IOException e) {
            _log.warn("Error switching to capture mode", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            _log.warn("Error switching to capture mode", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void replay(String directory) throws IOException {
        _log.debug("Switching to replay mode. Directory: " + directory);
        this._filter.setFilter(PASS_THROUGH_FILTER);
        try {
            this._filter.setFilter(new ReplayFilter(new DirectoryDbSource(directory, (MessageSerializer)new DefaultMessageSerializer())));
        }
        catch (IOException e) {
            _log.warn("Error switching to replay mode", (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            _log.warn("Error switching to capture mode", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void passThrough() {
        _log.debug("Switching to pass-through mode.");
        this._filter.setFilter(PASS_THROUGH_FILTER);
    }

    @Override
    public String getMode() {
        return this._filter.getFilter().getClass().getSimpleName();
    }

    @Override
    public void onRestRequest(RestRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        this._filter.onRestRequest(req, requestContext, wireAttrs, nextFilter);
    }

    @Override
    public void onRestResponse(RestResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        this._filter.onRestResponse(res, requestContext, wireAttrs, nextFilter);
    }

    @Override
    public void onRestError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<RestRequest, RestResponse> nextFilter) {
        this._filter.onRestError(ex, requestContext, wireAttrs, nextFilter);
    }

    @Override
    public void onStreamRequest(StreamRequest req, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        this._filter.onStreamRequest(req, requestContext, wireAttrs, nextFilter);
    }

    @Override
    public void onStreamResponse(StreamResponse res, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        this._filter.onStreamResponse(res, requestContext, wireAttrs, nextFilter);
    }

    @Override
    public void onStreamError(Throwable ex, RequestContext requestContext, Map<String, String> wireAttrs, NextFilter<StreamRequest, StreamResponse> nextFilter) {
        this._filter.onStreamError(ex, requestContext, wireAttrs, nextFilter);
    }
}

