/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.message;

import com.linkedin.r2.message.BaseMessage;
import com.linkedin.r2.message.Request;
import com.linkedin.util.ArgumentUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;

public abstract class BaseRequest
extends BaseMessage
implements Request {
    private final URI _uri;
    private final String _method;

    protected BaseRequest(Map<String, String> headers, List<String> cookies, URI uri, String method) {
        super(headers, cookies);
        ArgumentUtil.notNull((Object)uri, (String)"uri");
        ArgumentUtil.notNull((Object)method, (String)"method");
        this._uri = uri;
        this._method = method;
    }

    @Override
    public URI getURI() {
        return this._uri;
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseRequest that = (BaseRequest)o;
        return this._method.equals(that._method) && this._uri.equals(that._uri);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._uri.hashCode();
        result = 31 * result + this._method.hashCode();
        return result;
    }
}

