/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestRequestBuilder;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import com.linkedin.r2.transport.http.server.HttpDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractR2Servlet
extends HttpServlet {
    private static final Logger _log = LoggerFactory.getLogger(AbstractR2Servlet.class);
    private static final long serialVersionUID = 0L;
    protected final long _timeout;

    protected abstract HttpDispatcher getDispatcher();

    public AbstractR2Servlet(long timeout) {
        this._timeout = timeout;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        RestRequest restRequest;
        RequestContext requestContext = this.readRequestContext(req);
        try {
            restRequest = this.readFromServletRequest(req);
        }
        catch (URISyntaxException e) {
            this.writeToServletError(resp, RestStatus.BAD_REQUEST, e.toString());
            return;
        }
        final AtomicReference result = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        TransportCallback<RestResponse> callback = new TransportCallback<RestResponse>(){

            @Override
            public void onResponse(TransportResponse<RestResponse> response) {
                result.set(response);
                latch.countDown();
            }
        };
        this.getDispatcher().handleRequest(restRequest, requestContext, callback);
        try {
            if (latch.await(this._timeout, TimeUnit.MILLISECONDS)) {
                this.writeToServletResponse((TransportResponse)result.get(), resp);
            } else {
                this.writeToServletError(resp, RestStatus.INTERNAL_SERVER_ERROR, "Server Timeout after " + this._timeout + "ms.");
            }
        }
        catch (InterruptedException e) {
            throw new ServletException("Interrupted!", (Throwable)e);
        }
    }

    protected void writeToServletResponse(TransportResponse<RestResponse> response, HttpServletResponse resp) throws IOException {
        Map<String, String> wireAttrs = response.getWireAttributes();
        for (Map.Entry<String, String> entry : WireAttributeHelper.toWireAttributes(wireAttrs).entrySet()) {
            resp.setHeader(entry.getKey(), entry.getValue());
        }
        RestResponse restResponse = null;
        if (response.hasError()) {
            Throwable throwable = response.getError();
            if (throwable instanceof RestException) {
                restResponse = ((RestException)throwable).getResponse();
            }
            if (restResponse == null) {
                restResponse = RestStatus.responseForError(RestStatus.INTERNAL_SERVER_ERROR, throwable);
            }
        } else {
            restResponse = response.getResponse();
        }
        resp.setStatus(restResponse.getStatus());
        Map<String, String> map = restResponse.getHeaders();
        for (Map.Entry<String, String> e : map.entrySet()) {
            resp.setHeader(e.getKey(), e.getValue());
        }
        for (String cookie : restResponse.getCookies()) {
            resp.addHeader("Set-Cookie", cookie);
        }
        ByteString entity = restResponse.getEntity();
        entity.write((OutputStream)resp.getOutputStream());
        resp.getOutputStream().close();
    }

    protected void writeToServletError(HttpServletResponse resp, int statusCode, String message) throws IOException {
        RestResponse restResponse = RestStatus.responseForStatus(statusCode, message);
        this.writeToServletResponse(TransportResponseImpl.success(restResponse), resp);
    }

    protected RestRequest readFromServletRequest(HttpServletRequest req) throws IOException, ServletException, URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append(AbstractR2Servlet.extractPathInfo(req));
        String query = req.getQueryString();
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        URI uri = new URI(sb.toString());
        RestRequestBuilder rb = new RestRequestBuilder(uri);
        rb.setMethod(req.getMethod());
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName.equalsIgnoreCase("Cookie")) {
                Enumeration cookies = req.getHeaders(headerName);
                while (cookies.hasMoreElements()) {
                    rb.addCookie((String)cookies.nextElement());
                }
                continue;
            }
            Enumeration headerValues = req.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                rb.addHeaderValue(headerName, (String)headerValues.nextElement());
            }
        }
        int length = req.getContentLength();
        if (length > 0) {
            rb.setEntity(ByteString.read((InputStream)req.getInputStream(), (int)length));
        } else {
            rb.setEntity(ByteString.read((InputStream)req.getInputStream()));
        }
        return rb.build();
    }

    protected RequestContext readRequestContext(HttpServletRequest req) {
        RequestContext context = new RequestContext();
        context.putLocalAttr("REMOTE_ADDR", req.getRemoteAddr());
        HttpProtocolVersion protocol = HttpProtocolVersion.parse(req.getProtocol());
        context.putLocalAttr("HTTP_PROTOCOL_VERSION", (Object)protocol);
        if (req.isSecure()) {
            Object[] certs = (Object[])req.getAttribute("javax.servlet.request.X509Certificate");
            if (certs != null && certs.length > 0) {
                context.putLocalAttr("CLIENT_CERT", certs[0]);
            }
            context.putLocalAttr("IS_SECURE", true);
        } else {
            context.putLocalAttr("IS_SECURE", false);
        }
        return context;
    }

    protected static String extractPathInfo(HttpServletRequest req) throws ServletException {
        String pathInfo;
        String prefix;
        String servletPath;
        String requestUri = req.getRequestURI();
        String contextPath = req.getContextPath();
        StringBuilder builder = new StringBuilder();
        if (contextPath != null) {
            builder.append(contextPath);
        }
        if ((servletPath = req.getServletPath()) != null) {
            builder.append(servletPath);
        }
        if ((prefix = builder.toString()).length() == 0) {
            pathInfo = requestUri;
        } else if (requestUri.startsWith(prefix)) {
            pathInfo = requestUri.substring(prefix.length());
        } else {
            _log.warn("Unable to extract 'non decoded' pathInfo, returning 'decoded' pathInfo instead.  This may cause issues processing request URIs containing special characters. requestUri=" + requestUri);
            return req.getPathInfo();
        }
        if (pathInfo.length() == 0) {
            throw new ServletException("R2 servlet should only be mapped via wildcard path mapping e.g. /r2/*. Exact path matching (/r2) and file extension mappings (*.r2) are currently not supported");
        }
        return pathInfo;
    }
}

