/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.server;

import com.linkedin.data.ByteString;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestStatus;
import com.linkedin.r2.message.stream.StreamException;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.message.stream.entitystream.EntityStreams;
import com.linkedin.r2.message.stream.entitystream.Writer;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.common.TransportResponse;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.common.HttpProtocolVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServletHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)ServletHelper.class.getName());

    private ServletHelper() {
    }

    static StreamRequestBuilder readStreamRequestHeadersFromServletRequest(HttpServletRequest req) throws IOException, ServletException, URISyntaxException {
        StringBuilder sb = new StringBuilder();
        sb.append(ServletHelper.extractPathInfo(req));
        String query = req.getQueryString();
        if (query != null) {
            sb.append('?');
            sb.append(query);
        }
        URI uri = new URI(sb.toString());
        StreamRequestBuilder rb = new StreamRequestBuilder(uri);
        rb.setMethod(req.getMethod());
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName.equalsIgnoreCase("Cookie")) {
                Enumeration cookies = req.getHeaders(headerName);
                while (cookies.hasMoreElements()) {
                    rb.addCookie((String)cookies.nextElement());
                }
                continue;
            }
            Enumeration headerValues = req.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                rb.addHeaderValue(headerName, (String)headerValues.nextElement());
            }
        }
        return rb;
    }

    static String extractPathInfo(HttpServletRequest req) throws ServletException {
        String pathInfo;
        String prefix;
        String servletPath;
        String requestUri = req.getRequestURI();
        String contextPath = req.getContextPath();
        StringBuilder builder = new StringBuilder();
        if (contextPath != null) {
            builder.append(contextPath);
        }
        if ((servletPath = req.getServletPath()) != null) {
            builder.append(servletPath);
        }
        if ((prefix = builder.toString()).length() == 0) {
            pathInfo = requestUri;
        } else if (requestUri.startsWith(prefix)) {
            pathInfo = requestUri.substring(prefix.length());
        } else {
            LOG.warn("Unable to extract 'non decoded' pathInfo, returning 'decoded' pathInfo instead.  This may cause issues processing request URIs containing special characters. requestUri=" + requestUri);
            return req.getPathInfo();
        }
        if (pathInfo.length() == 0) {
            throw new ServletException("R2 servlet should only be mapped via wildcard path mapping e.g. /r2/*. Exact path matching (/r2) and file extension mappings (*.r2) are currently not supported");
        }
        return pathInfo;
    }

    static RequestContext readRequestContext(HttpServletRequest req) {
        RequestContext context = new RequestContext();
        context.putLocalAttr("REMOTE_ADDR", req.getRemoteAddr());
        HttpProtocolVersion protocol = HttpProtocolVersion.parse(req.getProtocol());
        context.putLocalAttr("HTTP_PROTOCOL_VERSION", (Object)protocol);
        if (req.isSecure()) {
            Object[] certs = (Object[])req.getAttribute("javax.servlet.request.X509Certificate");
            if (certs != null && certs.length > 0) {
                context.putLocalAttr("CLIENT_CERT", certs[0]);
            }
            context.putLocalAttr("IS_SECURE", true);
        } else {
            context.putLocalAttr("IS_SECURE", false);
        }
        return context;
    }

    static StreamResponse writeResponseHeadersToServletResponse(TransportResponse<StreamResponse> response, HttpServletResponse resp) {
        Throwable throwable;
        Map<String, String> wireAttrs = response.getWireAttributes();
        for (Map.Entry<String, String> entry : WireAttributeHelper.toWireAttributes(wireAttrs).entrySet()) {
            resp.setHeader(entry.getKey(), entry.getValue());
        }
        StreamResponse streamResponse = response.hasError() ? ((throwable = response.getError()) instanceof StreamException ? ((StreamException)throwable).getResponse() : Messages.toStreamResponse(RestStatus.responseForError(RestStatus.INTERNAL_SERVER_ERROR, throwable))) : response.getResponse();
        resp.setStatus(streamResponse.getStatus());
        Map<String, String> map = streamResponse.getHeaders();
        for (Map.Entry<String, String> e3 : map.entrySet()) {
            resp.setHeader(e3.getKey(), e3.getValue());
        }
        for (String cookie : streamResponse.getCookies()) {
            resp.addHeader("Set-Cookie", cookie);
        }
        return streamResponse;
    }

    static void writeToServletError(HttpServletResponse resp, int statusCode, String message) throws IOException {
        RestResponse restResponse = RestStatus.responseForStatus(statusCode, message);
        ServletHelper.writeResponseHeadersToServletResponse(TransportResponseImpl.success(Messages.toStreamResponse(restResponse)), resp);
        ByteString entity = restResponse.getEntity();
        entity.write((OutputStream)resp.getOutputStream());
        resp.getOutputStream().close();
    }

    static StreamRequest readFromServletRequest(HttpServletRequest req, Writer writer) throws IOException, ServletException, URISyntaxException {
        StreamRequestBuilder rb = ServletHelper.readStreamRequestHeadersFromServletRequest(req);
        return rb.build(EntityStreams.newEntityStream(writer));
    }
}

