/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.util;

import com.linkedin.r2.util.Timeout;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutRunnable.class);
    private final Timeout<Runnable> _timeout;

    public TimeoutRunnable(ScheduledExecutorService executor, long timeout, TimeUnit timeoutUnit, final Runnable action, final String timeoutMessage) {
        if (action == null) {
            throw new NullPointerException();
        }
        this._timeout = new Timeout<Runnable>(executor, timeout, timeoutUnit, action);
        this._timeout.addTimeoutTask(new Runnable(){

            @Override
            public void run() {
                LOG.info(timeoutMessage);
                action.run();
            }
        });
    }

    @Override
    public void run() {
        Runnable r = this._timeout.getItem();
        if (r != null) {
            r.run();
        }
    }
}

