/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.template.GetMode;
import com.linkedin.r2.message.rest.RestException;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.rest.RestResponseBuilder;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.internal.common.HeaderUtil;
import java.util.Map;

public class RestLiResponseException
extends RestException {
    private static final long serialVersionUID = 1L;
    private final int _status;
    private final ErrorResponse _errorResponse;
    private final Response<?> _decodedResponse;

    public RestLiResponseException(RestResponse rawResponse, Response<?> decodedResponse, ErrorResponse errorResponse) {
        super(rawResponse);
        this._status = rawResponse.getStatus();
        this._errorResponse = errorResponse;
        this._decodedResponse = decodedResponse;
    }

    public RestLiResponseException(RestResponse rawResponse, Response<?> decodedResponse, ErrorResponse errorResponse, Throwable cause) {
        super(rawResponse, cause);
        this._status = rawResponse.getStatus();
        this._errorResponse = errorResponse;
        this._decodedResponse = decodedResponse;
    }

    RestLiResponseException(ErrorResponse errorResponse) {
        super(RestLiResponseException.createErrorRestResponse(errorResponse));
        this._status = errorResponse.getStatus();
        this._errorResponse = errorResponse;
        this._decodedResponse = null;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean hasServiceErrorCode() {
        return this._errorResponse.hasServiceErrorCode();
    }

    public int getServiceErrorCode() {
        return this._errorResponse.getServiceErrorCode(GetMode.NULL);
    }

    public boolean hasServiceErrorMessage() {
        return this._errorResponse.hasMessage();
    }

    public String getServiceErrorMessage() {
        return this._errorResponse.getMessage(GetMode.NULL);
    }

    public boolean hasServiceErrorStackTrace() {
        return this._errorResponse.hasStackTrace();
    }

    public String getServiceErrorStackTrace() {
        return this._errorResponse.getStackTrace(GetMode.NULL);
    }

    public boolean hasServiceExceptionClass() {
        return this._errorResponse.hasExceptionClass();
    }

    public String getServiceExceptionClass() {
        return this._errorResponse.getExceptionClass(GetMode.NULL);
    }

    public boolean hasErrorDetails() {
        return this._errorResponse.hasErrorDetails();
    }

    public DataMap getErrorDetails() {
        if (this.hasErrorDetails()) {
            return this._errorResponse.getErrorDetails().data();
        }
        return null;
    }

    public String getErrorSource() {
        RestResponse response = this.getResponse();
        return HeaderUtil.getErrorResponseHeaderValue((Map)response.getHeaders());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)((Object)this)).getClass().getName()).append(": Response status ");
        builder.append(this.getResponse().getStatus());
        if (this.hasServiceErrorMessage()) {
            builder.append(", serviceErrorMessage: ").append(this.getServiceErrorMessage());
        }
        if (this.hasServiceErrorCode()) {
            builder.append(", serviceErrorCode: ").append(this.getServiceErrorCode());
        }
        return builder.toString();
    }

    public Response<?> getDecodedResponse() {
        return this._decodedResponse;
    }

    public boolean hasDecodedResponse() {
        return this._decodedResponse != null;
    }

    private static RestResponse createErrorRestResponse(ErrorResponse errorResponse) {
        RestResponseBuilder builder = (RestResponseBuilder)new RestResponseBuilder().setStatus(errorResponse.getStatus().intValue());
        String errorMessage = errorResponse.getMessage();
        if (errorMessage != null) {
            builder.setEntity(errorMessage.getBytes());
        }
        return builder.build();
    }
}

