/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client.uribuilders;

import com.linkedin.common.Version;
import com.linkedin.data.DataMap;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.jersey.api.uri.UriTemplate;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.uribuilders.RestliUriBuilder;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.client.QueryParamsUtil;
import com.linkedin.restli.internal.common.AllProtocolVersions;
import com.linkedin.restli.internal.common.QueryParamsDataMap;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.net.URI;

abstract class AbstractRestliRequestUriBuilder<R extends Request<?>>
implements RestliUriBuilder {
    protected final R _request;
    protected final ProtocolVersion _version;
    protected final CompoundKey _assocKey;
    private final String _uriPrefix;

    AbstractRestliRequestUriBuilder(R request, String uriPrefix, ProtocolVersion version) {
        this(request, uriPrefix, version, null);
    }

    AbstractRestliRequestUriBuilder(R request, String uriPrefix, ProtocolVersion version, CompoundKey assocKey) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        this._request = request;
        this._version = version;
        this._assocKey = assocKey;
        this._uriPrefix = uriPrefix == null ? "" : uriPrefix;
    }

    protected R getRequest() {
        return this._request;
    }

    private String bindPathKeys() {
        UriTemplate template = new UriTemplate(((Request)this._request).getBaseUriTemplate());
        return template.createURI(URIParamUtils.encodePathKeysForUri(((Request)this._request).getPathKeys(), (ProtocolVersion)this._version));
    }

    private final String addPrefix(String uri) {
        return this._uriPrefix + uri;
    }

    protected void appendKeyToPath(UriBuilder uriBuilder, Object key) {
        if (!((Request)this._request).getResourceProperties().isKeylessResource()) {
            uriBuilder.path(URIParamUtils.encodeKeyForUri((Object)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT, (ProtocolVersion)this._version));
        }
    }

    protected void appendQueryParams(UriBuilder b) {
        DataMap params = QueryParamsUtil.convertToDataMap(((Request)this._request).getQueryParamsObjects(), ((Request)this._request).getQueryParamClasses(), this._version);
        if (this._version.compareTo((Version)AllProtocolVersions.RESTLI_PROTOCOL_2_0_0.getProtocolVersion()) >= 0) {
            URIParamUtils.addSortedParams((UriBuilder)b, (DataMap)params);
        } else {
            QueryParamsDataMap.addSortedParams((UriBuilder)b, (DataMap)params);
        }
    }

    protected final void appendAssocKeys(UriBuilder uriBuilder) {
        if (this._assocKey == null) {
            throw new IllegalArgumentException("_assocKey is null");
        }
        if (this._assocKey.getNumParts() != 0) {
            uriBuilder.path(URIParamUtils.encodeKeyForUri((Object)this._assocKey, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT, (ProtocolVersion)this._version));
        }
    }

    @Override
    public URI buildBaseUri() {
        return URI.create(this.bindPathKeys());
    }

    public URI buildBaseUriWithPrefix() {
        return URI.create(this.addPrefix(this.bindPathKeys()));
    }
}

