/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.util.None;
import com.linkedin.r2.message.Messages;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.r2.message.rest.RestRequest;
import com.linkedin.r2.message.rest.RestResponse;
import com.linkedin.r2.message.stream.StreamRequest;
import com.linkedin.r2.message.stream.StreamRequestBuilder;
import com.linkedin.r2.message.stream.StreamResponse;
import com.linkedin.r2.transport.common.MessageType;
import com.linkedin.r2.transport.common.WireAttributeHelper;
import com.linkedin.r2.transport.common.bridge.client.TransportClient;
import com.linkedin.r2.transport.common.bridge.common.TransportCallback;
import com.linkedin.r2.transport.common.bridge.common.TransportResponseImpl;
import com.linkedin.r2.transport.http.client.AbstractJmxManager;
import com.linkedin.r2.transport.http.client.ChannelPoolFactory;
import com.linkedin.r2.transport.http.client.PoolStats;
import com.linkedin.r2.transport.http.client.StreamExecutionCallback;
import com.linkedin.r2.transport.http.client.TimeoutTransportCallback;
import com.linkedin.r2.transport.http.common.HttpBridge;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNettyStreamClient
implements TransportClient {
    static final Logger LOG = LoggerFactory.getLogger(AbstractNettyStreamClient.class);
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    protected final ChannelGroup _allChannels;
    protected final AtomicReference<State> _state = new AtomicReference<State>(State.RUNNING);
    protected final ScheduledExecutorService _scheduler;
    protected final ExecutorService _callbackExecutors;
    protected final long _requestTimeout;
    protected final long _shutdownTimeout;
    protected final long _maxResponseSize;
    protected final int _maxConcurrentConnections;
    protected final String _requestTimeoutMessage;
    protected final AbstractJmxManager _jmxManager;

    public AbstractNettyStreamClient(NioEventLoopGroup eventLoopGroup, ScheduledExecutorService executor, long requestTimeout, long shutdownTimeout, long maxResponseSize, ExecutorService callbackExecutors, AbstractJmxManager jmxManager, int maxConcurrentConnections) {
        this._maxResponseSize = maxResponseSize;
        this._maxConcurrentConnections = maxConcurrentConnections;
        this._scheduler = executor;
        this._callbackExecutors = callbackExecutors == null ? eventLoopGroup : callbackExecutors;
        this._requestTimeout = requestTimeout;
        this._shutdownTimeout = shutdownTimeout;
        this._requestTimeoutMessage = "Exceeded request timeout of " + this._requestTimeout + "ms";
        this._jmxManager = jmxManager;
        this._allChannels = new DefaultChannelGroup("R2 client channels", (EventExecutor)eventLoopGroup.next());
    }

    AbstractNettyStreamClient(ChannelPoolFactory factory, ScheduledExecutorService executor, int requestTimeout, int shutdownTimeout, long maxResponseSize) {
        this._maxResponseSize = maxResponseSize;
        this._scheduler = executor;
        this._callbackExecutors = new DefaultEventExecutorGroup(1);
        this._requestTimeout = requestTimeout;
        this._shutdownTimeout = shutdownTimeout;
        this._requestTimeoutMessage = "Exceeded request timeout of " + this._requestTimeout + "ms";
        this._jmxManager = AbstractJmxManager.NULL_JMX_MANAGER;
        this._maxConcurrentConnections = Integer.MAX_VALUE;
        this._allChannels = new DefaultChannelGroup("R2 client channels", (EventExecutor)GlobalEventExecutor.INSTANCE);
    }

    public abstract Map<String, PoolStats> getPoolStats();

    protected abstract void doShutdown(Callback<None> var1);

    protected abstract void doWriteRequest(Request var1, RequestContext var2, SocketAddress var3, TimeoutTransportCallback<StreamResponse> var4);

    public void restRequest(RestRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<RestResponse> callback) {
        throw new UnsupportedOperationException("This client only handles streaming.");
    }

    public void streamRequest(StreamRequest request, RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        MessageType.setMessageType((MessageType.Type)MessageType.Type.REST, wireAttrs);
        this.writeRequestWithTimeout(request, requestContext, wireAttrs, (TransportCallback<StreamResponse>)HttpBridge.streamToHttpCallback(callback, (StreamRequest)request));
    }

    public void shutdown(Callback<None> callback) {
        LOG.info("Shutdown requested");
        if (this._state.compareAndSet(State.RUNNING, State.SHUTTING_DOWN)) {
            LOG.info("Shutting down");
            this.doShutdown(callback);
        } else {
            callback.onError((Throwable)new IllegalStateException("Shutdown has already been requested."));
        }
    }

    private void writeRequestWithTimeout(StreamRequest request, final RequestContext requestContext, Map<String, String> wireAttrs, TransportCallback<StreamResponse> callback) {
        StreamExecutionCallback executionCallback = new StreamExecutionCallback(this._callbackExecutors, callback);
        final TimeoutTransportCallback timeoutCallback = new TimeoutTransportCallback(this._scheduler, this._requestTimeout, TimeUnit.MILLISECONDS, (TransportCallback)executionCallback, this._requestTimeoutMessage);
        StreamRequest requestWithWireAttrHeaders = ((StreamRequestBuilder)request.builder().overwriteHeaders(WireAttributeHelper.toWireAttributes(wireAttrs))).build(request.getEntityStream());
        if (AbstractNettyStreamClient.isFullRequest(requestContext)) {
            Messages.toRestRequest((StreamRequest)requestWithWireAttrHeaders, (Callback)new Callback<RestRequest>(){

                public void onError(Throwable e) {
                    AbstractNettyStreamClient.errorResponse(timeoutCallback, e);
                }

                public void onSuccess(RestRequest restRequest) {
                    AbstractNettyStreamClient.this.writeRequest((Request)restRequest, requestContext, (TimeoutTransportCallback<StreamResponse>)timeoutCallback);
                }
            });
        } else {
            this.writeRequest((Request)requestWithWireAttrHeaders, requestContext, (TimeoutTransportCallback<StreamResponse>)timeoutCallback);
        }
    }

    private void writeRequest(Request request, RequestContext requestContext, TimeoutTransportCallback<StreamResponse> callback) {
        InetSocketAddress address;
        State state = this._state.get();
        if (state != State.RUNNING) {
            AbstractNettyStreamClient.errorResponse(callback, new IllegalStateException("Client is " + (Object)((Object)state)));
            return;
        }
        URI uri = request.getURI();
        String scheme = uri.getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            AbstractNettyStreamClient.errorResponse(callback, new IllegalArgumentException("Unknown scheme: " + scheme + " (only http/https is supported)"));
            return;
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            port = "http".equalsIgnoreCase(scheme) ? 80 : 443;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            address = new InetSocketAddress(inetAddress, port);
            requestContext.putLocalAttr("REMOTE_SERVER_ADDR", (Object)inetAddress.getHostAddress());
        }
        catch (UnknownHostException e) {
            AbstractNettyStreamClient.errorResponse(callback, e);
            return;
        }
        this.doWriteRequest(request, requestContext, address, callback);
    }

    static <T> void errorResponse(TransportCallback<T> callback, Throwable e) {
        callback.onResponse(TransportResponseImpl.error((Throwable)e));
    }

    static boolean isFullRequest(RequestContext requestContext) {
        Object isFull = requestContext.getLocalAttr("IS_FULL_REQUEST");
        return isFull != null && (Boolean)isFull != false;
    }

    static Exception toException(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new Exception("Wrapped Throwable", t);
    }

    public long getRequestTimeout() {
        return this._requestTimeout;
    }

    public long getShutdownTimeout() {
        return this._shutdownTimeout;
    }

    public long getMaxResponseSize() {
        return this._maxResponseSize;
    }

    static enum State {
        RUNNING,
        SHUTTING_DOWN,
        REQUESTS_STOPPING,
        SHUTDOWN;

    }
}

