/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.r2.transport.http.client;

import com.linkedin.r2.transport.http.client.Http2FrameListener;
import com.linkedin.r2.transport.http.client.Http2StreamCodec;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2HeadersDecoder;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2LifecycleManager;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.ScheduledExecutorService;

public class Http2StreamCodecBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2StreamCodec, Http2StreamCodecBuilder> {
    private static final int INITIAL_HUFFMAN_DECODE_CAPACITY = 32;
    private long _maxContentLength = -1L;
    private long _streamingTimeout = -1L;
    private long _gracefulShutdownTimeoutMillis = -1L;
    private int _maxHeaderSize = -1;
    private ScheduledExecutorService _scheduler = null;
    private Http2Connection _connection = null;

    public Http2StreamCodecBuilder maxContentLength(long maxContentLength) {
        ObjectUtil.checkPositive((long)maxContentLength, (String)"maxContentLength");
        this._maxContentLength = maxContentLength;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodecBuilder streamingTimeout(long streamingTimeout) {
        ObjectUtil.checkPositive((long)streamingTimeout, (String)"streamingTimeout");
        this._streamingTimeout = streamingTimeout;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodecBuilder gracefulShutdownTimeoutMillis(long gracefulShutdownTimeoutMillis) {
        ObjectUtil.checkPositive((long)gracefulShutdownTimeoutMillis, (String)"gracefulShutdownTimeoutMillis");
        this._gracefulShutdownTimeoutMillis = gracefulShutdownTimeoutMillis;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodecBuilder scheduler(ScheduledExecutorService scheduler) {
        ObjectUtil.checkNotNull((Object)scheduler, (String)"scheduler");
        this._scheduler = scheduler;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodecBuilder maxHeaderSize(int maxHeaderSize) {
        ObjectUtil.checkPositive((int)maxHeaderSize, (String)"maxHeaderSize");
        this._maxHeaderSize = maxHeaderSize;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodecBuilder connection(Http2Connection connection) {
        ObjectUtil.checkNotNull((Object)connection, (String)"connection");
        this._connection = connection;
        return (Http2StreamCodecBuilder)this.self();
    }

    public Http2StreamCodec build() {
        ObjectUtil.checkNotNull((Object)this._connection, (String)"connection");
        ObjectUtil.checkPositive((int)this._maxHeaderSize, (String)"maxHeaderSize");
        DefaultHttp2HeadersDecoder headerDecoder = new DefaultHttp2HeadersDecoder(this._maxHeaderSize, 4096, this.isValidateHeaders(), 32);
        DefaultHttp2FrameReader reader = new DefaultHttp2FrameReader((Http2HeadersDecoder)headerDecoder);
        DefaultHttp2FrameWriter writer = new DefaultHttp2FrameWriter(this.headerSensitivityDetector());
        if (this.frameLogger() != null) {
            reader = new Http2InboundFrameLogger((Http2FrameReader)reader, this.frameLogger());
            writer = new Http2OutboundFrameLogger((Http2FrameWriter)writer, this.frameLogger());
        }
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder(this._connection, (Http2FrameWriter)writer);
        boolean encoderEnforceMaxConcurrentStreams = this.encoderEnforceMaxConcurrentStreams();
        if (encoderEnforceMaxConcurrentStreams) {
            if (this._connection.isServer()) {
                encoder.close();
                reader.close();
                throw new IllegalArgumentException("encoderEnforceMaxConcurrentStreams: " + encoderEnforceMaxConcurrentStreams + " not supported for server");
            }
            encoder = new StreamBufferingEncoder((Http2ConnectionEncoder)encoder);
        }
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder(this._connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)reader);
        super.codec((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder);
        return (Http2StreamCodec)super.build();
    }

    protected Http2StreamCodec build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        ObjectUtil.checkPositive((long)this._maxContentLength, (String)"maxContentLength");
        ObjectUtil.checkPositive((long)this._gracefulShutdownTimeoutMillis, (String)"gracefulShutdownTimeoutMillis");
        ObjectUtil.checkNotNull((Object)this._scheduler, (String)"scheduler");
        ObjectUtil.checkNotNull((Object)this._connection, (String)"connection");
        Http2StreamCodec codec = new Http2StreamCodec(decoder, encoder, initialSettings);
        super.frameListener((io.netty.handler.codec.http2.Http2FrameListener)new Http2FrameListener(this._scheduler, this._connection, (Http2LifecycleManager)codec, this._maxContentLength, this._streamingTimeout));
        super.gracefulShutdownTimeoutMillis(this._gracefulShutdownTimeoutMillis);
        return codec;
    }
}

