/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.DataSchemaResolver;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.data.schema.generator.SchemaSampleDataGenerator;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.jersey.api.uri.UriBuilder;
import com.linkedin.r2.message.rest.RestMessage;
import com.linkedin.restli.common.HttpStatus;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.docgen.MethodGatheringResourceSchemaVisitor;
import com.linkedin.restli.docgen.Node;
import com.linkedin.restli.docgen.ResourceMethodDocView;
import com.linkedin.restli.docgen.ResourceSchemaCollection;
import com.linkedin.restli.docgen.ResourceSchemaUtil;
import com.linkedin.restli.docgen.RestLiDocumentationRenderer;
import com.linkedin.restli.docgen.RestLiResourceRelationship;
import com.linkedin.restli.docgen.TemplatingEngine;
import com.linkedin.restli.docgen.examplegen.ExampleRequestResponse;
import com.linkedin.restli.docgen.examplegen.ExampleRequestResponseGenerator;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.internal.server.util.DataMapUtils;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.server.ResourceLevel;
import com.linkedin.restli.server.RestLiServer;
import com.linkedin.restli.server.RoutingException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestLiHTMLDocumentationRenderer
implements RestLiDocumentationRenderer {
    private static final Logger log = LoggerFactory.getLogger(RestLiServer.class);
    private static final Map<String, String> _restMethodDocsMapForCollection = new HashMap<String, String>();
    private static final Map<String, String> _restMethodDocsMapForSimpleResource = new HashMap<String, String>();
    private static final JacksonDataCodec _codec = new JacksonDataCodec();
    private final URI _serverNodeUri;
    private final URI _docBaseUri;
    private final RestLiResourceRelationship _relationships;
    private final ResourceSchemaCollection _resourceSchemas;
    private final TemplatingEngine _templatingEngine;
    private final DataSchemaResolver _schemaResolver;
    private final Map<Object, Map<String, ResourceSchema>> _relatedResourceCache = new HashMap<Object, Map<String, ResourceSchema>>();
    private final Map<Object, Map<String, NamedDataSchema>> _relatedSchemaCache = new HashMap<Object, Map<String, NamedDataSchema>>();
    private URI _jsonFormatUri;

    public RestLiHTMLDocumentationRenderer(URI serverNodeUri, RestLiResourceRelationship relationships, TemplatingEngine templatingEngine, DataSchemaResolver schemaResolver) {
        this._serverNodeUri = serverNodeUri;
        this._docBaseUri = UriBuilder.fromUri((URI)serverNodeUri).path("restli").path("docs").build(new Object[0]);
        this._relationships = relationships;
        this._resourceSchemas = this._relationships.getResourceSchemaCollection();
        this._templatingEngine = templatingEngine;
        this._schemaResolver = schemaResolver;
    }

    @Override
    public void renderHome(OutputStream out) {
        Map<String, Object> pageModel = this.createPageModel();
        pageModel.put("resourceSchemas", this._resourceSchemas.getResources());
        pageModel.put("dataModels", this._relationships.getDataModels());
        this._templatingEngine.render("main.vm", pageModel, out);
    }

    @Override
    public void renderResourceHome(OutputStream out) {
        Map<String, Object> pageModel = this.createPageModel();
        pageModel.put("resourceSchemas", this._resourceSchemas.getResources());
        this._templatingEngine.render("rest.vm", pageModel, out);
    }

    @Override
    public void renderResource(String resourceName, OutputStream out) {
        ResourceSchema resourceSchema = this._resourceSchemas.getResource(resourceName);
        List<ResourceSchema> parentResources = this._resourceSchemas.getParentResources(resourceSchema);
        ExampleRequestResponseGenerator generator = new ExampleRequestResponseGenerator(parentResources, resourceSchema, this._schemaResolver);
        if (resourceSchema == null) {
            throw new RoutingException(String.format("Resource \"%s\" does not exist", resourceName), HttpStatus.S_404_NOT_FOUND.getCode());
        }
        Map<String, Object> pageModel = this.createPageModel();
        pageModel.put("resource", resourceSchema);
        pageModel.put("resourceName", resourceName);
        pageModel.put("resourceFullName", ResourceSchemaUtil.getFullName(resourceSchema));
        pageModel.put("resourceType", RestLiHTMLDocumentationRenderer.getResourceType(resourceSchema));
        pageModel.put("subResources", this._resourceSchemas.getSubResources(resourceSchema));
        ArrayList<ResourceMethodDocView> restMethods = new ArrayList<ResourceMethodDocView>();
        ArrayList<ResourceMethodDocView> finders = new ArrayList<ResourceMethodDocView>();
        ArrayList<ResourceMethodDocView> actions = new ArrayList<ResourceMethodDocView>();
        MethodGatheringResourceSchemaVisitor visitor = new MethodGatheringResourceSchemaVisitor(resourceName);
        ResourceSchemaCollection.visitResources(this._resourceSchemas.getResources().values(), visitor);
        for (RecordTemplate recordTemplate : visitor.getAllMethods()) {
            ExampleRequestResponse capture;
            if (recordTemplate instanceof RestMethodSchema) {
                RestMethodSchema restMethodSchema = (RestMethodSchema)recordTemplate;
                capture = generator.method(ResourceMethod.valueOf((String)restMethodSchema.getMethod().toUpperCase()));
            } else if (recordTemplate instanceof FinderSchema) {
                FinderSchema finderMethodSchema = (FinderSchema)recordTemplate;
                capture = generator.finder(finderMethodSchema.getName());
            } else if (recordTemplate instanceof ActionSchema) {
                ActionSchema actionMethodSchema = (ActionSchema)recordTemplate;
                ResourceLevel resourceLevel = visitor.getCollectionActions().contains(recordTemplate) ? ResourceLevel.COLLECTION : ResourceLevel.ENTITY;
                capture = generator.action(actionMethodSchema.getName(), resourceLevel);
            } else {
                capture = null;
            }
            String requestEntity = null;
            String responseEntity = null;
            if (capture != null) {
                try {
                    DataMap entityMap;
                    if (capture.getRequest().getEntity().length() > 0) {
                        entityMap = DataMapUtils.readMap((RestMessage)capture.getRequest());
                        requestEntity = new String(_codec.mapToBytes(entityMap));
                    }
                    if (capture.getResponse() != null && capture.getResponse().getEntity() != null && capture.getResponse().getEntity().length() > 0) {
                        entityMap = DataMapUtils.readMap((RestMessage)capture.getResponse());
                        responseEntity = new String(_codec.mapToBytes(entityMap));
                    }
                }
                catch (IOException e) {
                    throw new RestLiInternalException((Throwable)e);
                }
            }
            ResourceMethodDocView docView = new ResourceMethodDocView(recordTemplate, capture, this.getDoc(recordTemplate, resourceSchema.hasSimple()), requestEntity, responseEntity);
            if (recordTemplate instanceof RestMethodSchema) {
                restMethods.add(docView);
                continue;
            }
            if (recordTemplate instanceof FinderSchema) {
                finders.add(docView);
                continue;
            }
            if (!(recordTemplate instanceof ActionSchema)) continue;
            actions.add(docView);
        }
        pageModel.put("restMethods", restMethods);
        pageModel.put("finders", finders);
        pageModel.put("actions", actions);
        this.addRelated(resourceSchema, pageModel);
        this._templatingEngine.render("resource.vm", pageModel, out);
    }

    @Override
    public void renderDataModelHome(OutputStream out) {
        Map<String, Object> pageModel = this.createPageModel();
        pageModel.put("dataModels", this._relationships.getDataModels());
        this._templatingEngine.render("data.vm", pageModel, out);
    }

    @Override
    public void renderDataModel(String dataModelName, OutputStream out) {
        NamedDataSchema schema = (NamedDataSchema)this._relationships.getDataModels().get(dataModelName);
        if (schema == null) {
            throw new RoutingException(String.format("Data model named '%s' does not exist", dataModelName), 404);
        }
        Map<String, Object> pageModel = this.createPageModel();
        pageModel.put("dataModel", schema);
        DataMap example = SchemaSampleDataGenerator.buildRecordData((NamedDataSchema)schema, (SchemaSampleDataGenerator.DataGenerationOptions)new SchemaSampleDataGenerator.DataGenerationOptions());
        try {
            pageModel.put("example", new String(_codec.mapToBytes(example)));
        }
        catch (IOException e) {
            throw new RestLiInternalException((Throwable)e);
        }
        this.addRelated(schema, pageModel);
        this._templatingEngine.render("dataModel.vm", pageModel, out);
    }

    @Override
    public boolean handleException(RuntimeException e, OutputStream out) {
        Map<String, Object> pageModel = this.createPageModel();
        pageModel.put("exception", e);
        pageModel.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)e));
        this._templatingEngine.render("exception.vm", pageModel, out);
        return true;
    }

    @Override
    public String getMIMEType() {
        return "text/html";
    }

    public void setJsonFormatUri(URI jsonFormatUri) {
        this._jsonFormatUri = URI.create(this._serverNodeUri.toString() + jsonFormatUri.toString());
    }

    private static String getResourceType(ResourceSchema resourceSchema) {
        if (resourceSchema.hasCollection()) {
            return "collection";
        }
        if (resourceSchema.hasAssociation()) {
            return "association";
        }
        if (resourceSchema.hasSimple()) {
            return "simple";
        }
        if (resourceSchema.hasActionsSet()) {
            return "actionSet";
        }
        return null;
    }

    private Map<String, Object> createPageModel() {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        pageModel.put("serverNodeUri", this._serverNodeUri);
        pageModel.put("docBaseUri", this._docBaseUri);
        pageModel.put("jsonFormatUri", this._jsonFormatUri);
        return pageModel;
    }

    private String getDoc(Object method, boolean isSimpleResourceMethod) {
        RestMethodSchema restMethodSchema;
        String doc = null;
        if (method instanceof RestMethodSchema && ((doc = (restMethodSchema = (RestMethodSchema)method).getDoc()) == null || doc.trim().length() == 0) && (doc = isSimpleResourceMethod ? _restMethodDocsMapForSimpleResource.get(restMethodSchema.getMethod()) : _restMethodDocsMapForCollection.get(restMethodSchema.getMethod())) == null) {
            log.warn(String.format("No doc string for REST method %s", doc));
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelated(Object parent, Map<String, Object> pageModel) {
        Map<String, NamedDataSchema> relatedSchemas;
        Map<String, ResourceSchema> relatedResources;
        Node<Object> node = this._relationships.getRelationships(parent);
        RestLiHTMLDocumentationRenderer restLiHTMLDocumentationRenderer = this;
        synchronized (restLiHTMLDocumentationRenderer) {
            ResourceSchema currResource;
            relatedResources = this._relatedResourceCache.get(parent);
            if (relatedResources == null) {
                relatedResources = new HashMap<String, ResourceSchema>();
                Iterator<Node<ResourceSchema>> resourcesItr = node.getAdjacency(ResourceSchema.class).iterator();
                while (resourcesItr.hasNext()) {
                    currResource = (ResourceSchema)resourcesItr.next().getObject();
                    relatedResources.put(currResource.getName(), currResource);
                }
                this._relatedResourceCache.put(parent, relatedResources);
            }
            if ((relatedSchemas = this._relatedSchemaCache.get(parent)) == null) {
                relatedSchemas = new HashMap<String, NamedDataSchema>();
                Iterator<Node<NamedDataSchema>> schemaItr = node.getAdjacency(NamedDataSchema.class).iterator();
                while (schemaItr.hasNext()) {
                    currResource = (NamedDataSchema)schemaItr.next().getObject();
                    relatedSchemas.put(currResource.getFullName(), (NamedDataSchema)currResource);
                }
                this._relatedSchemaCache.put(parent, relatedSchemas);
            }
        }
        pageModel.put("relatedResources", relatedResources);
        pageModel.put("relatedSchemas", relatedSchemas);
    }

    static {
        _restMethodDocsMapForCollection.put(ResourceMethod.BATCH_CREATE.toString(), "Creates multiple entities");
        _restMethodDocsMapForCollection.put(ResourceMethod.BATCH_DELETE.toString(), "Deletes multiple entities");
        _restMethodDocsMapForCollection.put(ResourceMethod.BATCH_GET.toString(), "Retrievies multiple entity representations given their keys");
        _restMethodDocsMapForCollection.put(ResourceMethod.BATCH_PARTIAL_UPDATE.toString(), "Partial update applied to multiple entities");
        _restMethodDocsMapForCollection.put(ResourceMethod.BATCH_UPDATE.toString(), "Replaces multiple entities");
        _restMethodDocsMapForCollection.put(ResourceMethod.CREATE.toString(), "Creates an entity");
        _restMethodDocsMapForCollection.put(ResourceMethod.DELETE.toString(), "Deletes an entity");
        _restMethodDocsMapForCollection.put(ResourceMethod.GET.toString(), "Gets a single entity given a key");
        _restMethodDocsMapForCollection.put(ResourceMethod.PARTIAL_UPDATE.toString(), "Updates parts of an entity given a key");
        _restMethodDocsMapForCollection.put(ResourceMethod.UPDATE.toString(), "Replaces an entity given a key");
        _restMethodDocsMapForSimpleResource.put(ResourceMethod.DELETE.toString(), "Deletes the entity");
        _restMethodDocsMapForSimpleResource.put(ResourceMethod.GET.toString(), "Gets the entity");
        _restMethodDocsMapForSimpleResource.put(ResourceMethod.UPDATE.toString(), "Replaces the entity");
        _codec.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
    }
}

