/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.docgen;

import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.schema.NamedDataSchema;
import com.linkedin.restli.docgen.Node;
import com.linkedin.restli.docgen.ResourceSchemaUtil;
import com.linkedin.restli.docgen.RestLiDocumentationRenderer;
import com.linkedin.restli.docgen.RestLiResourceRelationship;
import com.linkedin.restli.internal.server.RestLiInternalException;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.server.RoutingException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RestLiJSONDocumentationRenderer
implements RestLiDocumentationRenderer {
    private final RestLiResourceRelationship _relationships;
    private final JacksonDataCodec _codec = new JacksonDataCodec();
    private final Map<ResourceSchema, Map<String, DataMap>> _relatedSchemaCache = new HashMap<ResourceSchema, Map<String, DataMap>>();

    public RestLiJSONDocumentationRenderer(RestLiResourceRelationship relationships) {
        this._relationships = relationships;
    }

    @Override
    public void renderHome(OutputStream out) {
        this.renderResourceHome(out);
    }

    @Override
    public void renderResourceHome(OutputStream out) {
        DataMap outputMap = this.createEmptyOutput();
        try {
            for (ResourceSchema resourceSchema : new HashSet<ResourceSchema>(this._relationships.getResourceSchemaCollection().getResources().values())) {
                this.renderResource(resourceSchema, outputMap);
            }
            this._codec.writeMap(outputMap, out);
        }
        catch (IOException e) {
            throw new RestLiInternalException((Throwable)e);
        }
    }

    @Override
    public void renderResource(String resourceName, OutputStream out) {
        ResourceSchema resourceSchema = this._relationships.getResourceSchemaCollection().getResource(resourceName);
        if (resourceSchema == null) {
            throw new RoutingException(String.format("Resource named '%s' does not exist", resourceName), 404);
        }
        DataMap outputMap = this.createEmptyOutput();
        try {
            this.renderResource(resourceSchema, outputMap);
            this._codec.writeMap(outputMap, out);
        }
        catch (IOException e) {
            throw new RestLiInternalException((Throwable)e);
        }
    }

    @Override
    public void renderDataModelHome(OutputStream out) {
        DataMap outputMap = this.createEmptyOutput();
        try {
            for (NamedDataSchema schema : new HashSet<NamedDataSchema>(this._relationships.getDataModels().values())) {
                this.renderDataModel(schema, outputMap);
            }
            this._codec.writeMap(outputMap, out);
        }
        catch (IOException e) {
            throw new RestLiInternalException((Throwable)e);
        }
    }

    @Override
    public void renderDataModel(String dataModelName, OutputStream out) {
        NamedDataSchema schema = (NamedDataSchema)this._relationships.getDataModels().get(dataModelName);
        if (schema == null) {
            throw new RoutingException(String.format("Data model named '%s' does not exist", dataModelName), 404);
        }
        DataMap outputMap = this.createEmptyOutput();
        try {
            this.renderDataModel(schema, outputMap);
            this._codec.writeMap(outputMap, out);
        }
        catch (IOException e) {
            throw new RestLiInternalException((Throwable)e);
        }
    }

    @Override
    public boolean handleException(RuntimeException e, OutputStream out) {
        return false;
    }

    @Override
    public String getMIMEType() {
        return "application/json";
    }

    private DataMap createEmptyOutput() {
        DataMap emptyOutputMap = new DataMap();
        emptyOutputMap.put((Object)"resources", (Object)new DataMap());
        emptyOutputMap.put((Object)"models", (Object)new DataMap());
        return emptyOutputMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelatedModels(ResourceSchema resourceSchema, DataMap models) throws IOException {
        Map<String, DataMap> relatedSchemas;
        RestLiJSONDocumentationRenderer restLiJSONDocumentationRenderer = this;
        synchronized (restLiJSONDocumentationRenderer) {
            relatedSchemas = this._relatedSchemaCache.get(resourceSchema);
            if (relatedSchemas == null) {
                relatedSchemas = new HashMap<String, DataMap>();
                Node<ResourceSchema> node = this._relationships.getRelationships(resourceSchema);
                Iterator<Node<NamedDataSchema>> schemaItr = node.getAdjacency(NamedDataSchema.class).iterator();
                while (schemaItr.hasNext()) {
                    NamedDataSchema currResource = (NamedDataSchema)schemaItr.next().getObject();
                    relatedSchemas.put(currResource.getFullName(), this._codec.stringToMap(currResource.toString()));
                }
                this._relatedSchemaCache.put(resourceSchema, relatedSchemas);
            }
        }
        models.putAll(relatedSchemas);
    }

    private void renderResource(ResourceSchema resourceSchema, DataMap outputMap) throws IOException {
        DataMap resources = outputMap.getDataMap("resources");
        DataMap models = outputMap.getDataMap("models");
        resources.put((Object)ResourceSchemaUtil.getFullName(resourceSchema), (Object)resourceSchema.data());
        this.addRelatedModels(resourceSchema, models);
        List<ResourceSchema> subresources = this._relationships.getResourceSchemaCollection().getAllSubResources(resourceSchema);
        if (subresources != null) {
            for (ResourceSchema subresource : subresources) {
                resources.put((Object)ResourceSchemaUtil.getFullName(subresource), (Object)subresource.data());
                this.addRelatedModels(subresource, models);
            }
        }
    }

    private void renderDataModel(NamedDataSchema schema, DataMap outputMap) throws IOException {
        DataMap models = outputMap.getDataMap("models");
        DataMap schemaData = this._codec.stringToMap(schema.toString());
        models.put((Object)schema.getFullName(), (Object)schemaData);
    }
}

