/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.replication;

import java.util.HashMap;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.BaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestReplicationAdminWithClusters
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationAdminWithClusters.class);
    static Connection connection1;
    static Connection connection2;
    static Admin admin1;
    static Admin admin2;
    static ReplicationAdmin adminExt;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestReplicationBase.setUpBeforeClass();
        connection1 = ConnectionFactory.createConnection((Configuration)CONF1);
        connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
        admin1 = connection1.getAdmin();
        admin2 = connection2.getAdmin();
        adminExt = new ReplicationAdmin(CONF1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        admin1.close();
        admin2.close();
        adminExt.close();
        connection1.close();
        connection2.close();
        TestReplicationBase.tearDownAfterClass();
    }

    @Test
    public void disableNotFullReplication() throws Exception {
        HTableDescriptor table = new HTableDescriptor(admin2.getTableDescriptor(tableName));
        HColumnDescriptor f = new HColumnDescriptor("notReplicatedFamily");
        table.addFamily(f);
        admin1.disableTable(tableName);
        admin1.modifyTable(tableName, (TableDescriptor)table);
        admin1.enableTable(tableName);
        admin1.disableTableReplication(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)0L, (long)fam.getScope());
        }
        admin1.deleteColumnFamily(table.getTableName(), f.getName());
    }

    @Test
    public void testEnableReplicationWhenSlaveClusterDoesntHaveTable() throws Exception {
        admin1.disableTableReplication(tableName);
        admin2.disableTable(tableName);
        admin2.deleteTable(tableName);
        Assert.assertFalse((boolean)admin2.tableExists(tableName));
        admin1.enableTableReplication(tableName);
        Assert.assertTrue((boolean)admin2.tableExists(tableName));
    }

    @Test
    public void testEnableReplicationWhenReplicationNotEnabled() throws Exception {
        HTableDescriptor table = new HTableDescriptor(admin1.getTableDescriptor(tableName));
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            fam.setScope(0);
        }
        admin1.disableTable(tableName);
        admin1.modifyTable(tableName, (TableDescriptor)table);
        admin1.enableTable(tableName);
        admin2.disableTable(tableName);
        admin2.modifyTable(tableName, (TableDescriptor)table);
        admin2.enableTable(tableName);
        admin1.enableTableReplication(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)fam.getScope());
        }
    }

    @Test
    public void testEnableReplicationWhenTableDescriptorIsNotSameInClusters() throws Exception {
        HTableDescriptor table = new HTableDescriptor(admin2.getTableDescriptor(tableName));
        HColumnDescriptor f = new HColumnDescriptor("newFamily");
        table.addFamily(f);
        admin2.disableTable(tableName);
        admin2.modifyTable(tableName, (TableDescriptor)table);
        admin2.enableTable(tableName);
        try {
            admin1.enableTableReplication(tableName);
            Assert.fail((String)"Exception should be thrown if table descriptors in the clusters are not same.");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        admin1.disableTable(tableName);
        admin1.modifyTable(tableName, (TableDescriptor)table);
        admin1.enableTable(tableName);
        admin1.enableTableReplication(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)fam.getScope());
        }
        admin1.deleteColumnFamily(tableName, f.getName());
        admin2.deleteColumnFamily(tableName, f.getName());
    }

    @Test
    public void testDisableAndEnableReplication() throws Exception {
        admin1.disableTableReplication(tableName);
        HTableDescriptor table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)0L, (long)fam.getScope());
        }
        admin1.enableTableReplication(tableName);
        table = admin1.getTableDescriptor(tableName);
        for (HColumnDescriptor fam : table.getColumnFamilies()) {
            Assert.assertEquals((long)1L, (long)fam.getScope());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableReplicationForTableWithRegionReplica() throws Exception {
        TableName tn = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setRegionReplication(5).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])noRepfamName).build()).build();
        admin1.createTable(td);
        try {
            admin1.enableTableReplication(tn);
            td = admin1.getDescriptor(tn);
            for (ColumnFamilyDescriptor fam : td.getColumnFamilies()) {
                Assert.assertEquals((long)1L, (long)fam.getScope());
            }
        }
        finally {
            UTIL1.deleteTable(tn);
            UTIL2.deleteTable(tn);
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testDisableReplicationForNonExistingTable() throws Exception {
        admin1.disableTableReplication(TableName.valueOf((String)this.name.getMethodName()));
    }

    @Test(expected=TableNotFoundException.class)
    public void testEnableReplicationForNonExistingTable() throws Exception {
        admin1.enableTableReplication(TableName.valueOf((String)this.name.getMethodName()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDisableReplicationWhenTableNameAsNull() throws Exception {
        admin1.disableTableReplication(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEnableReplicationWhenTableNameAsNull() throws Exception {
        admin1.enableTableReplication(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableReplicationForExplicitSetTableCfs() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String peerId = "2";
        if (admin2.isTableAvailable(TestReplicationBase.tableName)) {
            admin2.disableTable(TestReplicationBase.tableName);
            admin2.deleteTable(TestReplicationBase.tableName);
        }
        Assert.assertFalse((String)"Table should not exists in the peer cluster", (boolean)admin2.isTableAvailable(TestReplicationBase.tableName));
        ReplicationPeerConfig rpc = admin1.getReplicationPeerConfig(peerId);
        rpc.setReplicateAllUserTables(false);
        admin1.updateReplicationPeerConfig(peerId, rpc);
        HashMap<TableName, Object> tableCfs = new HashMap<TableName, Object>();
        tableCfs.put(tableName, null);
        try {
            adminExt.setPeerTableCFs(peerId, tableCfs);
            admin1.enableTableReplication(TestReplicationBase.tableName);
            Assert.assertFalse((String)"Table should not be created if user has set table cfs explicitly for the peer and this is not part of that collection", (boolean)admin2.isTableAvailable(TestReplicationBase.tableName));
            tableCfs.put(TestReplicationBase.tableName, null);
            adminExt.setPeerTableCFs(peerId, tableCfs);
            admin1.enableTableReplication(TestReplicationBase.tableName);
            Assert.assertTrue((String)"Table should be created if user has explicitly added table into table cfs collection", (boolean)admin2.isTableAvailable(TestReplicationBase.tableName));
        }
        finally {
            adminExt.removePeerTableCFs(peerId, adminExt.getPeerTableCFs(peerId));
            admin1.disableTableReplication(TestReplicationBase.tableName);
            rpc = admin1.getReplicationPeerConfig(peerId);
            rpc.setReplicateAllUserTables(true);
            admin1.updateReplicationPeerConfig(peerId, rpc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Test
    public void testReplicationPeerConfigUpdateCallback() throws Exception {
        String peerId = "1";
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(UTIL2.getClusterKey());
        rpc.setReplicationEndpointImpl(TestUpdatableReplicationEndpoint.class.getName());
        rpc.getConfiguration().put("key1", "value1");
        admin1.addReplicationPeer(peerId, rpc);
        rpc.getConfiguration().put("key1", "value2");
        admin.updatePeerConfig(peerId, rpc);
        if (!TestUpdatableReplicationEndpoint.hasCalledBack()) {
            Class<TestUpdatableReplicationEndpoint> clazz = TestUpdatableReplicationEndpoint.class;
            // MONITORENTER : org.apache.hadoop.hbase.client.replication.TestReplicationAdminWithClusters$TestUpdatableReplicationEndpoint.class
            TestUpdatableReplicationEndpoint.class.wait(2000L);
            // MONITOREXIT : clazz
        }
        Assert.assertEquals((Object)true, (Object)TestUpdatableReplicationEndpoint.hasCalledBack());
        admin.removePeer(peerId);
    }

    public static class TestUpdatableReplicationEndpoint
    extends BaseReplicationEndpoint {
        private static boolean calledBack = false;

        public static boolean hasCalledBack() {
            return calledBack;
        }

        public synchronized void peerConfigUpdated(ReplicationPeerConfig rpc) {
            calledBack = true;
            ((Object)((Object)this)).notifyAll();
        }

        public void start() {
            this.startAsync();
        }

        public void stop() {
            this.stopAsync();
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }

        public UUID getPeerUUID() {
            UTIL1;
            return HBaseTestingUtility.getRandomUUID();
        }

        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            return false;
        }
    }
}

