/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;

/**
 * This UDF is packaged in a standalone jar to be used in {@link org.apache.hadoop.hive.ql.session.TestUdfClassLoaderAcrossSessions}
 * After changing this file, recompile and rejar it manually into DummyUDF.jar
 * Run:
 * - javac -cp <hiveroot>/ql/target/hive-exec-<version>.jar DummyUDF.java
 * - jar cf DummyUDF.jar DummyUDF.class
 */
@Description(name = "dummy",
    value = "_FUNC_(col) this UDF does nothing")
public class DummyUDF extends UDF {
  public int evaluate(Boolean b) {
    return b ? 1 : 0;
  }
}