/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.NewTableEntry;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntryType;

public class NewTableEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class NewTableEntrySerializerV2
    implements CatalogObjectSerializer<NewTableEntry> {
        NewTableEntrySerializerV2() {
        }

        @Override
        public NewTableEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogTableDescriptor descriptor = input.readEntry(CatalogTableDescriptor.class);
            return new NewTableEntry(descriptor);
        }

        @Override
        public void writeTo(NewTableEntry entry, CatalogObjectDataOutput output) throws IOException {
            output.writeEntry(entry.descriptor());
        }
    }

    @CatalogSerializer(version=1, since="3.0.0")
    static class NewTableEntrySerializerV1
    implements CatalogObjectSerializer<NewTableEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public NewTableEntrySerializerV1(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public NewTableEntry readFrom(CatalogObjectDataInput input) throws IOException {
            CatalogObjectSerializer serializer = this.serializers.get(1, MarshallableEntryType.DESCRIPTOR_TABLE.id());
            CatalogTableDescriptor descriptor = (CatalogTableDescriptor)serializer.readFrom(input);
            return new NewTableEntry(descriptor);
        }

        @Override
        public void writeTo(NewTableEntry entry, CatalogObjectDataOutput output) throws IOException {
            this.serializers.get(1, entry.descriptor().typeId()).writeTo(entry.descriptor(), output);
        }
    }
}

