/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.network.IgniteCluster;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingIgniteCluster
implements IgniteCluster,
Wrapper {
    private final IgniteCluster cluster;

    public PublicApiThreadingIgniteCluster(IgniteCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.cluster);
    }

    @Override
    public UUID id() {
        return PublicApiThreading.execUserSyncOperation(this.cluster::id);
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return PublicApiThreading.execUserSyncOperation(this.cluster::nodes);
    }

    @Override
    public CompletableFuture<Collection<ClusterNode>> nodesAsync() {
        return CompletableFuture.completedFuture(this.nodes());
    }

    @Override
    @Nullable
    public ClusterNode localNode() {
        return PublicApiThreading.execUserSyncOperation(this.cluster::localNode);
    }
}

