/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.ignite3.internal.raft.Command;
import org.apache.ignite3.internal.raft.service.RaftCommandRunner;
import org.apache.ignite3.internal.thread.PublicApiThreading;

public class ExecutorInclinedRaftCommandRunner
implements RaftCommandRunner {
    private final RaftCommandRunner commandRunner;
    private final Executor completionExecutor;

    public ExecutorInclinedRaftCommandRunner(RaftCommandRunner commandRunner, Executor completionExecutor) {
        this.commandRunner = commandRunner;
        this.completionExecutor = completionExecutor;
    }

    @Override
    public <R> CompletableFuture<R> run(Command cmd) {
        return this.decorateFuture(this.commandRunner.run(cmd));
    }

    @Override
    public <R> CompletableFuture<R> run(Command cmd, long timeoutMillis) {
        return this.decorateFuture(this.commandRunner.run(cmd, timeoutMillis));
    }

    private <T> CompletableFuture<T> decorateFuture(CompletableFuture<T> originalFuture) {
        if (originalFuture.isDone()) {
            return originalFuture;
        }
        if (PublicApiThreading.executingSyncPublicApi()) {
            try {
                return CompletableFuture.completedFuture(originalFuture.get());
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        return originalFuture.thenApplyAsync(Function.identity(), this.completionExecutor);
    }

    public RaftCommandRunner decoratedCommandRunner() {
        return this.commandRunner;
    }
}

