/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.schema;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.binarytuple.BinaryTupleParser;
import org.apache.ignite3.internal.binarytuple.ByteBufferAccessor;
import org.apache.ignite3.internal.util.GridUnsafe;

public class UnsafeByteBufferAccessor
implements ByteBufferAccessor {
    private static final boolean REVERSE_BYTE_ORDER = GridUnsafe.NATIVE_BYTE_ORDER != BinaryTupleParser.ORDER;
    private final byte[] bytes;
    private final long addr;
    private final int capacity;

    public UnsafeByteBufferAccessor(ByteBuffer buff) {
        if (buff.isDirect()) {
            this.bytes = null;
            this.addr = GridUnsafe.bufferAddress(buff);
        } else {
            this.bytes = buff.array();
            this.addr = GridUnsafe.BYTE_ARR_OFF + (long)buff.arrayOffset();
        }
        this.capacity = buff.capacity();
    }

    @Override
    public byte get(int p) {
        return GridUnsafe.getByte(this.bytes, this.addr + (long)p);
    }

    @Override
    public int getInt(int p) {
        int value = GridUnsafe.getInt(this.bytes, this.addr + (long)p);
        return REVERSE_BYTE_ORDER ? Integer.reverseBytes(value) : value;
    }

    @Override
    public long getLong(int p) {
        long value = GridUnsafe.getLong(this.bytes, this.addr + (long)p);
        return REVERSE_BYTE_ORDER ? Long.reverseBytes(value) : value;
    }

    @Override
    public short getShort(int p) {
        short value = GridUnsafe.getShort(this.bytes, this.addr + (long)p);
        return REVERSE_BYTE_ORDER ? Short.reverseBytes(value) : value;
    }

    @Override
    public float getFloat(int p) {
        float value = GridUnsafe.getFloat(this.bytes, this.addr + (long)p);
        return REVERSE_BYTE_ORDER ? Float.intBitsToFloat(Integer.reverseBytes(Float.floatToIntBits(value))) : value;
    }

    @Override
    public double getDouble(int p) {
        double value = GridUnsafe.getDouble(this.bytes, this.addr + (long)p);
        return REVERSE_BYTE_ORDER ? Double.longBitsToDouble(Long.reverseBytes(Double.doubleToLongBits(value))) : value;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    public byte[] getArray() {
        return this.bytes;
    }

    public long getAddress() {
        return this.addr;
    }
}

