/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlKeyConstraint;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlPrimaryKeyIndexType;
import org.apache.ignite3.internal.sql.engine.sql.IgniteSqlSpecialOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSqlPrimaryKeyConstraint
extends IgniteSqlKeyConstraint {
    public IgniteSqlPrimaryKeyConstraint(SqlParserPos pos, @Nullable SqlIdentifier name, SqlNodeList columnList, IgniteSqlPrimaryKeyIndexType indexType) {
        super((SqlOperator)new Operator(indexType), pos, name, columnList);
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.name, (Object)this.columnList);
    }

    public IgniteSqlPrimaryKeyIndexType getIndexType() {
        return this.operator().indexType;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.name != null) {
            writer.keyword("CONSTRAINT");
            this.name.unparse(writer, 0, 0);
        }
        writer.keyword(this.getOperator().getName());
        Operator operator = this.operator();
        if (operator.indexType != IgniteSqlPrimaryKeyIndexType.IMPLICIT_HASH) {
            writer.keyword("USING");
            writer.keyword(operator.indexType.name());
        }
        this.columnList.unparse(writer, 1, 1);
    }

    protected Operator operator() {
        return (Operator)this.getOperator();
    }

    protected static class Operator
    extends IgniteSqlSpecialOperator {
        private final IgniteSqlPrimaryKeyIndexType indexType;

        protected Operator(IgniteSqlPrimaryKeyIndexType indexType) {
            super("PRIMARY KEY", SqlKind.PRIMARY_KEY);
            this.indexType = Objects.requireNonNull(indexType, "indexType");
        }

        @Override
        public SqlCall createCall(@Nullable SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new IgniteSqlPrimaryKeyConstraint(pos, (SqlIdentifier)operands[0], new SqlNodeList(Arrays.asList(operands), pos), this.indexType);
        }
    }
}

