/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.ignite3.internal.configuration.SystemLocalConfiguration;
import org.apache.ignite3.internal.configuration.SystemLocalView;
import org.apache.ignite3.internal.configuration.SystemPropertyView;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.metrics.LongGauge;
import org.apache.ignite3.internal.metrics.MetricManager;
import org.apache.ignite3.internal.pagememory.DataRegion;
import org.apache.ignite3.internal.pagememory.FullPageId;
import org.apache.ignite3.internal.pagememory.configuration.PersistentDataRegionConfiguration;
import org.apache.ignite3.internal.pagememory.configuration.ReplacementMode;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite3.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite3.internal.pagememory.persistence.PersistentPageMemoryMetricSource;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite3.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite3.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite3.internal.pagememory.persistence.throttling.PagesWriteSpeedBasedThrottle;
import org.apache.ignite3.internal.pagememory.persistence.throttling.PagesWriteThrottlePolicy;
import org.apache.ignite3.internal.pagememory.persistence.throttling.TargetRatioPagesWriteThrottle;
import org.apache.ignite3.internal.pagememory.persistence.throttling.ThrottlingType;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.configurations.StorageProfileView;
import org.apache.ignite3.internal.storage.engine.StorageEngine;
import org.apache.ignite3.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileConfiguration;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileView;
import org.apache.ignite3.internal.storage.pagememory.mv.PersistentPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.util.OffheapReadWriteLock;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PersistentPageMemoryDataRegion
implements DataRegion<PersistentPageMemory> {
    private static final IgniteLogger LOG = Loggers.forClass(PersistentPageMemoryDataRegion.class);
    private static final double PAGE_LIST_CACHE_LIMIT_THRESHOLD = 0.1;
    private final MetricManager metricManager;
    private final PersistentPageMemoryProfileConfiguration cfg;
    @Nullable
    private final SystemLocalConfiguration systemLocalConfig;
    private final PageIoRegistry ioRegistry;
    private final int pageSize;
    private final FilePageStoreManager filePageStoreManager;
    private final PartitionMetaManager partitionMetaManager;
    private final CheckpointManager checkpointManager;
    private volatile PersistentPageMemory pageMemory;
    private volatile AtomicLong pageListCacheLimit;
    private final PersistentPageMemoryMetricSource metricSource;
    private final Collection<PersistentPageMemoryTableStorage> tableStorages = ConcurrentHashMap.newKeySet();

    public PersistentPageMemoryDataRegion(MetricManager metricManager, PersistentPageMemoryProfileConfiguration cfg, @Nullable SystemLocalConfiguration systemLocalConfig, PageIoRegistry ioRegistry, FilePageStoreManager filePageStoreManager, PartitionMetaManager partitionMetaManager, CheckpointManager checkpointManager, int pageSize) {
        this.metricManager = metricManager;
        this.cfg = cfg;
        this.systemLocalConfig = systemLocalConfig;
        this.ioRegistry = ioRegistry;
        this.pageSize = pageSize;
        this.filePageStoreManager = filePageStoreManager;
        this.partitionMetaManager = partitionMetaManager;
        this.checkpointManager = checkpointManager;
        this.metricSource = new PersistentPageMemoryMetricSource("storage.aipersist." + ((StorageProfileView)cfg.value()).name());
    }

    public void start() {
        PersistentPageMemoryProfileView dataRegionConfigView = (PersistentPageMemoryProfileView)this.cfg.value();
        long sizeBytes = dataRegionConfigView.sizeBytes();
        if (sizeBytes == -1L) {
            sizeBytes = StorageEngine.defaultDataRegionSize();
            LOG.info("{}.{} property is not specified, setting its value to {}", this.cfg.name().value(), this.cfg.sizeBytes().key(), sizeBytes);
        }
        PersistentPageMemory pageMemory = new PersistentPageMemory(PersistentPageMemoryDataRegion.regionConfiguration(dataRegionConfigView, sizeBytes, this.pageSize), this.metricSource, this.ioRegistry, PersistentPageMemoryDataRegion.calculateSegmentSizes(sizeBytes, Runtime.getRuntime().availableProcessors()), PersistentPageMemoryDataRegion.calculateCheckpointBufferSize(sizeBytes), this.filePageStoreManager, this::flushDirtyPageOnReplacement, this.checkpointManager.checkpointTimeoutLock(), new OffheapReadWriteLock(128), this.checkpointManager.partitionDestructionLockManager());
        this.initThrottling(pageMemory);
        pageMemory.start();
        this.initMetrics();
        this.metricManager.registerSource(this.metricSource);
        this.metricManager.enable(this.metricSource);
        this.pageListCacheLimit = new AtomicLong((long)((double)pageMemory.totalPages() * 0.1));
        this.pageMemory = pageMemory;
    }

    private static PersistentDataRegionConfiguration regionConfiguration(PersistentPageMemoryProfileView cfg, long sizeBytes, int pageSize) {
        return PersistentDataRegionConfiguration.builder().name(cfg.name()).pageSize(pageSize).size(sizeBytes).replacementMode(ReplacementMode.valueOf(cfg.replacementMode())).build();
    }

    private void initThrottling(PersistentPageMemory pageMemory) {
        ThrottlingType throttlingType = this.getThrottlingType();
        switch (throttlingType) {
            case DISABLED: {
                break;
            }
            case TARGET_RATIO: {
                pageMemory.initThrottling(new TargetRatioPagesWriteThrottle(this.getLoggingThreshold(), pageMemory, this.checkpointManager::currentCheckpointProgressForThrottling, this.checkpointManager.checkpointTimeoutLock()::checkpointLockIsHeldByThread, this.metricSource));
                break;
            }
            case SPEED_BASED: {
                pageMemory.initThrottling(new PagesWriteSpeedBasedThrottle(this.getLoggingThreshold(), this.getMinDirtyPages(), this.getMaxDirtyPages(), pageMemory, this.checkpointManager::currentCheckpointProgressForThrottling, this.checkpointManager.checkpointTimeoutLock()::checkpointLockIsHeldByThread, this.metricSource));
                break;
            }
            default: {
                assert (false) : "Impossible throttling type: " + throttlingType;
                break;
            }
        }
    }

    private ThrottlingType getThrottlingType() {
        return this.getSystemConfig("aipersistThrottling", ThrottlingType.SPEED_BASED, value -> ThrottlingType.valueOf(value.toUpperCase()), "Valid values are (case-insensitive): " + Arrays.toString((Object[])ThrottlingType.values()) + ".");
    }

    private long getLoggingThreshold() {
        return TimeUnit.MILLISECONDS.toNanos(this.getSystemConfig("aipersistThrottlingLogThresholdMillis", TimeUnit.NANOSECONDS.toMillis(PagesWriteThrottlePolicy.DEFAULT_LOGGING_THRESHOLD), value -> {
            long logThresholdMillis = Long.parseLong(value);
            if (logThresholdMillis <= 0L) {
                throw new IllegalArgumentException();
            }
            return logThresholdMillis;
        }, "Positive integer is expected."));
    }

    private double getMinDirtyPages() {
        return this.getSystemConfig("aipersistThrottlingMinDirtyPages", 0.5, value -> {
            double maxDirtyPages = Double.parseDouble(value);
            if (maxDirtyPages <= 0.01 || maxDirtyPages > 0.75) {
                throw new IllegalArgumentException();
            }
            return maxDirtyPages;
        }, "Floating point value in a range (0.01, 0.75] is expected.");
    }

    private double getMaxDirtyPages() {
        return this.getSystemConfig("aipersistThrottlingMaxDirtyPages", 0.9, value -> {
            double maxDirtyPages = Double.parseDouble(value);
            if (maxDirtyPages <= 0.5 || maxDirtyPages > 0.99999) {
                throw new IllegalArgumentException();
            }
            return maxDirtyPages;
        }, "Floating point value in a range (0.5, 0.99999] is expected.");
    }

    private <T> T getSystemConfig(String name, T defaultValue, Function<String, T> parseFunction, String extraErrorMessage) {
        SystemPropertyView property = this.systemLocalConfig == null ? null : ((SystemLocalView)this.systemLocalConfig.value()).properties().get(name);
        T value = defaultValue;
        try {
            if (property != null) {
                value = parseFunction.apply(property.propertyValue());
            }
        }
        catch (Exception e) {
            LOG.warn("Invalid throttling configuration {}={}, using default value {}. " + extraErrorMessage, name, property.propertyValue(), defaultValue);
        }
        return value;
    }

    public void stop() throws Exception {
        if (this.pageMemory != null) {
            this.pageMemory.stop(true);
            this.metricManager.unregisterSource(this.metricSource);
        }
    }

    private void flushDirtyPageOnReplacement(PersistentPageMemory pageMemory, FullPageId fullPageId, ByteBuffer byteBuffer) throws IgniteInternalCheckedException {
        this.checkpointManager.writePageToFilePageStore(pageMemory, fullPageId, byteBuffer);
        CheckpointProgress checkpointProgress = this.checkpointManager.currentCheckpointProgress();
        if (checkpointProgress != null) {
            checkpointProgress.evictedPagesCounter().incrementAndGet();
        }
    }

    @Override
    public PersistentPageMemory pageMemory() {
        this.checkDataRegionStarted();
        return this.pageMemory;
    }

    public FilePageStoreManager filePageStoreManager() {
        return this.filePageStoreManager;
    }

    public PartitionMetaManager partitionMetaManager() {
        return this.partitionMetaManager;
    }

    public CheckpointManager checkpointManager() {
        return this.checkpointManager;
    }

    public AtomicLong pageListCacheLimit() {
        this.checkDataRegionStarted();
        return this.pageListCacheLimit;
    }

    static long[] calculateSegmentSizes(long size, int concurrencyLevel) {
        assert (concurrencyLevel > 0) : concurrencyLevel;
        long maxSize = size;
        long fragmentSize = Math.max(maxSize / (long)concurrencyLevel, 0x100000L);
        long[] sizes = new long[concurrencyLevel];
        Arrays.fill(sizes, fragmentSize);
        return sizes;
    }

    static long calculateCheckpointBufferSize(long size) {
        long maxSize = size;
        if (maxSize < 0x40000000L) {
            return Math.min(0x10000000L, maxSize);
        }
        if (maxSize < 0x200000000L) {
            return maxSize / 4L;
        }
        return 0x80000000L;
    }

    private void checkDataRegionStarted() {
        if (this.pageMemory == null) {
            throw new StorageException("Data region not started");
        }
    }

    @VisibleForTesting
    public void addTableStorage(PersistentPageMemoryTableStorage tableStorage) {
        boolean add = this.tableStorages.add(tableStorage);
        assert (add) : tableStorage.getTableId();
    }

    void removeTableStorage(PersistentPageMemoryTableStorage tableStorage) {
        this.tableStorages.remove(tableStorage);
    }

    private void initMetrics() {
        this.metricSource.addMetric(new LongGauge("TotalAllocatedSize", "Total size of allocated pages on disk in bytes.", this::totalAllocatedPagesSizeOnDiskInBytes));
        this.metricSource.addMetric(new LongGauge("TotalUsedSize", "Total size of non-empty allocated pages on disk in bytes.", this::totalNonEmptyAllocatedPagesSizeOnDiskInBytes));
    }

    private long totalAllocatedPagesSizeOnDiskInBytes() {
        long pageCount = 0L;
        for (PersistentPageMemoryTableStorage tableStorage : this.tableStorages) {
            for (PersistentPageMemoryMvPartitionStorage partitionStorage : tableStorage.mvPartitionStorages.getAll()) {
                pageCount += this.allocatedPageCountOnDisk(tableStorage.getTableId(), partitionStorage.partitionId());
            }
        }
        return pageCount * (long)this.pageSize;
    }

    private long totalNonEmptyAllocatedPagesSizeOnDiskInBytes() {
        long pageCount = 0L;
        for (PersistentPageMemoryTableStorage tableStorage : this.tableStorages) {
            for (PersistentPageMemoryMvPartitionStorage partitionStorage : tableStorage.mvPartitionStorages.getAll()) {
                pageCount += this.allocatedPageCountOnDisk(tableStorage.getTableId(), partitionStorage.partitionId());
                pageCount -= (long)partitionStorage.emptyDataPageCountInFreeList();
            }
        }
        return pageCount * (long)this.pageSize;
    }

    private long allocatedPageCountOnDisk(int tableId, int partitionId) {
        FilePageStore store = this.filePageStoreManager.getStore(new GroupPartitionId(tableId, partitionId));
        return store == null ? 0L : (long)store.pages();
    }
}

