/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.tiff.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteWriter {
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();
    private ByteOrder byteOrder = null;

    public ByteWriter() {
        this(ByteOrder.nativeOrder());
    }

    public ByteWriter(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void close() {
        try {
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.os;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public byte[] getBytes() {
        return this.os.toByteArray();
    }

    public int size() {
        return this.os.size();
    }

    public int writeString(String value) throws IOException {
        byte[] valueBytes = value.getBytes();
        this.os.write(valueBytes);
        return valueBytes.length;
    }

    public void writeByte(byte value) {
        this.os.write(value);
    }

    public void writeUnsignedByte(short value) {
        this.os.write((byte)(value & 0xFF));
    }

    public void writeBytes(byte[] value) throws IOException {
        this.os.write(value);
    }

    public void writeShort(short value) throws IOException {
        byte[] valueBytes = new byte[2];
        ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(this.byteOrder).putShort(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }

    public void writeUnsignedShort(int value) throws IOException {
        byte[] valueBytes = new byte[2];
        ByteBuffer byteBuffer = ByteBuffer.allocate(2).order(this.byteOrder).putShort((short)(value & 0xFFFF));
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }

    public void writeInt(int value) throws IOException {
        byte[] valueBytes = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this.byteOrder).putInt(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }

    public void writeUnsignedInt(long value) throws IOException {
        byte[] valueBytes = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this.byteOrder).putInt((int)(value & 0xFFFFFFFFL));
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }

    public void writeFloat(float value) throws IOException {
        byte[] valueBytes = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(this.byteOrder).putFloat(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }

    public void writeDouble(double value) throws IOException {
        byte[] valueBytes = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).order(this.byteOrder).putDouble(value);
        byteBuffer.flip();
        byteBuffer.get(valueBytes);
        this.os.write(valueBytes);
    }
}

