/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractPublisherGroupBy;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.GroupedPublisher;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class PublisherGroupBy<Key, T>
extends AbstractPublisherGroupBy<Key, T> {
    private final Function<? super T, ? extends Key> keySelector;

    PublisherGroupBy(Publisher<T> original, Function<? super T, ? extends Key> keySelector, int queueLimit) {
        super(original, queueLimit);
        this.keySelector = Objects.requireNonNull(keySelector);
    }

    PublisherGroupBy(Publisher<T> original, Function<? super T, ? extends Key> keySelector, int queueLimit, int expectedGroupCountHint) {
        super(original, queueLimit, expectedGroupCountHint);
        this.keySelector = Objects.requireNonNull(keySelector);
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super GroupedPublisher<Key, T>> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new GroupBySubscriber(subscriber, this.queueLimit, this.initialCapacityForGroups, contextMap, contextProvider), contextMap, contextProvider);
    }

    private final class GroupBySubscriber
    extends AbstractPublisherGroupBy.AbstractGroupBySubscriber<Key, T> {
        GroupBySubscriber(PublisherSource.Subscriber<? super GroupedPublisher<Key, T>> target, int maxQueueSize, int initialCapacityForGroups, ContextMap contextMap, AsyncContextProvider contextProvider) {
            super(target, maxQueueSize, initialCapacityForGroups, contextMap, contextProvider);
        }

        public void onNext(@Nullable T t) {
            this.onNext(Objects.requireNonNull(PublisherGroupBy.this.keySelector.apply(t), () -> "Selector " + PublisherGroupBy.this.keySelector + " returned null"), t);
        }
    }
}

