/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleCompletableSubscriber
extends SequentialCancellable
implements CompletableSource.Subscriber {
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleCompletableSubscriber.class);
    private final Runnable onComplete;

    SimpleCompletableSubscriber() {
        this(NOOP_RUNNABLE);
    }

    SimpleCompletableSubscriber(Runnable onComplete) {
        this.onComplete = Objects.requireNonNull(onComplete);
    }

    public void onSubscribe(Cancellable cancellable) {
        this.nextCancellable(cancellable);
    }

    public void onComplete() {
        try {
            this.onComplete.run();
        }
        catch (Throwable t) {
            LOGGER.debug("Received exception from the onComplete Runnable {}.", (Object)this.onComplete, (Object)t);
        }
    }

    public void onError(Throwable t) {
        LOGGER.debug("Received exception from the source.", t);
    }
}

