/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.EmptyBuffer;
import io.servicetalk.buffer.netty.NettyBuffer;
import io.servicetalk.buffer.netty.ServiceTalkBufferAllocator;
import io.servicetalk.buffer.netty.WrappedBuffer;
import javax.annotation.Nullable;

public final class BufferUtils {
    static final BufferAllocator PREFER_HEAP_ALLOCATOR = new ServiceTalkBufferAllocator(false);
    static final BufferAllocator PREFER_DIRECT_ALLOCATOR = new ServiceTalkBufferAllocator(true);

    private BufferUtils() {
    }

    public static ByteBuf toByteBuf(Buffer buffer) {
        ByteBuf buf = BufferUtils.toByteBufNoThrow(buffer);
        if (buf == null) {
            throw new UnsupportedOperationException("Only NettyBuffer is supported");
        }
        return buf;
    }

    public static ByteBuf extractByteBufOrCreate(Buffer buffer) {
        ByteBuf buf = BufferUtils.toByteBufNoThrow(buffer);
        if (buf == null) {
            if (buffer.hasArray()) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])buffer.array(), (int)buffer.arrayOffset(), (int)buffer.capacity());
                byteBuf.readerIndex(buffer.readerIndex()).writerIndex(buffer.writerIndex());
                return byteBuf;
            }
            byte[] data = new byte[buffer.capacity()];
            buffer.getBytes(0, data, 0, data.length);
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])data);
            byteBuf.readerIndex(buffer.readerIndex()).writerIndex(buffer.writerIndex());
            return byteBuf;
        }
        return buf;
    }

    @Nullable
    public static ByteBuf toByteBufNoThrow(Buffer buffer) {
        if (buffer instanceof NettyBuffer) {
            return ((NettyBuffer)buffer).buffer;
        }
        if (buffer instanceof WrappedBuffer) {
            return BufferUtils.toByteBufNoThrow(((WrappedBuffer)buffer).buffer);
        }
        if (buffer instanceof EmptyBuffer) {
            return Unpooled.EMPTY_BUFFER;
        }
        return null;
    }

    public static ByteBufAllocator getByteBufAllocator(BufferAllocator allocator) {
        return (ByteBufAllocator)(allocator instanceof ByteBufAllocator ? allocator : (PlatformDependent.directBufferPreferred() ? PREFER_DIRECT_ALLOCATOR : PREFER_HEAP_ALLOCATOR));
    }

    public static Buffer newBufferFrom(ByteBuf buffer) {
        return new NettyBuffer<ByteBuf>(buffer);
    }

    public static int maxUtf8Bytes(CharSequence data) {
        return ByteBufUtil.utf8MaxBytes((CharSequence)data);
    }
}

