/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc.dto;

import org.apache.baremaps.iploc.data.InetnumLocation;
import org.apache.baremaps.iploc.data.Ipv4;

public class InetnumLocationDto {
    private final String address;
    private final String ipv4Start;
    private final String ipv4End;
    private final double latitude;
    private final double longitude;
    private final String network;
    private final String country;

    public InetnumLocationDto(InetnumLocation inetnumLocation) {
        this.address = inetnumLocation.getAddress();
        this.ipv4Start = Ipv4.format(inetnumLocation.getIpv4Range().getStart());
        this.ipv4End = Ipv4.format(inetnumLocation.getIpv4Range().getEnd());
        this.latitude = inetnumLocation.getLocation().getLatitude();
        this.longitude = inetnumLocation.getLocation().getLongitude();
        this.network = inetnumLocation.getNetwork();
        this.country = inetnumLocation.getCountry();
    }

    public String getAddress() {
        return this.address;
    }

    public String getIpv4Start() {
        return this.ipv4Start;
    }

    public String getIpv4End() {
        return this.ipv4End;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getCountry() {
        return this.country;
    }

    public String toString() {
        return "InetnumLocationDto{address='" + this.address + "', ipv4Start='" + this.ipv4Start + "', ipv4End='" + this.ipv4End + "', latitude=" + this.latitude + ", longitude=" + this.longitude + ", network='" + this.network + "', country='" + this.country + "'}";
    }
}

