/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.iploc.nic;

import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.baremaps.iploc.nic.NicAttribute;
import org.apache.baremaps.iploc.nic.NicObject;

class NicSpliterator
implements Spliterator<NicObject> {
    private final Spliterator<String> lineSpliterator;
    private String line;

    NicSpliterator(Spliterator<String> lineSpliterator) {
        this.lineSpliterator = lineSpliterator;
    }

    @Override
    public long estimateSize() {
        return this.lineSpliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.lineSpliterator.characteristics();
    }

    @Override
    public Spliterator<NicObject> trySplit() {
        return null;
    }

    @Override
    public boolean tryAdvance(Consumer<? super NicObject> consumer) {
        boolean tryAdvance;
        StringBuilder keyBuilder = new StringBuilder();
        StringBuilder valBuilder = new StringBuilder();
        ArrayList<NicAttribute> attributes = new ArrayList<NicAttribute>();
        while ((tryAdvance = this.lineSpliterator.tryAdvance(this::acceptLine)) && !"".equals(this.line)) {
            int index;
            if (this.line.startsWith(" ")) {
                valBuilder.append("\n");
                valBuilder.append(this.line.trim());
                continue;
            }
            if (this.line.startsWith("+")) {
                valBuilder.append("\n");
                valBuilder.append(this.line.substring(1).trim());
                continue;
            }
            if (this.line.startsWith("#") || this.line.startsWith("%") || (index = this.line.indexOf(":")) < 0) continue;
            this.addAttribute(attributes, keyBuilder, valBuilder);
            keyBuilder = new StringBuilder();
            valBuilder = new StringBuilder();
            keyBuilder.append(this.line.substring(0, index).trim());
            valBuilder.append(this.line.substring(index + 1).trim());
        }
        this.addAttribute(attributes, keyBuilder, valBuilder);
        if (!attributes.isEmpty()) {
            consumer.accept(new NicObject(attributes));
        }
        return tryAdvance;
    }

    private void acceptLine(String line) {
        this.line = line;
    }

    private void addAttribute(List<NicAttribute> attributes, StringBuilder key, StringBuilder val) {
        if (key.length() > 0) {
            attributes.add(new NicAttribute(key.toString(), val.toString()));
        }
    }
}

