/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.pbf;

import java.io.InputStream;
import java.util.List;
import java.util.stream.Stream;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.openstreetmap.model.DataBlock;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.HeaderBlock;
import org.apache.baremaps.openstreetmap.pbf.PbfBlockReader;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.stream.StreamException;
import org.locationtech.jts.geom.Coordinate;

public class PbfEntityReader
implements PbfReader<Entity> {
    private final PbfBlockReader reader = new PbfBlockReader();

    @Override
    public int buffer() {
        return this.reader.buffer();
    }

    @Override
    public PbfEntityReader buffer(int buffer) {
        this.reader.buffer(buffer);
        return this;
    }

    @Override
    public boolean geometries() {
        return this.reader.geometries();
    }

    @Override
    public PbfEntityReader geometries(boolean geometries) {
        this.reader.geometries(geometries);
        return this;
    }

    @Override
    public int projection() {
        return this.reader.projection();
    }

    @Override
    public PbfEntityReader projection(int srid) {
        this.reader.projection(srid);
        return this;
    }

    @Override
    public DataMap<Coordinate> coordinateMap() {
        return this.reader.coordinateMap();
    }

    @Override
    public PbfEntityReader coordinateMap(DataMap<Coordinate> coordinateMap) {
        this.reader.coordinateMap((DataMap)coordinateMap);
        return this;
    }

    @Override
    public DataMap<List<Long>> referenceMap() {
        return this.reader.referenceMap();
    }

    @Override
    public PbfEntityReader referenceMap(DataMap<List<Long>> referenceMap) {
        this.reader.referenceMap((DataMap)referenceMap);
        return this;
    }

    @Override
    public Stream<Entity> stream(InputStream inputStream) {
        return this.reader.stream(inputStream).flatMap(block -> {
            try {
                Stream.Builder<Entity> entities = Stream.builder();
                if (block instanceof HeaderBlock) {
                    HeaderBlock headerBlock = (HeaderBlock)block;
                    entities.add(headerBlock.getHeader());
                    entities.add(headerBlock.getBound());
                } else if (block instanceof DataBlock) {
                    DataBlock dataBlock = (DataBlock)block;
                    dataBlock.getDenseNodes().forEach(entities::add);
                    dataBlock.getNodes().forEach(entities::add);
                    dataBlock.getWays().forEach(entities::add);
                    dataBlock.getRelations().forEach(entities::add);
                } else {
                    throw new StreamException("Unknown block type.");
                }
                return entities.build();
            }
            catch (Exception e) {
                throw new StreamException(e);
            }
        });
    }
}

