/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.sql.DataSource;
import org.apache.baremaps.collection.AppendOnlyBuffer;
import org.apache.baremaps.collection.DataMap;
import org.apache.baremaps.collection.MemoryAlignedDataList;
import org.apache.baremaps.collection.MemoryAlignedDataMap;
import org.apache.baremaps.collection.MonotonicDataMap;
import org.apache.baremaps.collection.memory.MemoryMappedFile;
import org.apache.baremaps.collection.type.LonLatDataType;
import org.apache.baremaps.collection.type.LongDataType;
import org.apache.baremaps.collection.type.LongListDataType;
import org.apache.baremaps.collection.type.PairDataType;
import org.apache.baremaps.collection.utils.FileUtils;
import org.apache.baremaps.database.BlockImporter;
import org.apache.baremaps.database.repository.HeaderRepository;
import org.apache.baremaps.database.repository.PostgresHeaderRepository;
import org.apache.baremaps.database.repository.PostgresNodeRepository;
import org.apache.baremaps.database.repository.PostgresRelationRepository;
import org.apache.baremaps.database.repository.PostgresWayRepository;
import org.apache.baremaps.database.repository.Repository;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.pbf.PbfBlockReader;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.stream.StreamUtils;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ImportOpenStreetMap(Path file, String database, Integer databaseSrid) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ImportOpenStreetMap.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataMap coordinateMap;
        logger.info("Importing {} into {}", (Object)this.file, (Object)this.database);
        DataSource dataSource = context.getDataSource(this.database);
        Path path = this.file.toAbsolutePath();
        PostgresHeaderRepository headerRepository = new PostgresHeaderRepository(dataSource);
        PostgresNodeRepository nodeRepository = new PostgresNodeRepository(dataSource);
        PostgresWayRepository wayRepository = new PostgresWayRepository(dataSource);
        PostgresRelationRepository relationRepository = new PostgresRelationRepository(dataSource);
        headerRepository.drop();
        nodeRepository.drop();
        wayRepository.drop();
        relationRepository.drop();
        headerRepository.create();
        nodeRepository.create();
        wayRepository.create();
        relationRepository.create();
        Path cacheDir = Files.createTempDirectory(Paths.get(".", new String[0]), "cache_", new FileAttribute[0]);
        if (Files.size(path) > 0x40000000L) {
            Path coordinatesFile = Files.createFile(cacheDir.resolve("coordinates"), new FileAttribute[0]);
            coordinateMap = new MemoryAlignedDataMap<Coordinate>(new LonLatDataType(), new MemoryMappedFile(coordinatesFile));
        } else {
            Path coordinatesKeysFile = Files.createFile(cacheDir.resolve("coordinates_keys"), new FileAttribute[0]);
            Path coordinatesValsFile = Files.createFile(cacheDir.resolve("coordinates_vals"), new FileAttribute[0]);
            coordinateMap = new MonotonicDataMap<Coordinate>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedFile(coordinatesKeysFile)), new AppendOnlyBuffer<Coordinate>(new LonLatDataType(), new MemoryMappedFile(coordinatesValsFile)));
        }
        Path referencesKeysDir = Files.createFile(cacheDir.resolve("references_keys"), new FileAttribute[0]);
        Path referencesValuesDir = Files.createFile(cacheDir.resolve("references_vals"), new FileAttribute[0]);
        MonotonicDataMap<List<Long>> referenceMap = new MonotonicDataMap<List<Long>>(new MemoryAlignedDataList<PairDataType.Pair<Long, Long>>(new PairDataType<Long, Long>(new LongDataType(), new LongDataType()), new MemoryMappedFile(referencesKeysDir)), new AppendOnlyBuffer<List<Long>>(new LongListDataType(), new MemoryMappedFile(referencesValuesDir)));
        ImportOpenStreetMap.execute(path, coordinateMap, referenceMap, headerRepository, nodeRepository, wayRepository, relationRepository, this.databaseSrid);
        FileUtils.deleteRecursively(cacheDir);
        logger.info("Finished importing {} into {}", (Object)this.file, (Object)this.database);
    }

    public static void execute(Path path, DataMap<Coordinate> coordinateMap, DataMap<List<Long>> referenceMap, HeaderRepository headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository, Integer databaseSrid) throws IOException {
        PbfReader reader = ((PbfBlockReader)new PbfBlockReader().geometries(true).projection(databaseSrid).coordinateMap((DataMap)coordinateMap)).referenceMap((DataMap)referenceMap);
        BlockImporter importer = new BlockImporter(headerRepository, nodeRepository, wayRepository, relationRepository);
        try (InputStream input = Files.newInputStream(path, new OpenOption[0]);){
            StreamUtils.batch(((PbfBlockReader)reader).stream(input)).forEach(importer);
        }
    }
}

