/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.api.StreamingHttpServiceToOffloadedStreamingHttpService;
import java.util.function.BooleanSupplier;

final class OffloadingFilter
implements StreamingHttpServiceFilterFactory {
    private final HttpExecutionStrategy strategy;
    private final StreamingHttpServiceFilterFactory offloaded;
    private final BooleanSupplier shouldOffload;

    OffloadingFilter(HttpExecutionStrategy strategy, StreamingHttpServiceFilterFactory offloaded, BooleanSupplier shouldOffload) {
        this.strategy = strategy;
        this.offloaded = offloaded;
        this.shouldOffload = shouldOffload;
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        StreamingHttpService offloadedService = StreamingHttpServiceToOffloadedStreamingHttpService.offloadService((HttpExecutionStrategy)this.strategy, null, (BooleanSupplier)this.shouldOffload, (StreamingHttpService)this.offloaded.create(service));
        return new StreamingHttpServiceFilter(offloadedService);
    }

    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }
}

