/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.router.jersey.RouteStrategiesConfig;
import io.servicetalk.router.api.NoOffloadsRouteExecutionStrategy;
import io.servicetalk.router.api.RouteExecutionStrategy;
import io.servicetalk.router.api.RouteExecutionStrategyFactory;
import io.servicetalk.router.utils.internal.RouteExecutionStrategyUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.model.HandlerConstructor;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.MethodHandler;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.glassfish.jersey.server.model.ResourceModelComponent;
import org.glassfish.jersey.server.model.ResourceModelVisitor;
import org.glassfish.jersey.server.model.RuntimeResource;

final class JerseyRouteExecutionStrategyUtils {
    private static final HttpExecutionStrategy OFFLOAD_RECEIVE_META = HttpExecutionStrategies.customStrategyBuilder().offloadReceiveMetadata().build();
    private static final HttpExecutionStrategy OFFLOAD_RECEIVE_META_AND_SEND = HttpExecutionStrategies.customStrategyBuilder().offloadReceiveMetadata().offloadSend().build();

    private JerseyRouteExecutionStrategyUtils() {
    }

    static RouteStrategiesConfig validateRouteStrategies(ApplicationHandler applicationHandler, RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory) {
        ExtendedResourceContext resourceContext = (ExtendedResourceContext)applicationHandler.getInjectionManager().getInstance(ExtendedResourceContext.class);
        if (resourceContext == null) {
            return new RouteStrategiesConfig(Collections.emptyMap(), Collections.emptyMap());
        }
        RouteExecutionStrategyValidator validator = new RouteExecutionStrategyValidator(strategyFactory);
        resourceContext.getResourceModel().accept((ResourceModelVisitor)validator);
        if (!validator.errors.isEmpty()) {
            throw new IllegalArgumentException("Invalid execution strategy configuration found:\n" + validator.errors);
        }
        return new RouteStrategiesConfig(validator.routeStrategies, validator.methodDefaultStrategies);
    }

    static HttpExecutionStrategy getRouteExecutionStrategy(Method method, Class<?> clazz, RouteStrategiesConfig routeStrategiesConfig) {
        Annotation annotation = RouteExecutionStrategyUtils.getRouteExecutionStrategyAnnotation((Method)method, clazz);
        if (annotation == null) {
            return routeStrategiesConfig.methodDefaultStrategies.get(method);
        }
        if (annotation instanceof NoOffloadsRouteExecutionStrategy) {
            return HttpExecutionStrategies.offloadNone();
        }
        return routeStrategiesConfig.routeStrategies.get(((RouteExecutionStrategy)annotation).id());
    }

    private static HttpExecutionStrategy computeDefaultExecutionStrategy(Invocable invocable) {
        boolean producesAsync;
        Parameter entityParam = invocable.getParameters().stream().filter(p -> p.getSource() == Parameter.Source.ENTITY).findFirst().orElse(null);
        boolean consumesStreaming = entityParam != null && Publisher.class.isAssignableFrom(entityParam.getRawType());
        boolean consumesAsync = consumesStreaming || entityParam != null && Single.class.isAssignableFrom(entityParam.getRawType());
        boolean producesStreaming = Publisher.class.isAssignableFrom(invocable.getRawResponseType());
        boolean bl = producesAsync = producesStreaming || Single.class.isAssignableFrom(invocable.getRawResponseType()) || Completable.class.isAssignableFrom(invocable.getRawResponseType());
        if (!consumesAsync && !producesAsync) {
            return OFFLOAD_RECEIVE_META;
        }
        if (consumesAsync && !consumesStreaming && producesAsync && !producesStreaming) {
            return OFFLOAD_RECEIVE_META_AND_SEND;
        }
        return HttpExecutionStrategies.offloadAll();
    }

    private static void validateRouteExecutionStrategyAnnotationIfPresent(Method method, Class<?> clazz, RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory, @Nullable ResourceMethod resourceMethod, Set<String> errors) {
        Annotation annotation = RouteExecutionStrategyUtils.validateRouteExecutionStrategyAnnotationIfPresent((Method)method, clazz, strategyFactory, errors);
        if (annotation == null) {
            return;
        }
        if (resourceMethod != null) {
            if (resourceMethod.isManagedAsyncDeclared()) {
                errors.add("Execution strategy annotations are not supported on @ManagedAsync: " + method);
            } else if (resourceMethod.isSuspendDeclared()) {
                errors.add("Execution strategy annotations are not supported on AsyncResponse: " + method);
            } else if (resourceMethod.isSse()) {
                errors.add("Execution strategy annotations are not supported on Server-Sent Events: " + method);
            }
        }
        if (CompletionStage.class.isAssignableFrom(method.getReturnType())) {
            errors.add("Execution strategy annotations are not supported on CompletionStage returning method: " + method + " Consider returning " + Single.class.getSimpleName() + " instead.");
        }
    }

    private static final class RouteExecutionStrategyValidator
    implements ResourceModelVisitor {
        private final RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory;
        private final Map<String, HttpExecutionStrategy> routeStrategies;
        private final Map<Method, HttpExecutionStrategy> methodDefaultStrategies;
        private final Set<String> errors;
        private final Deque<ResourceMethod> resourceMethodDeque;

        RouteExecutionStrategyValidator(RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory) {
            this.strategyFactory = strategyFactory;
            this.routeStrategies = new HashMap<String, HttpExecutionStrategy>();
            this.methodDefaultStrategies = new HashMap<Method, HttpExecutionStrategy>();
            this.errors = new TreeSet<String>();
            this.resourceMethodDeque = new ArrayDeque<ResourceMethod>();
        }

        public void visitResource(Resource resource) {
            this.processComponents((ResourceModelComponent)resource);
        }

        public void visitChildResource(Resource resource) {
            this.processComponents((ResourceModelComponent)resource);
        }

        public void visitResourceMethod(ResourceMethod method) {
            this.resourceMethodDeque.push(method);
            try {
                this.processComponents((ResourceModelComponent)method);
            }
            finally {
                this.resourceMethodDeque.pop();
            }
        }

        public void visitInvocable(Invocable invocable) {
            this.methodDefaultStrategies.put(invocable.getHandlingMethod(), JerseyRouteExecutionStrategyUtils.computeDefaultExecutionStrategy(invocable));
            JerseyRouteExecutionStrategyUtils.validateRouteExecutionStrategyAnnotationIfPresent(invocable.getHandlingMethod(), invocable.getHandler().getHandlerClass(), (RouteExecutionStrategyFactory<HttpExecutionStrategy>)id -> this.routeStrategies.computeIfAbsent(id, arg_0 -> this.strategyFactory.get(arg_0)), this.resourceMethodDeque.peek(), this.errors);
        }

        public void visitMethodHandler(MethodHandler methodHandler) {
            this.processComponents((ResourceModelComponent)methodHandler);
        }

        public void visitResourceHandlerConstructor(HandlerConstructor constructor) {
            this.processComponents((ResourceModelComponent)constructor);
        }

        public void visitResourceModel(ResourceModel resourceModel) {
            this.processComponents((ResourceModelComponent)resourceModel);
        }

        public void visitRuntimeResource(RuntimeResource runtimeResource) {
            this.processComponents((ResourceModelComponent)runtimeResource);
        }

        private void processComponents(ResourceModelComponent component) {
            List components = component.getComponents();
            if (components == null) {
                return;
            }
            components.forEach(rmc -> rmc.accept((ResourceModelVisitor)this));
        }
    }
}

