/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.baremaps.model.Exception;
import org.apache.baremaps.model.TileJSON;

@Path(value="/tilesets")
@Api(description="the tilesets API")
public interface TilesetsApi {
    @POST
    @Consumes(value={"application/json"})
    @ApiOperation(value="adds a new tileset", notes="Adds a tileset to the tileset repository.  If no identifier can be determined from the submitted tileset, the server will assign a new identifier to the style.  The URI of the new tileset is returned in the header `Location`.", tags={"Tilesets"})
    @ApiResponses(value={@ApiResponse(code=201, message="tileset created", response=Void.class), @ApiResponse(code=409, message="a tileset with that id already exists", response=Void.class)})
    public Response addTileset(@Valid TileJSON var1);

    @DELETE
    @Path(value="/{tilesetId}")
    @ApiOperation(value="delete a tileset", notes="Delete an existing tileset with the id `tilesetId`. If no such tileset exists, an error is returned.", tags={"Tilesets"})
    @ApiResponses(value={@ApiResponse(code=204, message="tileset deleted", response=Void.class), @ApiResponse(code=404, message="tileset not found", response=Void.class)})
    public Response deleteTileset(@PathParam(value="tilesetId") @ApiParam(value="Local identifier of a tileset. \\ A list of all available tilesets can be found under the /tilesets path.") UUID var1);

    @GET
    @Path(value="/{tilesetId}/tiles/{tileMatrixSetId}/{tileMatrix}/{tileRow}/{tileCol}")
    @Produces(value={"application/vnd.mapbox-vector-tile", "application/json"})
    @ApiOperation(value="fetch a tile from one or more geospatial data resources", notes="Retrieves a tile in the requested tileMatrixSet, on the requested tileMatrix in the TileMatrixSet, with the requested tile indices (tileRow, tileCol). The tile has multiple collections (formerly refered as layers) with all selected features in the bounding box of the tile.", tags={"Tilesets"})
    @ApiResponses(value={@ApiResponse(code=200, message="A Mapbox Vector Tile of the collection.", response=byte[].class), @ApiResponse(code=404, message="The requested URI was not found", response=Void.class), @ApiResponse(code=500, message="A server error occurred", response=Exception.class)})
    public Response getTile(@PathParam(value="tilesetId") @ApiParam(value="Local identifier of a tileset. \\ A list of all available tilesets can be found under the /tilesets path.") UUID var1, @PathParam(value="tileMatrixSetId") @ApiParam(value="Identifier of a specific tiling scheme. It can be one of those specified in Annex D.1 of the OGC 17-083r2 standard or one defined in this service.") String var2, @PathParam(value="tileMatrix") @ApiParam(value="Identifier selecting one of the scales (z) defined in the TileMatrixSet and representing the scaleDenominator the tile.") Integer var3, @PathParam(value="tileRow") @Min(value=0L) @ApiParam(value="Row index (y) of the tile on the selected TileMatrix. It cannot exceed the MatrixWidth-1 for the selected TileMatrix.") @Min(value=0L) Integer var4, @PathParam(value="tileCol") @Min(value=0L) @ApiParam(value="Column index (x) of the tile on the selected TileMatrix. It cannot exceed the MatrixHeight-1 for the selected TileMatrix.") @Min(value=0L) Integer var5);

    @GET
    @Path(value="/{tilesetId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="fetch a tileset by id", notes="Fetches the tileset with identifier `tilesetId`. The set of available tilesets can be retrieved at `/tilesets`.", tags={"Tilesets"})
    @ApiResponses(value={@ApiResponse(code=200, message="The tileset", response=TileJSON.class), @ApiResponse(code=404, message="tileset not found", response=Void.class)})
    public Response getTileset(@PathParam(value="tilesetId") @ApiParam(value="Local identifier of a tileset. \\ A list of all available tilesets can be found under the /tilesets path.") UUID var1);

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="information about the available tilesets", notes="This operation fetches the set of tilesets available. For each tileset the id, a title, links to the tileset is provided.  For a small number of the tilesets the currently simple approach is sufficient, but in general the operation should support paging (using a parameter `limit` and links to the `next` page in responses).", tags={"Tilesets"})
    @ApiResponses(value={@ApiResponse(code=200, message="the set of available tilesets", response=UUID.class, responseContainer="List"), @ApiResponse(code=406, message="The media types accepted by the client are not supported for this resource", response=Void.class, responseContainer="List")})
    public Response getTilesets();

    @PUT
    @Path(value="/{tilesetId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="replace a tileset or add a new tileset", notes="Replace an existing tileset with the id `tilesetId`. If no such style exists, a new style with that id is added.", tags={"Tilesets"})
    @ApiResponses(value={@ApiResponse(code=204, message="tileset updated or created successfully", response=Void.class)})
    public Response updateTileset(@PathParam(value="tilesetId") @ApiParam(value="Local identifier of a tileset. \\ A list of all available tilesets can be found under the /tilesets path.") UUID var1, @Valid TileJSON var2);
}

