/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.model.StyleSetEntry;

public class StyleSet {
    @Valid
    private List<StyleSetEntry> styles = new ArrayList<StyleSetEntry>();

    public StyleSet styles(List<StyleSetEntry> styles) {
        this.styles = styles;
        return this;
    }

    @ApiModelProperty(example="[{id=night, title=Topographic night style, links=[{href=https://example.com/api/1.0/styles/night?f=mapbox, type=application/vnd.mapbox.style+json, rel=stylesheet}, {href=https://example.com/api/1.0/styles/night?f=sld10, type=application/vnd.ogc.sld+xml;version=1.0, rel=stylesheet}, {href=https://example.com/api/1.0/styles/night/metadata?f=json, type=application/json, rel=describedBy}]}, {id=topographic, title=Regular topographic style, links=[{href=https://example.com/api/1.0/styles/topographic?f=mapbox, type=application/vnd.mapbox.style+json, rel=stylesheet}, {href=https://example.com/api/1.0/styles/topographic?f=sld10, type=application/vnd.ogc.sld+xml;version=1.0, rel=stylesheet}, {href=https://example.com/api/1.0/styles/topographic/metadata?f=json, type=application/json, rel=describedBy}]}]", required=true, value="")
    @JsonProperty(value="styles")
    @NotNull
    public List<StyleSetEntry> getStyles() {
        return this.styles;
    }

    public void setStyles(List<StyleSetEntry> styles) {
        this.styles = styles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleSet styleSet = (StyleSet)o;
        return Objects.equals(this.styles, styleSet.styles);
    }

    public int hashCode() {
        return Objects.hash(this.styles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StyleSet {\n");
        sb.append("    styles: ").append(this.toIndentedString(this.styles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

