/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import com.google.common.io.Resources;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Singleton
@Path(value="")
public class ApiResource {
    private static String openapiPath;

    public ApiResource(String openapiPath) {
        ApiResource.openapiPath = openapiPath;
    }

    public String getVersion() {
        String string;
        block8: {
            InputStream input = Resources.getResource((String)"version.txt").openStream();
            try {
                Properties properties = new Properties();
                properties.load(input);
                string = properties.getProperty("version");
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read version number");
                }
            }
            input.close();
        }
        return string;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/api")
    public Response getListingJson(@Context UriInfo uriInfo) throws IOException {
        return Response.ok((Object)Json.mapper().writeValueAsString((Object)this.parseOpenapi(uriInfo))).build();
    }

    @GET
    @Produces(value={"application/yaml"})
    @Path(value="/api")
    public Response getListingYaml(@Context UriInfo uriInfo) throws IOException {
        return Response.ok((Object)Yaml.mapper().writeValueAsString((Object)this.parseOpenapi(uriInfo))).build();
    }

    private OpenAPI parseOpenapi(UriInfo uriInfo) throws IOException {
        try (InputStream inputStream = Resources.getResource((String)openapiPath).openStream();){
            OpenAPI openAPI = new OpenAPIV3Parser().readContents(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8)).getOpenAPI();
            openAPI.setServers(List.of(new Server().url(String.format("%s:%s", uriInfo.getBaseUri().getHost(), uriInfo.getBaseUri().getPort()))));
            OpenAPI openAPI2 = openAPI;
            return openAPI2;
        }
    }
}

