/*
 * Decompiled with CFR 0.152.
 */
package org.jctools.queues.ea.unpadded;

import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.ea.unpadded.BaseSpscLinkedUnpaddedArrayQueue;
import org.jctools.util.Pow2;
import org.jctools.util.UnsafeRefArrayAccess;

public class SpscUnboundedUnpaddedArrayQueue<E>
extends BaseSpscLinkedUnpaddedArrayQueue<E> {
    public SpscUnboundedUnpaddedArrayQueue(int chunkSize) {
        int chunkCapacity = Math.max(Pow2.roundToPowerOfTwo(chunkSize), 16);
        long mask = chunkCapacity - 1;
        E[] buffer = UnsafeRefArrayAccess.allocateRefArray(chunkCapacity + 1);
        this.producerBuffer = buffer;
        this.producerMask = mask;
        this.consumerBuffer = buffer;
        this.consumerMask = mask;
        this.producerBufferLimit = mask - 1L;
    }

    @Override
    final boolean offerColdPath(E[] buffer, long mask, long pIndex, long offset, E v, MessagePassingQueue.Supplier<? extends E> s) {
        long lookAheadStep = (mask + 1L) / 4L;
        long pBufferLimit = pIndex + lookAheadStep;
        if (null == UnsafeRefArrayAccess.lvRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(pBufferLimit, mask))) {
            this.producerBufferLimit = pBufferLimit - 1L;
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else if (null == UnsafeRefArrayAccess.lvRefElement(buffer, UnsafeRefArrayAccess.calcCircularRefElementOffset(pIndex + 1L, mask))) {
            this.writeToQueue(buffer, v == null ? s.get() : v, pIndex, offset);
        } else {
            E[] newBuffer = UnsafeRefArrayAccess.allocateRefArray((int)(mask + 2L));
            this.producerBuffer = newBuffer;
            this.producerBufferLimit = pIndex + mask - 1L;
            this.linkOldToNew(pIndex, buffer, offset, newBuffer, offset, v == null ? s.get() : v);
        }
        return true;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill((MessagePassingQueue.Supplier)s, (int)this.producerMask);
    }

    @Override
    public int capacity() {
        return -1;
    }
}

