/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.Dates;
import org.apache.baremaps.ogcapi.model.Link1;
import org.apache.baremaps.ogcapi.model.StyleLayer;
import org.apache.baremaps.ogcapi.model.Stylesheet;

@JsonTypeName(value="style-metadata")
public class StyleMetadata {
    @Valid
    private String id;
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private List<String> keywords = null;
    @Valid
    private String pointOfContact;
    @Valid
    private AccessConstraintsEnum accessConstraints;
    @Valid
    private Dates dates;
    @Valid
    private ScopeEnum scope;
    @Valid
    private String version;
    @Valid
    private List<Stylesheet> stylesheets = null;
    @Valid
    private List<StyleLayer> layers = null;
    @Valid
    private List<Link1> links = null;

    public StyleMetadata id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public StyleMetadata title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public StyleMetadata description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public StyleMetadata keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public StyleMetadata addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    public StyleMetadata removeKeywordsItem(String keywordsItem) {
        if (keywordsItem != null && this.keywords != null) {
            this.keywords.remove(keywordsItem);
        }
        return this;
    }

    public StyleMetadata pointOfContact(String pointOfContact) {
        this.pointOfContact = pointOfContact;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="pointOfContact")
    public String getPointOfContact() {
        return this.pointOfContact;
    }

    @JsonProperty(value="pointOfContact")
    public void setPointOfContact(String pointOfContact) {
        this.pointOfContact = pointOfContact;
    }

    public StyleMetadata accessConstraints(AccessConstraintsEnum accessConstraints) {
        this.accessConstraints = accessConstraints;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accessConstraints")
    public AccessConstraintsEnum getAccessConstraints() {
        return this.accessConstraints;
    }

    @JsonProperty(value="accessConstraints")
    public void setAccessConstraints(AccessConstraintsEnum accessConstraints) {
        this.accessConstraints = accessConstraints;
    }

    public StyleMetadata dates(Dates dates) {
        this.dates = dates;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dates")
    public Dates getDates() {
        return this.dates;
    }

    @JsonProperty(value="dates")
    public void setDates(Dates dates) {
        this.dates = dates;
    }

    public StyleMetadata scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="scope")
    public ScopeEnum getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public StyleMetadata version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public StyleMetadata stylesheets(List<Stylesheet> stylesheets) {
        this.stylesheets = stylesheets;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="stylesheets")
    public List<Stylesheet> getStylesheets() {
        return this.stylesheets;
    }

    @JsonProperty(value="stylesheets")
    public void setStylesheets(List<Stylesheet> stylesheets) {
        this.stylesheets = stylesheets;
    }

    public StyleMetadata addStylesheetsItem(Stylesheet stylesheetsItem) {
        if (this.stylesheets == null) {
            this.stylesheets = new ArrayList<Stylesheet>();
        }
        this.stylesheets.add(stylesheetsItem);
        return this;
    }

    public StyleMetadata removeStylesheetsItem(Stylesheet stylesheetsItem) {
        if (stylesheetsItem != null && this.stylesheets != null) {
            this.stylesheets.remove(stylesheetsItem);
        }
        return this;
    }

    public StyleMetadata layers(List<StyleLayer> layers) {
        this.layers = layers;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="layers")
    public List<StyleLayer> getLayers() {
        return this.layers;
    }

    @JsonProperty(value="layers")
    public void setLayers(List<StyleLayer> layers) {
        this.layers = layers;
    }

    public StyleMetadata addLayersItem(StyleLayer layersItem) {
        if (this.layers == null) {
            this.layers = new ArrayList<StyleLayer>();
        }
        this.layers.add(layersItem);
        return this;
    }

    public StyleMetadata removeLayersItem(StyleLayer layersItem) {
        if (layersItem != null && this.layers != null) {
            this.layers.remove(layersItem);
        }
        return this;
    }

    public StyleMetadata links(List<Link1> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="The links may reference related resources. It is recommended to include a link to a thumbnail with link relation `preview` (specified by RFC 6903) and the appropriate media type in the `type` parameter. The thumbnail may be an image that is published as a resource in the API, it may reference an appropriate raster tile, a map request, etc.")
    @JsonProperty(value="links")
    public List<Link1> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link1> links) {
        this.links = links;
    }

    public StyleMetadata addLinksItem(Link1 linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link1>();
        }
        this.links.add(linksItem);
        return this;
    }

    public StyleMetadata removeLinksItem(Link1 linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleMetadata styleMetadata = (StyleMetadata)o;
        return Objects.equals(this.id, styleMetadata.id) && Objects.equals(this.title, styleMetadata.title) && Objects.equals(this.description, styleMetadata.description) && Objects.equals(this.keywords, styleMetadata.keywords) && Objects.equals(this.pointOfContact, styleMetadata.pointOfContact) && Objects.equals((Object)this.accessConstraints, (Object)styleMetadata.accessConstraints) && Objects.equals(this.dates, styleMetadata.dates) && Objects.equals((Object)this.scope, (Object)styleMetadata.scope) && Objects.equals(this.version, styleMetadata.version) && Objects.equals(this.stylesheets, styleMetadata.stylesheets) && Objects.equals(this.layers, styleMetadata.layers) && Objects.equals(this.links, styleMetadata.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, this.description, this.keywords, this.pointOfContact, this.accessConstraints, this.dates, this.scope, this.version, this.stylesheets, this.layers, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StyleMetadata {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    pointOfContact: ").append(this.toIndentedString(this.pointOfContact)).append("\n");
        sb.append("    accessConstraints: ").append(this.toIndentedString((Object)this.accessConstraints)).append("\n");
        sb.append("    dates: ").append(this.toIndentedString(this.dates)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    stylesheets: ").append(this.toIndentedString(this.stylesheets)).append("\n");
        sb.append("    layers: ").append(this.toIndentedString(this.layers)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccessConstraintsEnum {
        UNCLASSIFIED(String.valueOf("unclassified")),
        CONFIDENTIAL(String.valueOf("confidential")),
        RESTRICTED(String.valueOf("restricted")),
        SECRET(String.valueOf("secret")),
        TOPSECRET(String.valueOf("topSecret"));

        private String value;

        private AccessConstraintsEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccessConstraintsEnum fromString(String s) {
            for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            return null;
        }

        @JsonCreator
        public static AccessConstraintsEnum fromValue(String value) {
            for (AccessConstraintsEnum b : AccessConstraintsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum ScopeEnum {
        STYLE(String.valueOf("style"));

        private String value;

        private ScopeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static ScopeEnum fromString(String s) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            return null;
        }

        @JsonCreator
        public static ScopeEnum fromValue(String value) {
            for (ScopeEnum b : ScopeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

