/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataColumnImpl;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.database.schema.DataRowTypeImpl;
import org.apache.baremaps.storage.shapefile.internal.CommonByteReader;
import org.apache.baremaps.storage.shapefile.internal.DBaseDataType;
import org.apache.baremaps.storage.shapefile.internal.DBaseFieldDescriptor;
import org.apache.baremaps.storage.shapefile.internal.DbaseByteReader;
import org.apache.baremaps.storage.shapefile.internal.ShapefileDescriptor;
import org.apache.baremaps.storage.shapefile.internal.ShapefileException;
import org.apache.baremaps.storage.shapefile.internal.ShapefileGeometryType;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ShapefileByteReader
extends CommonByteReader {
    private static final String GEOMETRY_NAME = "geometry";
    private ShapefileDescriptor shapefileDescriptor;
    private List<DBaseFieldDescriptor> databaseFieldsDescriptors;
    private DataRowType rowType;
    private File shapeFileIndex;
    private ArrayList<Integer> indexes;
    private ArrayList<Integer> recordsLengths;
    private GeometryFactory geometryFactory = new GeometryFactory();

    public ShapefileByteReader(File shapefile, File dbaseFile, File shapefileIndex) throws IOException {
        super(shapefile);
        this.shapeFileIndex = shapefileIndex;
        this.loadDatabaseFieldDescriptors(dbaseFile);
        this.loadDescriptor();
        if (this.shapeFileIndex != null) {
            this.loadShapefileIndexes();
        }
        this.rowType = this.getSchema(shapefile.getName());
    }

    public List<DBaseFieldDescriptor> getFieldsDescriptors() {
        return this.databaseFieldsDescriptors;
    }

    public ShapefileDescriptor getShapefileDescriptor() {
        return this.shapefileDescriptor;
    }

    public DataRowType getRowType() {
        return this.rowType;
    }

    private DataRowType getSchema(String name) {
        Objects.requireNonNull(name, "The row name cannot be null.");
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        for (int i = 0; i < this.databaseFieldsDescriptors.size(); ++i) {
            DBaseFieldDescriptor fieldDescriptor = this.databaseFieldsDescriptors.get(i);
            String columnName = fieldDescriptor.getName();
            DataColumn.Type columnType = switch (fieldDescriptor.getType()) {
                default -> throw new IncompatibleClassChangeError();
                case DBaseDataType.Character -> DataColumn.Type.STRING;
                case DBaseDataType.Number -> {
                    if (fieldDescriptor.getDecimalCount() == 0) {
                        yield DataColumn.Type.LONG;
                    }
                    yield DataColumn.Type.DOUBLE;
                }
                case DBaseDataType.Currency -> DataColumn.Type.DOUBLE;
                case DBaseDataType.Double -> DataColumn.Type.DOUBLE;
                case DBaseDataType.Integer -> DataColumn.Type.INTEGER;
                case DBaseDataType.AutoIncrement -> DataColumn.Type.INTEGER;
                case DBaseDataType.Logical -> DataColumn.Type.STRING;
                case DBaseDataType.Date -> DataColumn.Type.STRING;
                case DBaseDataType.Memo -> DataColumn.Type.STRING;
                case DBaseDataType.FloatingPoint -> DataColumn.Type.STRING;
                case DBaseDataType.Picture -> DataColumn.Type.STRING;
                case DBaseDataType.VariField -> DataColumn.Type.STRING;
                case DBaseDataType.Variant -> DataColumn.Type.STRING;
                case DBaseDataType.TimeStamp -> DataColumn.Type.STRING;
                case DBaseDataType.DateTime -> DataColumn.Type.STRING;
            };
            columns.add(new DataColumnImpl(columnName, columnType));
        }
        columns.add(new DataColumnImpl(GEOMETRY_NAME, DataColumn.Type.GEOMETRY));
        return new DataRowTypeImpl(name, columns);
    }

    private void loadDescriptor() {
        this.shapefileDescriptor = new ShapefileDescriptor(this.getByteBuffer());
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private boolean loadShapefileIndexes() {
        if (this.shapeFileIndex == null) {
            return false;
        }
        try (FileInputStream fis = new FileInputStream(this.shapeFileIndex);){
            boolean bl;
            block19: {
                FileChannel fc = fis.getChannel();
                try {
                    int fsize = (int)fc.size();
                    MappedByteBuffer indexesByteBuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fsize);
                    this.indexes = new ArrayList();
                    this.recordsLengths = new ArrayList();
                    indexesByteBuffer.position(100);
                    indexesByteBuffer.order(ByteOrder.BIG_ENDIAN);
                    while (indexesByteBuffer.hasRemaining()) {
                        this.indexes.add(indexesByteBuffer.getInt());
                        this.recordsLengths.add(indexesByteBuffer.getInt());
                    }
                    bl = true;
                    if (fc == null) break block19;
                }
                catch (IOException e) {
                    boolean bl2;
                    block20: {
                        this.shapeFileIndex = null;
                        bl2 = false;
                        if (fc == null) break block20;
                        fc.close();
                    }
                    fis.close();
                    return bl2;
                    {
                        catch (Throwable throwable) {
                            if (fc != null) {
                                try {
                                    fc.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                fc.close();
            }
            return bl;
        }
        catch (FileNotFoundException e) {
            this.shapeFileIndex = null;
            return false;
        }
        catch (IOException e) {
            this.shapeFileIndex = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDatabaseFieldDescriptors(File dbaseFile) throws IOException {
        DbaseByteReader databaseReader = null;
        try {
            databaseReader = new DbaseByteReader(dbaseFile, null);
            this.databaseFieldsDescriptors = databaseReader.getFieldsDescriptors();
        }
        finally {
            if (databaseReader != null) {
                try {
                    databaseReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setRowNum(int recordNumber) throws ShapefileException {
        if (recordNumber < 1) {
            throw new IllegalArgumentException("Wrong direct access before start");
        }
        if (this.shapeFileIndex == null) {
            throw new ShapefileException("No direct access");
        }
        int position = this.indexes.get(recordNumber - 1) * 2;
        if (position >= this.getByteBuffer().capacity()) {
            throw new ShapefileException("Wrong direct access after last");
        }
        try {
            this.getByteBuffer().position(position);
        }
        catch (IllegalArgumentException e) {
            throw new ShapefileException("Wrong position", e);
        }
    }

    public void completeRow(DataRow row) throws ShapefileException {
        int RecordNumber = this.getByteBuffer().getInt();
        int ContentLength = this.getByteBuffer().getInt();
        this.getByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        int shapeTypeId = this.getByteBuffer().getInt();
        ShapefileGeometryType shapefileGeometryType = ShapefileGeometryType.get(shapeTypeId);
        if (shapefileGeometryType == null) {
            throw new ShapefileException("The shapefile row type doesn''t match to any known row type.");
        }
        switch (shapefileGeometryType) {
            case Point: {
                this.loadPointRow(row);
                break;
            }
            case Polygon: {
                this.loadPolygonRow(row);
                break;
            }
            case PolyLine: {
                this.loadPolylineRow(row);
                break;
            }
            default: {
                throw new ShapefileException("Unsupported shapefile type: " + shapeTypeId);
            }
        }
        this.getByteBuffer().order(ByteOrder.BIG_ENDIAN);
    }

    private void loadPointRow(DataRow row) {
        double x = this.getByteBuffer().getDouble();
        double y = this.getByteBuffer().getDouble();
        Point pnt = this.geometryFactory.createPoint(new Coordinate(x, y));
        row.set(GEOMETRY_NAME, (Object)pnt);
    }

    private void loadPolygonRow(DataRow row) {
        double xmin = this.getByteBuffer().getDouble();
        double ymin = this.getByteBuffer().getDouble();
        double xmax = this.getByteBuffer().getDouble();
        double ymax = this.getByteBuffer().getDouble();
        int numParts = this.getByteBuffer().getInt();
        int numPoints = this.getByteBuffer().getInt();
        Geometry multiPolygon = this.readMultiplePolygon(numParts, numPoints);
        row.set(GEOMETRY_NAME, (Object)multiPolygon);
    }

    private Geometry readMultiplePolygon(int numParts, int numPoints) {
        int[] partsIndexes = new int[numParts];
        for (int index = 0; index < numParts; ++index) {
            partsIndexes[index] = this.getByteBuffer().getInt();
        }
        Coordinate[] coordinates = new Coordinate[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            Coordinate coordinate;
            double x = this.getByteBuffer().getDouble();
            double y = this.getByteBuffer().getDouble();
            coordinates[i] = coordinate = new Coordinate(x, y);
        }
        ArrayList<Polygon> shells = new ArrayList<Polygon>();
        LinkedList<Polygon> holes = new LinkedList<Polygon>();
        for (int i = 0; i < partsIndexes.length; ++i) {
            int from = partsIndexes[i];
            int to = i < partsIndexes.length - 1 ? partsIndexes[i + 1] : coordinates.length;
            Coordinate[] array = Arrays.copyOfRange(coordinates, from, to);
            Polygon linearRing = this.geometryFactory.createPolygon(array);
            if (!Orientation.isCCW((Coordinate[])linearRing.getCoordinates())) {
                shells.add(linearRing);
                continue;
            }
            holes.add(linearRing);
        }
        MultiPolygon shellsMultiPolygon = this.geometryFactory.createMultiPolygon((Polygon[])shells.toArray(Polygon[]::new));
        MultiPolygon holesMultiPolygon = this.geometryFactory.createMultiPolygon((Polygon[])holes.toArray(Polygon[]::new));
        return shellsMultiPolygon.difference((Geometry)holesMultiPolygon);
    }

    private void loadPolylineRow(DataRow row) {
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        this.getByteBuffer().getDouble();
        int NumParts = this.getByteBuffer().getInt();
        int NumPoints = this.getByteBuffer().getInt();
        int[] NumPartArr = new int[NumParts + 1];
        for (int n = 0; n < NumParts; ++n) {
            int idx;
            NumPartArr[n] = idx = this.getByteBuffer().getInt();
        }
        NumPartArr[NumParts] = NumPoints;
        CoordinateList coordinates = new CoordinateList();
        for (int m = 0; m < NumParts; ++m) {
            double xpnt = this.getByteBuffer().getDouble();
            double ypnt = this.getByteBuffer().getDouble();
            coordinates.add((Object)new Coordinate(xpnt, ypnt));
            for (int j = NumPartArr[m]; j < NumPartArr[m + 1] - 1; ++j) {
                xpnt = this.getByteBuffer().getDouble();
                ypnt = this.getByteBuffer().getDouble();
                coordinates.add((Object)new Coordinate(xpnt, ypnt));
            }
        }
        row.set(GEOMETRY_NAME, (Object)this.geometryFactory.createLineString(coordinates.toCoordinateArray()));
    }
}

