package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.baremaps.ogcapi.model.ExtentTemporalGrid;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The temporal extent of the features in the collection.
 **/
@ApiModel(description = "The temporal extent of the features in the collection.")
@JsonTypeName("extent_temporal")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class ExtentTemporal   {
  private @Valid List<List<Date>> interval = null;
  public enum TrsEnum {

    HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN(String.valueOf("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian"));


    private String value;

    TrsEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Convert a String into String, as specified in the
     * <a href="https://download.oracle.com/otndocs/jcp/jaxrs-2_0-fr-eval-spec/index.html">See JAX RS 2.0 Specification, section 3.2, p. 12</a>
     */
	public static TrsEnum fromString(String s) {
        for (TrsEnum b : TrsEnum.values()) {
            // using Objects.toString() to be safe if value type non-object type
            // because types like 'int' etc. will be auto-boxed
            if (java.util.Objects.toString(b.value).equals(s)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected string value '" + s + "'");
	}
	
    @JsonCreator
    public static TrsEnum fromValue(String value) {
        for (TrsEnum b : TrsEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
}

  private @Valid TrsEnum trs = TrsEnum.HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN;
  private @Valid ExtentTemporalGrid grid;

  /**
   * One or more time intervals that describe the temporal extent of the dataset. In the Core only a single time interval is supported.  Extensions may support multiple intervals. The first time interval describes the overall temporal extent of the data. All subsequent time intervals describe more precise time intervals, e.g., to identify clusters of data. Clients only interested in the overall extent will only need to access the first item in each array.
   **/
  public ExtentTemporal interval(List<List<Date>> interval) {
    this.interval = interval;
    return this;
  }

  
  @ApiModelProperty(value = "One or more time intervals that describe the temporal extent of the dataset. In the Core only a single time interval is supported.  Extensions may support multiple intervals. The first time interval describes the overall temporal extent of the data. All subsequent time intervals describe more precise time intervals, e.g., to identify clusters of data. Clients only interested in the overall extent will only need to access the first item in each array.")
  @JsonProperty("interval")
 @Size(min=1)  public List< @Size(min=2,max=2)List<Date>> getInterval() {
    return interval;
  }

  @JsonProperty("interval")
  public void setInterval(List<List<Date>> interval) {
    this.interval = interval;
  }

  public ExtentTemporal addIntervalItem(List<Date> intervalItem) {
    if (this.interval == null) {
      this.interval = new ArrayList<>();
    }

    this.interval.add(intervalItem);
    return this;
  }

  public ExtentTemporal removeIntervalItem(List<Date> intervalItem) {
    if (intervalItem != null && this.interval != null) {
      this.interval.remove(intervalItem);
    }

    return this;
  }
  /**
   * Coordinate reference system of the coordinates in the temporal extent (property &#x60;interval&#x60;). The default reference system is the Gregorian calendar. In the Core this is the only supported temporal coordinate reference system. Extensions may support additional temporal coordinate reference systems and add additional enum values.
   **/
  public ExtentTemporal trs(TrsEnum trs) {
    this.trs = trs;
    return this;
  }

  
  @ApiModelProperty(value = "Coordinate reference system of the coordinates in the temporal extent (property `interval`). The default reference system is the Gregorian calendar. In the Core this is the only supported temporal coordinate reference system. Extensions may support additional temporal coordinate reference systems and add additional enum values.")
  @JsonProperty("trs")
  public TrsEnum getTrs() {
    return trs;
  }

  @JsonProperty("trs")
  public void setTrs(TrsEnum trs) {
    this.trs = trs;
  }

  /**
   **/
  public ExtentTemporal grid(ExtentTemporalGrid grid) {
    this.grid = grid;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("grid")
  public ExtentTemporalGrid getGrid() {
    return grid;
  }

  @JsonProperty("grid")
  public void setGrid(ExtentTemporalGrid grid) {
    this.grid = grid;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtentTemporal extentTemporal = (ExtentTemporal) o;
    return Objects.equals(this.interval, extentTemporal.interval) &&
        Objects.equals(this.trs, extentTemporal.trs) &&
        Objects.equals(this.grid, extentTemporal.grid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interval, trs, grid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtentTemporal {\n");
    
    sb.append("    interval: ").append(toIndentedString(interval)).append("\n");
    sb.append("    trs: ").append(toIndentedString(trs)).append("\n");
    sb.append("    grid: ").append(toIndentedString(grid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

