package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.TileMatrix;
import org.apache.baremaps.ogcapi.model.TileSetBoundingBox;
import org.apache.baremaps.ogcapi.model.TileSetCrs;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A definition of a tile matrix set following the Tile Matrix Set standard. For tileSet metadata, such a description (in &#x60;tileMatrixSet&#x60; property) is only required for offline use, as an alternative to a link with a &#x60;http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme&#x60; relation type.
 **/
@ApiModel(description = "A definition of a tile matrix set following the Tile Matrix Set standard. For tileSet metadata, such a description (in `tileMatrixSet` property) is only required for offline use, as an alternative to a link with a `http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme` relation type.")
@JsonTypeName("tileMatrixSet")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class TileMatrixSet   {
  private @Valid String title;
  private @Valid String description;
  private @Valid List<String> keywords = null;
  private @Valid String id;
  private @Valid URI uri;
  private @Valid List<String> orderedAxes = null;
  private @Valid TileSetCrs crs;
  private @Valid URI wellKnownScaleSet;
  private @Valid TileSetBoundingBox boundingBox;
  private @Valid List<TileMatrix> tileMatrices = new ArrayList<>();

  /**
   * Title of this tile matrix set, normally used for display to a human
   **/
  public TileMatrixSet title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "Title of this tile matrix set, normally used for display to a human")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Brief narrative description of this tile matrix set, normally available for display to a human
   **/
  public TileMatrixSet description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "Brief narrative description of this tile matrix set, normally available for display to a human")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this tile matrix set
   **/
  public TileMatrixSet keywords(List<String> keywords) {
    this.keywords = keywords;
    return this;
  }

  
  @ApiModelProperty(value = "Unordered list of one or more commonly used or formalized word(s) or phrase(s) used to describe this tile matrix set")
  @JsonProperty("keywords")
  public List<String> getKeywords() {
    return keywords;
  }

  @JsonProperty("keywords")
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }

  public TileMatrixSet addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }

    this.keywords.add(keywordsItem);
    return this;
  }

  public TileMatrixSet removeKeywordsItem(String keywordsItem) {
    if (keywordsItem != null && this.keywords != null) {
      this.keywords.remove(keywordsItem);
    }

    return this;
  }
  /**
   * Tile matrix set identifier. Implementation of &#39;identifier&#39;
   **/
  public TileMatrixSet id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(value = "Tile matrix set identifier. Implementation of 'identifier'")
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   * Reference to an official source for this tileMatrixSet
   **/
  public TileMatrixSet uri(URI uri) {
    this.uri = uri;
    return this;
  }

  
  @ApiModelProperty(value = "Reference to an official source for this tileMatrixSet")
  @JsonProperty("uri")
  public URI getUri() {
    return uri;
  }

  @JsonProperty("uri")
  public void setUri(URI uri) {
    this.uri = uri;
  }

  /**
   **/
  public TileMatrixSet orderedAxes(List<String> orderedAxes) {
    this.orderedAxes = orderedAxes;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("orderedAxes")
 @Size(min=1)  public List<String> getOrderedAxes() {
    return orderedAxes;
  }

  @JsonProperty("orderedAxes")
  public void setOrderedAxes(List<String> orderedAxes) {
    this.orderedAxes = orderedAxes;
  }

  public TileMatrixSet addOrderedAxesItem(String orderedAxesItem) {
    if (this.orderedAxes == null) {
      this.orderedAxes = new ArrayList<>();
    }

    this.orderedAxes.add(orderedAxesItem);
    return this;
  }

  public TileMatrixSet removeOrderedAxesItem(String orderedAxesItem) {
    if (orderedAxesItem != null && this.orderedAxes != null) {
      this.orderedAxes.remove(orderedAxesItem);
    }

    return this;
  }
  /**
   **/
  public TileMatrixSet crs(TileSetCrs crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("crs")
  @NotNull
  public TileSetCrs getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(TileSetCrs crs) {
    this.crs = crs;
  }

  /**
   * Reference to a well-known scale set
   **/
  public TileMatrixSet wellKnownScaleSet(URI wellKnownScaleSet) {
    this.wellKnownScaleSet = wellKnownScaleSet;
    return this;
  }

  
  @ApiModelProperty(value = "Reference to a well-known scale set")
  @JsonProperty("wellKnownScaleSet")
  public URI getWellKnownScaleSet() {
    return wellKnownScaleSet;
  }

  @JsonProperty("wellKnownScaleSet")
  public void setWellKnownScaleSet(URI wellKnownScaleSet) {
    this.wellKnownScaleSet = wellKnownScaleSet;
  }

  /**
   **/
  public TileMatrixSet boundingBox(TileSetBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("boundingBox")
  public TileSetBoundingBox getBoundingBox() {
    return boundingBox;
  }

  @JsonProperty("boundingBox")
  public void setBoundingBox(TileSetBoundingBox boundingBox) {
    this.boundingBox = boundingBox;
  }

  /**
   * Describes scale levels and its tile matrices
   **/
  public TileMatrixSet tileMatrices(List<TileMatrix> tileMatrices) {
    this.tileMatrices = tileMatrices;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Describes scale levels and its tile matrices")
  @JsonProperty("tileMatrices")
  @NotNull
  public List<TileMatrix> getTileMatrices() {
    return tileMatrices;
  }

  @JsonProperty("tileMatrices")
  public void setTileMatrices(List<TileMatrix> tileMatrices) {
    this.tileMatrices = tileMatrices;
  }

  public TileMatrixSet addTileMatricesItem(TileMatrix tileMatricesItem) {
    if (this.tileMatrices == null) {
      this.tileMatrices = new ArrayList<>();
    }

    this.tileMatrices.add(tileMatricesItem);
    return this;
  }

  public TileMatrixSet removeTileMatricesItem(TileMatrix tileMatricesItem) {
    if (tileMatricesItem != null && this.tileMatrices != null) {
      this.tileMatrices.remove(tileMatricesItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TileMatrixSet tileMatrixSet = (TileMatrixSet) o;
    return Objects.equals(this.title, tileMatrixSet.title) &&
        Objects.equals(this.description, tileMatrixSet.description) &&
        Objects.equals(this.keywords, tileMatrixSet.keywords) &&
        Objects.equals(this.id, tileMatrixSet.id) &&
        Objects.equals(this.uri, tileMatrixSet.uri) &&
        Objects.equals(this.orderedAxes, tileMatrixSet.orderedAxes) &&
        Objects.equals(this.crs, tileMatrixSet.crs) &&
        Objects.equals(this.wellKnownScaleSet, tileMatrixSet.wellKnownScaleSet) &&
        Objects.equals(this.boundingBox, tileMatrixSet.boundingBox) &&
        Objects.equals(this.tileMatrices, tileMatrixSet.tileMatrices);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, description, keywords, id, uri, orderedAxes, crs, wellKnownScaleSet, boundingBox, tileMatrices);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TileMatrixSet {\n");
    
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    orderedAxes: ").append(toIndentedString(orderedAxes)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    wellKnownScaleSet: ").append(toIndentedString(wellKnownScaleSet)).append("\n");
    sb.append("    boundingBox: ").append(toIndentedString(boundingBox)).append("\n");
    sb.append("    tileMatrices: ").append(toIndentedString(tileMatrices)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

