package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Link;
import org.apache.baremaps.ogcapi.model.TileSetCrs;
import org.apache.baremaps.ogcapi.model.TileSetDataType;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A minimal tileSet element for use within a list of tileSets linking to full description of those tileSets.
 **/
@ApiModel(description = "A minimal tileSet element for use within a list of tileSets linking to full description of those tileSets.")
@JsonTypeName("tileSet-item")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class TileSetItem   {
  private @Valid String title;
  private @Valid TileSetDataType dataType;
  private @Valid TileSetCrs crs;
  private @Valid URI tileMatrixSetURI;
  private @Valid List<Link> links = new ArrayList<>();

  /**
   * A title for this tileSet
   **/
  public TileSetItem title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "A title for this tileSet")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   **/
  public TileSetItem dataType(TileSetDataType dataType) {
    this.dataType = dataType;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("dataType")
  @NotNull
  public TileSetDataType getDataType() {
    return dataType;
  }

  @JsonProperty("dataType")
  public void setDataType(TileSetDataType dataType) {
    this.dataType = dataType;
  }

  /**
   **/
  public TileSetItem crs(TileSetCrs crs) {
    this.crs = crs;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("crs")
  @NotNull
  public TileSetCrs getCrs() {
    return crs;
  }

  @JsonProperty("crs")
  public void setCrs(TileSetCrs crs) {
    this.crs = crs;
  }

  /**
   * Reference to a Tile Matrix Set on an offical source for Tile Matrix Sets such as the OGC NA definition server (http://www.opengis.net/def/tms/). Required if the tile matrix set is registered on an open official source.
   **/
  public TileSetItem tileMatrixSetURI(URI tileMatrixSetURI) {
    this.tileMatrixSetURI = tileMatrixSetURI;
    return this;
  }

  
  @ApiModelProperty(value = "Reference to a Tile Matrix Set on an offical source for Tile Matrix Sets such as the OGC NA definition server (http://www.opengis.net/def/tms/). Required if the tile matrix set is registered on an open official source.")
  @JsonProperty("tileMatrixSetURI")
  public URI getTileMatrixSetURI() {
    return tileMatrixSetURI;
  }

  @JsonProperty("tileMatrixSetURI")
  public void setTileMatrixSetURI(URI tileMatrixSetURI) {
    this.tileMatrixSetURI = tileMatrixSetURI;
  }

  /**
   * Links to related resources. A &#39;self&#39; link to the tileSet as well as a &#39;http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme&#39; link to a definition of the TileMatrixSet are required.
   **/
  public TileSetItem links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "Links to related resources. A 'self' link to the tileSet as well as a 'http://www.opengis.net/def/rel/ogc/1.0/tiling-scheme' link to a definition of the TileMatrixSet are required.")
  @JsonProperty("links")
  @NotNull
  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public TileSetItem addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public TileSetItem removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TileSetItem tileSetItem = (TileSetItem) o;
    return Objects.equals(this.title, tileSetItem.title) &&
        Objects.equals(this.dataType, tileSetItem.dataType) &&
        Objects.equals(this.crs, tileSetItem.crs) &&
        Objects.equals(this.tileMatrixSetURI, tileSetItem.tileMatrixSetURI) &&
        Objects.equals(this.links, tileSetItem.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, dataType, crs, tileMatrixSetURI, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TileSetItem {\n");
    
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    tileMatrixSetURI: ").append(toIndentedString(tileMatrixSetURI)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

