/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.quantization;

import java.io.IOException;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;
import org.apache.lucene.util.quantization.RandomAccessQuantizedByteVectorValues;
import org.apache.lucene.util.quantization.ScalarQuantizedRandomVectorScorer;
import org.apache.lucene.util.quantization.ScalarQuantizedVectorSimilarity;
import org.apache.lucene.util.quantization.ScalarQuantizer;

public class ScalarQuantizedRandomVectorScorerSupplier
implements RandomVectorScorerSupplier {
    private final RandomAccessQuantizedByteVectorValues values;
    private final ScalarQuantizedVectorSimilarity similarity;

    public ScalarQuantizedRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, ScalarQuantizer scalarQuantizer, RandomAccessQuantizedByteVectorValues values) {
        this.similarity = ScalarQuantizedVectorSimilarity.fromVectorSimilarity(similarityFunction, scalarQuantizer.getConstantMultiplier());
        this.values = values;
    }

    private ScalarQuantizedRandomVectorScorerSupplier(ScalarQuantizedVectorSimilarity similarity, RandomAccessQuantizedByteVectorValues values) {
        this.similarity = similarity;
        this.values = values;
    }

    @Override
    public RandomVectorScorer scorer(int ord) throws IOException {
        RandomAccessQuantizedByteVectorValues vectorsCopy = this.values.copy();
        byte[] queryVector = (byte[])this.values.vectorValue(ord);
        float queryOffset = this.values.getScoreCorrectionConstant();
        return new ScalarQuantizedRandomVectorScorer(this.similarity, vectorsCopy, queryVector, queryOffset);
    }

    @Override
    public RandomVectorScorerSupplier copy() throws IOException {
        return new ScalarQuantizedRandomVectorScorerSupplier(this.similarity, this.values.copy());
    }
}

