/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.postgres.PostgresNodeRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresRelationRepository;
import org.apache.baremaps.openstreetmap.postgres.PostgresWayRepository;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportDaylightTranslations
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(ImportDaylightTranslations.class);
    private Path file;
    private Object database;

    public ImportDaylightTranslations() {
    }

    public ImportDaylightTranslations(Path file, Object database) {
        this.file = file;
        this.database = database;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        DataSource datasource = context.getDataSource(this.database);
        PostgresNodeRepository nodeRepository = new PostgresNodeRepository(datasource);
        PostgresWayRepository wayRepository = new PostgresWayRepository(datasource);
        PostgresRelationRepository relationRepository = new PostgresRelationRepository(datasource);
        nodeRepository.create();
        wayRepository.create();
        relationRepository.create();
        try (Stream<String> lines = Files.lines(this.file);){
            Map<Group, List<Line>> entries = lines.map(Line::parse).collect(Collectors.groupingBy(Line::group));
            block15: for (Map.Entry<Group, List<Line>> entry : entries.entrySet()) {
                Group group = entry.getKey();
                switch (group.type()) {
                    case "node": {
                        Node node = nodeRepository.get(group.id());
                        if (node == null) continue block15;
                        HashMap<String, Object> tags = new HashMap<String, Object>(node.getTags());
                        for (Line line : entry.getValue()) {
                            tags.put(line.attributeKey(), line.attributeValue());
                        }
                        node.setTags(tags);
                        nodeRepository.put(node);
                        break;
                    }
                    case "way": {
                        Way way = wayRepository.get(group.id());
                        if (way == null) continue block15;
                        HashMap<String, Object> tags = new HashMap<String, Object>(way.getTags());
                        for (Line line : entry.getValue()) {
                            tags.put(line.attributeKey(), line.attributeValue());
                        }
                        way.setTags(tags);
                        wayRepository.put(way);
                        break;
                    }
                    case "relation": {
                        Relation relation = relationRepository.get(group.id());
                        if (relation == null) break;
                        HashMap<String, Object> tags = new HashMap<String, Object>(relation.getTags());
                        for (Line line : entry.getValue()) {
                            tags.put(line.attributeKey(), line.attributeValue());
                        }
                        relation.setTags(tags);
                        relationRepository.put(relation);
                    }
                }
            }
        }
    }

    public String toString() {
        return new StringJoiner(", ", ImportDaylightTranslations.class.getSimpleName() + "[", "]").add("file=" + this.file).add("database=" + this.database).toString();
    }

    record Group(String type, Long id, String name) {
    }

    record Line(String type, Long id, String name, String attributeKey, String attributeValue) {
        public Group group() {
            return new Group(this.type, this.id, this.name);
        }

        public static Line parse(String line) {
            String[] parts = line.split("\t");
            String type = parts[0];
            long id = Long.parseLong(parts[1]);
            String name = parts[2];
            String key = parts[3];
            String val = parts[4];
            return new Line(type, id, name, key, val);
        }
    }
}

