--
-- STANDARD DATA FOR olap_* TESTS.
--

-- start_ignore
-- count number of certain operators in a given plan
create language plpython3u;
create or replace function ow_count_operator(query text, operator text) returns int as
$$
rv = plpy.execute('EXPLAIN '+ query)
search_text = operator
result = 0
for i in range(len(rv)):
    cur_line = rv[i]['QUERY PLAN']
    if search_text.lower() in cur_line.lower():
        result = result+1
return result
$$
language plpython3u;

drop table ow_customer;
drop table ow_vendor;
drop table ow_product;
drop table ow_sale;
drop table ow_sale_ord;

create table ow_customer 
(
	cn int not null,
	cname text not null,
	cloc text,
	
	primary key (cn)
	
) distributed by (cn);

create table ow_vendor 
(
	vn int not null,
	vname text not null,
	vloc text,
	
	primary key (vn)
	
) distributed by (vn);

create table ow_product 
(
	pn int not null,
	pname text not null,
	pcolor text,
	
	primary key (pn)
	
) distributed by (pn);

create table ow_sale
(
	cn int not null,
	vn int not null,
	pn int not null,
	dt date not null,
	qty int not null,
	prc float not null,
	
	primary key (cn, vn, pn)
	
) distributed by (cn,vn,pn);

create table ow_sale_ord
(
        ord int not null,
	cn int not null,
	vn int not null,
	pn int not null,
	dt date not null,
	qty int not null,
	prc float not null,
	
	primary key (cn, vn, pn)
	
) distributed by (cn,vn,pn);

-- Customers
insert into ow_customer values 
  ( 1, 'Macbeth', 'Inverness'),
  ( 2, 'Duncan', 'Forres'),
  ( 3, 'Lady Macbeth', 'Inverness'),
  ( 4, 'Witches, Inc', 'Lonely Heath');

-- Vendors
insert into ow_vendor values 
  ( 10, 'Witches, Inc', 'Lonely Heath'),
  ( 20, 'Lady Macbeth', 'Inverness'),
  ( 30, 'Duncan', 'Forres'),
  ( 40, 'Macbeth', 'Inverness'),
  ( 50, 'Macduff', 'Fife');

-- Products
insert into ow_product values 
  ( 100, 'Sword', 'Black'),
  ( 200, 'Dream', 'Black'),
  ( 300, 'Castle', 'Grey'),
  ( 400, 'Justice', 'Clear'),
  ( 500, 'Donuts', 'Plain'),
  ( 600, 'Donuts', 'Chocolate'),
  ( 700, 'Hamburger', 'Grey'),
  ( 800, 'Fries', 'Grey');


-- Sales (transactions)
insert into ow_sale values 
  ( 2, 40, 100, '1401-1-1', 1100, 2400),
  ( 1, 10, 200, '1401-3-1', 1, 0),
  ( 3, 40, 200, '1401-4-1', 1, 0),
  ( 1, 20, 100, '1401-5-1', 1, 0),
  ( 1, 30, 300, '1401-5-2', 1, 0),
  ( 1, 50, 400, '1401-6-1', 1, 0),
  ( 2, 50, 400, '1401-6-1', 1, 0),
  ( 1, 30, 500, '1401-6-1', 12, 5),
  ( 3, 30, 500, '1401-6-1', 12, 5),
  ( 3, 30, 600, '1401-6-1', 12, 5),
  ( 4, 40, 700, '1401-6-1', 1, 1),
  ( 4, 40, 800, '1401-6-1', 1, 1);

-- Sales (ord transactions)
insert into ow_sale_ord values 
  ( 1,2, 40, 100, '1401-1-1', 1100, 2400),
  ( 2,1, 10, 200, '1401-3-1', 1, 0),
  ( 3,3, 40, 200, '1401-4-1', 1, 0),
  ( 4,1, 20, 100, '1401-5-1', 1, 0),
  ( 5,1, 30, 300, '1401-5-2', 1, 0),
  ( 6,1, 50, 400, '1401-6-1', 1, 0),
  ( 7,2, 50, 400, '1401-6-1', 1, 0),
  ( 8,1, 30, 500, '1401-6-1', 12, 5),
  ( 9,3, 30, 500, '1401-6-1', 12, 5),
  ( 10,3, 30, 600, '1401-6-1', 12, 5),
  ( 11,4, 40, 700, '1401-6-1', 1, 1),
  ( 12,4, 40, 800, '1401-6-1', 1, 1);
-- end_ignore

set datestyle="ISO, MDY";

-- ROW_NUMBER() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc); -- mvd 2->4; 

-- ROW_NUMBER() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),ow_sale.vn
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.pn desc,ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.pn desc,ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc,ow_sale.vn desc); -- mvd 6,2->5; 6,2->7; 6,2->8; 6,2->9; 

-- ROW_NUMBER() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.pn desc); -- mvd 4,1,5,2->3; 

-- ROW_NUMBER() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.vn order by ow_sale.pn desc,ow_sale.vn desc,ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.vn order by ow_sale.pn desc,ow_sale.vn desc,ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.vn order by ow_sale.pn desc,ow_sale.vn desc,ow_sale.vn asc); -- mvd 2,7,3,8->6; 2,7,3,8->9; 2,7,3,8->10; 2,7,3,8->11; 2,7,3,8->12; 2,7,3,8->13; 

-- DENSE_RANK() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc,ow_sale.cn asc); -- mvd 2,5->4; 

-- DENSE_RANK() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc); -- mvd 2->4; 2->5; 2->6; 2->7; 2->8; 

-- DENSE_RANK() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.qty,ow_sale.pn order by ow_sale.cn desc,ow_sale.cn asc); -- mvd 4,5,6,1->3; 

-- DENSE_RANK() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.cn order by ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.cn order by ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.cn order by ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.cn order by ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn desc); -- mvd 3,4,5,1->2; 3,4,5,1->6; 3,4,5,1->7; 3,4,5,1->8; 3,4,5,1->9; 3,4,5,1->10; 

-- RANK() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(RANK() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc); -- mvd 1->5; 

-- RANK() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(RANK() OVER(win1),0),'99999999.9999999'),ow_sale.cn
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc,ow_sale.cn desc); -- mvd 5->4; 5->6; 

-- RANK() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.vn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(RANK() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.pn desc,ow_sale.vn desc); -- mvd 2,1,3->4; 

-- RANK() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.dt,ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(RANK() OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.dt order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.dt order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.vn asc); -- mvd 3,6->7; 3,6->8; 3,6->9; 3,6->10; 

-- CUME_DIST() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc,ow_sale.vn asc); -- mvd 5,3->4; 

-- CUME_DIST() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc,ow_sale.cn desc); -- mvd 1->3; 1->4; 

-- CUME_DIST() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.qty, TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.dt order by ow_sale.cn desc,ow_sale.cn asc); -- mvd 3,4->2; 

-- CUME_DIST() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.cn,ow_sale.pn
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.pn,ow_sale.dt,ow_sale.prc,ow_sale.dt order by ow_sale.vn desc); -- mvd 3,4,5,1,6->2; 3,4,5,1,6->7; 

-- PERCENT_RANK() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc,ow_sale.vn desc); -- mvd 7->6; 

-- PERCENT_RANK() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc); -- mvd 1->2; 1->3; 1->4; 1->5; 

-- PERCENT_RANK() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.prc, TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.cn asc); -- mvd 1,3,4,5->2; 

-- PERCENT_RANK() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.qty,ow_sale.dt,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),ow_sale.pn
,
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.qty,ow_sale.qty,ow_sale.dt order by ow_sale.cn desc,ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.qty,ow_sale.dt order by ow_sale.cn desc,ow_sale.pn desc); -- mvd 1,4,2,8->7; 1,4,2,8->9; 

-- LAG() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn+ow_sale.prc) as int),NULL) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc); -- mvd 7,4->6; 

-- LAG() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc),
win2 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn desc); -- mvd 3->5; 3->6; 3->7; 3->8; 10,3->9; 

-- LAG() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn desc); -- mvd 2,4->3; 

-- LAG() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn-ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win1),0),'99999999.9999999'),ow_sale.vn
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc); -- mvd 3,1->2; 3,1->4; 3,1->5; 3,1->6; 3,1->7; 

-- LEAD() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.pn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.prc) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.prc) as int),cast (floor(ow_sale.vn-ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc),
win2 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 5,3->6; 3->7; 3->8; 5,3->9; 3->10; 

-- LEAD() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.pn,ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn+ow_sale.pn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc,ow_sale.pn asc); -- mvd 5,1->4; 

-- LEAD() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn/ow_sale.qty) as int),NULL) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc),
win2 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 2,4,5->3; 2,4,5->6; 4->7; 

-- COUNT() function with NULL OVER() clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (); -- mvd 7->7; 

-- COUNT() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (),
win2 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.cn,ow_sale.dt order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 4->4; 1,2,6,7->5; 9->8; 

-- COUNT() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.prc); -- mvd 4,6,7->5; 

-- COUNT() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn),
win2 as (partition by ow_sale.pn order by ow_sale.cn asc); -- mvd 2,3->5; 4,3->6; 

-- COUNT() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc,ow_sale.vn asc); -- mvd 1,5->4; 

-- COUNT() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.vn asc,ow_sale.cn desc,ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc,ow_sale.cn desc,ow_sale.pn desc); -- mvd 1,2,3->5; 1,2,3->6; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range unbounded preceding ); -- mvd 1->5; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn/ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range unbounded preceding ),
win2 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.pn desc),
win4 as (order by ow_sale.pn desc); -- mvd 4->3; 1,6->5; 4->7; 4->8; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range floor(ow_sale.qty)::integer preceding ); -- mvd 1->5; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ); -- mvd 1->4; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ),
win2 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.qty order by ow_sale.pn desc); -- mvd 4->3; 6,7,4,8,2->5; 6,7,4,8,2->9; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and 2 preceding ); -- mvd 2->3; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and floor(ow_sale.vn/ow_sale.pn)::integer preceding ),
win2 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.pn order by ow_sale.vn asc); -- mvd 3->2; 1,5,6,3->4; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and current row ); -- mvd 5->4; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn/ow_sale.vn) as int),cast (floor(ow_sale.vn+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and current row ),
win2 as (partition by ow_sale.prc order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 1->4; 6,1->5; 6,1->7; 9->8; 6,1->10; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.dt,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and floor(ow_sale.prc+ow_sale.qty)::integer following ); -- mvd 6->5; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn-ow_sale.qty)) OVER(order by ow_sale.cn desc range between unbounded preceding and 0 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and 0 following ); -- mvd 3->2; 3->4; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and unbounded following ); -- mvd 1->5; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty+ow_sale.qty) as int),cast (floor(ow_sale.vn+ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.dt order by ow_sale.cn desc),
win3 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.cn desc),
win4 as (order by ow_sale.ord, ow_sale.vn asc),
win5 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn desc); -- mvd 2->4; 2,6,7,3->5; 2,6,7->8; 7->9; 2,6->10; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 1 preceding and floor(ow_sale.vn)::integer preceding ); -- mvd 4->3; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 4 preceding and current row ); -- mvd 7->6; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 3 preceding and floor(ow_sale.pn)::integer following ); -- mvd 2->3; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between floor(ow_sale.qty+ow_sale.vn)::integer preceding and unbounded following ); -- mvd 1->2; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and current row ); -- mvd 3->2; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and current row ),
win2 as (order by ow_sale.cn asc); -- mvd 2->4; 6->5; 6->7; 6->8; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and 4 following ); -- mvd 5->6; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and 2 following ),
win2 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 4->3; 4->5; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between current row and unbounded following ); -- mvd 5->4; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 1 following and floor(ow_sale.prc)::integer following ); -- mvd 3->4; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 0 following and 1 following ),
win2 as (order by ow_sale.pn desc),
win3 as (partition by ow_sale.vn order by ow_sale.vn desc); -- mvd 4->3; 6->5; 4->7; 

-- COUNT() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.cn+ow_sale.prc)::integer following and unbounded following ); -- mvd 3->4; 

-- COUNT() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between 3 following and unbounded following ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.cn order by ow_sale.cn asc); -- mvd 1->4; 1->5; 2,3,7->6; 1->8; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows unbounded preceding ); -- mvd 1->3; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc rows unbounded preceding ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.vn order by ow_sale.cn asc); -- mvd 3->5; 7,8,3,2,4->6; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows floor(ow_sale.pn) preceding ); -- mvd 4->3; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty-ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.qty) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn+ow_sale.qty) as int),NULL) OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows 1 preceding ),
win2 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.prc order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.cn asc),
win4 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.cn asc),
win5 as (partition by ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc); -- mvd 3->6; 2,8,1,3->7; 1->9; 1,11,12,3->10; 1,3->13; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows current row ); -- mvd 1->4; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn-ow_sale.prc) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.pn) as int),cast (floor(ow_sale.cn*ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows current row ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),
win3 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.dt order by ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 7->6; 9,3->8; 4,7,9->10; 7->11; 9,3->12; 7->13; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and floor(ow_sale.pn+ow_sale.qty) preceding ); -- mvd 2->4; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between unbounded preceding and floor(ow_sale.prc+ow_sale.pn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between unbounded preceding and floor(ow_sale.prc+ow_sale.pn) preceding ); -- mvd 3,5->4; 3,5->6; 3,5->7; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and current row ); -- mvd 4->5; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.pn desc rows between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.pn desc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.pn desc); -- mvd 6,4,3->5; 6,4,3->7; 2,3->8; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn/ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc,ow_sale.cn desc rows between unbounded preceding and 3 following ); -- mvd 1->6; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and 1 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and 1 following ); -- mvd 1->2; 1->3; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn desc,ow_sale.pn asc rows between unbounded preceding and unbounded following ); -- mvd 3,5->4; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn desc rows between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.pn order by ow_sale.pn asc); -- mvd 3,4->2; 3->5; 3->6; 8,1->7; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows between 0 preceding and 2 preceding ); -- mvd 6,4->5; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.pn) as int),cast (floor(ow_sale.cn/ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between 1 preceding and 1 preceding ),
win2 as (partition by ow_sale.pn order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc),
win4 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc); -- mvd 3->5; 2->6; 4->7; 4,3->8; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc rows between 3 preceding and current row ); -- mvd 4->3; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc,ow_sale.pn desc rows between 2 preceding and current row ),
win2 as (order by ow_sale.pn desc); -- mvd 3,6->5; 6->7; 3,6->8; 6->9; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between 8 preceding and floor(ow_sale.prc+ow_sale.vn) following ); -- mvd 2->5; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between 7 preceding and unbounded following ); -- mvd 1->2; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between 3 preceding and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 5->4; 5->6; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc/ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between current row and current row ); -- mvd 3,2->5; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between current row and current row ); -- mvd 5->4; 5->6; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between current row and 8 following ); -- mvd 4,1->3; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between current row and unbounded following ); -- mvd 3->5; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.vn asc); -- mvd 1->4; 3->5; 3->6; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between 1 following and 2 following ); -- mvd 5->4; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows between 3 following and 1 following ),
win2 as (order by ow_sale.cn asc); -- mvd 4->3; 6->5; 

-- COUNT() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.cn) following and unbounded following ); -- mvd 4->3; 

-- COUNT() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc rows between floor(ow_sale.qty) following and unbounded following ),
win2 as (partition by ow_sale.qty order by ow_sale.cn asc); -- mvd 4,5->3; 2,7->6; 

-- COUNT() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.vn asc,ow_sale.cn desc); -- mvd 3,4,1,5->2; 

-- COUNT() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty order by ow_sale.cn asc); -- mvd 2,4,5->3; 2,4,5->6; 2,4,5->7; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.pn asc range unbounded preceding ); -- mvd 2,5->4; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.vn desc range unbounded preceding ),
win2 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.prc order by ow_sale.cn desc); -- mvd 1,4,5,6->3; 8,1,4->7; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.qty order by ow_sale.cn asc range floor(ow_sale.prc/ow_sale.cn)::integer preceding ); -- mvd 1,4,5,6->3; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.qty,ow_sale.prc,ow_sale.pn order by ow_sale.cn asc range 1 preceding ),
win2 as (order by ow_sale.pn desc); -- mvd 2,4,5,6,7->3; 7->8; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.pn asc range current row ); -- mvd 1,2,7->6; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc range current row ),
win2 as (order by ow_sale.pn desc); -- mvd 4,5->3; 7->6; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.qty order by ow_sale.pn asc range between unbounded preceding and 0 preceding ); -- mvd 2,1,7,5->6; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.vn desc range between unbounded preceding and 4 preceding ),
win2 as (order by ow_sale.cn asc); -- mvd 3,4->2; 6->5; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.pn desc range between unbounded preceding and current row ); -- mvd 2,5,1,6->4; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.pn asc range between unbounded preceding and current row ),
win2 as (order by ow_sale.vn asc); -- mvd 3,4,1->2; 4->5; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.qty,ow_sale.vn order by ow_sale.cn desc range between unbounded preceding and 3 following ); -- mvd 6,1,3,2,7->5; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.prc,ow_sale.vn order by ow_sale.pn desc range between unbounded preceding and unbounded following ); -- mvd 1,4,5,2,6->3; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.vn asc range between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.pn desc),
win4 as (order by ow_sale.cn desc); -- mvd 4,1,3->7; 1->8; 5->9; 1->10; 1->11; 1->12; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.qty,ow_sale.prc,ow_sale.pn order by ow_sale.vn asc range between floor(ow_sale.cn)::integer preceding and 4 preceding ); -- mvd 7,1,8,2->6; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc order by ow_sale.cn asc range between 0 preceding and 0 preceding ),
win2 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 6,3->5; 1,8->7; 1,8->9; 3->10; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.cn desc range between 4 preceding and current row ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.pn order by ow_sale.cn desc); -- mvd 2,1->3; 2->4; 6,2,7,1->5; 2->8; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.vn order by ow_sale.cn asc range between floor(ow_sale.pn+ow_sale.pn)::integer preceding and floor(ow_sale.qty)::integer following ); -- mvd 6,7,1->5; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.qty order by ow_sale.vn asc range between 3 preceding and 0 following ),
win2 as (partition by ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc); -- mvd 1,3,7->6; 9,3->8; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.qty,ow_sale.pn order by ow_sale.vn asc range between 3 preceding and unbounded following ); -- mvd 7,8,2,1->6; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.pn*ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.vn order by ow_sale.cn asc range between 0 preceding and unbounded following ),
win2 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.vn desc); -- mvd 3,4,1->2; 3,6,1,7->5; 4->8; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.vn asc range between current row and current row ); -- mvd 3,4,1->2; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc/ow_sale.qty) as int),cast (floor(ow_sale.qty*ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn-ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.cn order by ow_sale.cn desc range between current row and current row ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.pn asc),
win4 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc); -- mvd 3,5,1->6; 2->7; 2->8; 2->9; 3,5,4,2->10; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.pn desc range between current row and floor(ow_sale.vn)::integer following ); -- mvd 3,5,2,1->4; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc/ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc range between current row and 0 following ),
win2 as (partition by ow_sale.cn,ow_sale.vn order by ow_sale.vn asc),
win3 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc); -- mvd 4,2,5->3; 2,5->6; 4,5,8->7; 2,5->9; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc order by ow_sale.vn asc range between current row and unbounded following ); -- mvd 5,6->4; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.cn,ow_sale.prc,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn desc range between current row and unbounded following ),
win2 as (order by ow_sale.pn asc); -- mvd 1,7->6; 9->8; 9->10; 9->11; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn asc range between 3 following and floor(ow_sale.cn+ow_sale.vn)::integer following ); -- mvd 2,1->7; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.prc+ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn/ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.dt order by ow_sale.pn desc range between floor(ow_sale.qty+ow_sale.prc)::integer following and 4 following ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 1,6,7,2,8->5; 7->9; 7->10; 8->11; 

-- COUNT() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.dt order by ow_sale.cn desc range between 3 following and unbounded following ); -- mvd 6,2,7,8->5; 

-- COUNT() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.cn order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.pn asc range between 1 following and unbounded following ),
win2 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.cn order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc),
win4 as (partition by ow_sale.pn order by ow_sale.cn asc); -- mvd 3,4,5->2; 7,4,1,5->6; 7,4,1,5->8; 4->9; 4->10; 7,5->11; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc rows unbounded preceding ); -- mvd 8,2,9,1,10->7; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows unbounded preceding ),
win2 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.pn order by ow_sale.pn desc); -- mvd 4,5,1->3; 4,5,7->6; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.cn desc rows 9 preceding ); -- mvd 4,5,2->3; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc,ow_sale.pn asc rows floor(ow_sale.prc) preceding ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.cn order by ow_sale.pn asc),
win4 as (order by ow_sale.vn desc); -- mvd 6,7,8,1->5; 8->9; 7,1->10; 8->11; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn desc rows current row ); -- mvd 2,4->6; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn-ow_sale.pn) as int),cast (floor(ow_sale.qty/ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn asc,ow_sale.pn asc rows current row ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 6,1,4,7,3->5; 3->8; 3->9; 3->10; 7->11; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc rows between unbounded preceding and 1 preceding ); -- mvd 2,6,7,8->5; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and 1 preceding ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.vn order by ow_sale.vn desc); -- mvd 1,5,2,3->4; 1->6; 2->7; 2->8; 1->9; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.pn asc rows between unbounded preceding and current row ); -- mvd 1,3,4->2; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc,ow_sale.cn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.cn asc); -- mvd 4,1,5->3; 4->6; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.cn) following ); -- mvd 6,1->5; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.pn/ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between unbounded preceding and 0 following ),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc),
win3 as (order by ow_sale.vn asc); -- mvd 1,2->4; 1,3->5; 3->6; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc rows between unbounded preceding and unbounded following ); -- mvd 3,1->2; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc); -- mvd 2,6,1->5; 8,9,2,6->7; 8,9,2,6->10; 8,9,2,6->11; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows between 4 preceding and floor(ow_sale.prc) preceding ); -- mvd 5,3,1->4; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn desc rows between 2 preceding and 0 preceding ),
win2 as (order by ow_sale.pn asc); -- mvd 5,7,2,4,3->6; 3->8; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc,ow_sale.cn asc rows between 8 preceding and current row ); -- mvd 4,5,6,2->3; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty/ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty*ow_sale.cn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.vn desc rows between 2 preceding and current row ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.cn asc),
win4 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc); -- mvd 4,5,1,6,7->3; 5->8; 5,1->9; 5,1->10; 1,7->11; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.cn desc rows between 2 preceding and floor(ow_sale.qty+ow_sale.qty) following ); -- mvd 2,3,5,6,1->4; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc rows between 0 preceding and unbounded following ); -- mvd 2,3,5->4; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.pn asc rows between 1 preceding and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.vn order by ow_sale.pn desc); -- mvd 5,6,7->4; 5,3,1,7->8; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between current row and current row ); -- mvd 8,2->7; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.vn-ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.vn desc rows between current row and current row ),
win2 as (partition by ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.vn asc),
win3 as (order by ow_sale.cn desc); -- mvd 5,7,1->6; 9,5,7->8; 5->10; 9,5,7->11; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.vn asc rows between current row and 7 following ); -- mvd 3,1,4->2; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty/ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows between current row and floor(ow_sale.pn-ow_sale.vn) following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 3,4,5->2; 3->6; 3->7; 3->8; 3->9; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc rows between current row and unbounded following ); -- mvd 4,5,6,2->3; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.qty order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc rows between current row and unbounded following ),
win2 as (partition by ow_sale.qty order by ow_sale.vn asc),
win3 as (partition by ow_sale.prc order by ow_sale.vn desc); -- mvd 5,6,1->4; 6,5->7; 6,5->8; 10,6->9; 10,6->11; 5,6,1->12; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.vn+ow_sale.cn) following and 5 following ); -- mvd 6,7->5; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc/ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.pn desc rows between 4 following and 4 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn-ow_sale.prc) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.pn desc rows between 4 following and 4 following ),
win2 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc),
win3 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.pn desc),
win4 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.dt order by ow_sale.cn desc),
win5 as (order by ow_sale.cn desc); -- mvd 1,3,4,5,6->2; 1,3,4,5,6->7; 3,5,6->8; 6->9; 4,3,5,6->10; 4->11; 

-- COUNT() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.pn*ow_sale.prc) following and unbounded following ); -- mvd 3,5,6->4; 

-- COUNT() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.cn,ow_sale.dt order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc rows between 1 following and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.prc order by ow_sale.cn asc),
win3 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.cn asc); -- mvd 2,4,5->3; 7,2,4,5->6; 2,4,5->8; 10,2->9; 10,2->11; 

-- MAX() function with NULL OVER() clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (); -- mvd 4->4; 

-- MAX() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.vn*ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (),
win2 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.pn order by ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc); -- mvd 4->4; 1,3,6->5; 3,8,9,6->7; 4->10; 

-- MAX() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn); -- mvd 1,4->3; 

-- MAX() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 1,3->2; 5->4; 5->6; 5->7; 5->8; 

-- MAX() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc,ow_sale.pn desc,ow_sale.cn asc); -- mvd 4,1->6; 

-- MAX() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc,ow_sale.vn asc); -- mvd 3->6; 3->7; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range unbounded preceding ); -- mvd 1->3; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.qty,ow_sale.prc,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range unbounded preceding ),
win2 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.cn asc); -- mvd 1->7; 1,9->8; 1,9->10; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range floor(ow_sale.vn+ow_sale.qty)::integer preceding ); -- mvd 2->5; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.vn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range 3 preceding ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.pn order by ow_sale.vn desc); -- mvd 7->6; 1,9,3,7->8; 1,9,3,7->10; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ); -- mvd 4->3; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc*ow_sale.pn)) OVER(order by ow_sale.pn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.vn) as int),cast (floor(ow_sale.cn+ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range current row ),
win2 as (partition by ow_sale.cn order by ow_sale.pn asc),
win3 as (order by ow_sale.pn asc),
win4 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 4->3; 2,4->5; 4->6; 4->7; 4->8; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and 4 preceding ); -- mvd 4->3; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and floor(ow_sale.qty+ow_sale.cn)::integer preceding ),
win2 as (order by ow_sale.cn desc); -- mvd 1->4; 6->5; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and current row ); -- mvd 3->2; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.vn)::integer following ); -- mvd 1->5; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and 1 following ),
win2 as (order by ow_sale.cn desc); -- mvd 3->2; 3->4; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and unbounded following ); -- mvd 1->6; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.pn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(order by ow_sale.pn asc range between unbounded preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc); -- mvd 3->2; 5->4; 3->6; 5->7; 3->8; 5->9; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 2 preceding and 1 preceding ); -- mvd 6->5; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.pn)::integer preceding and 4 preceding ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.prc,ow_sale.pn order by ow_sale.pn desc); -- mvd 7->6; 9->8; 11,7,3,1->10; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.dt,ow_sale.prc,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.vn/ow_sale.qty)::integer preceding and current row ); -- mvd 7->6; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn/ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.vn/ow_sale.vn)::integer preceding and current row ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc); -- mvd 3->2; 5->4; 5->6; 5->7; 9,1,3,5->8; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 4 preceding and floor(ow_sale.vn*ow_sale.prc)::integer following ); -- mvd 1->3; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 4 preceding and floor(ow_sale.prc)::integer following ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.vn asc); -- mvd 5->4; 2->6; 2->7; 9,5->8; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 1 preceding and unbounded following ); -- mvd 4->3; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.prc) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn*ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 1 preceding and unbounded following ),
win2 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc),
win4 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc); -- mvd 2->4; 6,3->5; 6,3->7; 2,1,3->8; 2,1,3->9; 11,2,6->10; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and current row ); -- mvd 6->5; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.cn)) OVER(order by ow_sale.cn desc range between current row and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and current row ); -- mvd 3->7; 3->8; 3->9; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and 3 following ); -- mvd 4->3; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.cn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and 1 following ),
win2 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.prc,ow_sale.cn,ow_sale.vn order by ow_sale.pn desc); -- mvd 3->6; 3->7; 4,3,9,2,10->8; 4,3,9,2,10->11; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between current row and unbounded following ); -- mvd 5->4; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and unbounded following ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.dt order by ow_sale.vn desc); -- mvd 2->5; 1->6; 8,4,2->7; 1->9; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.qty+ow_sale.qty)::integer following and 0 following ); -- mvd 5->4; 

-- MAX() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 0 following and unbounded following ); -- mvd 4->3; 

-- MAX() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.cn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 2 following and unbounded following ),
win2 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc),
win3 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),
win4 as (order by ow_sale.cn desc); -- mvd 3->2; 3->4; 6,7,8,1,9->5; 3->10; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows unbounded preceding ); -- mvd 6,1->5; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn-ow_sale.cn) as int),cast (floor(ow_sale.pn*ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows unbounded preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.cn desc),
win4 as (order by ow_sale.vn asc); -- mvd 3,4->2; 3->5; 3->6; 1->7; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn+ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows floor(ow_sale.cn) preceding ); -- mvd 2->3; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn/ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn+ow_sale.qty) as int),NULL) OVER(win5),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc rows floor(ow_sale.prc) preceding ),
win2 as (partition by ow_sale.pn order by ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.pn asc),
win4 as (order by ow_sale.cn asc),
win5 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc); -- mvd 6,2->5; 2,3->7; 3->8; 6->9; 6,11,3->10; 6->12; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc,ow_sale.pn desc rows current row ); -- mvd 1->5; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty/ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.pn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows current row ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc); -- mvd 3->2; 3->4; 3->5; 7,8,9,3,1->6; 3->10; 3->11; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc,ow_sale.pn desc rows between unbounded preceding and 7 preceding ); -- mvd 2,5->4; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and current row ); -- mvd 4->5; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.vn) as int),cast (floor(ow_sale.cn*ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn desc); -- mvd 4,1,2->3; 1->5; 1,2->6; 1->7; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc rows between unbounded preceding and 2 following ); -- mvd 3->2; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and 3 following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.pn asc); -- mvd 1,4->3; 1->5; 1->6; 4->7; 1->8; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and unbounded following ); -- mvd 3->2; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.prc) as int),cast (floor(ow_sale.qty*ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc),
win4 as (order by ow_sale.pn desc); -- mvd 4->5; 1->6; 4->7; 9,10,3,1->8; 1->11; 4->12; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.vn) preceding and floor(ow_sale.qty+ow_sale.vn) preceding ); -- mvd 5->4; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn+ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn desc,ow_sale.pn desc rows between 0 preceding and floor(ow_sale.prc/ow_sale.cn) preceding ),
win2 as (order by ow_sale.pn asc),
win3 as (order by ow_sale.pn asc),
win4 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.vn desc); -- mvd 1,6->5; 6->7; 6->8; 6->9; 11,12,1,6->10; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn/ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between 6 preceding and current row ); -- mvd 1->3; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.dt,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc,ow_sale.cn asc rows between floor(ow_sale.vn) preceding and 0 following ); -- mvd 6->5; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.pn order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between 4 preceding and 1 following ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.pn order by ow_sale.vn desc); -- mvd 5->4; 1,7->6; 1,7->8; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between 0 preceding and unbounded following ); -- mvd 2->3; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty-ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc,ow_sale.cn desc rows between floor(ow_sale.prc) preceding and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.cn desc),
win4 as (partition by ow_sale.prc,ow_sale.qty,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc); -- mvd 1,6->5; 1->7; 1->8; 3,1,10,11->9; 1->12; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn asc,ow_sale.cn desc rows between current row and current row ); -- mvd 4,7->6; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc,ow_sale.cn asc rows between current row and 0 following ); -- mvd 3,4->2; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.pn+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between current row and 4 following ),
win2 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 3->6; 1,8,3->7; 1->9; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between current row and unbounded following ); -- mvd 4->3; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc rows between 8 following and 2 following ); -- mvd 6->5; 

-- MAX() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc rows between floor(ow_sale.vn) following and unbounded following ); -- mvd 2,6->5; 

-- MAX() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between 4 following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.cn asc); -- mvd 6->5; 8->7; 6->9; 8->10; 8->11; 

-- MAX() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.vn asc); -- mvd 1,3,2->5; 

-- MAX() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.pn desc); -- mvd 2,3,6->5; 2,3,6->7; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.qty,ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.pn desc range unbounded preceding ); -- mvd 1,5,6,7,8->4; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.vn)) OVER(partition by ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.vn asc range unbounded preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.vn asc range unbounded preceding ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc); -- mvd 1,4,2->3; 1,4,6,2->5; 1,4,6,2->7; 1,4,2->8; 1,4,6,2->9; 1,4,6,2->10; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn order by ow_sale.vn desc range floor(ow_sale.prc*ow_sale.cn)::integer preceding ); -- mvd 4,2,3->6; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn-ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.vn desc range floor(ow_sale.prc/ow_sale.vn)::integer preceding ),
win2 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 4->3; 2->5; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.prc,ow_sale.dt,ow_sale.vn order by ow_sale.vn asc range current row ); -- mvd 4,1,5,6,7->3; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.cn order by ow_sale.cn asc range current row ),
win2 as (order by ow_sale.vn desc); -- mvd 4->3; 6->5; 6->7; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.cn+ow_sale.pn)::integer preceding ); -- mvd 5,6,7->4; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.pn desc range between unbounded preceding and 0 preceding ),
win2 as (partition by ow_sale.cn order by ow_sale.pn asc); -- mvd 3,6,1->5; 3,1->7; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.qty order by ow_sale.cn asc range between unbounded preceding and current row ); -- mvd 4,1,2->3; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.cn asc range between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.cn asc range between unbounded preceding and current row ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.cn desc); -- mvd 3,4->2; 3,4->5; 4->6; 3,4->7; 9,3,1->8; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.pn desc range between unbounded preceding and 1 following ); -- mvd 4,5->3; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.pn,ow_sale.vn order by ow_sale.vn asc range between unbounded preceding and unbounded following ); -- mvd 4,6,2,1->5; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.pn desc range between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.pn asc),
win4 as (order by ow_sale.vn asc); -- mvd 4,5,6,7->3; 6->8; 7->9; 7->10; 2->11; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.cn desc range between floor(ow_sale.cn)::integer preceding and floor(ow_sale.cn)::integer preceding ); -- mvd 8,6,9,3->7; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.qty) as int),cast (floor(ow_sale.qty*ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.qty order by ow_sale.vn asc range between 1 preceding and floor(ow_sale.pn)::integer preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty order by ow_sale.vn asc range between 1 preceding and floor(ow_sale.pn)::integer preceding ),
win2 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.pn desc),
win4 as (partition by ow_sale.prc order by ow_sale.pn asc); -- mvd 4,1,5->3; 4,7,5,1->6; 9->8; 4,1,5->10; 9->11; 13,9->12; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.vn desc range between 2 preceding and current row ); -- mvd 6,3->5; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.pn)) OVER(partition by ow_sale.prc,ow_sale.prc,ow_sale.dt,ow_sale.cn order by ow_sale.cn asc range between 3 preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(partition by ow_sale.prc,ow_sale.prc,ow_sale.dt,ow_sale.cn order by ow_sale.cn asc range between 3 preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc*ow_sale.prc) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.dt,ow_sale.cn order by ow_sale.cn asc range between 3 preceding and current row ),
win2 as (partition by ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc); -- mvd 3,4,5->2; 3,4,5->6; 3,4,5->7; 3,4,9->8; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.pn desc range between 0 preceding and 0 following ); -- mvd 1,3->7; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn desc range between floor(ow_sale.vn+ow_sale.pn)::integer preceding and 3 following ),
win2 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.qty order by ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.vn desc); -- mvd 2,5->4; 2,7,5,1->6; 2,7,5,1->8; 10,5->9; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.vn asc range between floor(ow_sale.vn)::integer preceding and unbounded following ); -- mvd 1,8,4,9->7; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.pn,ow_sale.pn order by ow_sale.vn asc range between 3 preceding and unbounded following ),
win2 as (order by ow_sale.cn desc); -- mvd 6,3,7,1->5; 9->8; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.prc,ow_sale.qty order by ow_sale.pn desc range between current row and current row ); -- mvd 4,2,7->6; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn desc range between current row and current row ),
win2 as (order by ow_sale.pn desc); -- mvd 3,5->4; 2->6; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.vn asc range between current row and 1 following ); -- mvd 4,2,5->3; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn*ow_sale.prc) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.pn asc range between current row and floor(ow_sale.prc)::integer following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 6,8,9,5->7; 9->10; 5->11; 9->12; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.pn desc range between current row and unbounded following ); -- mvd 2,5,6,1,7->4; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.cn)) OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.dt order by ow_sale.vn desc range between current row and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.vn desc),
win4 as (order by ow_sale.vn asc); -- mvd 8,9,1,10->7; 1->11; 9,1->12; 1->13; 1->14; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn asc range between 2 following and floor(ow_sale.pn+ow_sale.cn)::integer following ); -- mvd 3,4->2; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.qty,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.pn order by ow_sale.pn desc range between floor(ow_sale.cn/ow_sale.vn)::integer following and 2 following ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.vn asc),
win3 as (order by ow_sale.cn asc); -- mvd 5,6,7,1->4; 6,2,1->8; 6->9; 

-- MAX() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.vn desc range between 0 following and unbounded following ); -- mvd 3,4->2; 

-- MAX() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.cn)) OVER(partition by ow_sale.pn,ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.cn asc range between floor(ow_sale.prc)::integer following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.cn asc range between floor(ow_sale.prc)::integer following and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.pn order by ow_sale.cn asc); -- mvd 1,3,4,5->2; 1,3,4,5->6; 8->7; 8->9; 11,1,8,5->10; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc,ow_sale.cn desc rows unbounded preceding ); -- mvd 4,1,3->5; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc rows unbounded preceding ),
win2 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.vn asc); -- mvd 3,4,5,6->2; 3,5,8->7; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc rows floor(ow_sale.prc) preceding ); -- mvd 6,7,4->5; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn-ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.vn asc rows floor(ow_sale.vn) preceding ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.dt order by ow_sale.cn desc),
win4 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.cn order by ow_sale.pn asc),
win5 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc); -- mvd 4,5,6->3; 6->7; 4,5->8; 1,4,6,10->9; 4,6,10->11; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.cn asc rows current row ); -- mvd 1,3,4->2; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.qty) as int),cast (floor(ow_sale.pn+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc,ow_sale.cn asc rows current row ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.cn desc),
win3 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc); -- mvd 8,9,10,4->7; 9,8,4->11; 10->12; 10->13; 9,8,4->14; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn/ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and floor(ow_sale.qty) preceding ); -- mvd 1,3->6; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and current row ); -- mvd 6,3,2,1->5; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.cn)) OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.pn+ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 1,5,6,2->4; 8->7; 8->9; 8->10; 1->11; 8->12; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc rows between unbounded preceding and 6 following ); -- mvd 2,1,6->7; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty+ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc,ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.qty) following ),
win2 as (partition by ow_sale.vn order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc),
win4 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.cn order by ow_sale.vn desc); -- mvd 6,2,1,3->5; 1,3->7; 1->8; 2,10,1,3->9; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.vn asc rows between unbounded preceding and unbounded following ); -- mvd 6,2->5; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn-ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty/ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 1,6,4->5; 1,8,6->7; 1,8,6->9; 1,8,6->10; 1,8,6->11; 1->12; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between floor(ow_sale.prc) preceding and 4 preceding ); -- mvd 4,5->3; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.cn desc rows between 3 preceding and floor(ow_sale.prc/ow_sale.cn) preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.cn desc rows between 3 preceding and floor(ow_sale.prc/ow_sale.cn) preceding ),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.vn desc); -- mvd 3,4,1->2; 3,4,1->5; 3->6; 3,4,1->7; 4->8; 3,4,1->9; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc,ow_sale.pn asc rows between 2 preceding and current row ); -- mvd 1,3,8->7; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.cn asc rows between floor(ow_sale.prc) preceding and current row ),
win2 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.cn desc),
win3 as (order by ow_sale.pn asc),
win4 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.vn,ow_sale.pn order by ow_sale.cn desc); -- mvd 3,2,4,6->7; 2,9,4,6->8; 2,9,4,6->10; 6->11; 3,2,9,4,6->12; 2,9,4,6->13; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows between 4 preceding and 4 following ); -- mvd 4,1->3; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn asc rows between floor(ow_sale.cn) preceding and floor(ow_sale.vn) following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,4,5->2; 1,7,3,5->6; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.prc)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc rows between 2 preceding and unbounded following ),
win2 as (order by ow_sale.cn desc); -- mvd 5->7; 2->8; 2->9; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc rows between current row and current row ); -- mvd 4,5,6,2->3; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MAX(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc,ow_sale.pn asc rows between current row and current row ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.cn asc),
win4 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.cn asc); -- mvd 5,6,7,1,2->4; 5->8; 5->9; 5->10; 5->11; 5->12; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn desc rows between current row and 8 following ); -- mvd 2,6->5; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.prc)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc rows between current row and floor(ow_sale.cn) following ),
win2 as (partition by ow_sale.prc,ow_sale.cn order by ow_sale.vn desc); -- mvd 1,3,4,5->2; 7,1,3->6; 7,1,3->8; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.cn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc rows between current row and unbounded following ); -- mvd 3,5,7->6; 

-- MAX() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows between 2 following and 7 following ); -- mvd 3,4->2; 

-- MAX() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc rows between 4 following and floor(ow_sale.pn+ow_sale.prc) following ),
win2 as (order by ow_sale.pn desc); -- mvd 2,3->7; 4->8; 

-- MIN() function with NULL OVER() clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (); -- mvd 2->2; 

-- MIN() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn),
win2 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc); -- mvd 4,2->3; 6,4,7,8->5; 

-- MIN() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn desc,ow_sale.cn desc); -- mvd 5,2->4; 

-- MIN() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc),
win2 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 1->5; 2->6; 1->7; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range unbounded preceding ); -- mvd 1->5; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range unbounded preceding ),
win2 as (partition by ow_sale.cn,ow_sale.vn order by ow_sale.cn asc),
win3 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.cn desc); -- mvd 2->4; 6,2->5; 6,8->7; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range 2 preceding ); -- mvd 6->5; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.cn order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range floor(ow_sale.prc)::integer preceding ),
win2 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt order by ow_sale.pn desc),
win3 as (partition by ow_sale.cn order by ow_sale.cn desc); -- mvd 4->3; 4->5; 7,2->6; 4->8; 4->9; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range current row ); -- mvd 2->3; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.qty)) OVER(order by ow_sale.vn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn/ow_sale.vn)) OVER(order by ow_sale.vn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.qty)) OVER(order by ow_sale.vn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(order by ow_sale.vn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.qty) as int),cast (floor(ow_sale.pn+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range current row ),
win2 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc); -- mvd 6->5; 6->7; 6->8; 6->9; 6->10; 2,12->11; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and 2 preceding ); -- mvd 1->4; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and current row ); -- mvd 4->6; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and current row ); -- mvd 3->2; 3->4; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and floor(ow_sale.qty)::integer following ); -- mvd 5->4; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and 2 following ); -- mvd 1->3; 1->4; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and unbounded following ); -- mvd 6->5; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc*ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.qty order by ow_sale.vn desc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 5->4; 3->6; 8,5,1,2,3->7; 8,5,1,2,3->9; 5->10; 8,5,1,2,3->11; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.prc+ow_sale.cn)::integer preceding and floor(ow_sale.cn)::integer preceding ); -- mvd 3->2; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(order by ow_sale.pn asc range between 2 preceding and 3 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 2 preceding and 3 preceding ),
win2 as (partition by ow_sale.cn order by ow_sale.vn asc); -- mvd 5->7; 5->8; 10,3->9; 5->11; 5->12; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.cn)::integer preceding and current row ); -- mvd 2->3; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.vn)::integer preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.vn desc),
win3 as (order by ow_sale.vn desc); -- mvd 4->3; 6,4->5; 6,4->7; 4->8; 4->9; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 2 preceding and unbounded following ); -- mvd 3->2; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 2 preceding and unbounded following ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.cn desc); -- mvd 4->3; 2->5; 2->6; 4->7; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and current row ); -- mvd 2->5; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and current row ),
win2 as (partition by ow_sale.cn order by ow_sale.pn desc); -- mvd 4->3; 4->5; 4->6; 4,8->7; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and 4 following ),
win2 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.prc,ow_sale.qty,ow_sale.prc order by ow_sale.cn desc),
win3 as (order by ow_sale.vn asc); -- mvd 6->5; 8,6,2,4,9->7; 6->10; 4->11; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.prc,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between current row and unbounded following ); -- mvd 7->6; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn/ow_sale.vn) as int),cast (floor(ow_sale.pn*ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and unbounded following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.prc order by ow_sale.ord, ow_sale.cn asc); -- mvd 3->2; 3->4; 6,3->5; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.qty)::integer following and 2 following ); -- mvd 5->4; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(order by ow_sale.pn asc range between 2 following and floor(ow_sale.prc/ow_sale.pn)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.vn*ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 2 following and floor(ow_sale.prc/ow_sale.pn)::integer following ),
win2 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 2->7; 2->8; 10->9; 

-- MIN() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 4 following and unbounded following ); -- mvd 3->2; 

-- MIN() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.vn)) OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 4 following and unbounded following ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.vn asc); -- mvd 4->3; 4->5; 4->6; 4->7; 4->8; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.pn desc rows unbounded preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows unbounded preceding ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc); -- mvd 2->3; 2->4; 1->5; 2->6; 1,8,2->7; 1->9; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.cn desc rows 4 preceding ); -- mvd 5,3->7; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn-ow_sale.cn)) OVER(partition by ow_sale.dt,ow_sale.vn order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.cn asc rows floor(ow_sale.prc*ow_sale.qty) preceding ),
win2 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.cn asc),
win3 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc); -- mvd 4->3; 4,6,7->5; 4,6,7->8; 4->9; 4->10; 6,7->11; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn-ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.cn asc rows current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows current row ),
win2 as (order by ow_sale.cn desc); -- mvd 6->5; 6->7; 6->8; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.vn asc rows between unbounded preceding and 1 preceding ); -- mvd 2,1->3; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn desc rows between unbounded preceding and 1 preceding ),
win2 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.pn order by ow_sale.pn desc); -- mvd 6,3,2->5; 4,3,2->7; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between unbounded preceding and current row ); -- mvd 2->3; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc rows between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc rows between unbounded preceding and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc rows between unbounded preceding and current row ); -- mvd 5,6->4; 5,6->7; 5,6->8; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between unbounded preceding and 6 following ); -- mvd 4,5->3; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn-ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and 4 following ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.cn asc),
win3 as (order by ow_sale.pn asc),
win4 as (partition by ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc); -- mvd 6->5; 6,4->7; 4->8; 3,6->9; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.vn asc rows between unbounded preceding and unbounded following ); -- mvd 1,3->2; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.vn desc rows between 3 preceding and 6 preceding ); -- mvd 1,5->7; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn*ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc,ow_sale.pn desc rows between 4 preceding and 1 preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc,ow_sale.pn desc rows between 4 preceding and 1 preceding ); -- mvd 5,6->4; 5,6->7; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows between 9 preceding and current row ); -- mvd 1,3->2; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between floor(ow_sale.cn) preceding and floor(ow_sale.prc) following ); -- mvd 2,4->3; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.pn+ow_sale.vn) preceding and unbounded following ); -- mvd 5->4; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.cn,ow_sale.prc,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc,ow_sale.vn asc rows between floor(ow_sale.prc) preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc,ow_sale.vn asc rows between floor(ow_sale.prc) preceding and unbounded following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.vn order by ow_sale.pn desc); -- mvd 3,8->7; 3->9; 3,8->10; 3->11; 8,6->12; 3->13; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.pn desc rows between current row and current row ); -- mvd 3,2,1->4; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.pn order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc*ow_sale.pn) as int),cast (floor(ow_sale.prc+ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.vn desc rows between current row and current row ),
win2 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.pn order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,2->6; 5,8,3,2->7; 5,8,3,2->9; 3->10; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and 2 following ); -- mvd 4->3; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc,ow_sale.vn desc rows between current row and 2 following ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.cn asc); -- mvd 4->3; 2,4,6->5; 2,4,6->7; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn asc,ow_sale.pn asc rows between current row and unbounded following ); -- mvd 1,5->4; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn-ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.prc order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between current row and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.prc order by ow_sale.ord, ow_sale.vn desc),
win3 as (partition by ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc); -- mvd 4->3; 6,4,1,2->5; 6,4,2->7; 6,4,2->8; 6,4,1,2->9; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between floor(ow_sale.cn*ow_sale.prc) following and 2 following ); -- mvd 6->5; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn+ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.cn desc rows between 3 following and floor(ow_sale.qty*ow_sale.vn) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.cn desc rows between 3 following and floor(ow_sale.qty*ow_sale.vn) following ),
win2 as (order by ow_sale.pn desc),
win3 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.cn asc); -- mvd 5,1->4; 5,1->6; 1->7; 9,5,10,2->8; 1->11; 

-- MIN() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between 1 following and unbounded following ); -- mvd 5->4; 

-- MIN() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn-ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc*ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between 0 following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc); -- mvd 2->5; 2->6; 4,3->7; 

-- MIN() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn order by ow_sale.vn desc); -- mvd 1,3->2; 

-- MIN() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt
,
TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.prc,ow_sale.vn,ow_sale.cn order by ow_sale.pn asc,ow_sale.pn desc,ow_sale.cn asc),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 8,9,10,3,2->7; 8,9,10,3,2->11; 9->12; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.prc order by ow_sale.pn asc range unbounded preceding ); -- mvd 3,4,5->2; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc order by ow_sale.cn asc range 1 preceding ); -- mvd 5,6->4; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn-ow_sale.qty)) OVER(partition by ow_sale.qty,ow_sale.dt order by ow_sale.pn asc range floor(ow_sale.pn)::integer preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn*ow_sale.vn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt order by ow_sale.pn asc range floor(ow_sale.pn)::integer preceding ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.pn asc); -- mvd 4,5,1->3; 4,5,1->6; 1->7; 1->8; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn asc range current row ); -- mvd 3,4->2; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(partition by ow_sale.pn order by ow_sale.cn desc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn desc range current row ),
win2 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.dt order by ow_sale.cn desc); -- mvd 1,4->3; 1,4->5; 1,4->6; 1,8,4->7; 1,10,8,4->9; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.pn*ow_sale.prc)::integer preceding ); -- mvd 4,8,3,1->7; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.qty,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.vn asc range between unbounded preceding and 3 preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.vn desc); -- mvd 6,7->5; 1->8; 1->9; 1->10; 12,7,13->11; 1->14; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.dt,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.pn desc range between unbounded preceding and current row ); -- mvd 4,7->6; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.pn order by ow_sale.vn asc range between unbounded preceding and current row ),
win2 as (order by ow_sale.pn asc); -- mvd 4,5,6->3; 6->7; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn*ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.pn asc range between unbounded preceding and floor(ow_sale.pn)::integer following ); -- mvd 1,2->4; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(partition by ow_sale.pn order by ow_sale.cn asc range between unbounded preceding and 2 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn asc range between unbounded preceding and 2 following ); -- mvd 4,2->3; 4,2->5; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn desc range between unbounded preceding and unbounded following ); -- mvd 5,1->4; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.pn desc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.cn order by ow_sale.cn desc); -- mvd 5,6->4; 2,6->7; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn asc range between floor(ow_sale.prc-ow_sale.prc)::integer preceding and 4 preceding ); -- mvd 1,3->2; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.pn order by ow_sale.vn desc range between 3 preceding and current row ); -- mvd 2,8,3->7; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.prc,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc*ow_sale.cn)) OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.cn asc range between floor(ow_sale.cn)::integer preceding and current row ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.prc order by ow_sale.vn asc); -- mvd 1,3,6,7->5; 1,3,6,7->8; 1->9; 1->10; 2,1,3->11; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.vn asc range between 0 preceding and 4 following ); -- mvd 3,4->2; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.prc)) OVER(partition by ow_sale.vn order by ow_sale.cn desc range between floor(ow_sale.pn)::integer preceding and floor(ow_sale.vn/ow_sale.vn)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn desc range between floor(ow_sale.pn)::integer preceding and floor(ow_sale.vn/ow_sale.vn)::integer following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.vn asc); -- mvd 3,4->2; 3,4->5; 4->6; 3,4->7; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.cn desc range between floor(ow_sale.cn)::integer preceding and unbounded following ); -- mvd 3,1,4->2; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.pn+ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn order by ow_sale.cn asc range between 2 preceding and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 1,5,6->4; 5->7; 5->8; 5->9; 1,5,6->10; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.prc,ow_sale.cn order by ow_sale.pn desc range between current row and current row ); -- mvd 7,8,1,9,4->6; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn-ow_sale.pn) as int),cast (floor(ow_sale.prc/ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.pn asc range between current row and current row ),
win2 as (partition by ow_sale.pn order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 1,5->7; 3,5->8; 4->9; 3,5->10; 3,5->11; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.cn desc range between current row and floor(ow_sale.cn)::integer following ); -- mvd 5,3->4; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.prc)) OVER(partition by ow_sale.prc,ow_sale.vn,ow_sale.qty,ow_sale.pn order by ow_sale.pn asc range between current row and floor(ow_sale.pn)::integer following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.qty,ow_sale.pn order by ow_sale.pn asc range between current row and floor(ow_sale.pn)::integer following ),
win2 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.cn desc); -- mvd 1,6,7,2->5; 9,6,7->8; 1,6,7,2->10; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.pn desc range between current row and unbounded following ); -- mvd 6,7->5; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.cn) as int),cast (floor(ow_sale.vn*ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn order by ow_sale.pn desc range between current row and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.vn asc); -- mvd 2,4->3; 4->5; 7->6; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.vn asc range between floor(ow_sale.pn)::integer following and floor(ow_sale.prc)::integer following ); -- mvd 2,7->6; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty-ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.cn desc range between 2 following and floor(ow_sale.vn+ow_sale.prc)::integer following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 4,2->3; 4->5; 

-- MIN() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.cn asc range between floor(ow_sale.vn)::integer following and unbounded following ); -- mvd 3,4,1->2; 

-- MIN() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.vn desc range between 4 following and unbounded following ),
win2 as (order by ow_sale.cn desc); -- mvd 2->4; 1->5; 1->6; 1->7; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.cn desc rows unbounded preceding ); -- mvd 5,6->4; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows floor(ow_sale.vn) preceding ); -- mvd 5,3->4; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc rows 1 preceding ),
win2 as (order by ow_sale.vn desc); -- mvd 3,4,5->2; 4->6; 3,4,5->7; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc,ow_sale.cn asc rows current row ); -- mvd 7,2,1->6; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc,ow_sale.cn asc rows current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty+ow_sale.pn) as int),cast (floor(ow_sale.pn+ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc,ow_sale.cn asc rows current row ),
win2 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn asc); -- mvd 8,9,5->7; 8,9,5->10; 8,9,5->11; 8,2->12; 8,9,5->13; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and 0 preceding ); -- mvd 4,1->3; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc rows between unbounded preceding and floor(ow_sale.cn+ow_sale.pn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc rows between unbounded preceding and floor(ow_sale.cn+ow_sale.pn) preceding ),
win2 as (order by ow_sale.cn desc); -- mvd 3,4->2; 3,4->5; 3,4->6; 1->7; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and current row ); -- mvd 4,5,2,1,6->3; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc,ow_sale.cn desc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.pn desc); -- mvd 4,1,2,5,6->3; 2->7; 6->8; 6->9; 4,1,2,5,6->10; 6->11; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and 6 following ); -- mvd 4,5,1->3; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc,ow_sale.pn asc rows between unbounded preceding and floor(ow_sale.prc) following ),
win2 as (order by ow_sale.cn asc); -- mvd 1,4,5,2->3; 1->6; 1,4,5,2->7; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.cn asc rows between unbounded preceding and unbounded following ); -- mvd 7,8,1,3,9,2->6; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.vn*ow_sale.pn) preceding and floor(ow_sale.pn) preceding ); -- mvd 4,5,6,7,2->3; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn-ow_sale.vn) as int),cast (floor(ow_sale.vn+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.pn/ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between 3 preceding and 0 preceding ),
win2 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.cn asc),
win4 as (order by ow_sale.vn desc); -- mvd 5,6->4; 1->7; 1->8; 10->9; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between 8 preceding and current row ); -- mvd 3,4,5,6->2; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc rows between 4 preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc rows between 4 preceding and current row ),
win2 as (order by ow_sale.cn asc); -- mvd 3,1,4,5->2; 3,1,4,5->6; 3->7; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn desc,ow_sale.pn desc rows between floor(ow_sale.prc) preceding and floor(ow_sale.vn*ow_sale.prc) following ); -- mvd 6,3,7,2->5; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.cn) preceding and floor(ow_sale.vn+ow_sale.cn) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.cn) preceding and floor(ow_sale.vn+ow_sale.cn) following ),
win2 as (order by ow_sale.pn asc); -- mvd 4,5->3; 4,5->6; 5->7; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.cn desc rows between floor(ow_sale.vn-ow_sale.vn) preceding and unbounded following ); -- mvd 4,2,6->5; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.cn) as int),cast (floor(ow_sale.vn*ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc rows between floor(ow_sale.qty+ow_sale.vn) preceding and unbounded following ),
win2 as (order by ow_sale.pn desc),
win3 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn desc); -- mvd 3,4,1->2; 3,4,1->5; 3,4,1->6; 1->7; 3,4->8; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn asc rows between current row and current row ); -- mvd 6,1->5; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between current row and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(partition by ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.prc order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between current row and current row ),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.cn order by ow_sale.vn desc),
win3 as (partition by ow_sale.pn order by ow_sale.cn asc),
win4 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.prc order by ow_sale.cn desc); -- mvd 6,2->5; 3,6,4->7; 6,2->8; 6,2->9; 11,6,3,4,2->10; 11,6,3,4,2->12; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc,ow_sale.cn desc rows between current row and unbounded following ); -- mvd 1,3,4->2; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.pn asc),
win3 as (order by ow_sale.vn asc); -- mvd 4,5,6,7->3; 7->8; 5->9; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows between floor(ow_sale.vn) following and 4 following ); -- mvd 3,4,5->2; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between 2 following and floor(ow_sale.vn/ow_sale.pn) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc+ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between 2 following and floor(ow_sale.vn/ow_sale.pn) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn+ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between 2 following and floor(ow_sale.vn/ow_sale.pn) following ),
win2 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.vn desc),
win3 as (order by ow_sale.pn asc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 5,6,3->4; 5,6,3->7; 6,9,3->8; 5,6,3->10; 3->11; 5->12; 

-- MIN() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.pn desc rows between floor(ow_sale.cn*ow_sale.prc) following and unbounded following ); -- mvd 1,7,2,3->6; 

-- MIN() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(MIN(floor(ow_sale.cn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc rows between 2 following and unbounded following ),
win2 as (order by ow_sale.vn desc); -- mvd 1,3,4->2; 1,3,4->5; 3->6; 

-- STDDEV() function with NULL OVER() clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (); -- mvd 6->6; 

-- STDDEV() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win4),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.pn asc),
win4 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.pn desc); -- mvd 3->3; 3->4; 6->5; 1->7; 9,10,6,1->8; 1->11; 

-- STDDEV() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.pn,ow_sale.prc,ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.cn); -- mvd 2,7->6; 

-- STDDEV() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.qty),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc); -- mvd 5,6,2->4; 6->7; 6,2,9->8; 6,2,9->10; 6->11; 

-- STDDEV() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn desc,ow_sale.pn asc,ow_sale.pn asc); -- mvd 4->3; 

-- STDDEV() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.pn desc,ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.pn+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.pn desc,ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc,ow_sale.vn desc),
win2 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc); -- mvd 2,4->5; 2,4->6; 8,1,3,4->7; 2,4->9; 8,1,3,4->10; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn-ow_sale.prc) as int),cast (floor(ow_sale.vn/ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range unbounded preceding ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.vn desc); -- mvd 3->2; 3->4; 6->5; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn/ow_sale.qty) as int),cast (floor(ow_sale.vn/ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.qty order by ow_sale.ord, ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range 1 preceding ),
win2 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.pn desc); -- mvd 4->6; 3,8->7; 3,8->9; 3,8->10; 3,8->11; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ); -- mvd 6->5; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ),
win2 as (order by ow_sale.pn asc); -- mvd 3->2; 5->4; 5->6; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and 2 preceding ); -- mvd 4->3; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.prc)) OVER(order by ow_sale.pn asc range between unbounded preceding and 3 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn/ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and 3 preceding ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt order by ow_sale.cn asc),
win3 as (order by ow_sale.vn desc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 4->3; 4->5; 7,1,4->6; 2->8; 7->9; 2->10; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and current row ); -- mvd 1->5; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and 1 following ); -- mvd 3->2; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn+ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and 0 following ),
win2 as (partition by ow_sale.qty,ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc),
win3 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.dt,ow_sale.dt order by ow_sale.cn desc),
win4 as (order by ow_sale.ord, ow_sale.cn desc),
win5 as (order by ow_sale.vn asc); -- mvd 3->2; 5,3,1,6->4; 3,8,1,9->7; 3->10; 9->11; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and unbounded following ); -- mvd 5->4; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc); -- mvd 1->4; 6,7,8,1,9->5; 1->10; 6,7,8,1,9->11; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 0 preceding and floor(ow_sale.qty)::integer preceding ); -- mvd 4->3; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.pn+ow_sale.cn)::integer preceding and 0 preceding ),
win2 as (order by ow_sale.vn asc); -- mvd 1->4; 1->5; 1->6; 1->7; 1->8; 1->9; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.vn*ow_sale.vn)::integer preceding and current row ); -- mvd 7->6; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(order by ow_sale.vn desc range between 2 preceding and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 2 preceding and current row ),
win2 as (order by ow_sale.vn asc); -- mvd 2->3; 2->4; 2->5; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 2 preceding and 2 following ),
win2 as (order by ow_sale.cn desc); -- mvd 4->3; 4->5; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.cn)::integer preceding and unbounded following ); -- mvd 1->5; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and current row ); -- mvd 3->6; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn-ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(partition by ow_sale.cn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and current row ),
win2 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc); -- mvd 6->5; 1,6->7; 1,6->8; 1,6->9; 1,6->10; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and floor(ow_sale.prc)::integer following ); -- mvd 3->2; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn+ow_sale.vn)) OVER(order by ow_sale.vn desc range between current row and floor(ow_sale.cn+ow_sale.vn)::integer following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and floor(ow_sale.cn+ow_sale.vn)::integer following ); -- mvd 2->5; 2->6; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between current row and unbounded following ); -- mvd 2->3; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.dt order by ow_sale.vn asc); -- mvd 1->3; 2->4; 6,2,7->5; 2->8; 2->9; 2->10; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 0 following and 0 following ); -- mvd 3->2; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 3 following and floor(ow_sale.vn+ow_sale.qty)::integer following ),
win2 as (order by ow_sale.pn asc); -- mvd 5->4; 1->6; 

-- STDDEV() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.qty/ow_sale.cn)::integer following and unbounded following ); -- mvd 8->7; 

-- STDDEV() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.cn+ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn-ow_sale.qty) as int),cast (floor(ow_sale.pn+ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.cn)::integer following and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 4->3; 4,6,2,1->5; 2->7; 2->8; 4->9; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows unbounded preceding ); -- mvd 5,1->4; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.pn asc rows unbounded preceding ),
win2 as (order by ow_sale.cn asc); -- mvd 3,4->2; 3->5; 3->6; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc rows 4 preceding ); -- mvd 3,4->2; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn*ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.cn asc rows 1 preceding ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.pn asc),
win4 as (partition by ow_sale.vn,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc); -- mvd 2,4->3; 2,4->5; 7->6; 9,10,7,4->8; 7->11; 9,7,4->12; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows current row ); -- mvd 4->3; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.pn asc rows current row ),
win2 as (order by ow_sale.cn desc); -- mvd 7,1,2->6; 7->8; 7,1,2->9; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc,ow_sale.vn asc rows between unbounded preceding and floor(ow_sale.pn) preceding ); -- mvd 4,1->3; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc*ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and 4 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and 4 preceding ),
win2 as (order by ow_sale.vn desc); -- mvd 1->2; 1->3; 1->4; 6->5; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and current row ); -- mvd 5->4; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn*ow_sale.pn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc,ow_sale.vn desc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc); -- mvd 6,1->5; 8,6,1,9,2->7; 6,1->10; 8,6,1,9,2->11; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc rows between unbounded preceding and 4 following ); -- mvd 3,4->2; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and 4 following ),
win2 as (partition by ow_sale.qty order by ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc); -- mvd 3->2; 5,1->4; 5,1->6; 3,1->7; 3,1->8; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc rows between unbounded preceding and unbounded following ); -- mvd 2->4; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc rows between unbounded preceding and unbounded following ); -- mvd 2,5->4; 2,5->6; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.pn-ow_sale.cn) preceding and 4 preceding ); -- mvd 2->5; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn*ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win5),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.vn desc rows between 0 preceding and 3 preceding ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc),
win4 as (order by ow_sale.ord, ow_sale.cn asc),
win5 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.qty order by ow_sale.cn asc); -- mvd 3,4,1->2; 4->5; 4->6; 3->7; 4->8; 3,10,11->9; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc rows between floor(ow_sale.vn-ow_sale.vn) preceding and current row ); -- mvd 5,1->4; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between 2 preceding and current row ),
win2 as (partition by ow_sale.cn,ow_sale.prc order by ow_sale.pn asc),
win3 as (order by ow_sale.cn desc); -- mvd 3->5; 7,8,3->6; 8->9; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.vn asc rows between floor(ow_sale.pn-ow_sale.cn) preceding and floor(ow_sale.vn) following ); -- mvd 3,4->2; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.prc) preceding and 1 following ),
win2 as (order by ow_sale.vn asc); -- mvd 1->5; 1->6; 1->7; 2->8; 2->9; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc rows between 0 preceding and unbounded following ); -- mvd 4->6; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn+ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc,ow_sale.cn asc rows between 4 preceding and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.pn asc); -- mvd 3->2; 1->4; 6,7->5; 3->8; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and current row ); -- mvd 3->7; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn-ow_sale.pn) as int),cast (floor(ow_sale.cn*ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.ord, ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between current row and current row ),
win2 as (order by ow_sale.ord, ow_sale.pn desc),
win3 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc); -- mvd 1->5; 2->6; 8,1,3,9,2->7; 2->10; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and 8 following ); -- mvd 3->2; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and unbounded following ); -- mvd 1->7; 

-- STDDEV() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc); -- mvd 2->4; 3->5; 3,7,2->6; 3->8; 3,7,2->9; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between floor(ow_sale.prc) following and 7 following ); -- mvd 7->6; 

-- STDDEV() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between floor(ow_sale.pn) following and unbounded following ); -- mvd 6,3->5; 

-- STDDEV() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.dt,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.pn order by ow_sale.vn asc,ow_sale.vn asc,ow_sale.cn asc); -- mvd 5,1,6,7->4; 

-- STDDEV() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty
,
TO_CHAR(COALESCE(RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.vn)) OVER(partition by ow_sale.qty,ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.cn order by ow_sale.cn asc,ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.cn order by ow_sale.cn asc,ow_sale.vn desc); -- mvd 4,1,5,2,6->3; 4,1,5,2,6->7; 4,1,5,2,6->8; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.cn asc range unbounded preceding ); -- mvd 1,2,5->4; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(partition by ow_sale.pn order by ow_sale.cn asc range unbounded preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(partition by ow_sale.pn order by ow_sale.cn asc range unbounded preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn asc range unbounded preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc); -- mvd 4,3->5; 4->6; 4,3->7; 4,3->8; 4,3->9; 4,3->10; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.pn order by ow_sale.pn desc range floor(ow_sale.vn)::integer preceding ); -- mvd 3,4,1,5->2; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.vn order by ow_sale.cn asc range 4 preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.cn desc); -- mvd 1,2->5; 1->6; 1->7; 1->8; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.cn desc range current row ); -- mvd 3,4,5->2; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn desc range current row ),
win2 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.cn asc); -- mvd 3,4->2; 3,6->5; 3,6->7; 3->8; 3->9; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.prc,ow_sale.vn order by ow_sale.pn asc range between unbounded preceding and floor(ow_sale.cn)::integer preceding ); -- mvd 6,7,1,8->5; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.pn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.vn asc range between unbounded preceding and 4 preceding ),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.vn asc),
win4 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.prc,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc); -- mvd 4,5,1,6->3; 5->7; 1->8; 10,5,4,1,6->9; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn desc range between unbounded preceding and current row ); -- mvd 2,6->5; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.cn)::integer following ),
win2 as (order by ow_sale.cn asc); -- mvd 5,6->4; 5->7; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.dt order by ow_sale.pn desc range between unbounded preceding and unbounded following ); -- mvd 4,7,2->6; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.cn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.cn order by ow_sale.vn desc),
win3 as (order by ow_sale.pn asc); -- mvd 7,8->6; 8,10->9; 7,8->11; 3->12; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.pn asc range between floor(ow_sale.vn+ow_sale.cn)::integer preceding and 0 preceding ); -- mvd 1,6->5; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.vn order by ow_sale.vn desc range between 1 preceding and floor(ow_sale.prc+ow_sale.vn)::integer preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.vn desc range between 1 preceding and floor(ow_sale.prc+ow_sale.vn)::integer preceding ); -- mvd 2->4; 2->5; 2->6; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.pn order by ow_sale.vn asc range between floor(ow_sale.cn-ow_sale.cn)::integer preceding and current row ); -- mvd 8,5,2,3->7; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(partition by ow_sale.prc order by ow_sale.cn asc range between floor(ow_sale.cn)::integer preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.cn asc range between floor(ow_sale.cn)::integer preceding and current row ),
win2 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.cn desc); -- mvd 3,4->2; 3,4->5; 3,4->6; 3,4->7; 4,9,1->8; 4,9,1->10; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn desc range between 4 preceding and floor(ow_sale.vn*ow_sale.cn)::integer following ); -- mvd 3,4->2; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.prc order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.prc order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(partition by ow_sale.vn,ow_sale.dt order by ow_sale.pn desc range between 0 preceding and 3 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.pn desc range between 0 preceding and 3 following ),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.prc order by ow_sale.cn asc),
win3 as (order by ow_sale.vn desc); -- mvd 6,7,8->5; 10,1,7->9; 10,1,7->11; 10,1,7->12; 7->13; 6,7,8->14; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.vn desc range between 1 preceding and unbounded following ); -- mvd 2,1,4,5->3; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.pn order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.pn order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.cn)) OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.cn asc range between 3 preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.cn asc range between 3 preceding and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.pn order by ow_sale.pn desc); -- mvd 6,1,7,2->5; 6,4,2->8; 6,4,2->9; 6,4,2->10; 6,4,2->11; 6,1,7,2->12; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.pn order by ow_sale.pn desc range between current row and current row ); -- mvd 3,4,5,1->2; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn+ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.pn,ow_sale.vn order by ow_sale.cn asc range between current row and current row ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,1,4,5->2; 3->6; 1->7; 3->8; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.cn asc range between current row and 1 following ); -- mvd 5,6,3->4; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.vn desc range between current row and floor(ow_sale.pn)::integer following ),
win2 as (order by ow_sale.vn asc); -- mvd 3,1->4; 1->5; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.dt,ow_sale.dt order by ow_sale.vn desc range between current row and unbounded following ); -- mvd 5,3,6->4; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.prc order by ow_sale.cn desc range between current row and unbounded following ); -- mvd 1,3,4->2; 1,3,4->5; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn order by ow_sale.pn asc range between 0 following and floor(ow_sale.vn+ow_sale.qty)::integer following ); -- mvd 1,3,4->2; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.vn asc range between floor(ow_sale.vn)::integer following and floor(ow_sale.qty)::integer following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 6,7,1->5; 2->8; 2->9; 7->10; 2->11; 

-- STDDEV() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.vn desc range between floor(ow_sale.vn)::integer following and unbounded following ); -- mvd 4,5->3; 

-- STDDEV() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.qty,ow_sale.cn order by ow_sale.cn desc range between 1 following and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 4,5,2->3; 4->6; 1->7; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows unbounded preceding ); -- mvd 4,5,6->3; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows unbounded preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.dt,ow_sale.prc,ow_sale.pn order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.cn)) OVER(partition by ow_sale.cn,ow_sale.dt,ow_sale.prc,ow_sale.pn order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.prc)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows unbounded preceding ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc,ow_sale.pn order by ow_sale.vn desc); -- mvd 2,4,5,1,6->3; 2,4,5,1,6->7; 2,5,4,1,9->8; 2,5,4,1,9->10; 2,5,4,1,9->11; 2,5,4,1,9->12; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows floor(ow_sale.pn) preceding ); -- mvd 3,4->2; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(partition by ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc rows 4 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.pn)) OVER(partition by ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc rows 4 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc rows 4 preceding ),
win2 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.pn desc),
win3 as (partition by ow_sale.dt order by ow_sale.vn desc); -- mvd 4,2,1,3,7->6; 4,2,1,3,7->8; 2,5,7->9; 4,2,1,3,7->10; 5,3->11; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc rows current row ); -- mvd 1,4,5->7; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn-ow_sale.pn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc rows current row ),
win2 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 6,7,1->5; 1->8; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn desc,ow_sale.vn desc rows between unbounded preceding and 2 preceding ); -- mvd 1,5,3,2->6; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and current row ); -- mvd 3,5->4; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.cn desc),
win4 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.pn asc),
win5 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn asc); -- mvd 5,6,3->4; 2,1,3->7; 5->8; 10,5,1,6,3->9; 2,1,3->11; 5,10->12; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and 6 following ); -- mvd 7,1,2,5->6; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.prc order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc,ow_sale.cn asc rows between unbounded preceding and 1 following ),
win2 as (partition by ow_sale.prc order by ow_sale.vn desc); -- mvd 1,4,2->3; 6,4->5; 6,4->7; 6,4->8; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn desc,ow_sale.pn desc rows between unbounded preceding and unbounded following ); -- mvd 3,1->2; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.cn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn asc,ow_sale.cn asc rows between unbounded preceding and unbounded following ); -- mvd 6,2,1,4->5; 6,2,1,4->7; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between 2 preceding and 9 preceding ); -- mvd 1,4,2->3; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.vn*ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.cn asc rows between 4 preceding and floor(ow_sale.qty) preceding ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.pn desc),
win3 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,4->2; 6,1,4->5; 1,4->7; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between floor(ow_sale.qty/ow_sale.qty) preceding and current row ); -- mvd 5,2,3->4; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.prc,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between 1 preceding and floor(ow_sale.prc+ow_sale.vn) following ); -- mvd 2,6,7->5; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows between 2 preceding and 4 following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.prc order by ow_sale.cn desc),
win4 as (order by ow_sale.cn asc); -- mvd 1,4,5,6,7->3; 5->8; 10,1,5->9; 1->11; 5->12; 1->13; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.vn desc rows between floor(ow_sale.pn) preceding and unbounded following ); -- mvd 1,3,4,5,6->2; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.cn)) OVER(partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.pn desc rows between 1 preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.pn order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.pn desc rows between 1 preceding and unbounded following ),
win2 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.pn order by ow_sale.cn asc),
win3 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.prc,ow_sale.cn order by ow_sale.vn asc); -- mvd 3,4,5->2; 7,3,4,5->6; 3,4,5->8; 7,3,4,5->9; 7,3,11,4,5->10; 7,3,11,4,5->12; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between current row and current row ); -- mvd 1,6->5; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between current row and current row ),
win2 as (order by ow_sale.pn asc); -- mvd 4,5,2,1->3; 4,5,2,1->6; 1->7; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc rows between current row and floor(ow_sale.qty+ow_sale.pn) following ); -- mvd 4,5,1->3; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows between current row and unbounded following ); -- mvd 3,4,5->2; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.cn desc rows between current row and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.vn desc),
win3 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn asc),
win4 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.pn asc); -- mvd 2,4,5->3; 4,1,5->6; 2,5->7; 9,10,4,5->8; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc rows between 3 following and floor(ow_sale.qty) following ); -- mvd 5,1,6->4; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc rows between floor(ow_sale.cn) following and floor(ow_sale.cn) following ),
win2 as (order by ow_sale.vn asc); -- mvd 4,5->3; 5->6; 5->7; 5->8; 

-- STDDEV() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn desc rows between 3 following and unbounded following ); -- mvd 3,1->2; 

-- STDDEV() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.prc)) OVER(partition by ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.vn desc rows between floor(ow_sale.cn/ow_sale.pn) following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn-ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn/ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.prc)) OVER(partition by ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.vn desc rows between floor(ow_sale.cn/ow_sale.pn) following and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.vn desc rows between floor(ow_sale.cn/ow_sale.pn) following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc); -- mvd 6,7,4->5; 6,7,4->8; 7->9; 7->10; 3,6,2,7,4->11; 6,7,4->12; 

-- STDDEV_POP() function with NULL OVER() clause --

SELECT ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (); -- mvd 3->3; 

-- STDDEV_POP() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.dt); -- mvd 3,1,6->5; 

-- STDDEV_POP() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.dt),
win2 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.vn desc); -- mvd 8,4,3,1->7; 8,4,3,1->9; 6,3,1->10; 6,3,1->11; 

-- STDDEV_POP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc*ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc); -- mvd 2->7; 

-- STDDEV_POP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn+ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc),
win2 as (partition by ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc); -- mvd 1->7; 1->8; 1->9; 3,1->10; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range unbounded preceding ); -- mvd 2->6; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc+ow_sale.vn)) OVER(order by ow_sale.vn asc range unbounded preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn*ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range unbounded preceding ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc),
win4 as (order by ow_sale.cn desc); -- mvd 3->2; 5->4; 3->6; 8,3,9->7; 5->10; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range 1 preceding ); -- mvd 2->5; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.pn) as int),cast (floor(ow_sale.vn+ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn*ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range 1 preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.vn asc),
win4 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 4->3; 4->5; 1->6; 4->7; 1->8; 1->9; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range current row ); -- mvd 8->7; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ),
win2 as (order by ow_sale.cn asc); -- mvd 6->5; 6->7; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and 0 preceding ); -- mvd 5->4; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.cn)::integer preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty+ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.cn)::integer preceding ),
win2 as (partition by ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc); -- mvd 4->3; 4->5; 4,7,1->6; 9,4,1->8; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and current row ); -- mvd 4->3; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and 2 following ); -- mvd 4->3; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.cn)) OVER(order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.qty)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(partition by ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.prc order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.qty)::integer following ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.dt order by ow_sale.cn desc),
win3 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.prc order by ow_sale.vn desc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 4->3; 4->5; 4,7,8->6; 1,4,2,8->9; 1,4,2,8->10; 4->11; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and unbounded following ); -- mvd 6->5; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(order by ow_sale.vn desc range between unbounded preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn-ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc); -- mvd 4->5; 4->6; 8,3,9->7; 8,3,9->10; 8,3,9->11; 8,3,9->12; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 2 preceding and floor(ow_sale.qty*ow_sale.cn)::integer preceding ); -- mvd 5->4; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc/ow_sale.cn) as int),cast (floor(ow_sale.pn+ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.vn)::integer preceding and 2 preceding ),
win2 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.dt,ow_sale.cn order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.vn desc),
win4 as (order by ow_sale.ord, ow_sale.vn asc),
win5 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn asc); -- mvd 3->2; 5,6,7,3->4; 3->8; 3->9; 6,1->10; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn/ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between 3 preceding and current row ); -- mvd 1->3; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn+ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between floor(ow_sale.pn-ow_sale.vn)::integer preceding and current row ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc); -- mvd 3->2; 3->4; 3->5; 3->6; 8,9->7; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.qty)) OVER(order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 3 preceding and 4 following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.cn asc); -- mvd 4->3; 4->5; 7->6; 7->8; 7->9; 11,7,4,2->10; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 1 preceding and unbounded following ); -- mvd 4->3; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc-ow_sale.qty)) OVER(order by ow_sale.cn asc range between floor(ow_sale.vn)::integer preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.vn)::integer preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.cn desc),
win3 as (order by ow_sale.vn asc); -- mvd 1->3; 5,1,6,2->4; 6->7; 1->8; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and current row ); -- mvd 6->5; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(order by ow_sale.cn asc range between current row and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(order by ow_sale.cn asc range between current row and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and current row ); -- mvd 4->6; 4->7; 4->8; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn+ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and 0 following ); -- mvd 2->4; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and unbounded following ); -- mvd 3->2; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (order by ow_sale.cn desc); -- mvd 3->5; 7->6; 9->8; 7->10; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 1 following and 0 following ); -- mvd 3->2; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 1 following and 3 following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.qty order by ow_sale.pn desc); -- mvd 4->3; 4->5; 7,4,1->6; 

-- STDDEV_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.pn/ow_sale.qty)::integer following and unbounded following ); -- mvd 3->2; 

-- STDDEV_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 2 following and unbounded following ),
win2 as (order by ow_sale.vn asc); -- mvd 2->4; 1->5; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows unbounded preceding ); -- mvd 5->4; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows unbounded preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.cn desc); -- mvd 4,5->3; 4->6; 4->7; 4->8; 4->9; 4->10; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.cn desc rows 8 preceding ); -- mvd 2,5->4; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn*ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc*ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows floor(ow_sale.cn+ow_sale.prc) preceding ),
win2 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 2->5; 2->6; 2->7; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn desc rows current row ); -- mvd 4,2->3; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.cn asc rows current row ),
win2 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.pn desc); -- mvd 1,2->4; 6,2,7->5; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows between unbounded preceding and floor(ow_sale.cn*ow_sale.qty) preceding ); -- mvd 4,5->3; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn+ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between unbounded preceding and 4 preceding ),
win2 as (order by ow_sale.ord, ow_sale.pn desc),
win3 as (order by ow_sale.pn asc); -- mvd 3->2; 5->4; 5->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.vn desc rows between unbounded preceding and current row ); -- mvd 2,3->5; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn-ow_sale.pn) as int),cast (floor(ow_sale.cn*ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn desc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc); -- mvd 3,4->2; 3->5; 7,8,9,3,4->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and floor(ow_sale.pn+ow_sale.qty) following ); -- mvd 6->5; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc,ow_sale.cn asc rows between unbounded preceding and 1 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc,ow_sale.cn asc rows between unbounded preceding and 1 following ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.pn desc); -- mvd 3,1->2; 1->4; 3,6,1->5; 1->7; 1->8; 3,1->9; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and unbounded following ); -- mvd 7->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc,ow_sale.pn asc rows between 2 preceding and 5 preceding ); -- mvd 3,1->2; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc,ow_sale.pn desc rows between 3 preceding and 1 preceding ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.cn desc),
win3 as (partition by ow_sale.prc,ow_sale.qty order by ow_sale.vn asc),
win4 as (order by ow_sale.cn asc); -- mvd 3,4->2; 3,4->5; 7,1,3,4->6; 9,3,10->8; 1->11; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.vn desc rows between 5 preceding and current row ); -- mvd 1,5->4; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.pn desc rows between floor(ow_sale.qty+ow_sale.cn) preceding and current row ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.pn order by ow_sale.pn desc),
win4 as (partition by ow_sale.prc order by ow_sale.cn desc); -- mvd 5,6->4; 3->7; 9,1,6->8; 3->10; 12,5->11; 5,6->13; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between floor(ow_sale.vn/ow_sale.pn) preceding and floor(ow_sale.pn) following ); -- mvd 5->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.prc,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc,ow_sale.pn desc rows between floor(ow_sale.qty) preceding and 2 following ),
win2 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.prc order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 6->5; 2,4,6->7; 4->8; 6->9; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between 7 preceding and unbounded following ); -- mvd 2->5; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc,ow_sale.cn desc rows between 3 preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc,ow_sale.cn desc rows between 3 preceding and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.qty order by ow_sale.cn asc); -- mvd 1,3,4->2; 1,6,4->5; 1,3,4->7; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc,ow_sale.cn asc rows between current row and current row ); -- mvd 2,6->5; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.cn asc rows between current row and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and current row ),
win2 as (order by ow_sale.vn asc); -- mvd 4->3; 4->5; 4->6; 4->7; 4->8; 10->9; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and floor(ow_sale.qty+ow_sale.prc) following ); -- mvd 4->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn*ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc,ow_sale.cn desc rows between current row and floor(ow_sale.vn*ow_sale.vn) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc,ow_sale.cn desc rows between current row and floor(ow_sale.vn*ow_sale.vn) following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc,ow_sale.cn desc rows between current row and floor(ow_sale.vn*ow_sale.vn) following ),
win2 as (partition by ow_sale.qty,ow_sale.qty,ow_sale.dt order by ow_sale.vn asc); -- mvd 2,6,7->5; 2,6,7->8; 3,6,10->9; 2,6,7->11; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and unbounded following ); -- mvd 1->3; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ),
win2 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.qty,ow_sale.qty order by ow_sale.vn asc); -- mvd 3->5; 1,2,4->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between floor(ow_sale.vn*ow_sale.prc) following and 5 following ); -- mvd 2->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc*ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between floor(ow_sale.prc) following and 1 following ); -- mvd 6->7; 6->8; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between floor(ow_sale.cn) following and unbounded following ); -- mvd 7->6; 

-- STDDEV_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between floor(ow_sale.cn) following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 4->5; 7->6; 

-- STDDEV_POP() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.dt order by ow_sale.cn desc,ow_sale.pn asc,ow_sale.cn asc); -- mvd 6,1,8->7; 

-- STDDEV_POP() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn/ow_sale.qty)) OVER(partition by ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn asc); -- mvd 3,4,1->2; 3,4,1->5; 3,4,1->6; 3,4,1->7; 3,4,1->8; 3,4,1->9; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.cn desc range unbounded preceding ); -- mvd 8->7; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.cn asc range unbounded preceding ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.pn asc),
win3 as (order by ow_sale.pn asc),
win4 as (order by ow_sale.pn desc); -- mvd 1,4,5->3; 7,5,8->6; 8->9; 8->10; 8->11; 7,5,8->12; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.prc,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.vn asc range floor(ow_sale.cn)::integer preceding ); -- mvd 3,2,8,9->7; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn*ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc/ow_sale.vn)) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc order by ow_sale.vn desc range floor(ow_sale.prc)::integer preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 8,9,1->7; 11->10; 11->12; 11->13; 11->14; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.vn asc range current row ); -- mvd 5,6,2->4; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.qty,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.dt order by ow_sale.vn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.vn)) OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.dt order by ow_sale.vn asc range current row ),
win2 as (order by ow_sale.cn desc); -- mvd 6,3,7->5; 6,3,7->8; 6->9; 6->10; 6->11; 6,3,7->12; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.qty)::integer preceding ),
win2 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 4,5,6->3; 4,5,6->7; 6->8; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.pn asc range between unbounded preceding and current row ); -- mvd 2,6->5; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.pn asc range between unbounded preceding and current row ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.prc,ow_sale.cn order by ow_sale.pn desc),
win4 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.pn order by ow_sale.vn asc); -- mvd 5,3->4; 7,5,3->6; 5,3->8; 10,7,3->9; 5,3->11; 10,5,13,3->12; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.dt order by ow_sale.pn desc range between unbounded preceding and floor(ow_sale.pn+ow_sale.vn)::integer following ); -- mvd 3,4,5->2; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.vn asc range between unbounded preceding and floor(ow_sale.qty)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.vn asc range between unbounded preceding and floor(ow_sale.qty)::integer following ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.pn asc); -- mvd 2,5,3->4; 2,5,3->6; 8->7; 8->9; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.vn desc range between unbounded preceding and unbounded following ); -- mvd 6,7->5; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.cn)) OVER(partition by ow_sale.dt,ow_sale.cn order by ow_sale.vn asc range between unbounded preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.vn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.pn order by ow_sale.vn asc); -- mvd 5,6,1->4; 1,8->7; 5,6,1->9; 5,6,1->10; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.pn desc range between 4 preceding and floor(ow_sale.qty+ow_sale.cn)::integer preceding ); -- mvd 8->7; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.pn asc range between 4 preceding and current row ); -- mvd 3,4->2; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.prc,ow_sale.prc,ow_sale.qty order by ow_sale.pn desc range between floor(ow_sale.qty+ow_sale.pn)::integer preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.qty)) OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.prc,ow_sale.prc,ow_sale.qty order by ow_sale.pn desc range between floor(ow_sale.qty+ow_sale.pn)::integer preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.prc,ow_sale.prc,ow_sale.qty order by ow_sale.pn desc range between floor(ow_sale.qty+ow_sale.pn)::integer preceding and current row ),
win2 as (order by ow_sale.vn asc); -- mvd 3,4,5,6,7->2; 3,4,5,6,7->8; 3,4,5,6,7->9; 6->10; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn+ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn*ow_sale.qty)) OVER(order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn+ow_sale.cn) as int),cast (floor(ow_sale.vn/ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.cn desc range between floor(ow_sale.vn+ow_sale.cn)::integer preceding and floor(ow_sale.cn+ow_sale.vn)::integer following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc); -- mvd 4,1,5,2->3; 4->6; 4->7; 4->8; 10,4,11,5->9; 4->12; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.pn order by ow_sale.cn desc range between floor(ow_sale.qty*ow_sale.qty)::integer preceding and unbounded following ); -- mvd 5,6,7->4; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(partition by ow_sale.cn order by ow_sale.vn desc range between floor(ow_sale.prc*ow_sale.vn)::integer preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.vn desc range between floor(ow_sale.prc*ow_sale.vn)::integer preceding and unbounded following ),
win2 as (order by ow_sale.vn asc); -- mvd 5,1->4; 1->6; 5,1->7; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.pn desc range between current row and current row ); -- mvd 4,2->5; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.dt order by ow_sale.pn asc range between current row and current row ),
win2 as (partition by ow_sale.cn,ow_sale.qty order by ow_sale.pn desc); -- mvd 3,1->2; 5,6,1->4; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.pn asc range between current row and 2 following ); -- mvd 8,3,2,1->7; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(partition by ow_sale.dt,ow_sale.pn order by ow_sale.vn asc range between current row and floor(ow_sale.pn)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.vn asc range between current row and floor(ow_sale.pn)::integer following ),
win2 as (order by ow_sale.vn asc); -- mvd 3,4,5->2; 3,4,5->6; 4->7; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn desc range between current row and unbounded following ); -- mvd 4,5->3; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn-ow_sale.cn) as int),cast (floor(ow_sale.pn/ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.vn asc range between current row and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.prc order by ow_sale.cn desc),
win3 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn desc); -- mvd 5->4; 7,8,5,2->6; 8,1->9; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.prc order by ow_sale.cn asc range between floor(ow_sale.prc)::integer following and 0 following ); -- mvd 1,3,4,5->2; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.cn asc range between floor(ow_sale.prc)::integer following and floor(ow_sale.pn-ow_sale.vn)::integer following ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc); -- mvd 7,1->6; 2,7,4->8; 

-- STDDEV_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.pn asc range between 1 following and unbounded following ); -- mvd 1,8,3,9->7; 

-- STDDEV_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.prc)) OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn+ow_sale.prc)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.vn asc range between 2 following and unbounded following ),
win2 as (order by ow_sale.pn desc); -- mvd 4->3; 1->5; 1->6; 1->7; 1->8; 1->9; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc rows unbounded preceding ); -- mvd 1,8,2,3->7; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.dt,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows unbounded preceding ),
win2 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn desc),
win3 as (order by ow_sale.cn asc); -- mvd 6,7,8->5; 1,8->9; 6->10; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc rows 6 preceding ); -- mvd 3,4->2; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows 4 preceding ),
win2 as (partition by ow_sale.pn order by ow_sale.vn desc),
win3 as (order by ow_sale.vn desc); -- mvd 1,3,4->2; 6,4->5; 6,4->7; 6,4->8; 6,4->9; 6->10; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows current row ); -- mvd 3->2; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows current row ),
win2 as (partition by ow_sale.pn order by ow_sale.cn asc),
win3 as (partition by ow_sale.pn order by ow_sale.cn desc),
win4 as (order by ow_sale.cn asc); -- mvd 2,3,1->5; 4,1->6; 4,1->7; 4,1->8; 4,1->9; 4->10; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(partition by ow_sale.qty,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.vn) preceding ),
win2 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc); -- mvd 1,7,8,5->6; 8,2,5->9; 8,2,5->10; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ); -- mvd 1,8,3->7; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(partition by ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc); -- mvd 4,2,5,1->3; 4,2,5,1->6; 4,2,5,1->7; 9->8; 4,2,9,5,1->10; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.prc,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and floor(ow_sale.vn) following ); -- mvd 8,6,2->7; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc rows between unbounded preceding and 0 following ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.vn desc); -- mvd 8,9,2->7; 2->10; 9->11; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn asc,ow_sale.pn asc rows between unbounded preceding and unbounded following ); -- mvd 5,6,7,3->4; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.pn desc); -- mvd 3,5->4; 3,5->6; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between floor(ow_sale.prc+ow_sale.vn) preceding and 6 preceding ); -- mvd 4,1->3; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn/ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.prc) preceding and 0 preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 3,4,5->2; 1->6; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc,ow_sale.pn asc rows between 3 preceding and current row ); -- mvd 4,1,5,2->3; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc/ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.cn desc rows between floor(ow_sale.prc) preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc),
win3 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc); -- mvd 4,5,6,1->3; 5,8,2->7; 5,2->9; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.prc+ow_sale.cn) preceding and floor(ow_sale.vn) following ); -- mvd 6,7->5; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.vn) as int),cast (floor(ow_sale.vn-ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.cn order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc rows between 2 preceding and floor(ow_sale.pn/ow_sale.pn) following ),
win2 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.vn asc),
win3 as (partition by ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc); -- mvd 4,5,6,2->3; 5,6->7; 5,1->8; 5,6->9; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(partition by ow_sale.prc,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.prc) preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.prc) preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.qty,ow_sale.prc,ow_sale.cn order by ow_sale.cn asc),
win3 as (partition by ow_sale.pn,ow_sale.cn order by ow_sale.vn asc); -- mvd 5,6,7->4; 5,6,7->8; 5,6,1->9; 6,7,2->10; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc rows between current row and current row ); -- mvd 3,4,5,6,7->2; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between current row and 5 following ); -- mvd 3,4->2; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc rows between current row and floor(ow_sale.pn) following ),
win2 as (partition by ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc); -- mvd 6,2,1->5; 8,6,9->7; 8,6,9->10; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.prc order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc,ow_sale.pn asc rows between current row and unbounded following ); -- mvd 2,1,6->5; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn-ow_sale.prc) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.vn desc rows between current row and unbounded following ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc),
win4 as (order by ow_sale.vn asc); -- mvd 4,2,1,5,6->3; 6->7; 4,2,5,9->8; 4,2,1,5,6->10; 5->11; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc rows between 6 following and 7 following ); -- mvd 1,3,4->2; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.qty)) OVER(partition by ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.cn,ow_sale.cn order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows between floor(ow_sale.cn) following and floor(ow_sale.pn/ow_sale.qty) following ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.cn,ow_sale.cn order by ow_sale.vn asc),
win3 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.vn asc),
win4 as (order by ow_sale.cn desc); -- mvd 1,4,5->3; 7,1,8,4,2->6; 7,1,8,4,2->9; 7,1,8,4->10; 1->11; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.cn asc rows between 1 following and unbounded following ); -- mvd 2,1->4; 

-- STDDEV_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_POP(floor(ow_sale.vn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.prc) following and unbounded following ),
win2 as (partition by ow_sale.cn order by ow_sale.cn asc),
win3 as (partition by ow_sale.prc,ow_sale.qty order by ow_sale.pn asc); -- mvd 1,4,5,2->3; 1->6; 1,4,5,2->7; 9,10,2->8; 

-- STDDEV_SAMP() function with NULL OVER() clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (); -- mvd 2->2; 

-- STDDEV_SAMP() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.vn); -- mvd 4,5,6->3; 

-- STDDEV_SAMP() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.cn,ow_sale.cn),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.cn desc); -- mvd 6,2->5; 8->7; 8->9; 6->10; 

-- STDDEV_SAMP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc,ow_sale.cn desc); -- mvd 4,5->3; 

-- STDDEV_SAMP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
,
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc); -- mvd 3->2; 3->4; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range unbounded preceding ); -- mvd 1->4; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn+ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty/ow_sale.cn)) OVER(partition by ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range unbounded preceding ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc),
win4 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.vn desc); -- mvd 1->3; 5->4; 7,5,8,9->6; 7,5,8,9->10; 1,7,5->11; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range 2 preceding ); -- mvd 3->6; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range 3 preceding ); -- mvd 3->6; 3->7; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range current row ); -- mvd 2->5; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range current row ); -- mvd 7->6; 7->8; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and 2 preceding ); -- mvd 1->6; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.prc,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.cn order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and floor(ow_sale.cn)::integer preceding ),
win2 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.cn order by ow_sale.vn desc); -- mvd 2->6; 3,8,2,4->7; 3,8,2,4->9; 3,8,2,4->10; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and current row ); -- mvd 3->2; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn+ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and 2 following ); -- mvd 1->2; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.vn+ow_sale.pn)::integer following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc); -- mvd 6->5; 6->7; 6,9->8; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and unbounded following ); -- mvd 3->7; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn+ow_sale.pn) as int),cast (floor(ow_sale.pn+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.pn asc); -- mvd 2->4; 6,7->5; 6,7->8; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 4 preceding and 3 preceding ); -- mvd 4->7; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.qty)) OVER(order by ow_sale.cn asc range between 1 preceding and 3 preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 1 preceding and 3 preceding ),
win2 as (order by ow_sale.pn asc); -- mvd 4->5; 4->6; 1->7; 4->8; 1->9; 4->10; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn/ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between 1 preceding and current row ); -- mvd 1->5; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.cn+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 3 preceding and current row ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc); -- mvd 3->6; 1->7; 1->8; 10,3,11,1,2->9; 1->12; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.qty)::integer preceding and 2 following ); -- mvd 5->4; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc*ow_sale.cn)) OVER(order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.qty)) OVER(order by ow_sale.cn desc range between 0 preceding and floor(ow_sale.qty)::integer following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 0 preceding and floor(ow_sale.qty)::integer following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc),
win4 as (order by ow_sale.vn desc); -- mvd 1->7; 1->8; 1->9; 1->10; 2->11; 1->12; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 4 preceding and unbounded following ); -- mvd 4->3; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.qty+ow_sale.cn)::integer preceding and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 6->5; 2->7; 2->8; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and current row ); -- mvd 1->6; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and 1 following ); -- mvd 5->4; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(order by ow_sale.vn desc range between current row and floor(ow_sale.cn)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc-ow_sale.vn)) OVER(order by ow_sale.vn desc range between current row and floor(ow_sale.cn)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and floor(ow_sale.cn)::integer following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.pn asc); -- mvd 3->2; 3->4; 3->5; 3,7->6; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.cn,ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and unbounded following ); -- mvd 8->7; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.cn)) OVER(order by ow_sale.cn desc range between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt order by ow_sale.vn asc),
win3 as (order by ow_sale.cn asc); -- mvd 6->5; 6->7; 6->8; 10,11,4->9; 6->12; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.vn)::integer following and 2 following ); -- mvd 3->2; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.pn)::integer following and unbounded following ); -- mvd 5->4; 

-- STDDEV_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.prc)::integer following and unbounded following ),
win2 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.qty order by ow_sale.vn asc); -- mvd 1->4; 6,7,2,1->5; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc,ow_sale.cn asc rows unbounded preceding ); -- mvd 6,2->5; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty+ow_sale.vn) as int),cast (floor(ow_sale.prc/ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.qty)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc rows unbounded preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc rows unbounded preceding ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 5->4; 5->6; 8->7; 8->9; 5->10; 5->11; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.prc+ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc,ow_sale.vn asc rows floor(ow_sale.qty) preceding ),
win2 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc),
win3 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc),
win4 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc); -- mvd 1,3->2; 1,5,3,6->4; 1,8,6->7; 1,5,3,6->9; 11,1,8,6->10; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc rows current row ); -- mvd 3,6->5; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows current row ),
win2 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.vn desc); -- mvd 8->7; 1,10,4,11,8->9; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and 5 preceding ); -- mvd 5->7; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and current row ); -- mvd 3->2; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 2->5; 2->6; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.vn asc rows between unbounded preceding and 3 following ); -- mvd 6,3->5; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.qty,ow_sale.qty,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn/ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn*ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and floor(ow_sale.qty/ow_sale.qty) following ),
win2 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt order by ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc),
win4 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc); -- mvd 1->7; 1->8; 6,2->9; 1,2->10; 12,1,2->11; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and unbounded following ); -- mvd 4->3; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn/ow_sale.vn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 3,1->2; 3->4; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn desc rows between floor(ow_sale.vn) preceding and 0 preceding ); -- mvd 4,2->3; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows between 4 preceding and 2 preceding ); -- mvd 1->7; 1->8; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.prc,ow_sale.cn order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn+ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between 4 preceding and current row ),
win2 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.prc,ow_sale.cn order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 4->5; 7,2,3->6; 7,2,3->8; 7,2,3->9; 2->10; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc,ow_sale.cn desc rows between 1 preceding and floor(ow_sale.vn+ow_sale.cn) following ); -- mvd 4,1->3; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn asc,ow_sale.vn asc rows between floor(ow_sale.vn+ow_sale.qty) preceding and 4 following ),
win2 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn asc); -- mvd 1,3->2; 5,6->4; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between floor(ow_sale.pn) preceding and unbounded following ); -- mvd 2->5; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.vn+ow_sale.qty) preceding and unbounded following ); -- mvd 5->4; 5->6; 5->7; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between current row and current row ); -- mvd 2->4; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and current row ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.vn desc),
win4 as (order by ow_sale.pn desc); -- mvd 4->3; 1->5; 1->6; 1->7; 4->8; 1->9; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc,ow_sale.cn asc rows between current row and 1 following ); -- mvd 3,1->2; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between current row and floor(ow_sale.pn) following ),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.pn order by ow_sale.pn asc); -- mvd 4->3; 1,6,2,4->5; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ); -- mvd 4->5; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.prc) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 6,1->5; 6,1->7; 6,1->8; 1->9; 1->10; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between floor(ow_sale.vn) following and 0 following ),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.vn desc); -- mvd 5->4; 5->6; 5->7; 9->8; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows between floor(ow_sale.prc) following and unbounded following ); -- mvd 8,1->7; 

-- STDDEV_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.dt,ow_sale.prc,ow_sale.qty,ow_sale.dt order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty/ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc,ow_sale.cn desc rows between 3 following and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.qty,ow_sale.dt order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 3->2; 5,3,6,1->4; 5,3,6,1->7; 5,3,6,1->8; 10->9; 

-- STDDEV_SAMP() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.pn desc,ow_sale.pn desc); -- mvd 1,3,4->2; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.prc,ow_sale.pn,ow_sale.pn order by ow_sale.vn desc range unbounded preceding ); -- mvd 1,8,9,3->7; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.qty,ow_sale.dt order by ow_sale.vn asc range floor(ow_sale.vn/ow_sale.cn)::integer preceding ); -- mvd 4,5,6,1->3; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.dt,ow_sale.qty,ow_sale.dt order by ow_sale.cn asc range floor(ow_sale.pn)::integer preceding ),
win2 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.pn asc); -- mvd 6,7,1,2->5; 7,9->8; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn asc range current row ); -- mvd 1,6->5; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn asc range current row ),
win2 as (order by ow_sale.vn desc); -- mvd 5,6->4; 2->7; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.pn asc range between unbounded preceding and 2 preceding ); -- mvd 5,6->4; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.cn order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.prc)::integer preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.cn order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.prc)::integer preceding ); -- mvd 1,4,2,5->3; 1,4,2,5->6; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.qty order by ow_sale.pn desc range between unbounded preceding and current row ); -- mvd 1,4,5,2->3; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.cn order by ow_sale.cn desc range between unbounded preceding and 0 following ); -- mvd 4,1,5,6->3; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt order by ow_sale.vn desc range between unbounded preceding and floor(ow_sale.pn)::integer following ),
win2 as (order by ow_sale.pn asc); -- mvd 3,1,4->2; 4->5; 3,1,4->6; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.vn order by ow_sale.pn asc range between unbounded preceding and unbounded following ); -- mvd 3,4,5,6->2; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.cn order by ow_sale.cn desc range between unbounded preceding and unbounded following ); -- mvd 5,2->4; 5,2->6; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.pn desc range between 3 preceding and 3 preceding ); -- mvd 4->3; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.prc,ow_sale.prc,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty+ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.vn order by ow_sale.pn asc range between 2 preceding and floor(ow_sale.cn)::integer preceding ),
win2 as (order by ow_sale.ord, ow_sale.vn asc),
win3 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.qty order by ow_sale.vn desc); -- mvd 7,4,8->6; 4->9; 11,1,4,8->10; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.dt order by ow_sale.cn asc range between 1 preceding and current row ); -- mvd 6,2,7->5; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(partition by ow_sale.dt,ow_sale.vn,ow_sale.prc order by ow_sale.cn desc range between 3 preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn/ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.prc order by ow_sale.cn desc range between 3 preceding and current row ),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,4,5,6->2; 3,4,5,6->7; 4->8; 6->9; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.vn desc range between floor(ow_sale.pn+ow_sale.vn)::integer preceding and floor(ow_sale.cn)::integer following ); -- mvd 8,1,2->7; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty+ow_sale.prc) as int),cast (floor(ow_sale.prc/ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.qty,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.pn desc range between 3 preceding and floor(ow_sale.pn*ow_sale.cn)::integer following ),
win2 as (partition by ow_sale.qty,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc); -- mvd 1,5->4; 7,3->6; 7,3->8; 7,3->9; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.vn desc range between floor(ow_sale.vn)::integer preceding and unbounded following ); -- mvd 6,3->5; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.qty,ow_sale.pn order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty/ow_sale.cn)) OVER(partition by ow_sale.dt order by ow_sale.cn desc range between 1 preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn+ow_sale.pn) as int),cast (floor(ow_sale.pn-ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn desc range between 1 preceding and unbounded following ),
win2 as (partition by ow_sale.qty,ow_sale.pn order by ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 1,4->3; 2,6,7->5; 2,6,7->8; 1,4->9; 1->10; 1->11; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.vn desc range between current row and current row ); -- mvd 8,6,3->7; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.qty)) OVER(partition by ow_sale.prc,ow_sale.dt order by ow_sale.pn desc range between current row and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.vn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt order by ow_sale.pn desc range between current row and current row ),
win2 as (order by ow_sale.cn asc); -- mvd 4,5,1->3; 2->6; 4,5,1->7; 4,5,1->8; 2->9; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.vn asc range between current row and floor(ow_sale.prc)::integer following ); -- mvd 4,1,5->3; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.vn order by ow_sale.cn asc range between current row and 2 following ),
win2 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.pn desc); -- mvd 4,5,6->3; 4,5,6->7; 6,9->8; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn desc range between current row and unbounded following ); -- mvd 3,1->2; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn*ow_sale.vn)) OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.prc order by ow_sale.vn asc range between current row and unbounded following ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.pn desc); -- mvd 4,5,6->3; 6->7; 9->8; 6->10; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.cn desc range between 2 following and floor(ow_sale.qty)::integer following ); -- mvd 6,7->5; 

-- STDDEV_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.pn desc range between 4 following and unbounded following ); -- mvd 4->3; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.pn asc rows unbounded preceding ); -- mvd 7,5,1,2->6; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc rows unbounded preceding ),
win2 as (order by ow_sale.cn asc); -- mvd 3,4,1->2; 4->5; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc*ow_sale.cn)) OVER(partition by ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows floor(ow_sale.qty/ow_sale.vn) preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows floor(ow_sale.qty/ow_sale.vn) preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 1,8,4,3,9->7; 1->10; 1,8,4,3,9->11; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.prc,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc rows current row ); -- mvd 4,1,5,6,2->3; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.qty)) OVER(partition by ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc rows current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc rows current row ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.prc order by ow_sale.vn desc),
win3 as (order by ow_sale.vn desc); -- mvd 6,2,3,7->5; 6,2,3,7->8; 6,2,3,7->9; 11,2,6,3,7->10; 3->12; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc rows between unbounded preceding and floor(ow_sale.vn) preceding ); -- mvd 3,4,1,5,6->2; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.qty)) OVER(partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.vn*ow_sale.vn) preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.vn*ow_sale.vn) preceding ); -- mvd 8,1->7; 8,1->9; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and current row ); -- mvd 1,4->3; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn/ow_sale.qty)) OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.prc order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.prc order by ow_sale.vn desc); -- mvd 5,3,1,6->4; 8,1->7; 5,3,1,6->9; 5,3,1,6->10; 8,1->11; 8,1->12; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and floor(ow_sale.vn) following ); -- mvd 4,1,5->3; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between unbounded preceding and unbounded following ); -- mvd 5,1->4; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn order by ow_sale.pn desc); -- mvd 4,1,2->3; 1,6->5; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.pn+ow_sale.vn) preceding and 4 preceding ); -- mvd 3,8,6->7; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.pn asc rows between floor(ow_sale.qty) preceding and floor(ow_sale.pn) preceding ),
win2 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn asc),
win3 as (order by ow_sale.cn desc); -- mvd 5->4; 3,7->6; 5->8; 3->9; 3,7->10; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between floor(ow_sale.qty) preceding and current row ); -- mvd 3,1,4->2; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.prc order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between floor(ow_sale.pn/ow_sale.vn) preceding and floor(ow_sale.vn+ow_sale.qty) following ); -- mvd 4,5,6,1,7->3; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.dt,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc rows between floor(ow_sale.qty*ow_sale.prc) preceding and floor(ow_sale.prc) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc rows between floor(ow_sale.qty*ow_sale.prc) preceding and floor(ow_sale.prc) following ),
win2 as (partition by ow_sale.qty order by ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,5->6; 2,1->7; 3,5->8; 2->9; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc rows between 8 preceding and unbounded following ); -- mvd 4,6,7,2->5; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.vn)) OVER(partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows between 2 preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows between 2 preceding and unbounded following ); -- mvd 6,3->5; 6,3->7; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows between current row and current row ); -- mvd 1,4,6,7->5; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between current row and current row ),
win2 as (order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.cn desc),
win4 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.vn asc); -- mvd 5,6,3,2->4; 2->7; 5->8; 6,10,2->9; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc rows between current row and 4 following ); -- mvd 2,6,4->5; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.vn+ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.pn,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows between current row and 1 following ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc); -- mvd 4,5,1->3; 4,5,1->6; 8->7; 5,1,10,11->9; 5,1,10,11->12; 4,5,1->13; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc rows between current row and unbounded following ); -- mvd 1,5,6->4; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc),
win4 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc); -- mvd 3,5,6,7->4; 5->8; 5->9; 3,5,6,7->10; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.cn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.prc)) OVER(partition by ow_sale.qty,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.pn) following and floor(ow_sale.pn+ow_sale.qty) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(partition by ow_sale.qty,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.pn) following and floor(ow_sale.pn+ow_sale.qty) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.pn) following and floor(ow_sale.pn+ow_sale.qty) following ); -- mvd 6,7,8->5; 6,7,8->9; 6,7,8->10; 6,7,8->11; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between 9 following and unbounded following ); -- mvd 4,5,1->3; 

-- STDDEV_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(STDDEV_SAMP(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc rows between floor(ow_sale.pn*ow_sale.cn) following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 2,3->5; 4->6; 2,3->7; 

-- SUM() function with NULL OVER() clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (); -- mvd 2->2; 

-- SUM() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn+ow_sale.vn)) OVER(),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (),
win2 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.prc order by ow_sale.pn desc),
win3 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.pn desc),
win4 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn order by ow_sale.vn asc); -- mvd 3->3; 2,5,6,7,1,8->4; 3->9; 7,8->10; 3->11; 5,6,1,8->12; 

-- SUM() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.vn); -- mvd 3,4->2; 

-- SUM() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc),
win2 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn asc); -- mvd 3->2; 1,5->4; 3->6; 1,5->7; 

-- SUM() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc,ow_sale.vn asc,ow_sale.cn asc); -- mvd 1,3,4->2; 

-- SUM() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.cn desc,ow_sale.vn desc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.cn desc,ow_sale.vn desc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.cn desc,ow_sale.vn desc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(order by ow_sale.cn desc,ow_sale.vn desc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.cn desc,ow_sale.vn desc,ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc,ow_sale.vn desc,ow_sale.pn desc); -- mvd 1,3,4->2; 1,3,4->5; 1,3,4->6; 1,3,4->7; 1,3,4->8; 1,3,4->9; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn*ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range unbounded preceding ); -- mvd 3->5; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.pn)) OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range unbounded preceding ),
win2 as (order by ow_sale.cn desc); -- mvd 3->4; 6->5; 6->7; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range 2 preceding ); -- mvd 3->2; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn+ow_sale.vn) as int),cast (floor(ow_sale.qty*ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range 2 preceding ),
win2 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 3->2; 5->4; 5->6; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ); -- mvd 4->3; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.cn)::integer preceding ); -- mvd 6->5; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.vn,ow_sale.vn order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and 2 preceding ),
win2 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.vn desc); -- mvd 2->5; 3->6; 3->7; 3->8; 3->9; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and current row ); -- mvd 6->5; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.prc-ow_sale.prc)::integer following ); -- mvd 5->4; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn*ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty/ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and 4 following ),
win2 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 7->6; 1,7->8; 2->9; 1,7->10; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and unbounded following ); -- mvd 4->3; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.pn desc); -- mvd 3->2; 5->4; 5->6; 5->7; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 2 preceding and floor(ow_sale.qty)::integer preceding ); -- mvd 4->3; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 3 preceding and floor(ow_sale.qty)::integer preceding ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.pn desc),
win3 as (partition by ow_sale.vn order by ow_sale.vn desc); -- mvd 2->3; 5,6->4; 5->7; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.cn+ow_sale.cn)::integer preceding and current row ); -- mvd 3->2; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 1 preceding and current row ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.prc,ow_sale.prc order by ow_sale.pn asc); -- mvd 7->6; 7->8; 10,3,7,2->9; 10,3,7,2->11; 10,3,13,2->12; 10,3,7,2->14; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.vn)::integer preceding and 4 following ); -- mvd 5->4; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 3 preceding and unbounded following ); -- mvd 1->2; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and current row ); -- mvd 4->5; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and current row ),
win2 as (order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 3->2; 5->4; 5->6; 5->7; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and 4 following ); -- mvd 4->5; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.prc)) OVER(order by ow_sale.cn desc range between current row and floor(ow_sale.prc*ow_sale.prc)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and floor(ow_sale.prc*ow_sale.prc)::integer following ); -- mvd 2->3; 2->4; 2->5; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and unbounded following ); -- mvd 4->5; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.pn/ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn+ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and unbounded following ),
win2 as (partition by ow_sale.qty order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.vn desc),
win4 as (order by ow_sale.cn desc); -- mvd 3->2; 3,5->4; 7->6; 3,5->8; 3->9; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 0 following and 4 following ); -- mvd 3->6; 

-- SUM() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.pn)) OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between 4 following and floor(ow_sale.pn)::integer following ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.cn asc); -- mvd 3->6; 3->7; 5->8; 1->9; 5->10; 

-- SUM() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.qty*ow_sale.cn)::integer following and unbounded following ); -- mvd 4->3; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc,ow_sale.pn desc rows unbounded preceding ); -- mvd 3,4->6; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.cn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc rows unbounded preceding ),
win2 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.vn order by ow_sale.cn desc); -- mvd 1,4->3; 1,6,4->5; 1,6,4->7; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows floor(ow_sale.qty) preceding ); -- mvd 6->5; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn asc rows 1 preceding ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc); -- mvd 1,3->5; 1,3->6; 1,3->7; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc,ow_sale.cn desc rows current row ); -- mvd 4,5->3; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.prc+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows current row ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 6->5; 6,4,8->7; 8->9; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between unbounded preceding and floor(ow_sale.qty) preceding ); -- mvd 2->3; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc,ow_sale.cn asc rows between unbounded preceding and floor(ow_sale.pn-ow_sale.pn) preceding ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.dt order by ow_sale.cn desc); -- mvd 3,5->4; 2,3,7,1->6; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and current row ); -- mvd 3->2; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty/ow_sale.pn) as int),cast (floor(ow_sale.prc+ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.vn desc); -- mvd 3->2; 3->4; 3->5; 7->6; 9,3->8; 3->10; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between unbounded preceding and floor(ow_sale.qty) following ); -- mvd 4->3; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn desc,ow_sale.pn desc rows between unbounded preceding and 4 following ),
win2 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.vn,ow_sale.pn order by ow_sale.vn asc),
win3 as (order by ow_sale.vn asc),
win4 as (order by ow_sale.cn desc); -- mvd 3,6->5; 8,3,6->7; 3->9; 2->10; 3,6->11; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.vn desc); -- mvd 4->3; 4->5; 7->6; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between 2 preceding and floor(ow_sale.pn-ow_sale.vn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between 2 preceding and floor(ow_sale.pn-ow_sale.vn) preceding ),
win2 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 3,1->2; 3,1->4; 6,3,1->5; 8->7; 8->9; 8->10; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows between 9 preceding and current row ); -- mvd 3,6->5; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc rows between floor(ow_sale.cn) preceding and current row ); -- mvd 3,1->2; 3,1->4; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn-ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.vn+ow_sale.qty) preceding and floor(ow_sale.qty) following ); -- mvd 4->5; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.cn asc rows between 9 preceding and unbounded following ); -- mvd 6,4->5; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between 3 preceding and unbounded following ),
win2 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.cn asc),
win4 as (partition by ow_sale.prc,ow_sale.dt order by ow_sale.pn asc); -- mvd 4,6->5; 2,4,3,8->7; 4->9; 4,6->10; 1,2,8->11; 1,2,8->12; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and current row ); -- mvd 5->4; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc rows between current row and current row ),
win2 as (order by ow_sale.cn asc); -- mvd 1->4; 6->5; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between current row and floor(ow_sale.vn/ow_sale.cn) following ); -- mvd 5->4; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between current row and 0 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between current row and 0 following ); -- mvd 1,3->2; 1,3->4; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and unbounded following ); -- mvd 4->3; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn asc rows between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.cn order by ow_sale.pn desc); -- mvd 4,5->3; 4,5->6; 8->7; 8->9; 1,4,5->10; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.pn asc rows between 3 following and floor(ow_sale.cn-ow_sale.cn) following ); -- mvd 1->4; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between 3 following and floor(ow_sale.qty+ow_sale.qty) following ),
win2 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.dt,ow_sale.vn order by ow_sale.pn asc); -- mvd 4->3; 6,1,7,8->5; 4->9; 

-- SUM() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between 3 following and unbounded following ); -- mvd 3->4; 

-- SUM() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty-ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.vn*ow_sale.qty) following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.pn desc),
win3 as (order by ow_sale.pn desc); -- mvd 4->3; 4->5; 7->6; 7->8; 

-- SUM() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.pn,ow_sale.qty,ow_sale.qty,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.qty order by ow_sale.pn desc,ow_sale.cn asc); -- mvd 7,8,2,9,1->6; 

-- SUM() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.vn order by ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(partition by ow_sale.vn order by ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.vn order by ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn desc); -- mvd 3,5,6->4; 3,5,6->7; 3,5,6->8; 3,5,6->9; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.cn desc range unbounded preceding ); -- mvd 3,5,6->4; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.pn desc range floor(ow_sale.cn+ow_sale.vn)::integer preceding ); -- mvd 3,1->2; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.qty) as int),cast (floor(ow_sale.prc+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn+ow_sale.pn) as int),cast (floor(ow_sale.vn+ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn/ow_sale.vn)) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.prc order by ow_sale.cn desc range floor(ow_sale.qty)::integer preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc); -- mvd 6,7,8->5; 7->9; 6,7,11->10; 6,7,11->12; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.pn asc range current row ); -- mvd 4,3->6; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.cn desc range current row ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc),
win3 as (partition by ow_sale.qty order by ow_sale.vn asc); -- mvd 6,1,7->5; 1,7->8; 4,2->9; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn asc range between unbounded preceding and 2 preceding ); -- mvd 3,2->4; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn+ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.prc) as int),cast (floor(ow_sale.pn*ow_sale.qty) as int),NULL) OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.pn desc range between unbounded preceding and 1 preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc),
win4 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc),
win5 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,1,5->4; 3->6; 3,8,5->7; 10,3,1,5->9; 3->11; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn order by ow_sale.vn desc range between unbounded preceding and current row ); -- mvd 4,5,6->3; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn+ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.vn,ow_sale.qty,ow_sale.dt,ow_sale.cn order by ow_sale.cn asc range between unbounded preceding and current row ),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc); -- mvd 2,4,1,5,6->3; 1,6,8->7; 4,6->9; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.vn order by ow_sale.pn asc range between unbounded preceding and floor(ow_sale.cn)::integer following ); -- mvd 1,6,7,8,2->5; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn*ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn/ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn*ow_sale.vn)) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.pn desc range between unbounded preceding and 1 following ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 4,1->3; 4->5; 1->6; 1->7; 1->8; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.prc order by ow_sale.cn asc range between unbounded preceding and unbounded following ); -- mvd 4,5,2,6->3; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.pn,ow_sale.qty,ow_sale.dt order by ow_sale.vn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.cn asc); -- mvd 8,3,9,2,1,4->7; 3,9,4->10; 3,9,4->11; 8,3,9,2,1,4->12; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.vn asc range between floor(ow_sale.prc/ow_sale.pn)::integer preceding and 3 preceding ); -- mvd 6,1->5; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.cn desc range between 0 preceding and 0 preceding ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.prc order by ow_sale.pn desc); -- mvd 4,5->3; 4,5->6; 8,1,5->7; 8,1,5->9; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.cn order by ow_sale.cn desc range between floor(ow_sale.prc/ow_sale.vn)::integer preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.cn order by ow_sale.cn desc range between floor(ow_sale.prc/ow_sale.vn)::integer preceding and current row ),
win2 as (order by ow_sale.pn asc); -- mvd 3,1->7; 3,1->8; 5->9; 5->10; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.dt order by ow_sale.vn asc range between floor(ow_sale.vn*ow_sale.cn)::integer preceding and floor(ow_sale.pn)::integer following ); -- mvd 4,5,6->3; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.vn)) OVER(partition by ow_sale.dt,ow_sale.cn order by ow_sale.cn desc range between floor(ow_sale.prc+ow_sale.qty)::integer preceding and floor(ow_sale.cn*ow_sale.vn)::integer following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.cn desc range between floor(ow_sale.prc+ow_sale.qty)::integer preceding and floor(ow_sale.cn*ow_sale.vn)::integer following ); -- mvd 4,5->3; 4,5->6; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.vn order by ow_sale.cn desc range between 3 preceding and unbounded following ); -- mvd 5,1,6->4; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.qty)) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.pn asc range between floor(ow_sale.vn)::integer preceding and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.prc,ow_sale.qty order by ow_sale.vn asc),
win3 as (partition by ow_sale.vn,ow_sale.prc order by ow_sale.vn desc),
win4 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.cn asc); -- mvd 1,5,6->4; 2,8,9,6->7; 2,9->10; 2,8,9,6->11; 2,9->12; 1,5,6->13; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.vn,ow_sale.qty order by ow_sale.pn desc range between current row and current row ); -- mvd 4,5,1,2->3; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc order by ow_sale.vn asc range between current row and floor(ow_sale.prc)::integer following ); -- mvd 5,1->7; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(partition by ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.cn asc range between current row and floor(ow_sale.prc/ow_sale.pn)::integer following ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.cn desc); -- mvd 3,1,7,4->6; 2->8; 2->9; 11,3,1,2,4->10; 11,3,1,2,4->12; 2->13; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.vn asc range between current row and unbounded following ); -- mvd 3,4->2; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty*ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.pn asc range between current row and unbounded following ),
win2 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,4,5->2; 7,4->6; 

-- SUM() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.vn asc range between floor(ow_sale.cn)::integer following and floor(ow_sale.qty)::integer following ); -- mvd 3,4->2; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.pn desc range between floor(ow_sale.cn+ow_sale.cn)::integer following and 0 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(partition by ow_sale.pn order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(partition by ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.pn desc range between floor(ow_sale.cn+ow_sale.cn)::integer following and 0 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.pn desc range between floor(ow_sale.cn+ow_sale.cn)::integer following and 0 following ),
win2 as (partition by ow_sale.pn order by ow_sale.cn asc); -- mvd 4,2,5->3; 4,2,5->6; 2,5->7; 2,5->8; 4,2,5->9; 

-- SUM() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn/ow_sale.vn)) OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.pn order by ow_sale.cn desc range between 1 following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.qty)) OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.pn order by ow_sale.cn desc range between 1 following and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.cn desc); -- mvd 4,5,6,7->3; 4->8; 4->9; 4,5,6,7->10; 4->11; 4->12; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc rows unbounded preceding ); -- mvd 3,6,7,1,8->5; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc rows unbounded preceding ),
win2 as (order by ow_sale.vn asc); -- mvd 2,7,8,3->6; 8->9; 8->10; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.cn asc rows floor(ow_sale.qty) preceding ); -- mvd 2,1->3; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows current row ); -- mvd 3,4,5,6->2; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc rows current row ); -- mvd 7,2,4,3->6; 7,2,4,3->8; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.vn desc rows between unbounded preceding and 7 preceding ); -- mvd 7,1->6; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.pn,ow_sale.vn order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.cn desc rows between unbounded preceding and 2 preceding ),
win2 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.cn desc); -- mvd 5,1,6,7->4; 1,2,7->8; 1,2,7->9; 1,2,7->10; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and current row ); -- mvd 3,1,4->2; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.vn order by ow_sale.cn asc); -- mvd 4,5,6->3; 8,1,5->7; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.pn*ow_sale.prc) following ); -- mvd 4,2,5->3; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc,ow_sale.pn desc rows between unbounded preceding and unbounded following ); -- mvd 2,4->3; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc/ow_sale.qty)) OVER(partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.pn desc rows between unbounded preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.prc)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.pn desc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.qty order by ow_sale.pn asc),
win3 as (partition by ow_sale.qty order by ow_sale.pn desc); -- mvd 2,5,1,6->4; 2,1,6->7; 2,5,1,6->8; 2,1,6->9; 1,6->10; 2,1,6->11; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between floor(ow_sale.cn) preceding and floor(ow_sale.qty) preceding ); -- mvd 2,4,1->3; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty+ow_sale.cn) as int),cast (floor(ow_sale.vn+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.cn asc rows between 1 preceding and floor(ow_sale.qty) preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.vn desc); -- mvd 3,4,1->2; 3->5; 4->6; 3->7; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows between floor(ow_sale.pn*ow_sale.pn) preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty+ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows between floor(ow_sale.pn*ow_sale.pn) preceding and current row ),
win2 as (partition by ow_sale.vn order by ow_sale.pn desc),
win3 as (order by ow_sale.vn asc),
win4 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc); -- mvd 3,1,2,4->5; 1,4->6; 1->7; 1->8; 3,1,2,4->9; 3,1,4->10; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between floor(ow_sale.qty*ow_sale.cn) preceding and 5 following ); -- mvd 8,2,1->7; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(SUM(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between floor(ow_sale.cn+ow_sale.cn) preceding and 4 following ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.vn desc); -- mvd 4,5->3; 5->6; 5->7; 5->8; 5->9; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc rows between 5 preceding and unbounded following ); -- mvd 3,1->4; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.qty)) OVER(partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc,ow_sale.vn asc rows between 0 preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc,ow_sale.vn asc rows between 0 preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.dt order by ow_sale.cn desc),
win3 as (order by ow_sale.vn asc),
win4 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.pn order by ow_sale.vn asc); -- mvd 3->2; 5,1->4; 5,1->6; 3->7; 3->8; 10,5,3,11->9; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between current row and current row ); -- mvd 5,2,6,7->4; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.qty,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn desc rows between current row and floor(ow_sale.pn/ow_sale.vn) following ); -- mvd 7,3,8->6; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows between current row and 3 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(partition by ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows between current row and 3 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows between current row and 3 following ),
win2 as (order by ow_sale.pn desc); -- mvd 3,4,5->2; 3,4,5->6; 5->7; 3,4,5->8; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.pn desc rows between current row and unbounded following ); -- mvd 2->3; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn+ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn-ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between current row and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.pn order by ow_sale.cn desc),
win4 as (order by ow_sale.pn desc),
win5 as (order by ow_sale.pn asc); -- mvd 5,6,7->4; 5,6,7->8; 5,1->9; 5,1->10; 1->11; 1->12; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(SUM(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc rows between floor(ow_sale.qty) following and 7 following ); -- mvd 5,1,2->4; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(SUM(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(partition by ow_sale.qty,ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc rows between 0 following and floor(ow_sale.pn) following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc rows between 0 following and floor(ow_sale.pn) following ); -- mvd 4,5,6,7->3; 4,5,6,7->8; 

-- SUM() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.pn asc rows between 8 following and unbounded following ); -- mvd 3,5,6,7->4; 

-- SUM() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(SUM(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn/ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc rows between floor(ow_sale.vn) following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc rows between floor(ow_sale.vn) following and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.pn order by ow_sale.cn desc),
win3 as (partition by ow_sale.qty order by ow_sale.pn asc),
win4 as (order by ow_sale.cn desc); -- mvd 4,5,6->3; 4,5,6->7; 2,6->8; 1,6->9; 2->10; 

-- VAR_POP() function with NULL OVER() clause --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (); -- mvd 6->6; 

-- VAR_POP() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn*ow_sale.vn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (),
win2 as (order by ow_sale.pn desc); -- mvd 4->4; 6->5; 6->7; 6->8; 

-- VAR_POP() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.vn); -- mvd 5,1,6,3->4; 

-- VAR_POP() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.dt),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.qty)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.dt),
win2 as (partition by ow_sale.qty,ow_sale.vn order by ow_sale.pn desc),
win3 as (order by ow_sale.cn asc),
win4 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.vn order by ow_sale.cn asc); -- mvd 7,2,1,4->6; 7,2,1,4->8; 1,10,4->9; 2->11; 1,10,4->12; 2,1,10,4->13; 

-- VAR_POP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc); -- mvd 4->3; 

-- VAR_POP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.cn)) OVER(order by ow_sale.vn asc,ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc,ow_sale.vn asc); -- mvd 6->5; 6->7; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range unbounded preceding ); -- mvd 1->6; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn*ow_sale.vn)) OVER(order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range unbounded preceding ),
win2 as (order by ow_sale.pn desc); -- mvd 3->2; 5->4; 5->6; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range floor(ow_sale.vn*ow_sale.pn)::integer preceding ),
win2 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.pn asc),
win3 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.vn order by ow_sale.vn asc); -- mvd 2->4; 3,6->5; 8,2,1->7; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range current row ); -- mvd 1->4; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range current row ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (order by ow_sale.vn asc); -- mvd 1->5; 1->6; 1->7; 1->8; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and 4 preceding ); -- mvd 4->3; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.vn-ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.qty)::integer preceding ),
win2 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc); -- mvd 6->5; 6,3,2->7; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and current row ); -- mvd 3->2; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.prc order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.prc order by ow_sale.pn desc); -- mvd 3->2; 5,6,3,1->4; 5,6,3,1->7; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and 0 following ); -- mvd 5->4; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.pn)::integer following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn+ow_sale.pn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.pn)::integer following ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.prc,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.cn asc),
win4 as (order by ow_sale.cn asc),
win5 as (order by ow_sale.vn desc); -- mvd 1->3; 1->4; 6,1,7,2->5; 1->8; 1->9; 7->10; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and unbounded following ); -- mvd 3->6; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.vn order by ow_sale.cn asc); -- mvd 3->2; 3,5->4; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.qty*ow_sale.cn)::integer preceding and current row ); -- mvd 4->3; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.cn)::integer preceding and current row ),
win2 as (order by ow_sale.pn desc); -- mvd 8->7; 8->9; 8->10; 8->11; 8->12; 2->13; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 2 preceding and floor(ow_sale.pn)::integer following ); -- mvd 4->7; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.vn/ow_sale.pn)::integer preceding and unbounded following ); -- mvd 5->4; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.cn order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.cn+ow_sale.pn)::integer preceding and unbounded following ),
win2 as (partition by ow_sale.cn order by ow_sale.vn asc); -- mvd 4->5; 4->6; 3,8->7; 3,8->9; 3,8->10; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and current row ); -- mvd 1->2; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and current row ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.cn desc); -- mvd 3->2; 5->4; 1->6; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and floor(ow_sale.qty)::integer following ); -- mvd 6->5; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn/ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and 4 following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 1->2; 1->3; 1->4; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and unbounded following ); -- mvd 7->6; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and unbounded following ),
win2 as (order by ow_sale.cn desc); -- mvd 5->4; 5->6; 5->7; 

-- VAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.vn)::integer following and 2 following ); -- mvd 5->4; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 3 following and floor(ow_sale.vn*ow_sale.cn)::integer following ),
win2 as (order by ow_sale.pn desc); -- mvd 2->5; 2->6; 1->7; 

-- VAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.qty)::integer following and unbounded following ),
win2 as (order by ow_sale.vn asc); -- mvd 5->4; 2->6; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc,ow_sale.vn desc rows unbounded preceding ); -- mvd 2,5,1->4; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn*ow_sale.vn) as int),cast (floor(ow_sale.qty+ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows unbounded preceding ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.cn desc),
win4 as (partition by ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc); -- mvd 1->5; 3,7,1->6; 3,9,7->8; 3,9,7->10; 12,3,9->11; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows 1 preceding ); -- mvd 6->5; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.pn asc rows 2 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn/ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.pn asc rows 2 preceding ),
win2 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.pn asc),
win3 as (order by ow_sale.cn desc),
win4 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 1,3->2; 5,6,3->4; 1,3->7; 1->8; 6->9; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows current row ); -- mvd 1->3; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty*ow_sale.pn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows current row ),
win2 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.prc order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 6->5; 8,4,1->7; 8,4,1->9; 1->10; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.cn asc rows between unbounded preceding and 6 preceding ); -- mvd 3,4,5->2; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.vn asc rows between unbounded preceding and current row ); -- mvd 6,7->5; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn*ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.prc,ow_sale.prc,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn asc,ow_sale.cn desc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.cn asc),
win3 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc); -- mvd 2,4,5->3; 2,7,1,4,5->6; 2,7,1,4,5->8; 10,7,2,4->9; 10,7,2,4->11; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.pn asc rows between unbounded preceding and 3 following ); -- mvd 3,2,1->5; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.vn-ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.qty,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty/ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc,ow_sale.cn desc rows between unbounded preceding and 4 following ),
win2 as (partition by ow_sale.qty,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 3->2; 5,3,6->4; 5,3,6->7; 9->8; 5,3,6->10; 9->11; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and unbounded following ); -- mvd 6->5; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc,ow_sale.cn desc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.cn desc); -- mvd 8,1->7; 8,2->9; 8,2->10; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.vn asc rows between 5 preceding and 4 preceding ); -- mvd 1,5,2->4; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc,ow_sale.vn asc rows between floor(ow_sale.pn) preceding and 3 preceding ),
win2 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.prc order by ow_sale.cn asc); -- mvd 7,3,8->6; 4,7,10,3->9; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between 6 preceding and current row ); -- mvd 4->3; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc rows between 8 preceding and 3 following ); -- mvd 6,1->5; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.dt order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc,ow_sale.vn asc rows between floor(ow_sale.cn) preceding and 1 following ),
win2 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.pn asc); -- mvd 5,1,6->4; 5,1,6->7; 3,1,6->8; 3,1,6->9; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.pn desc rows between floor(ow_sale.pn+ow_sale.pn) preceding and unbounded following ); -- mvd 6,3->5; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between current row and current row ); -- mvd 4->3; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between current row and current row ),
win2 as (partition by ow_sale.vn,ow_sale.prc order by ow_sale.cn desc); -- mvd 6->5; 4,6,3->7; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and floor(ow_sale.cn-ow_sale.cn) following ); -- mvd 5->4; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc-ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.vn asc rows between current row and 0 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and 0 following ); -- mvd 6->5; 6->7; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc,ow_sale.vn desc rows between current row and unbounded following ); -- mvd 4,1->3; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.pn desc),
win3 as (order by ow_sale.cn asc); -- mvd 3,6->5; 3,6->7; 6->8; 6->9; 3->10; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between 4 following and floor(ow_sale.cn+ow_sale.cn) following ); -- mvd 5->4; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn-ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.cn) following and 0 following ),
win2 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.vn asc),
win3 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc),
win4 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.cn desc); -- mvd 2->4; 6,2->5; 2->7; 3,6->8; 10,1,6->9; 

-- VAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc,ow_sale.cn asc rows between floor(ow_sale.qty) following and unbounded following ); -- mvd 1->6; 

-- VAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn*ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between 1 following and unbounded following ),
win2 as (order by ow_sale.pn desc); -- mvd 3->2; 3->4; 3->5; 3->6; 3->7; 3->8; 

-- VAR_POP() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.pn asc,ow_sale.vn desc,ow_sale.cn asc); -- mvd 7,2,4->6; 

-- VAR_POP() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
,
TO_CHAR(COALESCE(CUME_DIST() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.qty order by ow_sale.pn desc,ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.pn desc,ow_sale.vn desc); -- mvd 2,1,6->5; 2,1,6->7; 2,1,6->8; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.cn asc range unbounded preceding ); -- mvd 1,4,3->5; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.dt order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.dt order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.pn asc range unbounded preceding ),
win2 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.prc,ow_sale.dt order by ow_sale.pn asc); -- mvd 2,7,4,5->6; 2,7,9,1,5->8; 2,7,4,5->10; 2,7,9,1,5->11; 2,7,9,1,5->12; 2,7,9,1,5->13; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.prc,ow_sale.cn order by ow_sale.vn desc range 2 preceding ); -- mvd 4,5,2,6,7->3; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.pn order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.cn desc range 1 preceding ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.pn order by ow_sale.cn desc); -- mvd 1,3,5->4; 7->6; 1,5->8; 1,5->9; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn asc range current row ); -- mvd 3,4->2; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.dt order by ow_sale.pn asc range current row ),
win2 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.vn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,1,4,5,6->2; 1,3,4,5,6->7; 1,3,4,5,6->8; 3->9; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.cn)::integer preceding ); -- mvd 8,9->7; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.cn)::integer preceding ),
win2 as (order by ow_sale.vn desc); -- mvd 1,4,2,5->3; 2->6; 2->7; 2->8; 2->9; 2->10; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.vn desc range between unbounded preceding and current row ); -- mvd 5->4; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(partition by ow_sale.qty,ow_sale.pn,ow_sale.pn order by ow_sale.vn asc range between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn-ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc+ow_sale.vn) as int),cast (floor(ow_sale.vn-ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.pn order by ow_sale.vn asc range between unbounded preceding and current row ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.prc order by ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.pn desc),
win5 as (order by ow_sale.cn desc); -- mvd 3,4,1->2; 3,4,1->5; 7->6; 9,7,1->8; 1->10; 7->11; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.dt order by ow_sale.pn asc range between unbounded preceding and 4 following ); -- mvd 4,5,2->3; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.pn order by ow_sale.vn desc range between unbounded preceding and floor(ow_sale.cn*ow_sale.vn)::integer following ); -- mvd 2,4,5->3; 2,4,5->6; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.vn asc range between unbounded preceding and unbounded following ); -- mvd 4,5,1,6,2,7->3; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.prc,ow_sale.cn order by ow_sale.pn asc range between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.vn asc); -- mvd 7,8,5,9,1->6; 9->10; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.dt,ow_sale.vn,ow_sale.prc,ow_sale.dt order by ow_sale.vn asc range between 2 preceding and 0 preceding ); -- mvd 5,6,1,7->4; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.prc,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn order by ow_sale.pn desc range between 4 preceding and 3 preceding ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.vn order by ow_sale.cn asc); -- mvd 6,1,4->5; 6,1,4->7; 6,1,4->8; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.vn desc range between floor(ow_sale.pn+ow_sale.pn)::integer preceding and current row ); -- mvd 3,4->2; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.qty,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn/ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.cn asc range between 0 preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.prc,ow_sale.vn order by ow_sale.cn desc),
win3 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc); -- mvd 8,2,9->7; 3,8,5,1,2,9->10; 3,8,5,1,2,9->11; 8,2,9->12; 5,9->13; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.pn,ow_sale.prc,ow_sale.pn order by ow_sale.cn desc range between 0 preceding and floor(ow_sale.vn)::integer following ); -- mvd 1,3,4,5,6->2; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.pn asc range between 2 preceding and unbounded following ); -- mvd 4,3->6; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn order by ow_sale.vn asc range between floor(ow_sale.cn)::integer preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.pn order by ow_sale.vn desc); -- mvd 4,5,1->3; 4,5,2->6; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.pn,ow_sale.dt order by ow_sale.vn desc range between current row and current row ); -- mvd 6,7,4,2,8->5; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty/ow_sale.pn)) OVER(partition by ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.cn asc range between current row and current row ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc); -- mvd 4,5,2,1->3; 4,5,2,1->6; 5,2,8->7; 5,2,8->9; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.pn,ow_sale.prc order by ow_sale.vn asc range between current row and unbounded following ); -- mvd 6,7,8,1,2->5; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.dt,ow_sale.pn order by ow_sale.pn desc range between current row and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.pn order by ow_sale.pn desc range between current row and unbounded following ); -- mvd 3,4->2; 3,4->5; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc range between 1 following and 2 following ); -- mvd 4,1,5->3; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.pn*ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.cn asc range between floor(ow_sale.pn)::integer following and 4 following ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.cn order by ow_sale.cn asc),
win4 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc); -- mvd 8,1,2->7; 2->9; 8,4,2->10; 12,4,13->11; 

-- VAR_POP() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.qty order by ow_sale.pn asc range between floor(ow_sale.prc*ow_sale.cn)::integer following and unbounded following ); -- mvd 3,4->2; 

-- VAR_POP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(partition by ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.pn desc range between floor(ow_sale.vn)::integer following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.pn desc range between floor(ow_sale.vn)::integer following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.pn desc range between floor(ow_sale.vn)::integer following and unbounded following ),
win2 as (order by ow_sale.pn asc); -- mvd 3,6,7->5; 7->8; 7->9; 3,6,7->10; 3,6,7->11; 7->12; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn asc rows unbounded preceding ); -- mvd 4,5,6->3; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc rows unbounded preceding ); -- mvd 4,5,6->3; 4,5,6->7; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn asc rows floor(ow_sale.vn) preceding ); -- mvd 3,4->2; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc rows floor(ow_sale.qty) preceding ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.pn desc),
win4 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc); -- mvd 4,3,6,1->5; 1->7; 1->8; 1->9; 4,1->10; 1->11; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc rows current row ); -- mvd 6,7,2->5; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn/ow_sale.qty) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.prc)) OVER(partition by ow_sale.prc,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc rows current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc rows current row ),
win2 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc); -- mvd 3,4,5,6->2; 3,8,4,5,6,1->7; 3,8,4,5,6,1->9; 3,4,5,6->10; 3,8,4,5,6,1->11; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc,ow_sale.cn asc rows between unbounded preceding and 6 preceding ); -- mvd 3,1,4->2; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.cn order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between unbounded preceding and 2 preceding ),
win2 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.cn order by ow_sale.pn desc),
win3 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.cn order by ow_sale.pn asc); -- mvd 5,6,3->4; 6,8,1,2->7; 6,8,3,2->9; 6,8,1,2->10; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc rows between unbounded preceding and current row ); -- mvd 4,2,5->3; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc,ow_sale.vn desc rows between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.cn order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc,ow_sale.vn desc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.cn order by ow_sale.vn asc); -- mvd 2,3,8->7; 2,3,8->9; 2,1,3,4->10; 2,1,3,4->11; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty+ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn*ow_sale.qty) as int),NULL) OVER(win5),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win6),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and floor(ow_sale.pn+ow_sale.vn) following ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.cn order by ow_sale.cn desc),
win3 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.vn asc),
win5 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc),
win6 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 3,1->2; 5,3,1->4; 3,5,7->6; 7->8; 3,5,10,1->9; 7->11; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.cn desc rows between unbounded preceding and unbounded following ); -- mvd 5,6,7,1->4; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.pn asc); -- mvd 5,6->4; 6->7; 6->8; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc,ow_sale.cn asc rows between floor(ow_sale.prc*ow_sale.prc) preceding and floor(ow_sale.cn*ow_sale.qty) preceding ); -- mvd 4,5->3; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.cn)) OVER(partition by ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.cn asc rows between floor(ow_sale.vn) preceding and 3 preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn desc,ow_sale.cn asc rows between floor(ow_sale.vn) preceding and 3 preceding ); -- mvd 7,5,8,2,9->6; 7,5,8,2,9->10; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc,ow_sale.cn desc rows between 4 preceding and current row ); -- mvd 3,6->5; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.vn/ow_sale.cn) preceding and floor(ow_sale.vn-ow_sale.cn) following ); -- mvd 3,1,4->2; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between 5 preceding and unbounded following ); -- mvd 4,6,7,1,8->5; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc rows between floor(ow_sale.qty*ow_sale.qty) preceding and unbounded following ),
win2 as (order by ow_sale.pn desc); -- mvd 4,2,1,7->6; 7->8; 7->9; 7->10; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between current row and current row ); -- mvd 3,4,5->2; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn/ow_sale.cn) as int),cast (floor(ow_sale.pn+ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc rows between current row and current row ),
win2 as (order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.pn desc),
win4 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,4->2; 1->5; 1->6; 3,4->7; 1->8; 10->9; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.prc,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn asc rows between current row and floor(ow_sale.qty) following ); -- mvd 6,1,7,4,8->5; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc rows between current row and floor(ow_sale.cn) following ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.cn desc); -- mvd 4,1,5->3; 2,1,5,7->6; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn asc rows between current row and unbounded following ); -- mvd 1,3,4,5->2; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn asc,ow_sale.cn asc rows between 2 following and 6 following ); -- mvd 5,6,2,1->4; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn/ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows between 1 following and floor(ow_sale.vn) following ),
win2 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.vn asc); -- mvd 8,6->7; 1->9; 6->10; 1->11; 

-- VAR_POP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.qty) following and unbounded following ); -- mvd 3,1,4->2; 

-- VAR_POP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_POP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(partition by ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between 2 following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.vn)) OVER(partition by ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between 2 following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between 2 following and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.cn desc),
win3 as (order by ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 3,4,1->2; 4,6->5; 3,4,1->7; 4->8; 3,4,1->9; 1->10; 

-- VAR_SAMP() function with NULL OVER() clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (); -- mvd 2->2; 

-- VAR_SAMP() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn/ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.vn order by ow_sale.cn desc),
win3 as (order by ow_sale.vn desc),
win4 as (partition by ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc); -- mvd 2->2; 4,1,5,6->3; 5->7; 4,6->8; 

-- VAR_SAMP() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.pn); -- mvd 4,2,5->3; 

-- VAR_SAMP() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.pn desc); -- mvd 4->3; 6->5; 6,1->7; 

-- VAR_SAMP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc); -- mvd 1->4; 

-- VAR_SAMP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.prc) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc),
win2 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc); -- mvd 4->5; 2,7,8->6; 4->9; 2,7,8->10; 4->11; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range unbounded preceding ); -- mvd 3->2; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range unbounded preceding ),
win2 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.vn asc); -- mvd 1->2; 4->3; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range 3 preceding ); -- mvd 6->5; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range current row ); -- mvd 4->3; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(order by ow_sale.cn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.cn asc range current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range current row ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.vn,ow_sale.prc order by ow_sale.pn desc); -- mvd 1->3; 1->4; 1->5; 1->6; 2->7; 9,2,10->8; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc/ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and floor(ow_sale.pn)::integer preceding ); -- mvd 3->5; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and floor(ow_sale.prc)::integer preceding ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.pn desc); -- mvd 1->3; 5,1,6->4; 5,1,6->7; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and current row ); -- mvd 4->3; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and current row ),
win2 as (partition by ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc); -- mvd 1->2; 4,5->3; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.vn+ow_sale.cn)::integer following ); -- mvd 3->2; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and floor(ow_sale.pn+ow_sale.cn)::integer following ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3->2; 5->4; 7->6; 3->8; 7->9; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and unbounded following ); -- mvd 2->4; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 1 preceding and floor(ow_sale.qty*ow_sale.qty)::integer preceding ); -- mvd 1->2; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.vn)::integer preceding and current row ); -- mvd 1->2; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.cn)) OVER(order by ow_sale.pn asc range between 1 preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 1 preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.pn desc),
win3 as (order by ow_sale.pn desc); -- mvd 5->4; 5->6; 5->7; 9,1,5->8; 5->10; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between 2 preceding and floor(ow_sale.pn+ow_sale.cn)::integer following ); -- mvd 6->5; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.vn*ow_sale.qty)::integer preceding and 2 following ),
win2 as (order by ow_sale.vn desc); -- mvd 4->3; 1->5; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 2 preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.pn desc),
win4 as (order by ow_sale.pn desc); -- mvd 1->7; 9,3->8; 9,3->10; 9,12,3->11; 3->13; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc+ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and current row ); -- mvd 1->5; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.qty)) OVER(order by ow_sale.pn asc range between current row and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between current row and current row ),
win2 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3->2; 1,5,6,3->4; 3->7; 3->8; 1,5,6,3->9; 1->10; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and 3 following ); -- mvd 4->3; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and floor(ow_sale.vn)::integer following ),
win2 as (order by ow_sale.cn asc); -- mvd 4->3; 4->5; 4->6; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn*ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and unbounded following ); -- mvd 1->3; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc); -- mvd 6->5; 8,1,6->7; 6->9; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 3 following and 4 following ); -- mvd 5->4; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.cn)) OVER(order by ow_sale.vn asc range between 4 following and floor(ow_sale.qty+ow_sale.vn)::integer following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 4 following and floor(ow_sale.qty+ow_sale.vn)::integer following ),
win2 as (order by ow_sale.cn desc); -- mvd 3->2; 5->4; 3->6; 

-- VAR_SAMP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between floor(ow_sale.pn/ow_sale.vn)::integer following and unbounded following ); -- mvd 4->3; 

-- VAR_SAMP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn/ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn/ow_sale.cn) as int),cast (floor(ow_sale.qty/ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.prc/ow_sale.cn)::integer following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (partition by ow_sale.qty,ow_sale.qty,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc); -- mvd 1->5; 1->6; 8->7; 8->9; 1,3,11->10; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows unbounded preceding ); -- mvd 4->3; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn asc,ow_sale.cn desc rows unbounded preceding ),
win2 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.qty,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc); -- mvd 3,4->2; 6,7,1,4->5; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows floor(ow_sale.qty*ow_sale.cn) preceding ); -- mvd 3,4->2; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.cn desc rows floor(ow_sale.qty*ow_sale.pn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.cn desc rows floor(ow_sale.qty*ow_sale.pn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows floor(ow_sale.qty*ow_sale.pn) preceding ),
win2 as (order by ow_sale.vn desc); -- mvd 4->3; 4->5; 4->6; 8->7; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows current row ); -- mvd 3->2; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc*ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.cn asc rows current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.cn asc rows current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows current row ),
win2 as (order by ow_sale.pn desc); -- mvd 8->7; 8->9; 4->10; 8->11; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and 0 preceding ); -- mvd 4->7; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc rows between unbounded preceding and 4 preceding ),
win2 as (order by ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc); -- mvd 1,3->4; 3->5; 1,2,3->6; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows between unbounded preceding and current row ); -- mvd 5,1->7; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn/ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and current row ); -- mvd 4->5; 4->6; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn asc rows between unbounded preceding and 3 following ); -- mvd 2,5->4; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn desc rows between unbounded preceding and 2 following ),
win2 as (order by ow_sale.vn desc); -- mvd 4->3; 6->5; 6->7; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc rows between unbounded preceding and unbounded following ); -- mvd 7,1->6; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn asc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.cn order by ow_sale.vn desc),
win3 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc); -- mvd 1->2; 4,5,1,6->3; 5,4,1,8->7; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between floor(ow_sale.prc) preceding and current row ); -- mvd 5->4; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc rows between floor(ow_sale.vn) preceding and current row ),
win2 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.cn desc),
win3 as (partition by ow_sale.prc,ow_sale.vn order by ow_sale.vn asc); -- mvd 6,7->5; 6,1,4->8; 3,4->9; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.qty*ow_sale.qty) preceding and 5 following ); -- mvd 5->4; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows between floor(ow_sale.pn) preceding and floor(ow_sale.cn) following ),
win2 as (order by ow_sale.cn desc); -- mvd 3->4; 3->5; 3->6; 3->7; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc,ow_sale.vn desc rows between 4 preceding and unbounded following ); -- mvd 1,2->5; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.prc+ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between 0 preceding and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (order by ow_sale.cn desc),
win4 as (partition by ow_sale.pn order by ow_sale.vn desc); -- mvd 1,4->3; 1,4->5; 4->6; 1->7; 4,9->8; 4->10; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc rows between current row and current row ); -- mvd 4->3; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.vn desc rows between current row and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn*ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between current row and current row ),
win2 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.vn asc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 1->2; 4,1->3; 1->5; 7->6; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between current row and floor(ow_sale.pn*ow_sale.cn) following ); -- mvd 5,2->4; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and floor(ow_sale.prc) following ); -- mvd 8->7; 8->9; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.vn desc rows between current row and unbounded following ); -- mvd 3,4->2; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty+ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc); -- mvd 3->2; 5,6,7->4; 5,6,7->8; 3->9; 5,6,7->10; 5,6,7->11; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between 1 following and 1 following ); -- mvd 2->3; 

-- VAR_SAMP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.vn asc rows between 1 following and floor(ow_sale.qty) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.vn asc rows between 1 following and floor(ow_sale.qty) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between 1 following and floor(ow_sale.qty) following ),
win2 as (partition by ow_sale.vn order by ow_sale.pn asc); -- mvd 3->5; 3->6; 3->7; 3->8; 3,10->9; 

-- VAR_SAMP() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.pn order by ow_sale.pn asc,ow_sale.cn desc); -- mvd 3,4,5->2; 

-- VAR_SAMP() function with OVER() clause having PARTITION BY and ORDER BY (without framing) in combination with other window functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.dt,ow_sale.pn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
,
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.cn asc,ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.cn asc,ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.cn asc,ow_sale.vn desc); -- mvd 8,1,4->7; 8,1,4->9; 8,1,4->10; 8,1,4->11; 8,1,4->12; 8,1,4->13; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.cn desc range unbounded preceding ); -- mvd 4,1,5->3; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.prc,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty/ow_sale.pn)) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.vn desc range unbounded preceding ),
win2 as (partition by ow_sale.pn order by ow_sale.vn asc),
win3 as (order by ow_sale.cn asc),
win4 as (order by ow_sale.vn asc); -- mvd 2,1,6->5; 6,8->7; 4->9; 6->10; 4->11; 6->12; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.cn desc range 1 preceding ); -- mvd 4,2,5,6,7->3; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.pn asc range current row ); -- mvd 4,2->3; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.prc) as int),cast (floor(ow_sale.prc/ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.vn order by ow_sale.pn asc range current row ),
win2 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 1,6,7,3,2,8->5; 3->9; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.pn asc range between unbounded preceding and 1 preceding ); -- mvd 5,6,3,7,8->4; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc order by ow_sale.vn desc range between unbounded preceding and 4 preceding ),
win2 as (order by ow_sale.cn desc); -- mvd 8,4->7; 2->9; 2->10; 2->11; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.prc order by ow_sale.vn desc range between unbounded preceding and current row ); -- mvd 7,1,8,5,3->6; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn*ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc order by ow_sale.cn asc range between unbounded preceding and current row ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.pn order by ow_sale.pn desc),
win4 as (order by ow_sale.ord, ow_sale.cn asc),
win5 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.pn asc); -- mvd 2,4,1->3; 6->5; 4,8,6->7; 4->9; 4,8,6->10; 4,1,6->11; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.pn)::integer following ); -- mvd 1,6->5; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn*ow_sale.qty)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.qty order by ow_sale.cn desc range between unbounded preceding and 1 following ),
win2 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.qty order by ow_sale.cn asc); -- mvd 6,1,2,3->7; 9,6,2,4,3->8; 9,6,2,4,3->10; 9,6,2,4,3->11; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.pn asc range between unbounded preceding and unbounded following ); -- mvd 3,4->6; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn-ow_sale.cn) as int),cast (floor(ow_sale.qty/ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.vn order by ow_sale.cn asc range between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 4,1,3->6; 4->7; 4->8; 4->9; 4->10; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.cn asc range between 0 preceding and floor(ow_sale.cn)::integer preceding ); -- mvd 4,5,2->3; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc/ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.cn order by ow_sale.cn desc range between floor(ow_sale.qty+ow_sale.qty)::integer preceding and floor(ow_sale.cn+ow_sale.vn)::integer preceding ),
win2 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc); -- mvd 1,5->4; 1,2,5,3->6; 1,2,5,3->7; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.prc order by ow_sale.pn asc range between floor(ow_sale.vn*ow_sale.qty)::integer preceding and current row ); -- mvd 7,8,3,2->6; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.pn,ow_sale.pn order by ow_sale.pn desc range between 3 preceding and 1 following ); -- mvd 8,1->7; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.pn,ow_sale.prc,ow_sale.pn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.cn desc range between floor(ow_sale.qty)::integer preceding and 3 following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.pn,ow_sale.cn order by ow_sale.vn asc); -- mvd 8,6,2->7; 8->9; 8->10; 8,6,2->11; 8->12; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.vn desc range between floor(ow_sale.cn)::integer preceding and unbounded following ); -- mvd 3,4->2; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(partition by ow_sale.cn,ow_sale.dt order by ow_sale.cn asc range between floor(ow_sale.pn)::integer preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.cn asc range between floor(ow_sale.pn)::integer preceding and unbounded following ),
win2 as (order by ow_sale.vn desc); -- mvd 3,2->5; 3,2->6; 8->7; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.cn,ow_sale.vn order by ow_sale.pn asc range between current row and current row ); -- mvd 3,4,5,1->2; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn+ow_sale.vn) as int),cast (floor(ow_sale.qty*ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win5),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.pn asc range between current row and current row ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.pn desc),
win5 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.vn order by ow_sale.cn desc); -- mvd 5,2,1->4; 5,2,1->6; 1->7; 9->8; 1->10; 9,2,12->11; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.pn asc range between current row and 1 following ); -- mvd 5->4; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(partition by ow_sale.qty,ow_sale.qty,ow_sale.dt,ow_sale.cn order by ow_sale.pn desc range between current row and 3 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(partition by ow_sale.qty,ow_sale.qty,ow_sale.dt,ow_sale.cn order by ow_sale.pn desc range between current row and 3 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.qty,ow_sale.dt,ow_sale.cn order by ow_sale.pn desc range between current row and 3 following ),
win2 as (order by ow_sale.pn desc); -- mvd 3,5,6,2->4; 3,5,6,2->7; 3,5,6,2->8; 3,5,6,2->9; 2->10; 2->11; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt order by ow_sale.cn desc range between current row and unbounded following ); -- mvd 4,5,6->3; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.prc,ow_sale.pn order by ow_sale.pn desc range between floor(ow_sale.pn)::integer following and floor(ow_sale.cn)::integer following ); -- mvd 5,6,3->4; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.qty,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.pn desc range between 1 following and 4 following ),
win2 as (order by ow_sale.vn desc); -- mvd 4,2,1->5; 7->6; 7->8; 

-- VAR_SAMP() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.qty order by ow_sale.pn desc range between 2 following and unbounded following ); -- mvd 6,7,4,2->5; 

-- VAR_SAMP() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc*ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.vn order by ow_sale.cn desc range between floor(ow_sale.cn+ow_sale.cn)::integer following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 1,2->4; 1->5; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn desc rows unbounded preceding ); -- mvd 4,5->3; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc*ow_sale.pn)) OVER(partition by ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows floor(ow_sale.cn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(partition by ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows floor(ow_sale.cn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc+ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows floor(ow_sale.cn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn/ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc rows floor(ow_sale.cn) preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,4,1->2; 3,4,1->5; 3,4,1->6; 3,4,1->7; 3,4,1->8; 10->9; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn desc,ow_sale.pn desc rows current row ); -- mvd 4,5,6,1->3; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.qty,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows current row ),
win2 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn desc),
win3 as (order by ow_sale.cn asc); -- mvd 6,7,2,8->5; 7,2->9; 7,2->10; 7->11; 7,2->12; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc,ow_sale.cn desc rows between unbounded preceding and 2 preceding ); -- mvd 8,1,3->7; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.cn)) OVER(partition by ow_sale.vn,ow_sale.prc,ow_sale.qty,ow_sale.qty order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.cn desc rows between unbounded preceding and floor(ow_sale.pn) preceding ),
win2 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.qty,ow_sale.qty order by ow_sale.cn asc),
win3 as (order by ow_sale.pn asc); -- mvd 4,6->5; 4,6->7; 1,4,9,6->8; 1,4,9,6->10; 2->11; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc,ow_sale.cn desc rows between unbounded preceding and current row ); -- mvd 1->2; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.vn,ow_sale.dt order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn asc,ow_sale.cn desc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.vn desc),
win3 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.prc order by ow_sale.pn desc),
win4 as (order by ow_sale.cn asc); -- mvd 3,6,1->5; 6,8->7; 6,8->9; 11,6,3,1->10; 3->12; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc,ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.pn) following ); -- mvd 1,3,4,5,6,7->2; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and 3 following ),
win2 as (partition by ow_sale.qty,ow_sale.prc order by ow_sale.vn asc); -- mvd 1,3,4->2; 6,3,1->5; 6,3,1->7; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn desc rows between unbounded preceding and unbounded following ); -- mvd 3,4,5->2; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and unbounded following ),
win2 as (order by ow_sale.vn desc); -- mvd 5,6,1,3->4; 5,6,1,3->7; 9->8; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc rows between 2 preceding and 5 preceding ); -- mvd 1,6,3,4->5; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.qty/ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc,ow_sale.pn asc rows between floor(ow_sale.qty) preceding and 4 preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.prc order by ow_sale.ord, ow_sale.vn desc),
win4 as (partition by ow_sale.prc,ow_sale.qty order by ow_sale.cn desc); -- mvd 1,4,2,5->3; 1,4,2,5->6; 1->7; 9,4->8; 9,1,2->10; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.vn desc rows between floor(ow_sale.qty) preceding and current row ); -- mvd 1,3,4->2; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.pn*ow_sale.qty) preceding and 3 following ); -- mvd 5,2,7->6; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn-ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.qty*ow_sale.qty) preceding and floor(ow_sale.vn) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty-ow_sale.pn)) OVER(partition by ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.qty*ow_sale.qty) preceding and floor(ow_sale.vn) following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.qty*ow_sale.qty) preceding and floor(ow_sale.vn) following ),
win2 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 3,4,5,1->2; 1->6; 3,4,5,1->7; 1->8; 3,4,5,1->9; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.prc,ow_sale.pn,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between 0 preceding and unbounded following ); -- mvd 7,5,3->6; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(partition by ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc,ow_sale.pn asc rows between floor(ow_sale.vn/ow_sale.qty) preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc/ow_sale.qty) as int),cast (floor(ow_sale.prc+ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn desc,ow_sale.pn asc rows between floor(ow_sale.vn/ow_sale.qty) preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.pn asc); -- mvd 1,4->3; 1,4->5; 1,4->6; 1,4->7; 9,4->8; 1,4->10; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc rows between current row and current row ); -- mvd 5,6,7,2,8->4; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(partition by ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc rows between current row and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn asc rows between current row and current row ),
win2 as (order by ow_sale.vn asc); -- mvd 4,2,1->3; 6->5; 6->7; 6->8; 6->9; 4,2,1->10; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn+ow_sale.cn)) OVER(partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc rows between current row and 0 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc rows between current row and 0 following ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn order by ow_sale.pn asc); -- mvd 2,1->6; 2,1->7; 2,3,1->8; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.pn asc,ow_sale.pn asc rows between current row and unbounded following ); -- mvd 6,3,2,1,7->5; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(partition by ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(partition by ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty/ow_sale.qty) as int),cast (floor(ow_sale.prc+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between current row and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 4,2,1->5; 4,2,1->6; 4,2,1->7; 9,4,1->8; 4->10; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc rows between 1 following and 4 following ); -- mvd 1,2,3->5; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn-ow_sale.cn) as int),cast (floor(ow_sale.vn/ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn-ow_sale.pn)) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc rows between 0 following and floor(ow_sale.qty/ow_sale.pn) following ),
win2 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 2,5->4; 7,8,5->6; 8->9; 8->10; 

-- VAR_SAMP() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VAR_SAMP(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.cn asc rows between 3 following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.cn asc rows between 3 following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win4),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.cn asc rows between 3 following and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.vn desc),
win4 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc); -- mvd 3,1,4->2; 3,1,4->5; 1->6; 3,1,4->7; 1,4->8; 3,10,1,4->9; 

-- VARIANCE() function with NULL OVER() clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc-ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (); -- mvd 2->2; 

-- VARIANCE() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn); -- mvd 4->5; 

-- VARIANCE() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc,ow_sale.vn asc); -- mvd 1,4->7; 

-- VARIANCE() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.pn)) OVER(order by ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc,ow_sale.cn desc,ow_sale.pn asc),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 4,1->3; 4,1->5; 4->6; 4,1->7; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.prc,ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range unbounded preceding ); -- mvd 2->7; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range unbounded preceding ),
win2 as (order by ow_sale.pn asc); -- mvd 7->6; 7->8; 3->9; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range 1 preceding ); -- mvd 3->2; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range 4 preceding ),
win2 as (order by ow_sale.pn asc); -- mvd 3->5; 1->6; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ); -- mvd 2->3; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn-ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range current row ),
win2 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.pn desc); -- mvd 5->4; 5->6; 8,5,9,2->7; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn*ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.vn*ow_sale.qty)::integer preceding ); -- mvd 2->4; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(partition by ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.pn order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and 1 preceding ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.pn order by ow_sale.vn desc); -- mvd 3->2; 5->4; 5,3,1,7->6; 5,3,1,7->8; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and current row ); -- mvd 7->6; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(order by ow_sale.pn desc range between unbounded preceding and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and current row ); -- mvd 6->5; 6->7; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn/ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.prc)::integer following ); -- mvd 3->4; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(order by ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.qty) as int),cast (floor(ow_sale.pn+ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and floor(ow_sale.prc)::integer following ),
win2 as (order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 3->2; 3->4; 3->5; 3->6; 3->7; 9->8; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and unbounded following ); -- mvd 5->4; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty*ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.dt,ow_sale.vn order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.vn order by ow_sale.pn desc); -- mvd 4->3; 4,6->5; 6,1,2->7; 4,6->8; 6,1,2->9; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 1 preceding and 3 preceding ); -- mvd 4->5; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.prc)::integer preceding and floor(ow_sale.prc+ow_sale.qty)::integer following ); -- mvd 3->4; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn/ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty-ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between 0 preceding and floor(ow_sale.pn)::integer following ),
win2 as (order by ow_sale.vn asc),
win3 as (order by ow_sale.ord, ow_sale.cn desc),
win4 as (partition by ow_sale.qty,ow_sale.prc order by ow_sale.ord, ow_sale.cn desc); -- mvd 1->6; 4->7; 4->8; 10->9; 12,10,3->11; 4->13; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.cn)::integer preceding and unbounded following ); -- mvd 3->2; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.qty/ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.pn+ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.pn)::integer preceding and unbounded following ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc),
win4 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 8->7; 8->9; 8->10; 12,8,4,2->11; 2->13; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and current row ); -- mvd 3->2; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn+ow_sale.vn) as int),cast (floor(ow_sale.pn*ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.qty) as int),cast (floor(ow_sale.vn+ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and current row ),
win2 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.vn asc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 4->3; 1,6->5; 8->7; 1->9; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between current row and 4 following ); -- mvd 2->4; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and 1 following ),
win2 as (order by ow_sale.cn asc); -- mvd 1->3; 1->4; 1->5; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and unbounded following ); -- mvd 6->5; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.pn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(order by ow_sale.pn desc range between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn*ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and unbounded following ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.cn asc); -- mvd 3->6; 1->7; 3->8; 10,1,3->9; 1->11; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 4 following and floor(ow_sale.pn-ow_sale.pn)::integer following ); -- mvd 4->5; 

-- VARIANCE() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 2 following and unbounded following ); -- mvd 2->6; 

-- VARIANCE() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 2 following and unbounded following ),
win2 as (order by ow_sale.vn desc); -- mvd 2->4; 2->5; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn desc rows unbounded preceding ); -- mvd 4,1->3; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows unbounded preceding ),
win2 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.dt,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc); -- mvd 4,5->3; 4,5->6; 8,9,1->7; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc rows floor(ow_sale.vn+ow_sale.prc) preceding ); -- mvd 6,3->5; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn+ow_sale.cn)) OVER(order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows 0 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows 0 preceding ),
win2 as (order by ow_sale.vn desc),
win3 as (order by ow_sale.pn asc),
win4 as (order by ow_sale.cn desc); -- mvd 5->4; 3->6; 5->7; 5->8; 10->9; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows current row ); -- mvd 4->3; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn-ow_sale.vn) as int),cast (floor(ow_sale.qty/ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows current row ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc),
win3 as (order by ow_sale.pn asc); -- mvd 3->4; 3->5; 7,8,9,1,3->6; 3->10; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.prc,ow_sale.cn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.pn asc,ow_sale.vn asc rows between unbounded preceding and current row ); -- mvd 8,9->7; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn asc,ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.vn desc); -- mvd 7,4->6; 7,4->8; 10->9; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and 6 following ); -- mvd 4->3; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty-ow_sale.vn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and floor(ow_sale.cn) following ),
win2 as (order by ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 5->4; 1->6; 2->7; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.prc,ow_sale.qty,ow_sale.prc,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and unbounded following ); -- mvd 6->7; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.qty+ow_sale.cn) preceding and 3 preceding ); -- mvd 3->2; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between floor(ow_sale.pn/ow_sale.qty) preceding and floor(ow_sale.qty) preceding ),
win2 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.vn order by ow_sale.cn asc); -- mvd 1->2; 1,4,5,6,7->3; 1,4,5,6,7->8; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc rows between 4 preceding and current row ); -- mvd 1->5; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn desc rows between 2 preceding and current row ),
win2 as (order by ow_sale.pn desc); -- mvd 6->5; 6->7; 1->8; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc,ow_sale.pn asc rows between floor(ow_sale.cn+ow_sale.cn) preceding and floor(ow_sale.pn/ow_sale.cn) following ); -- mvd 2,3->4; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty/ow_sale.vn) as int),cast (floor(ow_sale.prc-ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between 1 preceding and 4 following ),
win2 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.vn asc),
win4 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.pn order by ow_sale.cn desc); -- mvd 4->3; 4,6,1->5; 1->7; 4,6,1->8; 4,1,2->9; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between floor(ow_sale.vn) preceding and unbounded following ); -- mvd 1,2->3; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn asc rows between 4 preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn asc rows between 4 preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn asc rows between 4 preceding and unbounded following ); -- mvd 3,4->2; 3,4->5; 3,4->6; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn desc rows between current row and current row ); -- mvd 3->2; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between current row and current row ); -- mvd 2->4; 2->5; 2->6; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn*ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and 8 following ); -- mvd 2->6; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.cn asc rows between current row and floor(ow_sale.qty) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.pn)) OVER(partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.qty order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.cn asc rows between current row and floor(ow_sale.qty) following ),
win2 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.qty order by ow_sale.vn desc); -- mvd 3,4->2; 3,4->5; 3,4->6; 3,1,4,8->7; 3,1,4,8->9; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and unbounded following ); -- mvd 4->3; 

-- VARIANCE() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.vn) as int),cast (floor(ow_sale.prc+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between current row and unbounded following ),
win2 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc); -- mvd 4->3; 6,4,2,7->5; 

-- VARIANCE() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.qty,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.cn) following and 2 following ); -- mvd 1->5; 

-- VARIANCE() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn order by ow_sale.cn desc); -- mvd 1,2->3; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.vn order by ow_sale.cn desc range unbounded preceding ); -- mvd 2,4,5,1->3; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn/ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.prc order by ow_sale.cn asc range floor(ow_sale.cn)::integer preceding ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 1,3,4,5->2; 7->6; 3->8; 3->9; 3->10; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.cn order by ow_sale.cn asc range current row ); -- mvd 1,4,5,2->3; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.pn desc range current row ),
win2 as (order by ow_sale.cn desc); -- mvd 6,1,2,7->5; 1->8; 1->9; 6,1,2,7->10; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.qty order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.prc+ow_sale.qty)::integer preceding ); -- mvd 8,4,9,5,1->7; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn*ow_sale.pn)) OVER(partition by ow_sale.prc,ow_sale.cn order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.pn)::integer preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.pn)::integer preceding ),
win2 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.cn desc),
win3 as (order by ow_sale.vn desc),
win4 as (order by ow_sale.cn desc); -- mvd 4,5->3; 4,5->6; 5,2,1->7; 9->8; 5->10; 4,5->11; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.vn order by ow_sale.cn desc range between unbounded preceding and current row ); -- mvd 4,5,2->3; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.vn)) OVER(partition by ow_sale.pn order by ow_sale.pn asc range between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(partition by ow_sale.pn order by ow_sale.pn asc range between unbounded preceding and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.pn asc range between unbounded preceding and current row ),
win2 as (order by ow_sale.cn desc); -- mvd 2->7; 2->8; 2->9; 1->10; 2->11; 1->12; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.prc,ow_sale.vn,ow_sale.dt order by ow_sale.pn asc range between unbounded preceding and 1 following ); -- mvd 3,1,4,5,6->2; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty+ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.cn asc range between unbounded preceding and floor(ow_sale.pn)::integer following ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.pn asc); -- mvd 5,2,6,1,7,8->4; 2->9; 8->10; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.vn order by ow_sale.cn asc range between unbounded preceding and unbounded following ); -- mvd 4,5,6->3; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty*ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn asc); -- mvd 4->7; 2,3->8; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.prc,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.vn order by ow_sale.pn desc range between floor(ow_sale.cn)::integer preceding and 4 preceding ); -- mvd 4,7,8,9->6; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn order by ow_sale.pn desc range between floor(ow_sale.vn/ow_sale.vn)::integer preceding and current row ); -- mvd 3,4,5->2; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.qty order by ow_sale.cn asc range between floor(ow_sale.cn)::integer preceding and current row ),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.vn asc),
win4 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 6,1,7,4->5; 1->8; 1->9; 7->10; 7->11; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc order by ow_sale.cn asc range between 4 preceding and 0 following ); -- mvd 4,2,5->3; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn+ow_sale.cn)) OVER(partition by ow_sale.vn order by ow_sale.cn desc range between floor(ow_sale.vn+ow_sale.qty)::integer preceding and 0 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn desc range between floor(ow_sale.vn+ow_sale.qty)::integer preceding and 0 following ),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.qty order by ow_sale.pn desc); -- mvd 6,1->5; 8,6,2,1,4->7; 6,1->9; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn asc range between 4 preceding and unbounded following ); -- mvd 1,2->6; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn/ow_sale.vn)) OVER(order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.cn order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.pn order by ow_sale.cn asc range between 1 preceding and unbounded following ),
win2 as (order by ow_sale.pn desc),
win3 as (partition by ow_sale.cn order by ow_sale.pn desc); -- mvd 3,4,5,6->2; 6->7; 6->8; 3,6->9; 3,6->10; 3,6->11; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.dt,ow_sale.cn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.cn desc range between current row and current row ); -- mvd 4,3,8->7; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn*ow_sale.vn) as int),cast (floor(ow_sale.pn+ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.prc+ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.vn order by ow_sale.pn desc range between current row and current row ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc),
win3 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc),
win4 as (partition by ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,4->2; 1,4->5; 1,4->6; 8,1,3,9,4->7; 8,1,3->10; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.prc order by ow_sale.pn asc range between current row and 3 following ); -- mvd 3,4,5->2; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.pn desc range between current row and floor(ow_sale.prc)::integer following ),
win2 as (order by ow_sale.cn asc); -- mvd 3,4->2; 3->5; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.pn desc range between current row and unbounded following ); -- mvd 3,1,4->2; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.prc,ow_sale.cn,ow_sale.qty order by ow_sale.cn asc range between current row and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.vn asc),
win3 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.qty order by ow_sale.vn asc); -- mvd 7,1,8,2,3->6; 3->9; 1,8,3,2->10; 3->11; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.dt order by ow_sale.vn desc range between 0 following and floor(ow_sale.prc)::integer following ); -- mvd 1,3,4,5->2; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.cn order by ow_sale.pn desc range between floor(ow_sale.qty)::integer following and 3 following ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.cn,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc); -- mvd 3,4,5,1,6->2; 3,4,5,1,6->7; 3,4,5,1,6->8; 

-- VARIANCE() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.cn order by ow_sale.pn asc range between floor(ow_sale.vn)::integer following and unbounded following ); -- mvd 3,4,5,1->2; 

-- VARIANCE() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn/ow_sale.vn) as int),cast (floor(ow_sale.qty*ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(order by ow_sale.ord, ow_sale.pn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn/ow_sale.vn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.pn asc range between floor(ow_sale.prc)::integer following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 6,2->5; 2->7; 1->8; 2->9; 1->10; 2->11; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.prc,ow_sale.prc order by ow_sale.ord, ow_sale.vn asc rows unbounded preceding ); -- mvd 6,7,1->5; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(partition by ow_sale.qty order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.pn)) OVER(partition by ow_sale.qty order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.qty order by ow_sale.ord, ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn asc,ow_sale.cn desc rows unbounded preceding ),
win2 as (order by ow_sale.pn desc),
win3 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.vn asc); -- mvd 2,4,1,5->3; 5->6; 1,8->7; 1,8->9; 1,8->10; 1,8->11; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows 2 preceding ); -- mvd 4,1,5->3; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn*ow_sale.vn) as int),cast (floor(ow_sale.vn+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows 2 preceding ),
win2 as (order by ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc); -- mvd 5,6,7,2->4; 2->8; 6,7,2->9; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.pn asc rows current row ); -- mvd 6,4,7,1->5; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.vn,ow_sale.cn order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc rows current row ),
win2 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.cn asc); -- mvd 3,4,5->2; 3,4->6; 3,4->7; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.dt,ow_sale.dt,ow_sale.prc,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and 1 preceding ); -- mvd 6,7,8,1->5; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc,ow_sale.vn asc rows between unbounded preceding and current row ); -- mvd 6,1,7->5; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.vn asc); -- mvd 1,2->5; 3->6; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc rows between unbounded preceding and floor(ow_sale.cn+ow_sale.pn) following ); -- mvd 1,6,3,8->7; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc/ow_sale.vn)) OVER(partition by ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc rows between unbounded preceding and 0 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc rows between unbounded preceding and 0 following ),
win2 as (order by ow_sale.vn asc); -- mvd 4,5,2->3; 4,5,2->6; 2->7; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc,ow_sale.vn desc rows between unbounded preceding and unbounded following ); -- mvd 3,7,1->6; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn/ow_sale.vn)) OVER(partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn asc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn order by ow_sale.pn desc); -- mvd 2,5->4; 2,5->6; 2,5->7; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.prc order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc rows between floor(ow_sale.pn) preceding and 7 preceding ); -- mvd 3,4,5->2; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc rows between 1 preceding and floor(ow_sale.qty/ow_sale.vn) preceding ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.pn order by ow_sale.cn desc); -- mvd 1,4,2->3; 2->5; 1,2->6; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows between floor(ow_sale.prc) preceding and current row ); -- mvd 2,5->6; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.cn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc,ow_sale.vn desc,ow_sale.cn asc rows between 2 preceding and current row ),
win2 as (order by ow_sale.cn desc); -- mvd 1,4,5,6,7->3; 1->8; 1->9; 1->10; 1->11; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc rows between 1 preceding and 5 following ); -- mvd 6,7,2->5; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.cn desc rows between 2 preceding and 0 following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.prc,ow_sale.pn order by ow_sale.cn desc),
win3 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.vn,ow_sale.prc order by ow_sale.ord, ow_sale.cn desc),
win4 as (order by ow_sale.vn desc); -- mvd 2,1->4; 6,2,3,1,7->5; 6,2,3,1,7->8; 1->9; 1->10; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(partition by ow_sale.vn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc rows between 1 preceding and unbounded following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc rows between 1 preceding and unbounded following ); -- mvd 1,4,5,6->3; 1,4,5,6->7; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.prc order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.cn desc rows between current row and current row ); -- mvd 3,4,1,5->2; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc,ow_sale.pn desc rows between current row and current row ),
win2 as (order by ow_sale.vn desc); -- mvd 8,4,2,3->7; 1->9; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.qty order by ow_sale.ord, ow_sale.cn asc rows between current row and 1 following ); -- mvd 2,5,6,1->4; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn desc,ow_sale.vn asc rows between current row and unbounded following ); -- mvd 6,7,8->5; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.vn)) OVER(partition by ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn-ow_sale.prc) as int),cast (floor(ow_sale.pn+ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between current row and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.cn desc),
win3 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc); -- mvd 5,3->4; 5,3->6; 8,5->7; 8,5->9; 5,3->10; 12,8,1->11; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.cn) following and floor(ow_sale.qty) following ); -- mvd 7,4,8->6; 

-- VARIANCE() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.vn) following and unbounded following ); -- mvd 4,5,6,7->3; 

-- VARIANCE() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(VARIANCE(floor(ow_sale.pn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn*ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc rows between floor(ow_sale.cn/ow_sale.cn) following and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,6,4->5; 1->7; 1->8; 

-- CORR() function with NULL OVER() clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.qty+ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (); -- mvd 2->2; 

-- CORR() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (),
win2 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.pn desc); -- mvd 3->3; 5,6,7,1->4; 5,6,7,1->8; 

-- CORR() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.prc); -- mvd 6,1,3,4->5; 

-- CORR() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn/ow_sale.qty),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.cn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.dt),
win2 as (order by ow_sale.cn asc); -- mvd 5,3->4; 5,3->6; 8->7; 8->9; 8->10; 

-- CORR() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty*ow_sale.cn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc); -- mvd 3->5; 

-- CORR() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.pn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc*ow_sale.vn),floor(ow_sale.cn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
,
TO_CHAR(COALESCE(DENSE_RANK() OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn+ow_sale.qty)) OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.vn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc); -- mvd 7->6; 7->8; 7->9; 7,3->10; 7,3->11; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn+ow_sale.vn),floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range unbounded preceding ); -- mvd 4->3; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range 2 preceding ); -- mvd 5->4; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn+ow_sale.vn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.pn) as int),cast (floor(ow_sale.prc*ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range floor(ow_sale.vn*ow_sale.vn)::integer preceding ),
win2 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.cn desc); -- mvd 4->3; 6,4,7->5; 4->8; 6,4,7->9; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn+ow_sale.pn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range current row ); -- mvd 5->4; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn+ow_sale.prc),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn*ow_sale.vn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range current row ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.prc,ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc); -- mvd 4->3; 1->5; 4->6; 1->7; 9,1,10->8; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn/ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and floor(ow_sale.prc)::integer preceding ); -- mvd 3->2; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn/ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc-ow_sale.prc) as int),cast (floor(ow_sale.vn/ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and 3 preceding ),
win2 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc); -- mvd 7->6; 9,7,10->8; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and current row ); -- mvd 2->4; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn+ow_sale.prc),floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and floor(ow_sale.qty+ow_sale.qty)::integer following ); -- mvd 3->2; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn*ow_sale.qty),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and floor(ow_sale.qty+ow_sale.cn)::integer following ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.pn asc); -- mvd 8->7; 2->9; 2->10; 4,8->11; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.pn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between unbounded preceding and unbounded following ); -- mvd 3->2; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc); -- mvd 4->5; 7,2->6; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 2 preceding and 1 preceding ); -- mvd 3->2; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.cn-ow_sale.cn)::integer preceding and floor(ow_sale.prc-ow_sale.prc)::integer preceding ),
win2 as (order by ow_sale.cn asc),
win3 as (order by ow_sale.vn asc); -- mvd 3->2; 3->4; 3->5; 7->6; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 0 preceding and current row ); -- mvd 4->7; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn*ow_sale.cn)) OVER(partition by ow_sale.pn,ow_sale.qty,ow_sale.cn order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.pn,ow_sale.qty,ow_sale.cn order by ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 3 preceding and current row ),
win2 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.cn order by ow_sale.vn desc); -- mvd 7->6; 1,7,3,4->8; 1,7,3,4->9; 1,7,3,4->10; 1,7,3,4->11; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.cn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 2 preceding and 3 following ); -- mvd 4->3; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.vn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.vn),floor(ow_sale.pn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.cn)) OVER(order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 0 preceding and floor(ow_sale.vn)::integer following ),
win2 as (order by ow_sale.pn desc); -- mvd 7->6; 7->8; 5->9; 5->10; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty-ow_sale.prc),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 0 preceding and unbounded following ); -- mvd 3->2; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between 0 preceding and unbounded following ),
win2 as (partition by ow_sale.vn,ow_sale.pn order by ow_sale.cn desc); -- mvd 2->4; 2,6,7->5; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between current row and current row ); -- mvd 3->2; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.qty+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.pn/ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and current row ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 2->6; 2->7; 3->8; 3->9; 1->10; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.prc,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn/ow_sale.qty),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and 2 following ); -- mvd 3->4; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn*ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn-ow_sale.pn)) OVER(order by ow_sale.pn desc range between current row and 2 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.prc*ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and 2 following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.vn desc),
win4 as (partition by ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc); -- mvd 1->3; 1->4; 6->5; 6,8->7; 6,10,1->9; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty*ow_sale.pn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and unbounded following ); -- mvd 5->4; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc*ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(order by ow_sale.cn asc range between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn+ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.vn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and unbounded following ),
win2 as (partition by ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.cn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc); -- mvd 3->6; 3->7; 3->8; 3->9; 3,11,12,4->10; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.vn+ow_sale.qty)::integer following and floor(ow_sale.vn+ow_sale.pn)::integer following ); -- mvd 1->5; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn-ow_sale.cn),floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(partition by ow_sale.cn order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 4 following and floor(ow_sale.vn)::integer following ),
win2 as (partition by ow_sale.cn order by ow_sale.pn desc); -- mvd 5->4; 5,1->6; 5,1->7; 

-- CORR() function with ONLY order by having range based framing clause --

SELECT ow_sale.dt,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty-ow_sale.prc),floor(ow_sale.pn+ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 0 following and unbounded following ); -- mvd 3->4; 

-- CORR() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc+ow_sale.qty),floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.pn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.cn)::integer following and unbounded following ),
win2 as (order by ow_sale.pn desc); -- mvd 6->5; 8->7; 8->9; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty+ow_sale.vn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows unbounded preceding ); -- mvd 1,3->2; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --
-- Note the +2 below. This is to get rid of inconsistent output because some zero float values are printed as -.000 on some platforms.
SELECT ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.cn)) OVER(win1),0)+2,'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn+ow_sale.qty) as int),cast (floor(ow_sale.prc+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.cn+ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows unbounded preceding ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.pn order by ow_sale.ord, ow_sale.vn asc),
win4 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 4->5; 4->6; 4,3->7; 4->8; 4->9; 4->10; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc+ow_sale.cn),floor(ow_sale.pn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows floor(ow_sale.pn) preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.vn+ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc rows floor(ow_sale.pn) preceding ),
win2 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 3->2; 3->4; 6->5; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows current row ); -- mvd 1->2; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn+ow_sale.pn),floor(ow_sale.vn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc rows current row ),
win2 as (order by ow_sale.cn desc); -- mvd 1->4; 6->5; 6->7; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc*ow_sale.pn),floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc,ow_sale.pn asc rows between unbounded preceding and floor(ow_sale.pn+ow_sale.prc) preceding ); -- mvd 4,5,1->3; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc rows between unbounded preceding and current row ); -- mvd 1,5->4; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

-- Note the +2 below. This is to get rid of inconsistent output because some zero float values are printed as -.000 on some platforms.
SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.cn)) OVER(win1),0)+2,'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty+ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (order by ow_sale.vn asc),
win3 as (order by ow_sale.ord, ow_sale.pn desc); -- mvd 3,4->2; 6->5; 6->7; 6->8; 4->9; 6->10; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc/ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between unbounded preceding and 1 following ); -- mvd 2,5->4; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.qty,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn-ow_sale.prc),floor(ow_sale.qty/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.prc order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty)) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and 4 following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.qty,ow_sale.prc order by ow_sale.vn desc),
win3 as (order by ow_sale.vn desc); -- mvd 7->6; 9,5,1,2,7->8; 7->10; 9,5,1,2,7->11; 2->12; 2->13; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.cn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc,ow_sale.cn desc rows between unbounded preceding and unbounded following ); -- mvd 3,2->4; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty-ow_sale.prc),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc,ow_sale.vn desc rows between floor(ow_sale.qty*ow_sale.prc) preceding and 2 preceding ); -- mvd 8,9,2->7; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.vn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn/ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between 1 preceding and 0 preceding ); -- mvd 3->7; 3->8; 3->9; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc+ow_sale.cn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between 7 preceding and current row ); -- mvd 3,4->2; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn-ow_sale.cn),floor(ow_sale.vn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.qty,ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between floor(ow_sale.cn) preceding and current row ),
win2 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.dt,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc); -- mvd 4,5->3; 7,5,1->6; 7,5,1->8; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.cn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between 0 preceding and 6 following ); -- mvd 1->4; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.cn desc rows between 0 preceding and unbounded following ); -- mvd 2,4->3; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.vn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc rows between current row and current row ); -- mvd 6->5; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc,ow_sale.vn asc rows between current row and current row ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,4->2; 3->5; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn/ow_sale.qty),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc rows between current row and 5 following ); -- mvd 2->4; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn/ow_sale.qty),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows between current row and floor(ow_sale.prc) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn+ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc rows between current row and floor(ow_sale.prc) following ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.cn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc); -- mvd 6,3->5; 6,3->7; 6->8; 6->9; 6->10; 2,6,3,1->11; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc rows between current row and unbounded following ); -- mvd 5->4; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ),
win2 as (partition by ow_sale.pn order by ow_sale.pn asc); -- mvd 3->2; 3->4; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc rows between floor(ow_sale.pn) following and floor(ow_sale.pn+ow_sale.vn) following ); -- mvd 3,4->2; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.vn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn-ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc rows between 2 following and floor(ow_sale.prc*ow_sale.vn) following ),
win2 as (partition by ow_sale.cn order by ow_sale.cn desc),
win3 as (order by ow_sale.cn asc),
win4 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.vn desc); -- mvd 2,1->6; 2->7; 2,1->8; 2->9; 2->10; 12,2,1->11; 

-- CORR() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn-ow_sale.qty),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.pn asc rows between 0 following and unbounded following ); -- mvd 1->4; 

-- CORR() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty-ow_sale.qty),floor(ow_sale.qty*ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.pn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn/ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between floor(ow_sale.prc) following and unbounded following ),
win2 as (partition by ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.pn desc),
win3 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.prc,ow_sale.vn order by ow_sale.ord, ow_sale.vn asc); -- mvd 3->2; 5,3,6,1->4; 5,3,6,1->7; 5,9,6,1->8; 5,3,6,1->10; 

-- CORR() function with OVER() clause having PARTITION BY and ORDER BY (without framing)--

SELECT ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.prc/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.cn asc,ow_sale.cn asc,ow_sale.cn asc); -- mvd 4,5->3; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty*ow_sale.prc),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn desc range unbounded preceding ); -- mvd 3,4->2; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.cn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.vn)) OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.dt order by ow_sale.pn desc range unbounded preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(partition by ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.dt order by ow_sale.pn desc range unbounded preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc-ow_sale.cn) as int),cast (floor(ow_sale.vn-ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.dt order by ow_sale.pn desc range unbounded preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (order by ow_sale.pn desc); -- mvd 4,2,1,6->5; 4,2,1,6->7; 4,2,1,6->8; 4,2,1,6->9; 3->10; 6->11; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.cn asc range floor(ow_sale.pn)::integer preceding ); -- mvd 1,7->6; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn+ow_sale.prc)) OVER(partition by ow_sale.qty,ow_sale.dt,ow_sale.prc,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc range 2 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.qty/ow_sale.cn)) OVER(partition by ow_sale.qty,ow_sale.dt,ow_sale.prc,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc range 2 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn-ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.prc,ow_sale.vn,ow_sale.vn order by ow_sale.vn asc range 2 preceding ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc); -- mvd 6,1,2,7->5; 6,1,2,7->8; 6,1,2,7->9; 6,1,2,7->10; 2->11; 3,1,13->12; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.cn asc range current row ); -- mvd 1,3->4; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.qty*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.pn desc range current row ),
win2 as (order by ow_sale.ord, ow_sale.cn desc),
win3 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.pn asc); -- mvd 5,2,7->6; 2->8; 5,2,7->9; 3,7->10; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.prc),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.vn desc range between unbounded preceding and 0 preceding ); -- mvd 3->2; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc-ow_sale.qty)) OVER(partition by ow_sale.cn,ow_sale.dt order by ow_sale.cn asc range between unbounded preceding and 2 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.dt order by ow_sale.cn asc range between unbounded preceding and 2 preceding ),
win2 as (order by ow_sale.pn asc); -- mvd 3,1->2; 3,1->4; 6->5; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.vn order by ow_sale.cn desc range between unbounded preceding and current row ); -- mvd 1,5,2,6->4; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.qty,ow_sale.dt,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn+ow_sale.pn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.cn-ow_sale.pn) as int),cast (floor(ow_sale.cn/ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn*ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.prc,ow_sale.pn order by ow_sale.pn asc range between unbounded preceding and current row ),
win2 as (partition by ow_sale.dt,ow_sale.dt order by ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.vn asc),
win4 as (order by ow_sale.ord, ow_sale.vn asc); -- mvd 6,2,7->5; 9,3->8; 1->10; 1->11; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.qty,ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc order by ow_sale.cn desc range between unbounded preceding and floor(ow_sale.prc*ow_sale.cn)::integer following ); -- mvd 8,2,1->7; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.prc-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn/ow_sale.pn)) OVER(partition by ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.cn desc range between unbounded preceding and 1 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty/ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.pn order by ow_sale.cn desc range between unbounded preceding and 1 following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.cn desc); -- mvd 2,4,1->3; 2,4,1->5; 2->6; 2,4,8,1->7; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.qty+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.vn desc range between unbounded preceding and unbounded following ); -- mvd 3,4->2; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.prc,ow_sale.vn,ow_sale.prc order by ow_sale.vn desc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.pn order by ow_sale.pn asc),
win3 as (order by ow_sale.cn asc); -- mvd 3,4,1->2; 6->5; 6->7; 9->8; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn-ow_sale.cn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.dt,ow_sale.dt order by ow_sale.pn desc range between floor(ow_sale.qty/ow_sale.vn)::integer preceding and floor(ow_sale.vn)::integer preceding ); -- mvd 5,2,7->6; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.pn)) OVER(partition by ow_sale.vn,ow_sale.prc,ow_sale.cn order by ow_sale.cn asc range between 4 preceding and 0 preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.prc,ow_sale.cn order by ow_sale.cn asc range between 4 preceding and 0 preceding ); -- mvd 3,4,5->2; 3,4,5->6; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.qty,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn*ow_sale.prc),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.vn desc range between 2 preceding and current row ); -- mvd 7,4,1->6; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty-ow_sale.pn),floor(ow_sale.pn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn-ow_sale.qty)) OVER(order by ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn/ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.cn,ow_sale.vn order by ow_sale.pn desc range between 4 preceding and current row ),
win2 as (order by ow_sale.vn desc),
win3 as (partition by ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc); -- mvd 7,2,8,1,9->6; 1->10; 1->11; 7,2,9->12; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty,ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.qty order by ow_sale.pn desc range between floor(ow_sale.vn)::integer preceding and 3 following ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.cn asc); -- mvd 3,4,5,1->2; 3,1->6; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty+ow_sale.pn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn order by ow_sale.pn desc range between 3 preceding and unbounded following ); -- mvd 6,3->5; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.dt,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.prc/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn asc range between current row and current row ); -- mvd 6,2->5; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.cn desc range between current row and floor(ow_sale.vn)::integer following ); -- mvd 3,4->2; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty+ow_sale.prc),floor(ow_sale.cn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.cn order by ow_sale.cn asc range between current row and 3 following ),
win2 as (partition by ow_sale.vn order by ow_sale.pn asc),
win3 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.cn desc); -- mvd 2,1,4->3; 4,6->5; 2,4->7; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.cn asc range between current row and unbounded following ); -- mvd 1,3,2->4; 

-- CORR() function with partition by and order by having range based framing clause in combination with other functions--

SELECT ow_sale.qty,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.vn),floor(ow_sale.pn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(partition by ow_sale.dt order by ow_sale.cn desc range between current row and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.cn desc range between current row and unbounded following ),
win2 as (partition by ow_sale.cn order by ow_sale.vn asc); -- mvd 3,5->4; 3,5->6; 3,2->7; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn*ow_sale.vn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.cn,ow_sale.pn order by ow_sale.cn desc range between floor(ow_sale.prc)::integer following and floor(ow_sale.prc)::integer following ); -- mvd 6,3->5; 

-- CORR() function with partition by and order by having range based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.prc),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.dt order by ow_sale.pn desc range between floor(ow_sale.cn)::integer following and unbounded following ); -- mvd 3,1,4->2; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows unbounded preceding ); -- mvd 5,6,2,7,8->4; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty-ow_sale.cn),floor(ow_sale.pn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.qty,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.dt order by ow_sale.ord, ow_sale.cn desc rows unbounded preceding ),
win2 as (order by ow_sale.pn asc),
win3 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.vn desc),
win4 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,6,7,2,1->5; 1->8; 6,2->9; 3->10; 1->11; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn asc rows floor(ow_sale.pn*ow_sale.prc) preceding ); -- mvd 3,6,1->5; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.vn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc rows 1 preceding ),
win2 as (order by ow_sale.vn asc),
win3 as (order by ow_sale.vn asc); -- mvd 7,4,8,5,1->6; 3->9; 3->10; 3->11; 7,4,8,5,1->12; 3->13; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc rows current row ); -- mvd 1,8->7; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty-ow_sale.vn)) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.pn asc rows current row ),
win2 as (partition by ow_sale.pn order by ow_sale.vn desc),
win3 as (order by ow_sale.pn desc); -- mvd 1,2->5; 7,2->6; 2->8; 2->9; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.prc+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.vn asc rows between unbounded preceding and 2 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.vn)) OVER(partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.vn asc rows between unbounded preceding and 2 preceding ),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn desc,ow_sale.vn asc rows between unbounded preceding and 2 preceding ),
win2 as (order by ow_sale.vn asc),
win3 as (order by ow_sale.cn asc); -- mvd 4,2->3; 4,2->5; 4,2->6; 2->7; 2->8; 4->9; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.pn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc rows between unbounded preceding and current row ); -- mvd 3,4,5,1->2; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty/ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.qty,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(partition by ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.dt,ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.dt,ow_sale.dt order by ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.pn asc rows between unbounded preceding and current row ),
win2 as (partition by ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.dt,ow_sale.vn,ow_sale.dt,ow_sale.dt order by ow_sale.cn asc); -- mvd 3,4,5,6,1->2; 3,5->7; 3,4,5->8; 3,5->9; 3,5->10; 3,4,5->11; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn-ow_sale.vn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.qty,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn desc,ow_sale.pn desc rows between unbounded preceding and 2 following ); -- mvd 5,6,1,2,7->4; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty/ow_sale.vn)) OVER(partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn desc rows between unbounded preceding and 3 following ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn asc,ow_sale.pn desc rows between unbounded preceding and 3 following ); -- mvd 4,5,1->3; 4,5,1->6; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.vn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.pn,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and unbounded following ); -- mvd 5,6,3,1,7->4; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn-ow_sale.pn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.cn asc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.dt order by ow_sale.cn desc),
win3 as (order by ow_sale.vn asc); -- mvd 2,1,4,5->3; 7,2,1,5->6; 7,2,1,5->8; 4->9; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.pn desc rows between floor(ow_sale.cn) preceding and floor(ow_sale.qty) preceding ); -- mvd 3,4->2; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn,ow_sale.dt,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc rows between floor(ow_sale.cn*ow_sale.pn) preceding and 3 preceding ); -- mvd 3,1,4->2; 3,1,4->5; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.vn asc rows between 5 preceding and current row ); -- mvd 3,6->7; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.vn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn+ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.qty) as int),cast (floor(ow_sale.pn-ow_sale.pn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc rows between 1 preceding and current row ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.vn desc); -- mvd 3,1,4->7; 4->8; 3->9; 4->10; 1->11; 1->12; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.qty,ow_sale.vn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.vn),floor(ow_sale.vn+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.prc,ow_sale.qty order by ow_sale.ord, ow_sale.pn asc rows between floor(ow_sale.prc) preceding and 6 following ); -- mvd 8,4,1->7; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn-ow_sale.qty),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn+ow_sale.prc) as int),cast (floor(ow_sale.qty+ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn*ow_sale.vn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.cn)) OVER(partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between floor(ow_sale.cn) preceding and floor(ow_sale.cn+ow_sale.vn) following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.vn,ow_sale.vn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc rows between floor(ow_sale.cn) preceding and floor(ow_sale.cn+ow_sale.vn) following ),
win2 as (partition by ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.dt order by ow_sale.cn desc),
win3 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc),
win4 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.ord, ow_sale.vn asc); -- mvd 1,2,6->5; 1,8,2,6->7; 8,2,10->9; 10,2->11; 1,2,6->12; 10,2->13; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.vn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc,ow_sale.pn desc rows between 0 preceding and unbounded following ); -- mvd 4,2,5->3; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc-ow_sale.pn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.pn,ow_sale.cn order by ow_sale.ord, ow_sale.vn desc rows between current row and current row ); -- mvd 1,4,5->3; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty/ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.pn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc rows between current row and current row ),
win2 as (partition by ow_sale.dt order by ow_sale.ord, ow_sale.cn asc); -- mvd 5,2,1->4; 5,7->6; 5,7->8; 5,2,1->9; 5,7->10; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.prc+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.qty order by ow_sale.ord, ow_sale.cn asc,ow_sale.cn asc,ow_sale.pn asc rows between current row and 7 following ); -- mvd 5,6,2->4; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.qty),floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.vn,ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn asc rows between current row and 3 following ),
win2 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.prc,ow_sale.qty,ow_sale.dt order by ow_sale.cn asc); -- mvd 1,3,4->2; 1,3,4->5; 7,1,3,8,4,9->6; 7,1,3,8,4,9->10; 1,3,4->11; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.qty,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.dt,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.cn desc,ow_sale.vn asc rows between current row and unbounded following ); -- mvd 6,7,8,4->5; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(CORR(floor(ow_sale.pn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc+ow_sale.prc) as int),cast (floor(ow_sale.vn*ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.prc,ow_sale.pn,ow_sale.vn,ow_sale.dt order by ow_sale.ord, ow_sale.pn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (order by ow_sale.ord, ow_sale.pn asc); -- mvd 3,4,5,1->2; 7->6; 7->8; 3,4,5,1->9; 1->10; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn desc,ow_sale.cn asc rows between floor(ow_sale.pn/ow_sale.qty) following and floor(ow_sale.vn*ow_sale.vn) following ); -- mvd 2,3,1->5; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty, TO_CHAR(COALESCE(CORR(floor(ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.prc)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc rows between 2 following and floor(ow_sale.pn) following ),
win2 as (order by ow_sale.pn desc),
win3 as (order by ow_sale.cn asc); -- mvd 5,6->4; 6->7; 5,6->8; 6->9; 1->10; 

-- CORR() function with partition by and order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.prc/ow_sale.pn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.cn,ow_sale.pn,ow_sale.pn,ow_sale.dt order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.prc) following and unbounded following ); -- mvd 4,5,1,6,7->3; 

-- CORR() function with partition by and order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(CORR(floor(ow_sale.vn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.vn order by ow_sale.ord, ow_sale.cn asc rows between 3 following and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.cn,ow_sale.qty order by ow_sale.ord, ow_sale.pn desc); -- mvd 1,2,5->4; 1,2,5->6; 8,1,9,2,10->7; 

-- COVAR_POP() function with NULL OVER() clause --

SELECT ow_sale.prc,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (); -- mvd 4->4; 

-- COVAR_POP() function with NULL OVER() clause in combination with other window functions --

SELECT ow_sale.dt,ow_sale.cn,ow_sale.vn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn+ow_sale.pn),floor(ow_sale.qty-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
,
TO_CHAR(COALESCE(MIN(floor(ow_sale.pn-ow_sale.prc)) OVER(),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (),
win2 as (order by ow_sale.cn asc); -- mvd 6->6; 6->7; 2->8; 

-- COVAR_POP() function with OVER() clause having ONLY PARTITION BY --

SELECT ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.prc/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (partition by ow_sale.qty,ow_sale.cn); -- mvd 1,3->2; 

-- COVAR_POP() function with OVER() clause having ONLY PARTITION BY in combination with other window functions --

SELECT ow_sale.cn,ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn-ow_sale.vn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt
,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(partition by ow_sale.cn,ow_sale.prc,ow_sale.dt,ow_sale.cn),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (partition by ow_sale.cn,ow_sale.prc,ow_sale.dt,ow_sale.cn); -- mvd 5,6,1->4; 5,6,1->7; 

-- COVAR_POP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) --

SELECT ow_sale.qty, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn*ow_sale.cn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc,ow_sale.pn desc,ow_sale.cn asc); -- mvd 3,4->2; 

-- COVAR_POP() function with OVER() clause having ONLY ORDER BY ASC/DESC (without framing) in combination with other window functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn-ow_sale.pn)) OVER(order by ow_sale.cn asc,ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.cn asc,ow_sale.vn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc)) OVER(order by ow_sale.cn asc,ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc,ow_sale.vn desc); -- mvd 3,4->2; 3,4->5; 3,4->6; 3,4->7; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty/ow_sale.cn),floor(ow_sale.cn*ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range unbounded preceding ); -- mvd 1->3; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn),floor(ow_sale.vn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn-ow_sale.pn) as int),cast (floor(ow_sale.prc+ow_sale.cn) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.prc+ow_sale.pn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc/ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range unbounded preceding ),
win2 as (partition by ow_sale.pn,ow_sale.cn,ow_sale.cn order by ow_sale.pn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc),
win4 as (partition by ow_sale.dt,ow_sale.cn,ow_sale.prc,ow_sale.cn,ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc); -- mvd 5->4; 7,5->6; 7->8; 7,5->9; 11,7,12,3->10; 7,5->13; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn/ow_sale.pn),floor(ow_sale.pn-ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range 3 preceding ); -- mvd 3->2; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn+ow_sale.prc),floor(ow_sale.prc-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty-ow_sale.vn)) OVER(order by ow_sale.vn desc range floor(ow_sale.cn)::integer preceding ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range floor(ow_sale.cn)::integer preceding ),
win2 as (order by ow_sale.cn desc); -- mvd 4->3; 2->5; 2->6; 4->7; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.prc),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range current row ); -- mvd 3->4; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.vn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.cn,ow_sale.pn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range current row ),
win2 as (partition by ow_sale.cn,ow_sale.dt,ow_sale.pn order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 1->4; 1->5; 7,8,9->6; 8->10; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.qty,ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.prc-ow_sale.prc),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between unbounded preceding and 2 preceding ),
win2 as (order by ow_sale.pn asc); -- mvd 5->7; 3->8; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn),floor(ow_sale.cn+ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and current row ); -- mvd 1->4; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn+ow_sale.pn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn-ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and current row ); -- mvd 3->2; 3->4; 3->5; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn-ow_sale.cn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between unbounded preceding and 0 following ); -- mvd 4->3; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.pn-ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty-ow_sale.qty) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win4),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.cn*ow_sale.pn) as int),NULL) OVER(win5),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between unbounded preceding and 4 following ),
win2 as (order by ow_sale.ord, ow_sale.pn asc),
win3 as (order by ow_sale.ord, ow_sale.pn desc),
win4 as (order by ow_sale.cn asc),
win5 as (partition by ow_sale.pn order by ow_sale.ord, ow_sale.pn asc); -- mvd 3->4; 1->5; 1->6; 8->7; 1->9; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.vn,ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn+ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between unbounded preceding and unbounded following ); -- mvd 3->7; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.vn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn-ow_sale.vn),floor(ow_sale.pn-ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.qty+ow_sale.prc) as int),NULL) OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty*ow_sale.cn) as int),cast (floor(ow_sale.prc+ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty/ow_sale.pn) as int),cast (floor(ow_sale.prc+ow_sale.vn) as int),NULL) OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(order by ow_sale.ord, ow_sale.cn asc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.prc,ow_sale.pn,ow_sale.pn order by ow_sale.ord, ow_sale.pn asc),
win3 as (partition by ow_sale.dt,ow_sale.qty,ow_sale.pn,ow_sale.qty,ow_sale.pn order by ow_sale.ord, ow_sale.vn desc),
win4 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 5->6; 8,9,5->7; 9,3,11,5->10; 8,9,5->12; 1->13; 1->14; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.prc, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 2 preceding and floor(ow_sale.cn)::integer preceding ); -- mvd 3->2; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,ow_sale.vn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 3 preceding and 4 preceding ),
win2 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.vn,ow_sale.dt order by ow_sale.vn asc),
win3 as (order by ow_sale.cn desc); -- mvd 1->2; 1->3; 5,6,1->4; 8->7; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn*ow_sale.cn),floor(ow_sale.vn/ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between floor(ow_sale.pn)::integer preceding and current row ); -- mvd 3->2; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.dt,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty+ow_sale.prc)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.vn desc range between 3 preceding and current row ); -- mvd 2->5; 2->6; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.vn,ow_sale.prc,ow_sale.prc, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn),floor(ow_sale.prc-ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.qty*ow_sale.prc)::integer preceding and floor(ow_sale.cn/ow_sale.cn)::integer following ); -- mvd 2->6; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.qty+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.vn,ow_sale.qty order by ow_sale.pn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between floor(ow_sale.cn/ow_sale.qty)::integer preceding and floor(ow_sale.vn+ow_sale.pn)::integer following ),
win2 as (partition by ow_sale.vn,ow_sale.qty order by ow_sale.pn desc); -- mvd 3->2; 5,3,6->4; 5,3,6->7; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between floor(ow_sale.cn)::integer preceding and unbounded following ); -- mvd 6->5; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.cn-ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.vn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between floor(ow_sale.pn)::integer preceding and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.vn order by ow_sale.vn desc),
win3 as (partition by ow_sale.vn order by ow_sale.ord, ow_sale.pn desc); -- mvd 4->3; 4,6->5; 6,8->7; 4->9; 4->10; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between current row and current row ); -- mvd 3->2; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.prc,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn),floor(ow_sale.pn*ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.vn) as int),cast (floor(ow_sale.qty+ow_sale.vn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.dt,ow_sale.pn,
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(partition by ow_sale.pn,ow_sale.dt order by ow_sale.cn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.prc*ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between current row and current row ),
win2 as (order by ow_sale.ord, ow_sale.cn asc),
win3 as (partition by ow_sale.pn,ow_sale.dt order by ow_sale.cn asc),
win4 as (order by ow_sale.ord, ow_sale.cn desc); -- mvd 5->4; 2->6; 2,8,9->7; 2->10; 2,8,9->11; 2->12; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn+ow_sale.vn),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.prc) as int),cast (floor(ow_sale.prc+ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.cn,ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.pn desc range between current row and floor(ow_sale.pn/ow_sale.qty)::integer following ),
win2 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.pn desc),
win3 as (partition by ow_sale.dt,ow_sale.vn,ow_sale.cn,ow_sale.cn order by ow_sale.ord, ow_sale.pn desc),
win4 as (order by ow_sale.cn asc); -- mvd 2->3; 5,2->4; 7,8,5,2->6; 5,2->9; 7->10; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.vn,ow_sale.cn,ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between current row and unbounded following ); -- mvd 1->7; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.qty,ow_sale.pn,ow_sale.pn,ow_sale.pn,ow_sale.dt, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.cn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(RANK() OVER(partition by ow_sale.prc order by ow_sale.cn desc),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between current row and unbounded following ),
win2 as (partition by ow_sale.prc order by ow_sale.cn desc); -- mvd 8->7; 10,8->9; 10,8->11; 10,8->12; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.cn,ow_sale.dt,ow_sale.prc, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_vendor WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.cn desc range between 1 following and 0 following ); -- mvd 1->4; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn,ow_sale.prc,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn*ow_sale.pn),floor(ow_sale.qty/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn+ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.qty/ow_sale.cn)) OVER(order by ow_sale.pn asc range between 2 following and 2 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(CUME_DIST() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.pn asc range between 2 following and 2 following ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.prc,ow_sale.dt,ow_sale.prc,ow_sale.prc,ow_sale.pn order by ow_sale.pn desc),
win4 as (order by ow_sale.vn desc); -- mvd 7->6; 7->8; 7->9; 2->10; 3,12,7->11; 14->13; 

-- COVAR_POP() function with ONLY order by having range based framing clause --

SELECT ow_sale.qty, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn+ow_sale.vn),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.vn asc range between 4 following and unbounded following ); -- mvd 3->2; 

-- COVAR_POP() function with ONLY order by having range based framing clause in combination with other functions --

SELECT ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.prc/ow_sale.vn),floor(ow_sale.pn+ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),ow_sale.prc,ow_sale.dt,ow_sale.qty,ow_sale.pn,
TO_CHAR(COALESCE(MIN(floor(ow_sale.cn)) OVER(order by ow_sale.cn asc range between floor(ow_sale.cn)::integer following and unbounded following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.cn asc range between floor(ow_sale.cn)::integer following and unbounded following ),
win2 as (partition by ow_sale.cn,ow_sale.pn,ow_sale.qty,ow_sale.dt,ow_sale.prc order by ow_sale.cn asc),
win3 as (order by ow_sale.vn desc); -- mvd 3->2; 3->4; 6,7,3,8,9->5; 3->10; 1->11; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.prc+ow_sale.prc),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.pn asc rows unbounded preceding ); -- mvd 1,3,4->2; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.dt,ow_sale.vn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn-ow_sale.vn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn desc,ow_sale.pn asc rows unbounded preceding ),
win2 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 3,5->4; 3->6; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.prc,ow_sale.pn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty-ow_sale.pn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.cn desc,ow_sale.cn asc rows floor(ow_sale.pn+ow_sale.vn) preceding ); -- mvd 5->4; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.cn,ow_sale.qty,ow_sale.qty, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn-ow_sale.pn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows 3 preceding ),
win2 as (order by ow_sale.cn desc); -- mvd 2->5; 2->6; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn),floor(ow_sale.prc*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn asc,ow_sale.vn desc,ow_sale.pn asc rows current row ); -- mvd 3,4,5->2; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.qty,ow_sale.dt, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.cn),floor(ow_sale.pn+ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty/ow_sale.cn) as int),cast (floor(ow_sale.cn) as int),NULL) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.qty) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win4),0),'99999999.9999999'),ow_sale.pn,
TO_CHAR(COALESCE(PERCENT_RANK() OVER(order by ow_sale.ord, ow_sale.vn desc),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.cn asc rows current row ),
win2 as (order by ow_sale.ord, ow_sale.vn desc),
win3 as (partition by ow_sale.vn,ow_sale.vn order by ow_sale.ord, ow_sale.vn desc),
win4 as (order by ow_sale.pn asc); -- mvd 1,5->4; 5->6; 5->7; 9->8; 5->10; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and floor(ow_sale.cn+ow_sale.cn) preceding ); -- mvd 5->4; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.pn,ow_sale.qty, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn asc,ow_sale.vn asc rows between unbounded preceding and 1 preceding ),
win2 as (partition by ow_sale.dt,ow_sale.pn order by ow_sale.cn desc),
win3 as (partition by ow_sale.qty,ow_sale.dt,ow_sale.dt,ow_sale.qty order by ow_sale.cn asc); -- mvd 7->6; 1,9,4->8; 1,9,3->10; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty-ow_sale.prc),floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product WHERE ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between unbounded preceding and current row ); -- mvd 4->3; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.dt,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn+ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc,ow_sale.pn asc rows between unbounded preceding and current row ); -- mvd 5,1->4; 5,1->6; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn*ow_sale.cn),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between unbounded preceding and 4 following ); -- mvd 4->3; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.prc,ow_sale.vn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.prc/ow_sale.vn),floor(ow_sale.vn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(MIN(floor(ow_sale.vn*ow_sale.pn)) OVER(order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc rows between unbounded preceding and 0 following ),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win3),0),'99999999.9999999'),ow_sale.qty
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc rows between unbounded preceding and 0 following ),
win2 as (order by ow_sale.cn desc),
win3 as (partition by ow_sale.qty,ow_sale.vn,ow_sale.qty order by ow_sale.cn asc); -- mvd 1,5->6; 1,5->7; 4->8; 4,1,10->9; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.dt,ow_sale.prc,ow_sale.dt, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn-ow_sale.qty),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_vendor WHERE ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc rows between unbounded preceding and unbounded following ); -- mvd 5,6->4; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn-ow_sale.vn),floor(ow_sale.pn*ow_sale.vn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.qty)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.vn asc,ow_sale.vn desc rows between unbounded preceding and unbounded following ),
win2 as (partition by ow_sale.dt,ow_sale.dt,ow_sale.cn,ow_sale.vn order by ow_sale.cn asc); -- mvd 2->6; 2->7; 3,9,2->8; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.pn,ow_sale.pn,ow_sale.dt,ow_sale.cn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between 2 preceding and floor(ow_sale.cn) preceding ),
win2 as (order by ow_sale.cn desc); -- mvd 6->7; 4->8; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty+ow_sale.qty),floor(ow_sale.pn/ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between 1 preceding and current row ); -- mvd 4->3; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.vn),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.cn-ow_sale.prc)) OVER(order by ow_sale.ord, ow_sale.pn asc rows between 4 preceding and current row ),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc rows between 4 preceding and current row ); -- mvd 2->3; 2->4; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.prc,ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty+ow_sale.prc),floor(ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc rows between floor(ow_sale.vn) preceding and floor(ow_sale.cn+ow_sale.vn) following ); -- mvd 3->5; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty+ow_sale.pn),floor(ow_sale.pn*ow_sale.cn)) OVER(win1),0),'99999999.9999999'),ow_sale.vn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.vn asc,ow_sale.pn desc rows between 1 preceding and unbounded following ); -- mvd 3,1->2; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.qty,ow_sale.cn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.cn*ow_sale.prc)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999'),ow_sale.vn,ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer WHERE ow_sale_ord.cn=ow_customer.cn ) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.cn desc rows between 0 preceding and unbounded following ),
win2 as (order by ow_sale.cn asc),
win3 as (partition by ow_sale.pn order by ow_sale.vn asc); -- mvd 2->3; 2->4; 6,7->5; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.cn,ow_sale.vn,ow_sale.dt, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.prc),floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),ow_sale.pn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_customer,ow_product WHERE ow_sale_ord.cn=ow_customer.cn AND ow_sale_ord.pn=ow_product.pn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn asc,ow_sale.cn desc rows between current row and current row ); -- mvd 1,5->4; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.prc+ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn*ow_sale.vn)) OVER(order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc rows between current row and current row ),0),'99999999.9999999'),
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LEAD(cast(floor(ow_sale.pn) as int),cast (floor(ow_sale.cn+ow_sale.prc) as int),NULL) OVER(win3),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn*ow_sale.qty)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn asc rows between current row and current row ),
win2 as (partition by ow_sale.vn,ow_sale.dt order by ow_sale.cn desc),
win3 as (order by ow_sale.ord, ow_sale.cn asc); -- mvd 5,3->4; 5,3->6; 1,8,5->7; 1->9; 5,3->10; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.cn,ow_sale.cn,ow_sale.qty,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn*ow_sale.qty),floor(ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.pn desc,ow_sale.pn asc,ow_sale.vn desc rows between current row and 8 following ); -- mvd 1,5->6; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.pn,ow_sale.vn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty),floor(ow_sale.prc)) OVER(win1),0),'99999999.9999999'),ow_sale.cn,
TO_CHAR(COALESCE(RANK() OVER(win2),0),'99999999.9999999'),ow_sale.dt,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.qty*ow_sale.vn) as int),cast (floor(ow_sale.cn*ow_sale.pn) as int),NULL) OVER(win3),0),'99999999.9999999'),ow_sale.prc,
TO_CHAR(COALESCE(CUME_DIST() OVER(win4),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(DENSE_RANK() OVER(win3),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor,ow_customer WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn AND ow_sale_ord.cn=ow_customer.cn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.cn desc rows between current row and 0 following ),
win2 as (partition by ow_sale.pn,ow_sale.dt,ow_sale.qty,ow_sale.dt order by ow_sale.vn asc),
win3 as (partition by ow_sale.pn,ow_sale.pn,ow_sale.cn,ow_sale.prc,ow_sale.prc order by ow_sale.ord, ow_sale.cn asc),
win4 as (order by ow_sale.pn asc); -- mvd 7,1->6; 9,1,4,2->8; 11,7,2->10; 2->12; 7,1->13; 11,7,2->14; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.vn,ow_sale.prc, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty*ow_sale.qty),floor(ow_sale.cn/ow_sale.vn)) OVER(win1),0),'99999999.9999999'),ow_sale.cn
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.cn asc,ow_sale.vn asc rows between current row and unbounded following ); -- mvd 4,1->3; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.cn,ow_sale.cn,ow_sale.pn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.qty/ow_sale.pn),floor(ow_sale.qty-ow_sale.qty)) OVER(win1),0),'99999999.9999999'),ow_sale.vn,
TO_CHAR(COALESCE(ROW_NUMBER() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(RANK() OVER(win3),0),'99999999.9999999'),ow_sale.qty,
TO_CHAR(COALESCE(LAG(cast(floor(ow_sale.cn) as int),cast (floor(ow_sale.qty) as int),NULL) OVER(win4),0),'99999999.9999999'),ow_sale.dt
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc rows between current row and unbounded following ),
win2 as (order by ow_sale.vn asc),
win3 as (partition by ow_sale.qty,ow_sale.qty,ow_sale.vn,ow_sale.qty order by ow_sale.vn asc),
win4 as (partition by ow_sale.vn,ow_sale.pn,ow_sale.cn,ow_sale.dt,ow_sale.dt,ow_sale.vn order by ow_sale.ord, ow_sale.cn desc); -- mvd 5->4; 5->6; 5,8->7; 10,1,5,3->9; 

-- COVAR_POP() function with ONLY order by having rows based framing clause --

SELECT ow_sale.qty,ow_sale.pn,ow_sale.qty,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn/ow_sale.qty),floor(ow_sale.pn-ow_sale.cn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord,ow_product,ow_vendor WHERE ow_sale_ord.pn=ow_product.pn AND ow_sale_ord.vn=ow_vendor.vn) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn asc,ow_sale.pn desc,ow_sale.pn desc rows between floor(ow_sale.pn+ow_sale.cn) following and floor(ow_sale.vn+ow_sale.cn) following ); -- mvd 4,2->5; 

-- COVAR_POP() function with ONLY order by having rows based framing clause in combination with other functions --

SELECT ow_sale.vn,ow_sale.vn, TO_CHAR(COALESCE(COVAR_POP(floor(ow_sale.pn),floor(ow_sale.cn+ow_sale.pn)) OVER(win1),0),'99999999.9999999'),
TO_CHAR(COALESCE(PERCENT_RANK() OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.pn)) OVER(order by ow_sale.vn asc),0),'99999999.9999999'),
TO_CHAR(COALESCE(COUNT(floor(ow_sale.vn/ow_sale.cn)) OVER(win2),0),'99999999.9999999'),
TO_CHAR(COALESCE(MAX(floor(ow_sale.vn)) OVER(win1),0),'99999999.9999999')
FROM (SELECT ow_sale_ord.* FROM ow_sale_ord) ow_sale
WINDOW win1 as (order by ow_sale.ord, ow_sale.vn desc,ow_sale.vn desc rows between 4 following and 3 following ),
win2 as (order by ow_sale.vn asc); -- mvd 1->3; 1->4