/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.rel.TableDTO;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.dto.requests.AddPartitionsRequest;
import org.apache.gravitino.dto.responses.DropResponse;
import org.apache.gravitino.dto.responses.PartitionListResponse;
import org.apache.gravitino.dto.responses.PartitionNameListResponse;
import org.apache.gravitino.dto.responses.PartitionResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.exceptions.NoSuchPartitionException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.PartitionAlreadyExistsException;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;
import org.apache.gravitino.rel.partitions.Partition;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.rest.RESTUtils;
import org.apache.gravitino.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.gravitino.shaded.com.google.common.base.Joiner;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class RelationalTable
implements Table,
SupportsPartitions,
SupportsTags {
    private static final Joiner DOT_JOINER = Joiner.on(".");
    private final Table table;
    private final RESTClient restClient;
    private final Namespace namespace;
    private final MetadataObjectTagOperations objectTagOperations;

    static RelationalTable from(Namespace namespace, TableDTO tableDTO, RESTClient restClient) {
        return new RelationalTable(namespace, tableDTO, restClient);
    }

    private RelationalTable(Namespace namespace, TableDTO tableDTO, RESTClient restClient) {
        this.namespace = namespace;
        this.restClient = restClient;
        this.table = DTOConverters.fromDTO(tableDTO);
        MetadataObject tableObject = MetadataObjects.parse(RelationalTable.tableFullName(namespace, tableDTO.name()), MetadataObject.Type.TABLE);
        this.objectTagOperations = new MetadataObjectTagOperations(namespace.level(0), tableObject, restClient);
    }

    @Override
    public String name() {
        return this.table.name();
    }

    @Override
    public Column[] columns() {
        return this.table.columns();
    }

    @Override
    public Transform[] partitioning() {
        return this.table.partitioning();
    }

    @Override
    public SortOrder[] sortOrder() {
        return this.table.sortOrder();
    }

    @Override
    public Distribution distribution() {
        return this.table.distribution();
    }

    @Override
    @Nullable
    public String comment() {
        return this.table.comment();
    }

    @Override
    public Map<String, String> properties() {
        return this.table.properties();
    }

    @Override
    public Audit auditInfo() {
        return this.table.auditInfo();
    }

    @Override
    public Index[] index() {
        return this.table.index();
    }

    @Override
    public String[] listPartitionNames() {
        PartitionNameListResponse resp = this.restClient.get(this.getPartitionRequestPath(), PartitionNameListResponse.class, Collections.emptyMap(), ErrorHandlers.partitionErrorHandler());
        return resp.partitionNames();
    }

    @VisibleForTesting
    String getPartitionRequestPath() {
        return "api/metalakes/" + this.namespace.level(0) + "/catalogs/" + this.namespace.level(1) + "/schemas/" + this.namespace.level(2) + "/tables/" + this.name() + "/partitions";
    }

    @Override
    public Partition[] listPartitions() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("details", "true");
        PartitionListResponse resp = this.restClient.get(this.getPartitionRequestPath(), params, PartitionListResponse.class, Collections.emptyMap(), ErrorHandlers.partitionErrorHandler());
        return resp.getPartitions();
    }

    @Override
    public Partition getPartition(String partitionName) throws NoSuchPartitionException {
        PartitionResponse resp = this.restClient.get(RelationalTable.formatPartitionRequestPath(this.getPartitionRequestPath(), partitionName), PartitionResponse.class, Collections.emptyMap(), ErrorHandlers.partitionErrorHandler());
        return resp.getPartition();
    }

    @Override
    public Partition addPartition(Partition partition) throws PartitionAlreadyExistsException {
        AddPartitionsRequest req = new AddPartitionsRequest(new PartitionDTO[]{DTOConverters.toDTO(partition)});
        req.validate();
        PartitionListResponse resp = this.restClient.post(this.getPartitionRequestPath(), (RESTRequest)req, PartitionListResponse.class, Collections.emptyMap(), ErrorHandlers.partitionErrorHandler());
        resp.validate();
        return resp.getPartitions()[0];
    }

    @Override
    public boolean dropPartition(String partitionName) {
        DropResponse resp = this.restClient.delete(RelationalTable.formatPartitionRequestPath(this.getPartitionRequestPath(), partitionName), DropResponse.class, Collections.emptyMap(), ErrorHandlers.partitionErrorHandler());
        resp.validate();
        return resp.dropped();
    }

    @Override
    public SupportsPartitions supportPartitions() throws UnsupportedOperationException {
        return this;
    }

    @VisibleForTesting
    protected static String formatPartitionRequestPath(String prefix, String partitionName) {
        return prefix + "/" + RESTUtils.encodeString(partitionName);
    }

    @Override
    public SupportsTags supportsTags() {
        return this;
    }

    private static String tableFullName(Namespace tableNS, String tableName) {
        return DOT_JOINER.join(tableNS.level(1), tableNS.level(2), tableName);
    }

    @Override
    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    @Override
    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    @Override
    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    @Override
    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }
}

