/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import org.apache.commons.net.DatagramSocketClient;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPRequestPacket;

public class TFTP
extends DatagramSocketClient {
    public static final int ASCII_MODE = 0;
    public static final int NETASCII_MODE = 0;
    public static final int BINARY_MODE = 1;
    public static final int IMAGE_MODE = 1;
    public static final int OCTET_MODE = 1;
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_PORT = 69;
    static final int PACKET_SIZE = 516;
    private byte[] receiveBuffer;
    private DatagramPacket receiveDatagram;
    private DatagramPacket sendDatagram;
    byte[] sendBuffer;

    public static final String getModeName(int mode) {
        return TFTPRequestPacket.modeStrings[mode];
    }

    public TFTP() {
        this.setDefaultTimeout(5000);
        this.receiveBuffer = null;
        this.receiveDatagram = null;
    }

    public final void discardPackets() throws IOException {
        DatagramPacket datagram = new DatagramPacket(new byte[516], 516);
        int to = this.getSoTimeout();
        this.setSoTimeout(1);
        try {
            while (true) {
                this._socket_.receive(datagram);
            }
        }
        catch (InterruptedIOException | SocketException iOException) {
            this.setSoTimeout(to);
            return;
        }
    }

    public final TFTPPacket bufferedReceive() throws IOException, InterruptedIOException, SocketException, TFTPPacketException {
        this.receiveDatagram.setData(this.receiveBuffer);
        this.receiveDatagram.setLength(this.receiveBuffer.length);
        this._socket_.receive(this.receiveDatagram);
        TFTPPacket newTFTPPacket = TFTPPacket.newTFTPPacket(this.receiveDatagram);
        this.trace("<", newTFTPPacket);
        return newTFTPPacket;
    }

    public final void bufferedSend(TFTPPacket packet) throws IOException {
        this.trace(">", packet);
        this._socket_.send(packet.newDatagram(this.sendDatagram, this.sendBuffer));
    }

    public final void beginBufferedOps() {
        this.receiveBuffer = new byte[516];
        this.receiveDatagram = new DatagramPacket(this.receiveBuffer, this.receiveBuffer.length);
        this.sendBuffer = new byte[516];
        this.sendDatagram = new DatagramPacket(this.sendBuffer, this.sendBuffer.length);
    }

    public final void endBufferedOps() {
        this.receiveBuffer = null;
        this.receiveDatagram = null;
        this.sendBuffer = null;
        this.sendDatagram = null;
    }

    public final void send(TFTPPacket packet) throws IOException {
        this.trace(">", packet);
        this._socket_.send(packet.newDatagram());
    }

    public final TFTPPacket receive() throws IOException, InterruptedIOException, SocketException, TFTPPacketException {
        DatagramPacket packet = new DatagramPacket(new byte[516], 516);
        this._socket_.receive(packet);
        TFTPPacket newTFTPPacket = TFTPPacket.newTFTPPacket(packet);
        this.trace("<", newTFTPPacket);
        return newTFTPPacket;
    }

    protected void trace(String direction, TFTPPacket packet) {
    }
}

