/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hertzbeat.alert.config.SmsConfig;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.alert.service.impl.AlibabaSmsClientImpl;
import org.apache.hertzbeat.alert.service.impl.AwsSmsClientImpl;
import org.apache.hertzbeat.alert.service.impl.SmsLocalSmsClientImpl;
import org.apache.hertzbeat.alert.service.impl.TencentSmsClientImpl;
import org.apache.hertzbeat.alert.service.impl.TwilioSmsClientImpl;
import org.apache.hertzbeat.alert.service.impl.UniSmsClientImpl;
import org.apache.hertzbeat.base.dao.GeneralConfigDao;
import org.apache.hertzbeat.common.constants.GeneralConfigTypeEnum;
import org.apache.hertzbeat.common.entity.manager.GeneralConfig;
import org.apache.hertzbeat.common.support.event.SmsConfigChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SmsClientFactory {
    private static final Logger log = LoggerFactory.getLogger(SmsClientFactory.class);
    private static final String TYPE = GeneralConfigTypeEnum.sms.name();
    private final GeneralConfigDao generalConfigDao;
    private final ObjectMapper objectMapper;
    private final SmsConfig yamlSmsConfig;
    private volatile SmsClient currentSmsClient;

    public SmsClientFactory(GeneralConfigDao generalConfigDao, ObjectMapper objectMapper, SmsConfig yamlSmsConfig) {
        this.generalConfigDao = generalConfigDao;
        this.objectMapper = objectMapper;
        this.yamlSmsConfig = yamlSmsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={SmsConfigChangeEvent.class})
    public void onSmsConfigChange(SmsConfigChangeEvent event) {
        log.info("[SmsClientFactory] SMS configuration change event received");
        SmsClientFactory smsClientFactory = this;
        synchronized (smsClientFactory) {
            this.currentSmsClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmsClient getSmsClient() {
        if (this.currentSmsClient != null) {
            return this.currentSmsClient;
        }
        SmsClientFactory smsClientFactory = this;
        synchronized (smsClientFactory) {
            if (this.currentSmsClient != null) {
                return this.currentSmsClient;
            }
            this.loadConfig();
            return this.currentSmsClient;
        }
    }

    private void loadConfig() {
        try {
            SmsConfig dbConfig = this.loadDatabaseConfig();
            if (dbConfig != null && !dbConfig.getType().isBlank() && dbConfig.isEnable()) {
                this.createSmsClient(dbConfig);
                if (this.currentSmsClient != null) {
                    log.info("[SmsClientFactory] Using database SMS configuration, provider: {}", (Object)dbConfig.getType());
                    return;
                }
            }
            if (this.yamlSmsConfig != null && !this.yamlSmsConfig.getType().isBlank() && this.yamlSmsConfig.isEnable()) {
                this.createSmsClient(this.yamlSmsConfig);
                if (this.currentSmsClient != null) {
                    log.info("[SmsClientFactory] Using YAML SMS configuration, provider: {}", (Object)this.yamlSmsConfig.getType());
                    return;
                }
            }
            log.warn("[SmsClientFactory] No valid SMS configuration found");
        }
        catch (Exception e) {
            log.error("[SmsClientFactory] Failed to load SMS configuration", (Throwable)e);
            this.currentSmsClient = null;
        }
    }

    private SmsConfig loadDatabaseConfig() {
        try {
            GeneralConfig config = this.generalConfigDao.findByType(TYPE);
            if (config != null && config.getContent() != null) {
                return (SmsConfig)this.objectMapper.readValue(config.getContent(), SmsConfig.class);
            }
        }
        catch (Exception e) {
            log.error("[SmsClientFactory] Failed to load database configuration", (Throwable)e);
        }
        return null;
    }

    private void createSmsClient(SmsConfig smsConfig) {
        switch (smsConfig.getType()) {
            case "tencent": {
                this.currentSmsClient = new TencentSmsClientImpl(smsConfig.getTencent());
                break;
            }
            case "unisms": {
                this.currentSmsClient = new UniSmsClientImpl(smsConfig.getUnisms());
                break;
            }
            case "alibaba": {
                this.currentSmsClient = new AlibabaSmsClientImpl(smsConfig.getAlibaba());
                break;
            }
            case "smslocal": {
                this.currentSmsClient = new SmsLocalSmsClientImpl(smsConfig.getSmslocal());
                break;
            }
            case "aws": {
                this.currentSmsClient = new AwsSmsClientImpl(smsConfig.getAws());
                break;
            }
            case "twilio": {
                this.currentSmsClient = new TwilioSmsClientImpl(smsConfig.getTwilio());
                break;
            }
            default: {
                log.warn("[SmsClientFactory] Unsupported SMS provider type: {}", (Object)smsConfig.getType());
            }
        }
    }
}

