/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class AlibabaCloudSlsExternAlert {
    @JsonProperty(value="alert_instance_id")
    private String alertInstanceId;
    @JsonProperty(value="alert_id")
    private String alertId;
    @JsonProperty(value="alert_name")
    private String alertName;
    private String region;
    private String project;
    @JsonProperty(value="alert_time")
    private int alertTime;
    @JsonProperty(value="fire_time")
    private int fireTime;
    @JsonProperty(value="resolve_time")
    private int resolveTime;
    private String status;
    @JsonProperty(value="fire_results_count")
    private int fireResultsCount;
    private Map<String, String> labels;
    private Map<String, String> annotations;
    private int severity;
    @JsonProperty(value="signin_url")
    private String signinUrl;

    public String getAnnotation(String key) {
        if (null == this.annotations || this.annotations.isEmpty()) {
            return "N/A";
        }
        return this.annotations.get(key);
    }

    public static AlibabaCloudSlsExternAlertBuilder builder() {
        return new AlibabaCloudSlsExternAlertBuilder();
    }

    public String getAlertInstanceId() {
        return this.alertInstanceId;
    }

    public String getAlertId() {
        return this.alertId;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getProject() {
        return this.project;
    }

    public int getAlertTime() {
        return this.alertTime;
    }

    public int getFireTime() {
        return this.fireTime;
    }

    public int getResolveTime() {
        return this.resolveTime;
    }

    public String getStatus() {
        return this.status;
    }

    public int getFireResultsCount() {
        return this.fireResultsCount;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSigninUrl() {
        return this.signinUrl;
    }

    @JsonProperty(value="alert_instance_id")
    public void setAlertInstanceId(String alertInstanceId) {
        this.alertInstanceId = alertInstanceId;
    }

    @JsonProperty(value="alert_id")
    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    @JsonProperty(value="alert_name")
    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @JsonProperty(value="alert_time")
    public void setAlertTime(int alertTime) {
        this.alertTime = alertTime;
    }

    @JsonProperty(value="fire_time")
    public void setFireTime(int fireTime) {
        this.fireTime = fireTime;
    }

    @JsonProperty(value="resolve_time")
    public void setResolveTime(int resolveTime) {
        this.resolveTime = resolveTime;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="fire_results_count")
    public void setFireResultsCount(int fireResultsCount) {
        this.fireResultsCount = fireResultsCount;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    @JsonProperty(value="signin_url")
    public void setSigninUrl(String signinUrl) {
        this.signinUrl = signinUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlibabaCloudSlsExternAlert)) {
            return false;
        }
        AlibabaCloudSlsExternAlert other = (AlibabaCloudSlsExternAlert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAlertTime() != other.getAlertTime()) {
            return false;
        }
        if (this.getFireTime() != other.getFireTime()) {
            return false;
        }
        if (this.getResolveTime() != other.getResolveTime()) {
            return false;
        }
        if (this.getFireResultsCount() != other.getFireResultsCount()) {
            return false;
        }
        if (this.getSeverity() != other.getSeverity()) {
            return false;
        }
        String this$alertInstanceId = this.getAlertInstanceId();
        String other$alertInstanceId = other.getAlertInstanceId();
        if (this$alertInstanceId == null ? other$alertInstanceId != null : !this$alertInstanceId.equals(other$alertInstanceId)) {
            return false;
        }
        String this$alertId = this.getAlertId();
        String other$alertId = other.getAlertId();
        if (this$alertId == null ? other$alertId != null : !this$alertId.equals(other$alertId)) {
            return false;
        }
        String this$alertName = this.getAlertName();
        String other$alertName = other.getAlertName();
        if (this$alertName == null ? other$alertName != null : !this$alertName.equals(other$alertName)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Map<String, String> this$labels = this.getLabels();
        Map<String, String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$signinUrl = this.getSigninUrl();
        String other$signinUrl = other.getSigninUrl();
        return !(this$signinUrl == null ? other$signinUrl != null : !this$signinUrl.equals(other$signinUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlibabaCloudSlsExternAlert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAlertTime();
        result = result * 59 + this.getFireTime();
        result = result * 59 + this.getResolveTime();
        result = result * 59 + this.getFireResultsCount();
        result = result * 59 + this.getSeverity();
        String $alertInstanceId = this.getAlertInstanceId();
        result = result * 59 + ($alertInstanceId == null ? 43 : $alertInstanceId.hashCode());
        String $alertId = this.getAlertId();
        result = result * 59 + ($alertId == null ? 43 : $alertId.hashCode());
        String $alertName = this.getAlertName();
        result = result * 59 + ($alertName == null ? 43 : $alertName.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Map<String, String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $signinUrl = this.getSigninUrl();
        result = result * 59 + ($signinUrl == null ? 43 : $signinUrl.hashCode());
        return result;
    }

    public String toString() {
        return "AlibabaCloudSlsExternAlert(alertInstanceId=" + this.getAlertInstanceId() + ", alertId=" + this.getAlertId() + ", alertName=" + this.getAlertName() + ", region=" + this.getRegion() + ", project=" + this.getProject() + ", alertTime=" + this.getAlertTime() + ", fireTime=" + this.getFireTime() + ", resolveTime=" + this.getResolveTime() + ", status=" + this.getStatus() + ", fireResultsCount=" + this.getFireResultsCount() + ", labels=" + this.getLabels() + ", annotations=" + this.getAnnotations() + ", severity=" + this.getSeverity() + ", signinUrl=" + this.getSigninUrl() + ")";
    }

    public AlibabaCloudSlsExternAlert(String alertInstanceId, String alertId, String alertName, String region, String project, int alertTime, int fireTime, int resolveTime, String status, int fireResultsCount, Map<String, String> labels, Map<String, String> annotations, int severity, String signinUrl) {
        this.alertInstanceId = alertInstanceId;
        this.alertId = alertId;
        this.alertName = alertName;
        this.region = region;
        this.project = project;
        this.alertTime = alertTime;
        this.fireTime = fireTime;
        this.resolveTime = resolveTime;
        this.status = status;
        this.fireResultsCount = fireResultsCount;
        this.labels = labels;
        this.annotations = annotations;
        this.severity = severity;
        this.signinUrl = signinUrl;
    }

    public AlibabaCloudSlsExternAlert() {
    }

    public static class AlibabaCloudSlsExternAlertBuilder {
        private String alertInstanceId;
        private String alertId;
        private String alertName;
        private String region;
        private String project;
        private int alertTime;
        private int fireTime;
        private int resolveTime;
        private String status;
        private int fireResultsCount;
        private Map<String, String> labels;
        private Map<String, String> annotations;
        private int severity;
        private String signinUrl;

        AlibabaCloudSlsExternAlertBuilder() {
        }

        @JsonProperty(value="alert_instance_id")
        public AlibabaCloudSlsExternAlertBuilder alertInstanceId(String alertInstanceId) {
            this.alertInstanceId = alertInstanceId;
            return this;
        }

        @JsonProperty(value="alert_id")
        public AlibabaCloudSlsExternAlertBuilder alertId(String alertId) {
            this.alertId = alertId;
            return this;
        }

        @JsonProperty(value="alert_name")
        public AlibabaCloudSlsExternAlertBuilder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public AlibabaCloudSlsExternAlertBuilder region(String region) {
            this.region = region;
            return this;
        }

        public AlibabaCloudSlsExternAlertBuilder project(String project) {
            this.project = project;
            return this;
        }

        @JsonProperty(value="alert_time")
        public AlibabaCloudSlsExternAlertBuilder alertTime(int alertTime) {
            this.alertTime = alertTime;
            return this;
        }

        @JsonProperty(value="fire_time")
        public AlibabaCloudSlsExternAlertBuilder fireTime(int fireTime) {
            this.fireTime = fireTime;
            return this;
        }

        @JsonProperty(value="resolve_time")
        public AlibabaCloudSlsExternAlertBuilder resolveTime(int resolveTime) {
            this.resolveTime = resolveTime;
            return this;
        }

        public AlibabaCloudSlsExternAlertBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="fire_results_count")
        public AlibabaCloudSlsExternAlertBuilder fireResultsCount(int fireResultsCount) {
            this.fireResultsCount = fireResultsCount;
            return this;
        }

        public AlibabaCloudSlsExternAlertBuilder labels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public AlibabaCloudSlsExternAlertBuilder annotations(Map<String, String> annotations) {
            this.annotations = annotations;
            return this;
        }

        public AlibabaCloudSlsExternAlertBuilder severity(int severity) {
            this.severity = severity;
            return this;
        }

        @JsonProperty(value="signin_url")
        public AlibabaCloudSlsExternAlertBuilder signinUrl(String signinUrl) {
            this.signinUrl = signinUrl;
            return this;
        }

        public AlibabaCloudSlsExternAlert build() {
            return new AlibabaCloudSlsExternAlert(this.alertInstanceId, this.alertId, this.alertName, this.region, this.project, this.alertTime, this.fireTime, this.resolveTime, this.status, this.fireResultsCount, this.labels, this.annotations, this.severity, this.signinUrl);
        }

        public String toString() {
            return "AlibabaCloudSlsExternAlert.AlibabaCloudSlsExternAlertBuilder(alertInstanceId=" + this.alertInstanceId + ", alertId=" + this.alertId + ", alertName=" + this.alertName + ", region=" + this.region + ", project=" + this.project + ", alertTime=" + this.alertTime + ", fireTime=" + this.fireTime + ", resolveTime=" + this.resolveTime + ", status=" + this.status + ", fireResultsCount=" + this.fireResultsCount + ", labels=" + this.labels + ", annotations=" + this.annotations + ", severity=" + this.severity + ", signinUrl=" + this.signinUrl + ")";
        }
    }

    public static enum Severity {
        CRITICAL(10, "Critical"),
        HIGH(8, "High"),
        MEDIUM(6, "Medium"),
        LOW(4, "Low"),
        REPORT_ONLY(2, "Report only");

        private static final Map<Integer, Severity> STATUS_MAP;
        private final int status;
        private final String alias;

        private Severity(int status, String alias) {
            this.status = status;
            this.alias = alias;
        }

        public static Optional<Severity> convert(int severity) {
            return Optional.ofNullable(STATUS_MAP.get(severity));
        }

        public int getStatus() {
            return this.status;
        }

        public String getAlias() {
            return this.alias;
        }

        static {
            STATUS_MAP = Arrays.stream(Severity.values()).collect(Collectors.toMap(Severity::getStatus, t -> t, (oldVal, newVal) -> newVal));
        }
    }
}

