/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.reduce;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hertzbeat.alert.dao.AlertSilenceDao;
import org.apache.hertzbeat.alert.notice.AlertNoticeDispatch;
import org.apache.hertzbeat.common.cache.CacheFactory;
import org.apache.hertzbeat.common.entity.alerter.AlertSilence;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.springframework.stereotype.Component;

@Component
public class AlarmSilenceReduce {
    private final AlertSilenceDao alertSilenceDao;
    private final AlertNoticeDispatch dispatcherAlarm;

    public void silenceAlarm(GroupAlert groupAlert) {
        List<AlertSilence> alertSilenceList = CacheFactory.getAlertSilenceCache();
        if (alertSilenceList == null) {
            alertSilenceList = this.alertSilenceDao.findAlertSilencesByEnableTrue();
            CacheFactory.setAlertSilenceCache(alertSilenceList);
        }
        for (AlertSilence alertSilence : alertSilenceList) {
            boolean match = alertSilence.isMatchAll();
            if (!match && groupAlert.getGroupLabels() != null) {
                Map labels = alertSilence.getLabels();
                Map alertLabels = groupAlert.getGroupLabels();
                match = labels.entrySet().stream().anyMatch(item -> alertLabels.containsKey(item.getKey()) && ((String)item.getValue()).equals(alertLabels.get(item.getKey())));
            }
            if (!match) continue;
            LocalDateTime now = LocalDateTime.now();
            if (alertSilence.getType() == 0) {
                if (this.checkAndSave(now, alertSilence)) continue;
                return;
            }
            if (alertSilence.getType() != 1) continue;
            int currentDayOfWeek = now.getDayOfWeek().getValue();
            if (alertSilence.getDays() == null || !alertSilence.getDays().contains((byte)currentDayOfWeek) || this.checkAndSave(now, alertSilence)) continue;
            return;
        }
        this.dispatcherAlarm.dispatchAlarm(groupAlert);
    }

    private boolean checkAndSave(LocalDateTime now, AlertSilence alertSilence) {
        boolean endMatch;
        boolean startMatch = alertSilence.getPeriodStart() == null || now.isAfter(alertSilence.getPeriodStart().toLocalDateTime());
        boolean bl = endMatch = alertSilence.getPeriodEnd() == null || now.isBefore(alertSilence.getPeriodEnd().toLocalDateTime());
        if (startMatch && endMatch) {
            int time = Optional.ofNullable(alertSilence.getTimes()).orElse(0);
            alertSilence.setTimes(Integer.valueOf(time + 1));
            this.alertSilenceDao.save(alertSilence);
            return false;
        }
        return true;
    }

    public AlarmSilenceReduce(AlertSilenceDao alertSilenceDao, AlertNoticeDispatch dispatcherAlarm) {
        this.alertSilenceDao = alertSilenceDao;
        this.dispatcherAlarm = dispatcherAlarm;
    }
}

