/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.twostage.exchange.payload;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum RequestType {
    COMBINE(0),
    FETCH_COMBINE_RESULT(1);

    private final short type;
    private static final Map<Short, RequestType> TYPE_MAP;

    private RequestType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedRequestType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static RequestType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(RequestType.values()).collect(HashMap::new, (typeMap, pipeRequestType) -> typeMap.put(pipeRequestType.getType(), pipeRequestType), HashMap::putAll);
    }
}

